/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.local;

import com.blazesoft.server.base.NdMonitoredServiceSessionManager;
import com.blazesoft.server.base.NdServerRuntimeException;
import com.blazesoft.server.base.NdService;
import com.blazesoft.server.base.NdServiceClientContext;
import com.blazesoft.server.base.NdServiceException;
import com.blazesoft.server.base.NdServiceExecContext;
import com.blazesoft.server.base.NdServiceSessionEvent;
import com.blazesoft.server.base.NdServiceSessionException;
import com.blazesoft.server.base.NdServiceSessionId;
import com.blazesoft.server.base.NdServiceSessionListener;
import com.blazesoft.server.base.NdServiceSessionManager;
import com.blazesoft.server.local.NdLocalServiceSession;
import com.blazesoft.server.local.NdLocalServiceSessionEvent;
import com.blazesoft.system.NdExceptionEvent;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.util.concurrent.NdConcurrentHashtable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NdLocalServiceSessionManager
implements NdServiceSessionManager,
NdMonitoredServiceSessionManager {
    private NdService SiPoWNM;
    private NdConcurrentHashtable SiPyBwB;
    private Hashtable SiPoWPO;
    private Vector SiPoWQP;

    public static void notifyServiceSessionException(NdServiceSessionManager ndServiceSessionManager, NdExceptionEvent ndExceptionEvent) {
        NdServiceExecContext ndServiceExecContext;
        NdServiceSessionId ndServiceSessionId = NdServiceSessionException.getServiceSessionId(ndExceptionEvent.getException());
        if (ndServiceSessionId != null && (ndServiceExecContext = ndServiceSessionManager.getExecContext(ndServiceSessionId)) != null) {
            NdServiceClientContext ndServiceClientContext = ndServiceExecContext.getServiceClientContext();
            ndServiceClientContext.onException(ndServiceExecContext, ndExceptionEvent);
        }
    }

    public NdLocalServiceSessionManager(NdService ndService) {
        this.SiPoWNM = ndService;
        this.SiPyBwB = new NdConcurrentHashtable();
    }

    private NdLocalServiceSession SiPoWRQ(NdServiceSessionId ndServiceSessionId) {
        return (NdLocalServiceSession)this.SiPyBwB.get((Object)ndServiceSessionId);
    }

    public NdServiceSessionId createSession(NdServiceExecContext ndServiceExecContext, long l) {
        NdBaseObject.advAssert((boolean)ndServiceExecContext.getService().equals(this.SiPoWNM));
        NdServiceSessionId ndServiceSessionId = new NdServiceSessionId();
        NdLocalServiceSession ndLocalServiceSession = new NdLocalServiceSession(ndServiceSessionId, ndServiceExecContext, l);
        this.SiPyBwB.put((Object)ndServiceSessionId, (Object)ndLocalServiceSession);
        if (this.SiPoWQP != null) {
            this.notifySessionEvent(new NdLocalServiceSessionEvent(this, 0, ndServiceSessionId, ndServiceExecContext.getServiceClientContext().getClientContextId()));
        }
        return ndServiceSessionId;
    }

    public NdServiceExecContext getExecContext(NdServiceSessionId ndServiceSessionId) {
        NdLocalServiceSession ndLocalServiceSession = this.SiPoWRQ(ndServiceSessionId);
        if (ndLocalServiceSession != null) {
            return ndLocalServiceSession.getServiceExecContext();
        }
        return null;
    }

    public void releaseSession(NdServiceSessionId ndServiceSessionId) {
        NdLocalServiceSession ndLocalServiceSession = (NdLocalServiceSession)this.SiPyBwB.remove((Object)ndServiceSessionId);
        if (this.SiPoWQP != null) {
            this.notifySessionEvent(new NdLocalServiceSessionEvent(this, 1, ndServiceSessionId, ndLocalServiceSession.getServiceExecContext().getServiceClientContext().getClientContextId()));
        }
    }

    public void sessionStartPending(NdServiceSessionId ndServiceSessionId, long l) {
        boolean bl = false;
        NdLocalServiceSession ndLocalServiceSession = this.SiPoWRQ(ndServiceSessionId);
        if (ndLocalServiceSession != null) {
            ndLocalServiceSession.setPending(true, l);
            bl = true;
        }
        if (bl && this.SiPoWQP != null) {
            this.notifySessionEvent(new NdLocalServiceSessionEvent(this, 2, ndServiceSessionId, ndLocalServiceSession.getServiceExecContext().getServiceClientContext().getClientContextId()));
        }
    }

    public void sessionEndPending(NdServiceSessionId ndServiceSessionId, long l) {
        boolean bl = false;
        NdLocalServiceSession ndLocalServiceSession = this.SiPoWRQ(ndServiceSessionId);
        if (ndLocalServiceSession != null) {
            ndLocalServiceSession.setPending(false, l);
            bl = true;
        }
        if (bl && this.SiPoWQP != null) {
            this.notifySessionEvent(new NdLocalServiceSessionEvent(this, 3, ndServiceSessionId, ndLocalServiceSession.getServiceExecContext().getServiceClientContext().getClientContextId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseStaleSessions(long l) {
        if (l == 0L) {
            return;
        }
        NdLocalServiceSessionManager ndLocalServiceSessionManager = this;
        synchronized (ndLocalServiceSessionManager) {
            long l2 = System.currentTimeMillis();
            Enumeration enumeration = this.SiPyBwB.elements();
            while (enumeration.hasMoreElements()) {
                NdLocalServiceSession ndLocalServiceSession = (NdLocalServiceSession)enumeration.nextElement();
                if (!ndLocalServiceSession.isPending() || l2 - ndLocalServiceSession.getStartPendingTime() <= l) continue;
                try {
                    this.SiPoWNM.abortServiceSession(ndLocalServiceSession.getId());
                }
                catch (NdServiceSessionException ndServiceSessionException) {
                    throw new NdServerRuntimeException((Throwable)((Object)ndServiceSessionException));
                }
                catch (NdServiceException ndServiceException) {
                    throw new NdServerRuntimeException((Throwable)((Object)ndServiceException));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortSessions() {
        NdLocalServiceSessionManager ndLocalServiceSessionManager = this;
        synchronized (ndLocalServiceSessionManager) {
            Enumeration enumeration = this.SiPyBwB.elements();
            while (enumeration.hasMoreElements()) {
                NdLocalServiceSession ndLocalServiceSession = (NdLocalServiceSession)enumeration.nextElement();
                try {
                    this.SiPoWNM.abortServiceSession(ndLocalServiceSession.getId());
                }
                catch (NdServiceSessionException ndServiceSessionException) {
                    throw new NdServerRuntimeException((Throwable)((Object)ndServiceSessionException));
                }
                catch (NdServiceException ndServiceException) {
                    throw new NdServerRuntimeException((Throwable)((Object)ndServiceException));
                }
            }
        }
    }

    public synchronized void addNdServiceSessionListener(NdServiceSessionListener ndServiceSessionListener) {
        if (this.SiPoWQP == null) {
            this.SiPoWQP = new Vector();
        }
        this.SiPoWQP.addElement(ndServiceSessionListener);
    }

    public synchronized void removeNdServiceSessionListener(NdServiceSessionListener ndServiceSessionListener) {
        this.SiPoWQP.removeElement(ndServiceSessionListener);
        if (this.SiPoWQP.size() == 0) {
            this.SiPoWQP = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySessionEvent(NdServiceSessionEvent ndServiceSessionEvent) {
        Object[] objectArray;
        Vector vector;
        Vector vector2 = vector = this.SiPoWQP;
        synchronized (vector2) {
            objectArray = new NdServiceSessionListener[vector.size()];
            vector.copyInto(objectArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i].onSessionEvent(ndServiceSessionEvent);
        }
    }

    public void setPropertyValue(NdServiceSessionId ndServiceSessionId, Object object, Object object2) {
        NdLocalServiceSession ndLocalServiceSession = this.SiPoWRQ(ndServiceSessionId);
        ndLocalServiceSession.setPropertyValue(object, object2);
    }

    public Object getPropertyValue(NdServiceSessionId ndServiceSessionId, Object object) {
        Object object2 = null;
        NdLocalServiceSession ndLocalServiceSession = this.SiPoWRQ(ndServiceSessionId);
        if (ndLocalServiceSession != null) {
            object2 = ndLocalServiceSession.getPropertyValue(object);
        }
        return object2;
    }
}

