/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.management;

import com.blazesoft.server.base.NdManagedService;
import com.blazesoft.server.base.NdServer;
import com.blazesoft.server.base.NdService;
import com.blazesoft.server.base.NdServiceException;
import com.blazesoft.server.local.NdLocalServer;
import com.blazesoft.server.local.NdLocalService;
import com.blazesoft.server.management.NdDefaultServiceMgmtBeanRemoteDebuggingBase;
import com.blazesoft.server.management.NdMgmtBean;
import com.blazesoft.server.management.NdServiceMgmtBean;
import com.blazesoft.server.management.NdStrings;
import com.blazesoft.server.management.config.NdMgmtBeanPublisherFactory;
import com.blazesoft.util.NdWrappedRuntimeException;

public class NdDefaultServiceMgmtBean
extends NdDefaultServiceMgmtBeanRemoteDebuggingBase
implements NdServiceMgmtBean {
    public NdDefaultServiceMgmtBean(NdServer ndServer, NdService ndService, NdMgmtBeanPublisherFactory ndMgmtBeanPublisherFactory) {
        super(ndServer, ndService, ndMgmtBeanPublisherFactory);
    }

    public String getBeanName() {
        return this.getServerName() + " " + this.getServiceName();
    }

    public String getServerMgmtBeanName() {
        return ((NdMgmtBean)((Object)((NdLocalServer)this.getServer()).getServerMgmtBean())).getFullName();
    }

    public String getServerName() {
        return this.getServer().getServerId().toString();
    }

    public String getServiceName() {
        return this.getService().getServiceId().getServiceName();
    }

    public String getServiceState() {
        String string = NdStrings.SiPNZDR("UNKNOWN");
        switch (((NdLocalService)this.getService()).getServiceState()) {
            case -1: {
                string = NdStrings.SiPNZDR("Inactive");
                break;
            }
            case 0: {
                string = NdStrings.SiPNZDR("Initializing");
                break;
            }
            case 1: {
                string = NdStrings.SiPNZDR("Active");
                break;
            }
            case 2: {
                string = NdStrings.SiPNZDR("Resetting");
                break;
            }
            case 3: {
                string = NdStrings.SiPNZDR("ShuttingDown");
            }
        }
        return string;
    }

    public void requestReset() {
        ((NdLocalService)this.getService()).resetService();
    }

    public void requestStop() {
        try {
            ((NdLocalService)this.getService()).stopService();
        }
        catch (NdServiceException ndServiceException) {
            String string = NdStrings.SiPNZDR("StopFailed");
            throw new NdWrappedRuntimeException(string, (Throwable)((Object)ndServiceException));
        }
    }

    public void requestAbort() {
        try {
            ((NdLocalService)this.getService()).abortService();
        }
        catch (NdServiceException ndServiceException) {
            String string = NdStrings.SiPNZDR("AbortFailed");
            throw new NdWrappedRuntimeException(string, (Throwable)((Object)ndServiceException));
        }
    }

    public int getNumFreeAgents() {
        return ((NdManagedService)((Object)this.getService())).getStatistics().getNumFreeAgents();
    }

    public int getNumExecutingAgents() {
        return ((NdManagedService)((Object)this.getService())).getStatistics().getNumExecutingAgents();
    }

    public int getNumPooledAgents() {
        return ((NdManagedService)((Object)this.getService())).getStatistics().getNumAgents();
    }
}

