/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.management.jmx;

import com.blazesoft.server.management.NdAbstractMgmtBeanPublisherServer;
import com.blazesoft.server.management.jmx.NdJMXMBeanServerPublisherServer;
import com.blazesoft.server.management.jmx.NdStrings;
import com.blazesoft.util.NdWrappedRuntimeException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class NdDefaultJMXPublisherServer
extends NdAbstractMgmtBeanPublisherServer
implements NdJMXMBeanServerPublisherServer {
    public static final String DEFAULT_JMX_PUBLICATIONDOMAIN = "com.blazesoft.server";
    private String SiPQqRC = null;
    private MBeanServer SiPQqSD;

    public NdDefaultJMXPublisherServer() {
        this.setPublicationDomain(DEFAULT_JMX_PUBLICATIONDOMAIN);
    }

    public void publish(Object object, String string) {
        try {
            ObjectName objectName = new ObjectName(string);
            MBeanServer mBeanServer = this.SiPQqTE();
            mBeanServer.registerMBean(object, objectName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new NdWrappedRuntimeException(NdStrings.SiPOcgB("ObjectNameFailed", string), (Throwable)malformedObjectNameException);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw new NdWrappedRuntimeException(NdStrings.SiPOcgB("RegisterFailed", string), (Throwable)instanceAlreadyExistsException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw new NdWrappedRuntimeException(NdStrings.SiPOcgB("RegisterFailed", string), (Throwable)mBeanRegistrationException);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw new NdWrappedRuntimeException(NdStrings.SiPOcgB("RegisterFailed", string), (Throwable)notCompliantMBeanException);
        }
    }

    public void unpublish(Object object, String string) {
        try {
            ObjectName objectName = new ObjectName(string);
            MBeanServer mBeanServer = this.SiPQqTE();
            mBeanServer.unregisterMBean(objectName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new NdWrappedRuntimeException(NdStrings.SiPOcgB("ObjectNameFailed", string), (Throwable)malformedObjectNameException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new NdWrappedRuntimeException(NdStrings.SiPOcgB("RegisterFailed", string), (Throwable)instanceNotFoundException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw new NdWrappedRuntimeException(NdStrings.SiPOcgB("RegisterFailed", string), (Throwable)mBeanRegistrationException);
        }
    }

    public MBeanServer getMBeanServer() {
        return this.SiPQqTE();
    }

    private MBeanServer SiPQqTE() {
        if (this.SiPQqSD == null) {
            this.SiPQqSD = this.SiPQqRC != null ? this.SiPQqUF() : ManagementFactory.getPlatformMBeanServer();
        }
        return this.SiPQqSD;
    }

    private MBeanServer SiPQqUF() {
        MBeanServer mBeanServer;
        try {
            InitialContext initialContext = new InitialContext();
            mBeanServer = (MBeanServer)initialContext.lookup(this.getMbeanServerURL());
        }
        catch (NamingException namingException) {
            throw new NdWrappedRuntimeException(NdStrings.SiPOcgB("GetBeanServerFailed", this.getMbeanServerURL()), (Throwable)namingException);
        }
        return mBeanServer;
    }

    public String getMbeanServerURL() {
        return this.SiPQqRC;
    }

    public void setMbeanServerURL(String string) {
        this.SiPQqRC = string;
    }
}

