/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.management.jmx;

import com.blazesoft.server.management.NdManagementException;
import com.blazesoft.server.management.NdMgmtBeanPublisherServer;
import com.blazesoft.server.management.NdMgmtConnector;
import com.blazesoft.server.management.jmx.NdDefaultJMXPublisherServer;
import com.blazesoft.server.management.jmx.NdJMXMBeanServerPublisherServer;
import com.blazesoft.server.management.jmx.NdStrings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class NdMgmtRMIConnector
implements NdMgmtConnector {
    private NdMgmtBeanPublisherServer SiPVoNJ;
    private JMXConnectorServer SiPVoNK;
    private String SiPVoNL;
    private String SiPVoNM;
    private String SiPVoNN;
    private String SiPVoNO;
    private String SiPVoNP;

    public NdMgmtRMIConnector(NdMgmtBeanPublisherServer ndMgmtBeanPublisherServer) throws NdManagementException {
        this.SiPVoNJ = ndMgmtBeanPublisherServer;
    }

    public JMXServiceURL getJMXServiceURL() throws NdManagementException {
        Object object;
        if (this.SiPVoNL == null) {
            if (this.SiPVoNN == null) {
                this.SiPVoNN = String.valueOf(1099);
            }
            object = "";
            if (this.SiPVoNO != null) {
                object = "localhost:" + this.SiPVoNO;
            }
            if (this.SiPVoNM == null) {
                this.SiPVoNM = "localhost";
            }
            this.SiPVoNL = "service:jmx:rmi://" + (String)object + "/jndi/rmi://localhost:" + this.SiPVoNN + "/" + this.SiPVoNP;
        }
        try {
            object = new JMXServiceURL(this.SiPVoNL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new NdManagementException(malformedURLException);
        }
        return object;
    }

    public void initialize() throws NdManagementException {
        if (!(this.SiPVoNJ instanceof NdJMXMBeanServerPublisherServer)) {
            return;
        }
        MBeanServer mBeanServer = ((NdDefaultJMXPublisherServer)this.SiPVoNJ).getMBeanServer();
        if (mBeanServer == null) {
            return;
        }
        JMXServiceURL jMXServiceURL = this.getJMXServiceURL();
        try {
            String string = jMXServiceURL.getURLPath();
            if (string.indexOf("/rmi://") < 0) {
                throw new NdManagementException(NdStrings.SiPOcfZ("InvalidRMIServiceURL"));
            }
            int n = string.lastIndexOf(58);
            int n2 = string.lastIndexOf(47);
            String string2 = string.substring(n + 1, n2);
            int n3 = Integer.parseInt(string2);
            try {
                Registry registry = LocateRegistry.getRegistry(n3);
                registry.list();
            }
            catch (RemoteException remoteException) {
                Registry registry = LocateRegistry.createRegistry(n3);
                registry.list();
            }
            Properties properties = System.getProperties();
            this.SiPVoNK = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, properties, mBeanServer);
            System.out.println("publish connector server at\n" + jMXServiceURL.toString());
            this.SiPVoNK.start();
        }
        catch (MalformedURLException malformedURLException) {
            throw new NdManagementException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new NdManagementException(iOException);
        }
    }

    public void shutdown() throws NdManagementException {
        if (this.SiPVoNK != null) {
            try {
                this.SiPVoNK.stop();
                this.SiPVoNK = null;
            }
            catch (IOException iOException) {
                throw new NdManagementException(iOException);
            }
        }
    }

    public String getServiceURL() {
        return this.SiPVoNL;
    }

    public void setServiceURL(String string) throws NdManagementException {
        this.SiPVoNL = string;
    }

    public void setRegistryHostName(String string) {
        this.SiPVoNM = string;
    }

    public String getRegistryHostName() {
        return this.SiPVoNM;
    }

    public void setRegistryPort(String string) {
        this.SiPVoNN = string;
    }

    public String getRegistryPort() {
        return this.SiPVoNN;
    }

    public void setConnectionName(String string) {
        this.SiPVoNP = string;
    }

    public String getConnectionName() {
        return this.SiPVoNP;
    }

    public void setCommunicationPort(String string) {
        this.SiPVoNO = string;
    }

    public String getCommunicationPort() {
        return this.SiPVoNO;
    }
}

