/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.qdeployer;

import com.blazesoft.engines.rules.NdClassProviderResource;
import com.blazesoft.engines.rules.NdResource;
import com.blazesoft.objects.dotnet.NdAssemblyProvider;
import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.objects.dotnet.NdImportedAssemblyInfo;
import com.blazesoft.objects.dotnet.NdImportedAssemblyList;
import com.blazesoft.server.base.NdServerException;
import com.blazesoft.server.qdeployer.NdQDeployerDotNETAssemblyCopy;
import com.blazesoft.server.qdeployer.NdStrings;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.util.NdIOUtil;
import com.blazesoft.util.NdWrappedRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class NdDotNetAssemblyManager {
    private NdQDeployerDotNETAssemblyCopy SiPFXGV = null;
    private Hashtable SiPFXHW;
    private Hashtable SiPGiQE;
    private Hashtable SiPFXIX;
    private Hashtable SiPFXJY;
    private Hashtable SiPFXKZ = new Hashtable();
    private Hashtable SiPFXLA = new Hashtable();

    public NdDotNetAssemblyManager() {
        this.SiPFXHW = new Hashtable();
        this.SiPFXIX = new Hashtable();
        this.SiPGiQE = new Hashtable();
        this.SiPFXJY = new Hashtable();
    }

    public Hashtable getImportedAssembliesInGAC() {
        return this.SiPFXHW;
    }

    public Hashtable getExplicitImportedAssemblies() {
        return this.SiPGiQE;
    }

    public Hashtable getExplicitImportedAssembliesInGAC() {
        return this.SiPFXIX;
    }

    public Hashtable getImportedAssembliesNotInGAC() {
        return this.SiPFXJY;
    }

    public void loadImportedAssemblyTables(NdResource[] ndResourceArray) {
        NdBaseObject.advAssert((this.getAssemblyCopyObject() != null ? 1 : 0) != 0);
        for (int i = 0; i < ndResourceArray.length; ++i) {
            if (!(ndResourceArray[i] instanceof NdClassProviderResource) || !(ndResourceArray[i] instanceof NdAssemblyProvider)) continue;
            NdImportedAssemblyList ndImportedAssemblyList = ((NdAssemblyProvider)ndResourceArray[i]).getImportedAssemblyList();
            NdImportedAssemblyInfo[] ndImportedAssemblyInfoArray = ndImportedAssemblyList.getAllImports();
            for (int j = 0; j < ndImportedAssemblyInfoArray.length; ++j) {
                if (!ndImportedAssemblyInfoArray[j].isImplicitImport()) {
                    this.SiPGiQE.put(ndImportedAssemblyInfoArray[j].getFullName(), ndImportedAssemblyInfoArray[j]);
                }
                if (ndImportedAssemblyInfoArray[j].isInGAC()) {
                    this.SiPFXHW.put(ndImportedAssemblyInfoArray[j].getFullName(), ndImportedAssemblyInfoArray[j]);
                    if (ndImportedAssemblyInfoArray[j].isImplicitImport()) continue;
                    this.SiPFXIX.put(ndImportedAssemblyInfoArray[j].getName(), ndImportedAssemblyInfoArray[j]);
                    continue;
                }
                if (ndImportedAssemblyInfoArray[j].getName().equals("mscorlib") && ndImportedAssemblyInfoArray[j].getPublicKeyToken().equals("b77a5c561934e089")) {
                    this.SiPFXHW.put(ndImportedAssemblyInfoArray[j].getFullName(), ndImportedAssemblyInfoArray[j]);
                    continue;
                }
                this.SiPFXJY.put(ndImportedAssemblyInfoArray[j].getHintPath(), ndImportedAssemblyInfoArray[j]);
                this.getAssemblyCopyObject().getImportedModules(this.getImpAssembliesNotInGAC(), ndImportedAssemblyInfoArray[j]);
            }
        }
    }

    public NdQDeployerDotNETAssemblyCopy getAssemblyCopyObject() {
        if (NdDotNETLib.isDotNETSupportEnabled() && this.SiPFXGV == null) {
            try {
                Class<?> clazz = Class.forName("com.blazesoft.server.qdeployer.netonly.NdQDeployerDotNETAssemblyCopyImpl");
                this.SiPFXGV = (NdQDeployerDotNETAssemblyCopy)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NdWrappedRuntimeException((Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new NdWrappedRuntimeException((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new NdWrappedRuntimeException((Throwable)illegalAccessException);
            }
        }
        return this.SiPFXGV;
    }

    public Hashtable getImpAssembliesCopied() {
        return this.SiPFXKZ;
    }

    public Hashtable getImpAssembliesNotCopied() {
        return this.SiPFXLA;
    }

    public Hashtable getImpAssembliesInGAC() {
        return this.SiPFXHW;
    }

    public Hashtable getImpAssembliesNotInGAC() {
        return this.SiPFXJY;
    }

    public void copyImportedAssembliesToDeploymentDirectory(String string) {
        Hashtable hashtable = this.getImpAssembliesNotInGAC();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = string2 = (String)enumeration.nextElement();
            if (string2.lastIndexOf(92) != -1) {
                string3 = string2.substring(string2.lastIndexOf(92) + 1);
            }
            string3 = string + '\\' + string3;
            try {
                if (!string2.toLowerCase().equals(string3.toLowerCase())) {
                    this.copyImportedAssembliesToDestinationDir(string2, string3);
                }
                this.SiPFXKZ.put(string2, hashtable.get(string2));
            }
            catch (NdServerException ndServerException) {
                this.SiPFXLA.put(string2, hashtable.get(string2));
            }
        }
    }

    protected void copyImportedAssembliesToDestinationDir(String string, String string2) throws NdServerException {
        File file = new File(string);
        if (!file.exists()) {
            throw new NdServerException(NdStrings.SiPqnuZ("FileDoesNotExist", string));
        }
        try {
            NdIOUtil.copyFile((String)string, (String)string2);
        }
        catch (IOException iOException) {
            throw new NdServerException(NdStrings.SiPqnuZ("CannotCreateFile", string2), iOException);
        }
        catch (RuntimeException runtimeException) {
            throw new NdServerException(NdStrings.SiPqnuZ("ErrorWhileCreatingFile", string2), runtimeException);
        }
    }
}

