/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.qdeployer;

import com.blazesoft.server.base.NdServerException;
import com.blazesoft.server.config.NdServiceAgentFactoryFactory;
import com.blazesoft.server.config.NdServiceAgentReloaderFactory;
import com.blazesoft.server.config.NdServiceAgentResetterFactory;
import com.blazesoft.server.config.NdServiceAgentValueMapperFactory;
import com.blazesoft.server.qdeployer.NdMTSDeploymentEnvironmentDetails;
import com.blazesoft.server.qdeployer.NdQDeployerComLookup;
import com.blazesoft.server.qdeployer.NdQDeployerConstants;
import com.blazesoft.server.qdeployer.NdQDeployerDetails;
import com.blazesoft.server.qdeployer.NdQDeployerFileInfo;
import com.blazesoft.server.qdeployer.NdStrings;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerMTSDeploymentGenerator;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerMTSExtractor;
import com.blazesoft.server.qdeployer.subconfig.NdMTSQDeployerSubConfig;
import com.blazesoft.template.repository.NdRomException;
import java.util.Hashtable;

public class NdQDeployerMTSDetails
extends NdQDeployerDetails {
    private NdQDeployerComLookup SiPrzQN;
    private String SiPunbW;

    public NdQDeployerMTSDetails(String string) throws NdRomException {
        this.SiPunbW = string;
        this.setDeploymentGenerator(new NdQDeployerMTSDeploymentGenerator());
    }

    public NdQDeployerMTSDetails() throws NdRomException {
        this(null);
    }

    public String getDeploymentEnvironmentDirectory() {
        return "mts";
    }

    protected void setServerDefaultsForDepEnv() {
        this.getServerConfig().setUseCallingContext(true);
    }

    protected void setServiceDefaultsForDepEnv() {
        if (this.getService().getServiceAgentFactoryFactory() != null) {
            this.getService().getServiceAgentFactoryFactory().setJavaName("com.blazesoft.server.rules.NdNonThreadedScriptRulesServiceAgentFactory");
        } else {
            this.getService().setServiceAgentFactoryFactory(new NdServiceAgentFactoryFactory("com.blazesoft.server.rules.NdNonThreadedScriptRulesServiceAgentFactory"));
        }
        this.getService().setServiceAgentResetterFactory(new NdServiceAgentResetterFactory("com.blazesoft.server.local.NdLocalServiceAgentDispenserResetterBase"));
        this.getService().setServiceAgentReloaderFactory(new NdServiceAgentReloaderFactory("com.blazesoft.server.local.NdLocalServiceAgentDispenserReloaderBase"));
        this.getService().setServiceAgentValueMapperFactory(new NdServiceAgentValueMapperFactory("com.blazesoft.engines.rules.com.NdRulesComValueMapper"));
    }

    public void createExtractor() throws NdRomException {
        if (this.getProject() != null) {
            this.setExtractor(new NdQDeployerMTSExtractor(this.getProject(), this.getSchemaSupport(), this.getSubConfig().getTargetLanguage()));
        }
    }

    public void createSubConfig() {
        this.setSubConfig(new NdMTSQDeployerSubConfig());
    }

    public void addDeploymentCode() throws NdServerException {
        String string = this.getDeploymentCode().getPrefix();
        String string2 = ((NdMTSDeploymentEnvironmentDetails)this.getDeploymentEnvironment()).getDllName();
        string2 = string2 != null && string2.length() > 0 ? string2 : string + "Server" + "." + "dll";
        NdQDeployerFileInfo ndQDeployerFileInfo = new NdQDeployerFileInfo(string2, true, true);
        Hashtable hashtable = new Hashtable();
        String string3 = null;
        string3 = string2.indexOf(NdQDeployerConstants.FILE_SEP) != -1 ? string2.substring(string2.lastIndexOf(NdQDeployerConstants.FILE_SEP) + 1, string2.lastIndexOf(".")) : string2.substring(0, string2.lastIndexOf("."));
        this.addDepCodeTemplateToSubList(hashtable, "Prefix.cri", new NdQDeployerFileInfo(string3 + "." + "cri"));
        this.addDepCodeTemplateToSubList(hashtable, "PrefixServer.java", new NdQDeployerFileInfo(string3 + "." + "java"));
        this.addDepCodeTemplateToSubList(hashtable, "_ND_PostGenerate.bat", new NdQDeployerFileInfo("_ND_PostGenerate.bat"));
        ndQDeployerFileInfo.setIntermediateFiles(hashtable);
        this.addDepCodeTemplateToList("PrefixServer.dll", ndQDeployerFileInfo);
        String[] stringArray = this.getDeploymentGenerator().getFileGenerator().getTemplates(this);
        this.addDepCodeTemplatesToList(stringArray);
    }

    public boolean isTemplateExcluded(String string) {
        boolean bl = super.isTemplateExcluded(string);
        if (!bl) {
            if (string.equals("PrefixServer.java") || string.equals("PrefixServerDeploymentContext.java") || string.equals("Prefix.cri") || string.equals("_ND_PostGenerate.bat")) {
                bl = true;
            }
            if (!((NdMTSDeploymentEnvironmentDetails)this.getDeploymentEnvironment()).isKeepGeneratedFiles() && (string.equals("PrefixBuild.bat") || string.equals("PrefixRegister.bat"))) {
                bl = true;
            }
            if (string.equals("PrefixServerDeploymentContext.java") && !this.isUsingInCodeConfig()) {
                bl = true;
            }
        }
        return bl;
    }

    public NdQDeployerComLookup getComLookup() {
        return this.SiPrzQN;
    }

    public void setComLookup(NdQDeployerComLookup ndQDeployerComLookup) {
        this.SiPrzQN = ndQDeployerComLookup;
    }

    public String getDeploymentEnvironmentSubType() {
        return this.SiPunbW;
    }

    public String getDeploymentEnvironmentSubTypeSubDirectory() {
        String string = null;
        if (this.SiPunbW != null) {
            if (this.SiPunbW.equals(".NET")) {
                string = "dotNET";
            } else {
                throw new IllegalStateException(NdStrings.SiPqnuZ("UnsupportedDeploymentSubType", this.SiPunbW));
            }
        }
        return string;
    }
}

