/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.base;

import com.blazesoft.server.base.NdServerId;
import com.blazesoft.server.base.NdServiceId;
import com.blazesoft.server.base.NdStrings;
import java.util.EventObject;

public class NdServiceManagerEvent
extends EventObject {
    public static final int SERVICE_STATE_UNKNOWN = -2;
    public static final int SERVICE_STATE_NONE = -1;
    public static final int SERVICE_CREATION_REQUESTED = 0;
    public static final int SERVICE_CREATED = 1;
    public static final int SERVICE_INITIALIZED = 12;
    public static final int SERVICE_STOP_REQUESTED = 2;
    public static final int SERVICE_STOPPED = 3;
    public static final int SERVICE_RESET_REQUESTED = 4;
    public static final int SERVICE_RESET = 5;
    public static final int SERVICE_ABORT_REQUESTED = 6;
    public static final int SERVICE_ABORTED = 7;
    public static final int SERVICE_SUSPEND_REQUESTED = 8;
    public static final int SERVICE_SUSPENDED = 9;
    public static final int SERVICE_RESUME_REQUESTED = 10;
    public static final int SERVICE_RESUMED = 11;
    private int SiPoVKQ;
    private NdServerId SiPoVKR;
    private NdServiceId SiPoVKS;

    public NdServiceManagerEvent(NdServerId ndServerId, int n) {
        this(ndServerId, n, null);
    }

    public NdServiceManagerEvent(NdServerId ndServerId, int n, NdServiceId ndServiceId) {
        super(ndServerId);
        this.SiPoVKR = ndServerId;
        this.SiPoVKQ = n;
        this.SiPoVKS = ndServiceId;
    }

    public int getType() {
        return this.SiPoVKQ;
    }

    public NdServerId getServerId() {
        return this.SiPoVKR;
    }

    public NdServiceId getServiceId() {
        return this.SiPoVKS;
    }

    public static String getUnlocalizedTypeString(int n) {
        switch (n) {
            case 0: {
                return "SERVICE_CREATION_REQUESTED";
            }
            case 1: {
                return "SERVICE_CREATED";
            }
            case 12: {
                return "SERVICE_INITIALIZED";
            }
            case 2: {
                return "SERVICE_STOP_REQUESTED";
            }
            case 3: {
                return "SERVICE_STOPPED";
            }
            case 4: {
                return "SERVICE_RESET_REQUESTED";
            }
            case 5: {
                return "SERVICE_RESET";
            }
            case -1: {
                return "SERVICE_STATE_NONE";
            }
        }
        return "SERVICE_STATE_UNKNOWN";
    }

    public String getUnlocalizedTypeString() {
        return NdServiceManagerEvent.getUnlocalizedTypeString(this.getType());
    }

    public String getTypeString() {
        switch (this.getType()) {
            case 0: {
                return NdStrings.SiPoUGH("ServiceCreationRequested");
            }
            case 1: {
                return NdStrings.SiPoUGH("ServiceCreated");
            }
            case 12: {
                return NdStrings.SiPoUGH("ServiceInitialized");
            }
            case 2: {
                return NdStrings.SiPoUGH("ServiceStopRequested");
            }
            case 3: {
                return NdStrings.SiPoUGH("ServiceStopped");
            }
            case 4: {
                return NdStrings.SiPoUGH("ServiceResetRequested");
            }
            case 5: {
                return NdStrings.SiPoUGH("ServiceReset");
            }
            case -1: {
                return NdStrings.SiPoUGH("ServiceStateNone");
            }
        }
        return NdStrings.SiPoUGH("ServiceOther");
    }

    public String getMessage() {
        String string = this.getServerId().getIdentifierString();
        if (this.getServiceId() != null) {
            string = string + ": " + this.getServiceId().getIdentifierString();
            string = string + " (" + this.getTypeString() + ")";
        }
        return string;
    }

    public String toString() {
        return this.getMessage();
    }
}

