/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy;

import com.blazesoft.server.base.NdManagedService;
import com.blazesoft.server.base.NdMonitoredServer;
import com.blazesoft.server.base.NdMonitoredService;
import com.blazesoft.server.base.NdMonitoredServiceManager;
import com.blazesoft.server.base.NdMonitoredServiceSessionManager;
import com.blazesoft.server.base.NdServer;
import com.blazesoft.server.base.NdServerException;
import com.blazesoft.server.base.NdServerId;
import com.blazesoft.server.base.NdServerRuntimeException;
import com.blazesoft.server.base.NdServerStatistics;
import com.blazesoft.server.base.NdService;
import com.blazesoft.server.base.NdServiceManager;
import com.blazesoft.server.base.SiPpmrF;
import com.blazesoft.server.config.NdServerConfig;
import com.blazesoft.server.config.NdServerConfigFactory;
import com.blazesoft.server.config.NdServiceConfig;
import com.blazesoft.server.deploy.NdDefaultServerDeploymentContext;
import com.blazesoft.server.deploy.NdDeploymentSupport;
import com.blazesoft.server.deploy.NdManagedComponent;
import com.blazesoft.server.deploy.NdServerDeploymentAccessException;
import com.blazesoft.server.deploy.NdServerDeploymentContext;
import com.blazesoft.server.deploy.NdServerDeploymentIllegalStateException;
import com.blazesoft.server.deploy.NdServerDeploymentInitializationException;
import com.blazesoft.server.deploy.NdStrings;
import com.blazesoft.server.local.NdInvalidServerConfigurationException;
import com.blazesoft.server.local.NdLocalServer;
import com.blazesoft.server.local.NdLocalServerException;
import com.blazesoft.server.local.NdLocalServerRuntimeException;
import com.blazesoft.server.local.NdStringBufferServerConfigFactory;
import com.blazesoft.server.local.NdURLServerConfigFactory;
import com.blazesoft.system.NdMonitoredSystemErrStream;
import com.blazesoft.system.NdMonitoredSystemOutStream;
import com.blazesoft.util.NdClassLoadingContext;
import com.blazesoft.util.NdWrappedExceptionSupport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class NdServerDeploymentBase
extends NdManagedComponent
implements NdServer,
Cloneable {
    private transient NdServerId SiPVwNE;
    private transient SiPVyTM SiPVwOF;
    private transient boolean SiPVwPG;
    private transient boolean SiPVwQH;
    private transient boolean SiPVwRI;
    private transient boolean SiPVwSJ;
    private static final Hashtable SiPVwTK = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void SiPVwUL(SiPVyTM siPVyTM) throws NdLocalServerException {
        NdServerDeploymentBase ndServerDeploymentBase = this;
        synchronized (ndServerDeploymentBase) {
            if (this.SiPVwQH) {
                this.SiPVxcT();
            } else if (this.SiPVwPG) {
                throw new NdServerDeploymentIllegalStateException(siPVyTM.SiPVySL(), NdStrings.SiPpjKN("ErrorAlreadyInitialized"));
            }
            this.SiPVwOF = siPVyTM;
            NdLocalServer ndLocalServer = this.SiPVwZQ();
            if (ndLocalServer != null) {
                this.SiPVwNE = ndLocalServer.getServerId();
                if (!this.SiPVwPG) {
                    this.SiPVwPG = true;
                    this.SiPVwWN();
                }
            }
        }
    }

    SiPVyTM SiPVwVM() {
        return this.SiPVwOF;
    }

    private void SiPVwWN() throws NdLocalServerException {
        NdServerConfig ndServerConfig = this.getLocalServer().getServerConfig();
        NdServiceConfig[] ndServiceConfigArray = ndServerConfig.getServiceConfig();
        if (ndServiceConfigArray != null) {
            for (int i = 0; i < ndServiceConfigArray.length; ++i) {
                if (ndServiceConfigArray[i].getNumAgents() != -2) continue;
                ((NdManagedService)((Object)this.getLocalServer().getService(ndServiceConfigArray[i].getName()))).addServiceAgents(1);
            }
        }
        this.SiPVwSJ = true;
    }

    private void SiPVwXO() throws NdLocalServerException {
        if (!this.SiPVwSJ) {
            return;
        }
        NdServerConfig ndServerConfig = this.getLocalServer().getServerConfig();
        NdServiceConfig[] ndServiceConfigArray = ndServerConfig.getServiceConfig();
        if (ndServiceConfigArray != null) {
            for (int i = 0; i < ndServiceConfigArray.length; ++i) {
                if (ndServiceConfigArray[i].getNumAgents() != -2) continue;
                ((NdManagedService)((Object)this.getLocalServer().getService(ndServiceConfigArray[i].getName()))).removeServiceAgents(1);
            }
        }
        this.SiPVwSJ = false;
    }

    private Object SiPVwYP() throws NdServerDeploymentIllegalStateException {
        Object object = this.getKey();
        if (object == null) {
            throw new NdServerDeploymentIllegalStateException(this.getServerId(), NdStrings.SiPpjKN("ErrorKeyNotSet"));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NdLocalServer SiPVwZQ() throws NdServerDeploymentAccessException {
        NdLocalServer ndLocalServer = null;
        Object object = this.SiPVwYP();
        Hashtable hashtable = SiPVwTK;
        synchronized (hashtable) {
            SiPVuSH siPVuSH = (SiPVuSH)SiPVwTK.get(object);
            if (siPVuSH != null) {
                ndLocalServer = (NdLocalServer)siPVuSH.SiPVuOD.SiPpmrD();
                ++siPVuSH.SiPVuPE;
                NdServerConfig ndServerConfig = ndLocalServer.getServerConfig();
                this.SiPVwOF.SiPVyRK(ndServerConfig);
                this.SiPVwRI = ndServerConfig.getShutdownOnZeroRefCount();
            }
        }
        return ndLocalServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SiPVxaR(boolean bl) throws NdServerException {
        if (!this.SiPVwQH) {
            NdServer ndServer = null;
            boolean bl2 = false;
            try {
                NdServerDeploymentBase ndServerDeploymentBase = this;
                synchronized (ndServerDeploymentBase) {
                    if (!this.SiPVwQH) {
                        Hashtable hashtable = SiPVwTK;
                        synchronized (hashtable) {
                            block18: {
                                Object object = this.SiPVwYP();
                                SiPVuSH siPVuSH = (SiPVuSH)SiPVwTK.get(object);
                                if (siPVuSH != null) {
                                    ndServer = siPVuSH.SiPVuOD.SiPpmrD();
                                    try {
                                        this.SiPVwXO();
                                        Object var9_8 = null;
                                        --siPVuSH.SiPVuPE;
                                        if (bl) {
                                            siPVuSH.SiPVuRG = true;
                                        }
                                        this.SiPVwQH = true;
                                        if (siPVuSH.SiPVuPE != 0L || !siPVuSH.SiPVuRG) break block18;
                                        siPVuSH.SiPVuOD.SiPpmrE(null);
                                        SiPVwTK.remove(object);
                                    }
                                    catch (Throwable throwable) {
                                        Object var9_9 = null;
                                        --siPVuSH.SiPVuPE;
                                        if (bl) {
                                            siPVuSH.SiPVuRG = true;
                                        }
                                        this.SiPVwQH = true;
                                        if (siPVuSH.SiPVuPE == 0L && siPVuSH.SiPVuRG) {
                                            siPVuSH.SiPVuOD.SiPpmrE(null);
                                            SiPVwTK.remove(object);
                                            bl2 = true;
                                        }
                                        throw throwable;
                                    }
                                    bl2 = true;
                                    {
                                        break block18;
                                    }
                                }
                                this.SiPVwQH = true;
                            }
                        }
                    }
                }
                Object var13_13 = null;
                if (ndServer != null && bl2) {
                    ndServer.shutdown();
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (ndServer != null && bl2) {
                    ndServer.shutdown();
                }
                throw throwable;
            }
        }
    }

    protected void removed() {
        try {
            this.SiPVxaR(this.SiPVwRI);
        }
        catch (NdServerException ndServerException) {
            throw new NdServerRuntimeException((Throwable)((Object)ndServerException));
        }
    }

    public Object getKey() {
        Object object = null;
        if (this.SiPVwOF != null) {
            object = this.SiPVwOF.SiPVyPI();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws NdLocalServerException {
        try {
            this.prepareTxContext();
            if (!this.SiPVwPG) {
                NdServerDeploymentBase ndServerDeploymentBase = this;
                synchronized (ndServerDeploymentBase) {
                    if (!this.SiPVwPG) {
                        NdLocalServer ndLocalServer = null;
                        Hashtable hashtable = SiPVwTK;
                        synchronized (hashtable) {
                            ndLocalServer = this.SiPVwZQ();
                            if (ndLocalServer == null) {
                                NdServerConfig ndServerConfig = this.SiPVwOF.SiPVyQJ();
                                this.SiPVwRI = ndServerConfig.getShutdownOnZeroRefCount();
                                this.validateServerConfiguration(ndServerConfig);
                                ndLocalServer = this.createServer(ndServerConfig);
                                SiPVwTK.put(this.SiPVwYP(), new SiPVuSH(ndLocalServer));
                            }
                        }
                        this.SiPVwNE = ndLocalServer.getServerId();
                        this.SiPVwPG = true;
                        this.SiPVwWN();
                    }
                }
            }
            this.validateTxContext();
        }
        catch (RuntimeException runtimeException) {
            throw new NdServerDeploymentInitializationException(this.getServerId(), (Throwable)runtimeException);
        }
    }

    protected void validateServerConfiguration(NdServerConfig ndServerConfig) throws NdInvalidServerConfigurationException {
    }

    protected abstract NdLocalServer createServer(NdServerConfig var1) throws NdLocalServerException;

    public void resetDeploymentService(String string) throws NdLocalServerException {
        this.prepareTxContext();
        this.getLocalServer().resetService(string);
        this.validateTxContext();
    }

    public void shutdownDeployment() throws NdServerException {
        this.prepareTxContext();
        if (this.SiPVwPG) {
            try {
                this.removed();
            }
            catch (NdServerRuntimeException ndServerRuntimeException) {
                Throwable throwable = ndServerRuntimeException.getSourceThrowable();
                if (throwable instanceof NdServerException) {
                    throw (NdServerException)((Object)throwable);
                }
                throw ndServerRuntimeException;
            }
        }
        this.validateTxContext();
    }

    public void shutdown() throws NdServerException {
        this.SiPVwRI = true;
        this.shutdownDeployment();
    }

    private SiPVuSH SiPVxbS() throws NdServerDeploymentAccessException {
        SiPVuSH siPVuSH;
        try {
            if (this.SiPVwQH) {
                throw new NdServerDeploymentIllegalStateException(this.getServerId(), NdStrings.SiPpjKN("AttemptToAccessServerAfterShutdown"));
            }
            if (!this.SiPVwPG) {
                try {
                    this.initialize();
                }
                catch (NdLocalServerException ndLocalServerException) {
                    if (ndLocalServerException instanceof NdServerDeploymentAccessException) {
                        throw (NdServerDeploymentAccessException)ndLocalServerException;
                    }
                    throw new NdServerDeploymentInitializationException(this.getServerId(), (Throwable)((Object)ndLocalServerException));
                }
            }
            if ((siPVuSH = (SiPVuSH)SiPVwTK.get(this.SiPVwYP())) == null) {
                throw new NdServerDeploymentIllegalStateException(this.getServerId(), NdStrings.SiPpjKN("AttemptToAccessServerAfterShutdown"));
            }
        }
        catch (RuntimeException runtimeException) {
            throw new NdServerDeploymentInitializationException(this.getServerId(), (Throwable)runtimeException);
        }
        return siPVuSH;
    }

    protected SiPpmrF getServerHandle() throws NdLocalServerException {
        return this.SiPVxbS().SiPVuOD;
    }

    protected Object getServerProperty(Object object) throws NdLocalServerException {
        return this.SiPVxbS().SiPVuQF.get(object);
    }

    protected void setServerProperty(Object object, Object object2) throws NdLocalServerException {
        if (object2 == null) {
            this.SiPVxbS().SiPVuQF.remove(object);
        } else {
            this.SiPVxbS().SiPVuQF.put(object, object2);
        }
    }

    protected Enumeration getServerProperties() throws NdLocalServerException {
        return this.SiPVxbS().SiPVuQF.keys();
    }

    protected NdLocalServer tryGetLocalServer() {
        NdLocalServer ndLocalServer = null;
        if (!this.SiPVwQH && this.SiPVwPG) {
            Object object;
            try {
                object = this.SiPVwYP();
            }
            catch (NdServerDeploymentIllegalStateException ndServerDeploymentIllegalStateException) {
                throw new NdLocalServerRuntimeException(this.getServerId(), (Throwable)((Object)ndServerDeploymentIllegalStateException));
            }
            SiPVuSH siPVuSH = (SiPVuSH)SiPVwTK.get(object);
            if (siPVuSH != null) {
                ndLocalServer = (NdLocalServer)siPVuSH.SiPVuOD.SiPpmrD();
            }
        }
        return ndLocalServer;
    }

    protected NdLocalServer getLocalServerInternal() throws NdLocalServerException {
        NdLocalServer ndLocalServer;
        try {
            ndLocalServer = (NdLocalServer)this.SiPVxbS().SiPVuOD.SiPpmrD();
        }
        catch (NdLocalServerException ndLocalServerException) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.blazesoft.server.deploy.NdServerDeploymentAccessException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NdServerDeploymentInitializationException(this.getServerId(), (Throwable)classNotFoundException);
            }
            Throwable throwable = NdWrappedExceptionSupport.getMatchingSourceThrowable((Throwable)((Object)ndLocalServerException), clazz);
            if (throwable == null) {
                throw new NdServerDeploymentInitializationException(this.getServerId(), (Throwable)((Object)ndLocalServerException));
            }
            throw ndLocalServerException;
        }
        if (ndLocalServer == null) {
            throw new NdServerDeploymentIllegalStateException(this.getServerId(), NdStrings.SiPpjKN("AttemptToAccessServerAfterShutdown"));
        }
        return ndLocalServer;
    }

    public NdServerConfig getServerConfig() throws NdLocalServerException {
        NdLocalServer ndLocalServer = this.tryGetLocalServer();
        NdServerConfig ndServerConfig = ndLocalServer == null ? this.SiPVwOF.SiPVyQJ() : ndLocalServer.getServerConfig();
        return ndServerConfig;
    }

    public NdMonitoredServer getLocalMonitoredServer() throws NdLocalServerException {
        return this.getLocalServerInternal();
    }

    public NdMonitoredServiceManager getLocalMonitoredServiceManager() throws NdLocalServerException {
        return (NdMonitoredServiceManager)((Object)this.getLocalServerInternal().getServiceManager());
    }

    public NdMonitoredService getLocalMonitoredService(String string) throws NdLocalServerException {
        return (NdMonitoredService)((Object)this.getLocalServerInternal().getService(string));
    }

    public NdMonitoredServiceSessionManager getLocalMonitoredServiceSessionManager(String string) throws NdLocalServerException {
        return (NdMonitoredServiceSessionManager)((Object)((NdManagedService)((Object)this.getLocalServerInternal().getService(string))).getServiceSessionManager());
    }

    public NdMonitoredSystemOutStream getLocalMonitoredSystemOutStream() throws NdLocalServerException {
        return this.getLocalServerInternal();
    }

    public NdMonitoredSystemErrStream getLocalMonitoredSystemErrStream() throws NdLocalServerException {
        return this.getLocalServerInternal();
    }

    protected NdServerDeploymentBase() {
    }

    protected NdServerDeploymentBase(Object object, NdServerConfigFactory ndServerConfigFactory) throws NdLocalServerException {
        this();
        this.setServerDeploymentContext(new NdDefaultServerDeploymentContext(object, ndServerConfigFactory));
    }

    protected NdServerDeploymentBase(Object object, String string) throws NdLocalServerException {
        this(object, string, null);
    }

    protected NdServerDeploymentBase(Object object, String string, Object[] objectArray) throws NdLocalServerException {
        this(object, new NdURLServerConfigFactory(string, objectArray));
    }

    protected NdServerDeploymentBase(Object object, StringBuffer stringBuffer) throws NdLocalServerException {
        this(object, stringBuffer, null);
    }

    protected NdServerDeploymentBase(Object object, StringBuffer stringBuffer, Object[] objectArray) throws NdLocalServerException {
        this(object, new NdStringBufferServerConfigFactory(stringBuffer, objectArray));
    }

    protected void setServerDeploymentContext(NdServerDeploymentContext ndServerDeploymentContext) throws NdLocalServerException {
        SiPVyTM siPVyTM = new SiPVyTM(ndServerDeploymentContext);
        this.SiPVwUL(siPVyTM);
    }

    protected NdServerDeploymentBase cloneServerDeployment() throws NdLocalServerException {
        NdServerDeploymentBase ndServerDeploymentBase;
        try {
            ndServerDeploymentBase = (NdServerDeploymentBase)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        ndServerDeploymentBase.SiPVxcT();
        ndServerDeploymentBase.SiPVwUL(this.SiPVwOF);
        return ndServerDeploymentBase;
    }

    public NdLocalServer getLocalServer() {
        NdLocalServer ndLocalServer;
        try {
            ndLocalServer = this.getLocalServerInternal();
        }
        catch (NdLocalServerException ndLocalServerException) {
            throw new NdLocalServerRuntimeException(this.getServerId(), NdStrings.SiPpjKN("ErrorInitializingServer"), (Throwable)((Object)ndLocalServerException));
        }
        return ndLocalServer;
    }

    public void setServiceClassLoadingContext(String string, NdClassLoadingContext ndClassLoadingContext) throws NdLocalServerException {
        this.getLocalServerInternal().setServiceClassLoadingContext(string, ndClassLoadingContext);
    }

    public NdServiceManager getServiceManager() {
        this.prepareTxContext();
        NdServiceManager ndServiceManager = this.getLocalServer().getServiceManager();
        this.validateTxContext();
        return ndServiceManager;
    }

    public NdService getService(String string) {
        this.prepareTxContext();
        NdService ndService = this.getLocalServer().getService(string);
        this.validateTxContext();
        return ndService;
    }

    public String[] getServiceNames() {
        this.prepareTxContext();
        String[] stringArray = this.getLocalServer().getServiceNames();
        this.validateTxContext();
        return stringArray;
    }

    public NdServerId getServerId() {
        this.prepareTxContext();
        NdServerId ndServerId = this.SiPVwNE;
        if (ndServerId == null) {
            ndServerId = this.SiPVwOF == null ? new NdServerId(NdStrings.SiPpjKN("UnspecifiedServerConfig")) : this.SiPVwOF.SiPVySL();
        }
        this.validateTxContext();
        return ndServerId;
    }

    public NdServerStatistics getStatistics() {
        this.prepareTxContext();
        NdServerStatistics ndServerStatistics = this.getLocalServer().getStatistics();
        this.validateTxContext();
        return ndServerStatistics;
    }

    public void garbageCollect() {
        this.prepareTxContext();
        System.gc();
        System.runFinalization();
        this.validateTxContext();
    }

    public long getUsedMemory() {
        this.prepareTxContext();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        this.validateTxContext();
        return l;
    }

    public long getFreeMemory() {
        this.prepareTxContext();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        this.validateTxContext();
        return l;
    }

    public long getTotalMemory() {
        this.prepareTxContext();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        this.validateTxContext();
        return l;
    }

    public String getSystemPropertiesList() {
        this.prepareTxContext();
        String string = NdDeploymentSupport.getSystemPropertiesList();
        this.validateTxContext();
        return string;
    }

    private void SiPVxcT() {
        this.SiPVwNE = null;
        this.SiPVwOF = null;
        this.SiPVwPG = false;
        this.SiPVwQH = false;
    }

    static class SiPVyTM
    implements Serializable {
        private NdServerDeploymentContext SiPVyKD;
        private Object SiPVyLE;
        private NdServerConfig SiPVyMF;
        private NdServerId SiPVyNG;

        SiPVyTM(NdServerDeploymentContext ndServerDeploymentContext) throws NdLocalServerException {
            this.SiPVyKD = ndServerDeploymentContext;
            this.SiPVyOH(ndServerDeploymentContext);
        }

        private void SiPVyOH(NdServerDeploymentContext ndServerDeploymentContext) throws NdLocalServerException {
            if (this.SiPVyLE != null) {
                throw new NdLocalServerException(this.SiPVySL(), NdStrings.SiPpjKN("ErrorSettingKey"));
            }
            Object object = ndServerDeploymentContext.getServerConfigKey();
            if (object == null) {
                throw new NdLocalServerException(this.SiPVySL(), NdStrings.SiPpjKN("ErrorSettingNullKey"));
            }
            this.SiPVyLE = object;
        }

        public Object SiPVyPI() {
            return this.SiPVyLE;
        }

        public NdServerConfig SiPVyQJ() throws NdLocalServerException {
            if (this.SiPVyMF == null) {
                try {
                    this.SiPVyMF = this.SiPVyKD.getServerConfig();
                }
                catch (NdServerException ndServerException) {
                    if (ndServerException instanceof NdLocalServerException) {
                        throw (NdLocalServerException)ndServerException;
                    }
                    throw new NdLocalServerException(this.SiPVySL(), (Throwable)((Object)ndServerException));
                }
                this.SiPVyKD = null;
            }
            return this.SiPVyMF;
        }

        void SiPVyRK(NdServerConfig ndServerConfig) {
            this.SiPVyMF = ndServerConfig;
            this.SiPVyKD = null;
        }

        public NdServerId SiPVySL() {
            if (this.SiPVyNG == null) {
                this.SiPVyNG = this.SiPVyMF != null ? new NdServerId(this.SiPVyMF.getName()) : new NdServerId(String.valueOf(this.SiPVyKD.getServerConfigKey()));
            }
            return this.SiPVyNG;
        }
    }

    private static class SiPVuSH {
        public SiPpmrF SiPVuOD;
        public long SiPVuPE;
        public Hashtable SiPVuQF;
        public boolean SiPVuRG;

        public SiPVuSH(NdLocalServer ndLocalServer) {
            this.SiPVuOD = new SiPpmrF(ndLocalServer);
            this.SiPVuPE = 1L;
            this.SiPVuQF = new Hashtable();
        }
    }
}

