/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy;

import com.blazesoft.server.base.NdInteractiveServiceSession;
import com.blazesoft.server.base.NdManagedService;
import com.blazesoft.server.base.NdMonitoredServiceAgent;
import com.blazesoft.server.base.NdMonitoredServiceSession;
import com.blazesoft.server.base.NdService;
import com.blazesoft.server.base.NdServiceException;
import com.blazesoft.server.base.NdServiceSessionException;
import com.blazesoft.server.config.NdServerConfig;
import com.blazesoft.server.config.NdServerConfigFactory;
import com.blazesoft.server.deploy.NdServerDeploymentBase;
import com.blazesoft.server.deploy.NdStatelessServer;
import com.blazesoft.server.deploy.NdStrings;
import com.blazesoft.server.local.NdLocalServer;
import com.blazesoft.server.local.NdLocalServerException;
import com.blazesoft.server.local.NdLocalService;
import com.blazesoft.util.NdClassLoadingContext;

public abstract class NdStatelessServerDeploymentBase
extends NdServerDeploymentBase {
    protected NdLocalServer createServer(NdServerConfig ndServerConfig) throws NdLocalServerException {
        return NdStatelessServer.createStatelessServer(ndServerConfig);
    }

    protected NdStatelessServerDeploymentBase() {
    }

    protected NdStatelessServerDeploymentBase(Object object, NdServerConfigFactory ndServerConfigFactory) throws NdLocalServerException {
        super(object, ndServerConfigFactory);
    }

    protected NdStatelessServerDeploymentBase(Object object, String string) throws NdLocalServerException {
        this(object, string, null);
    }

    protected NdStatelessServerDeploymentBase(Object object, String string, Object[] objectArray) throws NdLocalServerException {
        super(object, string, objectArray);
    }

    protected NdStatelessServerDeploymentBase(Object object, StringBuffer stringBuffer) throws NdLocalServerException {
        this(object, stringBuffer, null);
    }

    protected NdStatelessServerDeploymentBase(Object object, StringBuffer stringBuffer, Object[] objectArray) throws NdLocalServerException {
        super(object, stringBuffer, objectArray);
    }

    public Object invokeDeployment(String string, String string2, String string3, Object[] objectArray, NdClassLoadingContext ndClassLoadingContext) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        NdStatelessServer ndStatelessServer = null;
        Object object = null;
        try {
            this.prepareTxContext();
            ndStatelessServer = (NdStatelessServer)this.getLocalServerInternal();
            object = ndStatelessServer.invokeService(string, string2, string3, objectArray, ndClassLoadingContext);
            this.validateTxContext();
        }
        catch (RuntimeException runtimeException) {
            NdLocalServerException ndLocalServerException = new NdLocalServerException(this.getServerId(), NdStrings.SiPpjMP("FailedToInvokeService", string), runtimeException);
            if (ndStatelessServer != null) {
                ndStatelessServer.notifyException((Throwable)((Object)ndLocalServerException));
            }
            throw ndLocalServerException;
        }
        return object;
    }

    public Object invokeDeployment(String string, String string2, String string3, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        return this.invokeDeployment(string, string2, string3, objectArray, null);
    }

    public Object invokeDeployment(String string, String string2, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        return this.invokeDeployment(string, null, string2, objectArray);
    }

    public Object invokeDeployment(String string, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        return this.invokeDeployment(string, null, objectArray);
    }

    public Object invokeDeployment(NdService ndService, String string, String string2, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        Object object = null;
        NdStatelessServer ndStatelessServer = null;
        try {
            this.prepareTxContext();
            ndStatelessServer = (NdStatelessServer)this.getLocalServerInternal();
            object = ndStatelessServer.invokeService(ndService, string, string2, objectArray);
            this.validateTxContext();
        }
        catch (RuntimeException runtimeException) {
            NdServiceException ndServiceException = new NdServiceException(ndService.getServiceId(), NdStrings.SiPpjMP("FailedToInvokeService", ndService.getServiceId().getServiceName()), runtimeException);
            if (ndService instanceof NdLocalService) {
                ((NdLocalService)ndService).notifyException((Throwable)((Object)ndServiceException));
            } else if (ndStatelessServer != null) {
                ndStatelessServer.notifyException((Throwable)((Object)ndServiceException));
            }
            throw ndServiceException;
        }
        return object;
    }

    public Object invokeDeployment(NdService ndService, String string, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        return this.invokeDeployment(ndService, null, string, objectArray);
    }

    public Object invokeDeployment(NdService ndService, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        return this.invokeDeployment(ndService, null, objectArray);
    }

    protected NdMonitoredServiceSession getLocalMonitoredServiceSession(String string, String string2) throws NdLocalServerException {
        return ((NdManagedService)((Object)this.getLocalServerInternal().getService(string))).getMonitoredServiceSession(string2);
    }

    protected NdMonitoredServiceAgent getLocalMonitoredServiceAgent(String string, String string2) throws NdLocalServerException {
        return ((NdManagedService)((Object)this.getLocalServerInternal().getService(string))).getMonitoredServiceAgent(string2);
    }

    protected NdInteractiveServiceSession getLocalInteractiveServiceSession(String string, String string2) throws NdLocalServerException {
        return ((NdManagedService)((Object)this.getLocalServerInternal().getService(string))).getInteractiveServiceSession(string2);
    }
}

