/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy.ejb.session;

import com.blazesoft.server.deploy.ejb.NdEjbServerDeploymentUtil;
import com.blazesoft.server.deploy.ejb.session.NdStatelessEjbServerEnterpriseBean;
import com.blazesoft.server.deploy.ejb.session.NdStrings;
import com.blazesoft.server.local.NdLocalServerException;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.NamingException;

public abstract class NdStatelessEjbServerMessageDrivenBeanBase
extends NdStatelessEjbServerEnterpriseBean {
    protected NdStatelessEjbServerMessageDrivenBeanBase() {
    }

    private void SiPucKM(Destination destination, Object object) throws JMSException, NamingException {
        QueueConnectionFactory queueConnectionFactory = this.getReplyQueueConnectionFactory();
        QueueConnection queueConnection = queueConnectionFactory.createQueueConnection();
        QueueSession queueSession = queueConnection.createQueueSession(false, 1);
        QueueSender queueSender = queueSession.createSender((Queue)destination);
        ObjectMessage objectMessage = queueSession.createObjectMessage((Serializable)object);
        queueSender.send((Message)objectMessage);
        queueSession.close();
        queueConnection.close();
    }

    private void SiPucLN(Destination destination, Object object) throws JMSException, NamingException {
        TopicConnectionFactory topicConnectionFactory = this.getReplyTopicConnectionFactory();
        TopicConnection topicConnection = topicConnectionFactory.createTopicConnection();
        TopicSession topicSession = topicConnection.createTopicSession(false, 1);
        TopicPublisher topicPublisher = topicSession.createPublisher((Topic)destination);
        ObjectMessage objectMessage = topicSession.createObjectMessage((Serializable)object);
        topicPublisher.publish((Message)objectMessage);
        topicSession.close();
        topicConnection.close();
    }

    protected void putReplyMessage(Message message, Object object) throws NdLocalServerException {
        block25: {
            try {
                Destination destination;
                try {
                    destination = message.getJMSReplyTo();
                }
                catch (JMSException jMSException) {
                    throw new NdLocalServerException(this.getServerId(), (Throwable)jMSException);
                }
                if (destination == null) {
                    return;
                }
                if (destination instanceof Queue && destination instanceof Topic) {
                    String string = "";
                    try {
                        string = message.getStringProperty("ndconfig_replyDestinationType");
                    }
                    catch (JMSException jMSException) {
                        throw new NdLocalServerException(this.getServerId(), NdStrings.SiPpjaU("FailedToSetRetrieveReply"));
                    }
                    if (string.equals("Queue")) {
                        try {
                            this.SiPucKM(destination, object);
                            break block25;
                        }
                        catch (JMSException jMSException) {
                            throw new NdLocalServerException(this.getServerId(), (Throwable)jMSException);
                        }
                        catch (NamingException namingException) {
                            throw new NdLocalServerException(this.getServerId(), (Throwable)namingException);
                        }
                    }
                    if (string.equals("Topic")) {
                        try {
                            this.SiPucLN(destination, object);
                            break block25;
                        }
                        catch (JMSException jMSException) {
                            throw new NdLocalServerException(this.getServerId(), (Throwable)jMSException);
                        }
                        catch (NamingException namingException) {
                            throw new NdLocalServerException(this.getServerId(), (Throwable)namingException);
                        }
                    }
                    if (string.equals("")) {
                        throw new NdLocalServerException(this.getServerId(), NdStrings.SiPpjaU("ReplyNotSet"));
                    }
                    throw new NdLocalServerException(this.getServerId(), NdStrings.SiPpjaU("InvalideReply"));
                }
                if (destination instanceof Queue) {
                    try {
                        this.SiPucKM(destination, object);
                        break block25;
                    }
                    catch (JMSException jMSException) {
                        throw new NdLocalServerException(this.getServerId(), (Throwable)jMSException);
                    }
                    catch (NamingException namingException) {
                        throw new NdLocalServerException(this.getServerId(), (Throwable)namingException);
                    }
                }
                if (destination instanceof Topic) {
                    try {
                        this.SiPucLN(destination, object);
                        break block25;
                    }
                    catch (JMSException jMSException) {
                        throw new NdLocalServerException(this.getServerId(), (Throwable)jMSException);
                    }
                    catch (NamingException namingException) {
                        throw new NdLocalServerException(this.getServerId(), (Throwable)namingException);
                    }
                }
                throw new NdLocalServerException(this.getServerId(), NdStrings.SiPpjaW("UnsupportedReplyDestinationType", destination.getClass().getName()));
            }
            catch (RuntimeException runtimeException) {
                throw new NdLocalServerException(this.getServerId(), (Throwable)runtimeException);
            }
        }
    }

    protected QueueConnectionFactory getReplyQueueConnectionFactory() throws NamingException {
        return (QueueConnectionFactory)NdEjbServerDeploymentUtil.getEnvPropertyValue(this.getJNDIContext(), this.getEJBContext(), "ndconfig.replyQueueConnectionFactory");
    }

    protected TopicConnectionFactory getReplyTopicConnectionFactory() throws NamingException {
        return (TopicConnectionFactory)NdEjbServerDeploymentUtil.getEnvPropertyValue(this.getJNDIContext(), this.getEJBContext(), "ndconfig.replyTopicConnectionFactory");
    }
}

