/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy.manager;

import com.blazesoft.server.config.NdDeploymentManagerConfig;
import com.blazesoft.server.deploy.manager.NdDeploymentEvent;
import com.blazesoft.server.deploy.manager.NdDeploymentManager;
import com.blazesoft.server.deploy.manager.NdRulesProjectStatus;
import com.blazesoft.server.deploy.manager.cache.NdProjectCacheManager;
import com.blazesoft.server.rules.NdRulesProjectInnovatorLoaderFactory;
import com.blazesoft.server.rules.NdRulesProjectLoaderFactory;
import com.blazesoft.server.rules.NdSerializedRulesProjectLoaderFactory;
import com.blazesoft.server.rules.NdServerRulesAgent;
import com.blazesoft.server.rules.NdServerRulesSerializationHeader;
import com.blazesoft.server.rules.SiPNxgT;
import com.blazesoft.system.NdExceptionEvent;
import com.blazesoft.system.NdRunnableStoppable;
import com.blazesoft.system.NdRuntimeExceptionHandler;
import com.blazesoft.system.NdSemaphore;
import com.blazesoft.util.NdWrappedRuntimeException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class NdDeploymentManagerChangeMonitor
extends Thread
implements NdRunnableStoppable {
    private long SiPpTYS = Long.MAX_VALUE;
    private NdDeploymentManager SiPpTYT;
    private boolean SiPpTYU;
    private NdRuntimeExceptionHandler SiPpTYV;
    private Vector SiPpTYW;
    private Vector SiPpTYX;
    private Vector SiPqwDC;
    private NdSemaphore SiPpTYY;
    private boolean SiPNvzI = true;
    private SiPpUuP SiPpTYZ = new SiPpUuP();

    public NdDeploymentManagerChangeMonitor(NdDeploymentManager ndDeploymentManager, String string) {
        int n;
        this.SiPpTYT = ndDeploymentManager;
        if (string != null) {
            try {
                this.SiPpTYS = new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.SiPpTYU = true;
        this.SiPpTYY = new NdSemaphore(0);
        NdDeploymentManagerConfig ndDeploymentManagerConfig = this.SiPpTYT.getConfig();
        NdRulesProjectLoaderFactory[] ndRulesProjectLoaderFactoryArray = ndDeploymentManagerConfig.getRulesProjectLoaderFactory();
        ndDeploymentManagerConfig.enableLocalRepository(false);
        NdSerializedRulesProjectLoaderFactory[] ndSerializedRulesProjectLoaderFactoryArray = ndDeploymentManagerConfig.getSerializedRulesProjectLoaderFactory();
        NdRulesProjectInnovatorLoaderFactory[] ndRulesProjectInnovatorLoaderFactoryArray = ndDeploymentManagerConfig.getRulesProjectInnovatorLoaderFactory();
        if (ndRulesProjectLoaderFactoryArray != null) {
            this.SiPpTYW = new Vector();
            for (n = 0; n < ndRulesProjectLoaderFactoryArray.length; ++n) {
                this.SiPpTYW.addElement(ndRulesProjectLoaderFactoryArray[n].newRulesProjectLoader(ndDeploymentManagerConfig));
            }
        }
        if (ndSerializedRulesProjectLoaderFactoryArray != null) {
            this.SiPpTYX = new Vector();
            for (n = 0; n < ndSerializedRulesProjectLoaderFactoryArray.length; ++n) {
                this.SiPpTYX.addElement(ndSerializedRulesProjectLoaderFactoryArray[n].newSerializedRulesProjectLoader(ndDeploymentManagerConfig));
            }
        }
        if (ndRulesProjectInnovatorLoaderFactoryArray != null) {
            this.SiPqwDC = new Vector();
            for (n = 0; n < ndRulesProjectInnovatorLoaderFactoryArray.length; ++n) {
                if (ndRulesProjectInnovatorLoaderFactoryArray[0] == null) continue;
                this.SiPqwDC.addElement(ndRulesProjectInnovatorLoaderFactoryArray[n].newRulesProjectInnovatorLoader(ndDeploymentManagerConfig, true));
            }
        }
    }

    public NdDeploymentManagerChangeMonitor(NdDeploymentManager ndDeploymentManager) {
        this(ndDeploymentManager, null);
    }

    private void SiPpTZA() {
        Vector vector = new Vector();
        if (this.SiPpTYW != null) {
            this.SiPNvzJ(vector, this.SiPpTYW.elements());
        }
        if (this.SiPpTYX != null) {
            this.SiPNvzJ(vector, this.SiPpTYX.elements());
        }
        if (this.SiPqwDC != null) {
            this.SiPNvzJ(vector, this.SiPqwDC.elements());
        }
        this.SiPNvzI = false;
        if (vector.size() > 0) {
            NdRulesProjectStatus[] ndRulesProjectStatusArray = new NdRulesProjectStatus[vector.size()];
            for (int i = 0; i < ndRulesProjectStatusArray.length; ++i) {
                ndRulesProjectStatusArray[i] = (NdRulesProjectStatus)vector.elementAt(i);
            }
            this.SiPpTYT.onDeploymentEvent(new NdDeploymentEvent((Object)this, ndRulesProjectStatusArray, 0));
        }
    }

    private void SiPNvzJ(Vector vector, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof SiPNxgT)) continue;
            SiPNxgT siPNxgT = (SiPNxgT)e;
            if (!this.SiPNvzI || this.SiPpTYT.getProjectCacheManager() == null) {
                String string = siPNxgT.getId();
                boolean bl = siPNxgT.hasChanged();
                if (!bl) continue;
                Date date = ((SiPNxgT)e).getLastModified();
                vector.addElement(new NdRulesProjectStatus(string, date, true));
                continue;
            }
            this.SiPNvzK(siPNxgT, vector);
        }
    }

    public void start() {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.SiPpTYU) {
            SiPpUuP siPpUuP = this.SiPpTYZ;
            synchronized (siPpUuP) {
                try {
                    this.SiPpTYZ.wait(this.SiPpTYS);
                }
                catch (InterruptedException interruptedException) {
                    this.SiPpTYV.handleRuntimeException((RuntimeException)new NdWrappedRuntimeException((Throwable)interruptedException), (Runnable)this);
                }
                catch (RuntimeException runtimeException) {
                    this.SiPpTYV.handleRuntimeException(runtimeException, (Runnable)this);
                }
                this.SiPpTZA();
            }
        }
        try {
            this.SiPpTYY.release();
        }
        catch (RuntimeException runtimeException) {
            this.SiPpTYV.handleRuntimeException(runtimeException, (Runnable)this);
        }
    }

    public void stopRunning(boolean bl) throws InterruptedException {
        if (!this.SiPpTYU) {
            return;
        }
        this.SiPpTYU = false;
        if (bl) {
            this.SiPpTYY.acquire();
        }
    }

    public void stopRunning() throws InterruptedException {
        this.SiPpTYU = false;
    }

    public void abortRunning(boolean bl) throws InterruptedException {
        this.SiPpTYU = false;
        if (bl) {
            this.SiPpTYY.acquire();
        }
    }

    public void abortRunning() throws InterruptedException {
        this.SiPpTYU = false;
    }

    public void setRuntimeExceptionHandler(NdRuntimeExceptionHandler ndRuntimeExceptionHandler) {
        this.SiPpTYV = ndRuntimeExceptionHandler;
    }

    public void notifyBeginRun() {
    }

    public void notifyEndRun() {
    }

    private void SiPNvzK(SiPNxgT siPNxgT, Vector vector) {
        String string = siPNxgT.getId();
        Iterator iterator = this.SiPNvzL(string);
        if (iterator == null) {
            vector.addElement(string);
            return;
        }
        while (iterator.hasNext()) {
            Date date = (Date)iterator.next();
            Date date2 = siPNxgT.getLastModified();
            if (date2 == null || date == null) {
                vector.addElement(new NdRulesProjectStatus(string, null, true));
                break;
            }
            if (date2.getTime() <= date.getTime()) continue;
            vector.addElement(new NdRulesProjectStatus(string, date2, true));
            break;
        }
    }

    private Iterator SiPNvzL(String string) {
        NdProjectCacheManager ndProjectCacheManager = this.SiPpTYT.getProjectCacheManager();
        if (ndProjectCacheManager == null) {
            return null;
        }
        Iterator iterator = ndProjectCacheManager.getAllCache(string);
        if (iterator == null) {
            return null;
        }
        ArrayList<Date> arrayList = new ArrayList<Date>();
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            if (byArray == null) continue;
            Date date = this.SiPNvzM(byArray);
            arrayList.add(date);
        }
        return arrayList.iterator();
    }

    private Date SiPNvzM(byte[] byArray) {
        try {
            NdServerRulesSerializationHeader ndServerRulesSerializationHeader = NdServerRulesAgent.loadHeader(new ByteArrayInputStream(byArray), 1);
            return ndServerRulesSerializationHeader.getProjectLastModifiedDateTime();
        }
        catch (Exception exception) {
            this.SiPNvzN(exception);
            return null;
        }
    }

    private void SiPNvzN(Throwable throwable) {
        this.SiPpTYT.getExceptionListener().onException(new NdExceptionEvent(throwable));
    }

    private static class SiPpUuP {
        private SiPpUuP() {
        }
    }
}

