/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy.manager;

import com.blazesoft.engines.rules.NdCompilationException;
import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.server.deploy.manager.NdDeploymentManager;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerException;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerProjectCompiler;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerServerManager;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerServerManagerImpl;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerServerManagerRemote;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerServiceInfo;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerServiceProjectLoaderInfo;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerServiceProjectLoaderInfoRemote;
import com.blazesoft.server.deploy.manager.NdGenericDeploymentManagerServerManager;
import com.blazesoft.server.deploy.manager.NdMonitoredDeploymentManagerServiceProjectLoaderInfo;
import com.blazesoft.server.deploy.manager.NdRulesProjectLoaderEvent;
import com.blazesoft.server.deploy.manager.NdRulesProjectLoaderListener;
import com.blazesoft.server.deploy.manager.NdRulesProjectStatus;
import com.blazesoft.server.deploy.manager.NdStrings;
import com.blazesoft.server.deploy.manager.java.NdDeploymentManagerJavaServerManagerSupport;
import com.blazesoft.server.rules.NdRulesProjectLoader;
import com.blazesoft.server.rules.NdRulesProjectLoaderFactory;
import com.blazesoft.server.rules.NdSerializedRulesProjectLoader;
import com.blazesoft.server.rules.NdSerializedRulesProjectLoaderFactory;
import com.blazesoft.server.rules.NdSerializedRulesProjectRemoteLoader;
import com.blazesoft.server.rules.SiPNxgT;
import com.blazesoft.system.NdExceptionEvent;
import com.blazesoft.system.NdExceptionListener;
import com.blazesoft.util.NdSystemProperties;
import com.blazesoft.util.NdWrappedExceptionSupport;
import java.rmi.RemoteException;

public class NdDeploymentManagerServiceProjectLoaderInfoImpl
implements NdDeploymentManagerServiceProjectLoaderInfo,
NdDeploymentManagerServiceProjectLoaderInfoRemote,
NdMonitoredDeploymentManagerServiceProjectLoaderInfo {
    private NdDeploymentManagerServerManagerRemote SiPzGTZ;
    private NdDeploymentManager SiPzGUA;
    private NdDeploymentManagerServiceInfo SiPzGUB;
    private NdRulesProjectLoaderFactory SiPzGUC;
    private NdSerializedRulesProjectLoaderFactory SiPzGUD;
    private NdRulesProjectLoaderListener SiPUikZ;
    private NdExceptionListener SiPUilA;

    NdDeploymentManagerServiceProjectLoaderInfoImpl(NdDeploymentManagerServerManagerRemote ndDeploymentManagerServerManagerRemote, NdDeploymentManager ndDeploymentManager, NdDeploymentManagerServiceInfo ndDeploymentManagerServiceInfo, NdRulesProjectLoaderFactory ndRulesProjectLoaderFactory) {
        this.SiPzGTZ = ndDeploymentManagerServerManagerRemote;
        this.SiPzGUA = ndDeploymentManager;
        this.SiPzGUB = ndDeploymentManagerServiceInfo;
        this.SiPzGUC = ndRulesProjectLoaderFactory;
        this.SiPzGUD = null;
    }

    NdDeploymentManagerServiceProjectLoaderInfoImpl(NdDeploymentManagerServerManagerRemote ndDeploymentManagerServerManagerRemote, NdDeploymentManager ndDeploymentManager, NdDeploymentManagerServiceInfo ndDeploymentManagerServiceInfo, NdSerializedRulesProjectLoaderFactory ndSerializedRulesProjectLoaderFactory) {
        this.SiPzGTZ = ndDeploymentManagerServerManagerRemote;
        this.SiPzGUA = ndDeploymentManager;
        this.SiPzGUB = ndDeploymentManagerServiceInfo;
        this.SiPzGUC = null;
        this.SiPzGUD = ndSerializedRulesProjectLoaderFactory;
    }

    private int SiPzGUF() {
        int n = -1;
        if (this.SiPzGUC != null) {
            n = this.SiPzGUC.isMapAllPropertiesEnabled() ? 1 : 0;
        }
        return n;
    }

    public String getServiceName() throws NdDeploymentManagerException {
        return this.SiPzGUB.getServiceName();
    }

    public NdRulesProjectLoader getProjectLoader() throws NdDeploymentManagerException {
        SiPNxgT siPNxgT = null;
        if (this.SiPzGUC != null) {
            try {
                siPNxgT = this.SiPzGUC.newRulesProjectLoader(this.SiPzGUA.getConfig());
            }
            catch (Exception exception) {
                throw new NdDeploymentManagerException(NdStrings.SiPpJqD("FailedToGetProjectLoader"), exception);
            }
        }
        if (siPNxgT != null) {
            this.SiPzGUA.notifyDeploymentManagerEvent(6, siPNxgT.getId());
        }
        return siPNxgT;
    }

    public NdSerializedRulesProjectLoader getSerializedProjectLoader() throws NdDeploymentManagerException {
        SiPNxgT siPNxgT = null;
        if (this.SiPzGUD != null) {
            try {
                siPNxgT = this.SiPzGUD.newSerializedRulesProjectLoader(this.SiPzGUA.getConfig());
            }
            catch (Exception exception) {
                throw new NdDeploymentManagerException(NdStrings.SiPpJqD("FailedToGetProjectLoader"), exception);
            }
        }
        if (siPNxgT != null) {
            this.SiPzGUA.notifyDeploymentManagerEvent(6, siPNxgT.getId());
        }
        return siPNxgT;
    }

    public NdRulesProjectStatus getRulesProjectStatus() {
        NdRulesProjectStatus ndRulesProjectStatus = null;
        NdDeploymentManagerJavaServerManagerSupport ndDeploymentManagerJavaServerManagerSupport = null;
        if (this.SiPzGTZ instanceof NdGenericDeploymentManagerServerManager) {
            ndDeploymentManagerJavaServerManagerSupport = ((NdDeploymentManagerServerManagerImpl)this.SiPzGTZ).getSupport();
        } else if (this.SiPzGTZ instanceof NdDeploymentManagerServerManagerImpl) {
            ndDeploymentManagerJavaServerManagerSupport = ((NdDeploymentManagerServerManagerImpl)this.SiPzGTZ).getSupport();
        }
        if (ndDeploymentManagerJavaServerManagerSupport != null) {
            ndRulesProjectStatus = ndDeploymentManagerJavaServerManagerSupport.getRulesProjectStatus(this.SiPzGUB);
        } else if (NdSystemProperties.isDebugModeEnabled()) {
            Exception exception = new Exception(NdStrings.SiPpJqF("ErrorGettingCurrentLoaderSerialNumber", this.SiPzGTZ.getClass().getName()));
            exception.printStackTrace();
        }
        return ndRulesProjectStatus;
    }

    public String getRemoteServiceName() throws RemoteException {
        String string = null;
        try {
            string = this.getServiceName();
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException(NdStrings.SiPpJqD("ErrorGettingServiceName"), exception);
            this.notifyException(NdDotNETLib.makeJavaThrowable((Object)remoteException));
            throw remoteException;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getRemoteSerializedProjectFileContents() throws RemoteException {
        byte[] byArray = null;
        try {
            NdSerializedRulesProjectLoader ndSerializedRulesProjectLoader = this.getSerializedProjectLoader();
            if (ndSerializedRulesProjectLoader != null) {
                if (!(ndSerializedRulesProjectLoader instanceof NdSerializedRulesProjectRemoteLoader)) throw new NdDeploymentManagerException(NdStrings.SiPpJqD("NonRemoteSerializedProjectLoader"));
                return ((NdSerializedRulesProjectRemoteLoader)((Object)ndSerializedRulesProjectLoader)).getSerializedProjectFileContents();
            }
            byArray = new NdDeploymentManagerProjectCompiler().getCompiledSerializedProject(this.SiPzGUF(), this.getProjectLoader(), this.SiPzGUB.getServiceConfig(), this.SiPzGUB.getServerConfig(), this.SiPzGUA.getProjectCacheManager(), this.SiPzGUA.getConfig(), this.SiPzGUA.getCompilationMutexManager(), this.SiPzGUA.getClassLoadingContext());
            this.notifyProjectLoaderEvent();
            return byArray;
        }
        catch (NdCompilationException ndCompilationException) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                NdWrappedExceptionSupport.printStackTrace((Throwable)ndCompilationException);
            }
            RemoteException remoteException = new RemoteException(NdStrings.SiPpJqG("FailureCompilingAgent", this.SiPzGUC.getId(), ndCompilationException.fullMessage()), ndCompilationException);
            this.notifyProjectLoaderEvent(NdDotNETLib.makeJavaThrowable((Object)remoteException));
            this.notifyException(NdDotNETLib.makeJavaThrowable((Object)remoteException));
            throw remoteException;
        }
        catch (Exception exception) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                NdWrappedExceptionSupport.printStackTrace((Throwable)exception);
            }
            RemoteException remoteException = new RemoteException(NdStrings.SiPpJqD("ErrorGettingProjectFileContents"), exception);
            this.notifyProjectLoaderEvent(NdDotNETLib.makeJavaThrowable((Object)remoteException));
            this.notifyException(NdDotNETLib.makeJavaThrowable((Object)remoteException));
            throw remoteException;
        }
        catch (Throwable throwable) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                NdWrappedExceptionSupport.printStackTrace((Throwable)throwable);
            }
            RemoteException remoteException = new RemoteException(NdStrings.SiPpJqD("ErrorGettingProjectFileContents"), throwable);
            this.notifyProjectLoaderEvent(NdDotNETLib.makeJavaThrowable((Object)remoteException));
            this.notifyException(NdDotNETLib.makeJavaThrowable((Object)remoteException));
            throw remoteException;
        }
    }

    public NdRulesProjectStatus getRemoteRulesProjectStatus() throws RemoteException {
        try {
            return this.getRulesProjectStatus();
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException(NdStrings.SiPpJqD("ErrorAccessRulesProjectStatus"), exception);
            this.notifyException(NdDotNETLib.makeJavaThrowable((Object)remoteException));
            throw remoteException;
        }
    }

    public void ping() throws RemoteException {
    }

    public NdRulesProjectLoaderFactory getProjectLoaderFactory() {
        return this.SiPzGUC;
    }

    public void setRulesProjectLoaderListener(NdRulesProjectLoaderListener ndRulesProjectLoaderListener) {
        this.SiPUikZ = ndRulesProjectLoaderListener;
    }

    public NdRulesProjectLoaderListener getRulesProjectLoaderListener() {
        return this.SiPUikZ;
    }

    public void setExceptionListener(NdExceptionListener ndExceptionListener) {
        this.SiPUilA = ndExceptionListener;
    }

    public void notifyException(Throwable throwable) {
        if (this.SiPUilA != null) {
            this.SiPUilA.onException(new NdExceptionEvent(Thread.currentThread(), throwable));
        }
    }

    public void notifyProjectLoaderEvent(Throwable throwable) {
        NdRulesProjectLoaderEvent ndRulesProjectLoaderEvent = null;
        if (this.SiPUikZ != null) {
            ndRulesProjectLoaderEvent = throwable == null ? new NdRulesProjectLoaderEvent(this, this.SiPzGUB, (NdDeploymentManagerServerManager)((Object)this.SiPzGTZ), this.SiPzGUC.getId()) : new NdRulesProjectLoaderEvent(this, this.SiPzGUB, (NdDeploymentManagerServerManager)((Object)this.SiPzGTZ), this.SiPzGUC.getId(), throwable);
            this.SiPUikZ.onRulesProjectLoaderEvent(ndRulesProjectLoaderEvent);
        }
    }

    public void notifyProjectLoaderEvent() {
        this.notifyProjectLoaderEvent(null);
    }
}

