/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy.manager.cache;

import com.blazesoft.server.config.NdDeploymentManagerConfig;
import com.blazesoft.server.config.NdServiceConfig;
import com.blazesoft.server.config.SiPNvbI;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerRuntimeException;
import com.blazesoft.server.deploy.manager.cache.NdCacheProjectInfo;
import com.blazesoft.server.deploy.manager.cache.NdProjectCacheStore;
import com.blazesoft.server.deploy.manager.cache.NdProjectCacheStoreFactory;
import com.blazesoft.server.deploy.manager.cache.SiPNuKV;
import com.blazesoft.server.rules.NdServerRulesAgent;
import com.blazesoft.server.rules.NdServerRulesSerializationHeader;
import com.blazesoft.system.NdExceptionEvent;
import com.blazesoft.system.NdExceptionListener;
import com.blazesoft.system.NdMutex;
import com.blazesoft.system.NdMutexManager;
import com.blazesoft.util.WjHzFYN;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class NdProjectCacheManager {
    private String SiPNxNK = "NdDMCacheMap.ser";
    private Map SiPNxNL;
    private NdProjectCacheStore SiPNxNM;
    private NdExceptionListener SiPNxNN;
    private NdMutexManager SiPNxNO = new NdMutexManager();
    private static final String SiPNxNP = "___LAST_CACHE_NUM___";
    private static final String SiPUlfI = "___SERVICE_CONFIG_KEY____";
    private int SiPNxNQ = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdProjectCacheManager(NdDeploymentManagerConfig ndDeploymentManagerConfig, NdExceptionListener ndExceptionListener) {
        Integer n;
        NdProjectCacheStoreFactory ndProjectCacheStoreFactory = ndDeploymentManagerConfig.getProjectCacheStoreFactory();
        if (ndProjectCacheStoreFactory != null) {
            this.SiPNxNM = ndProjectCacheStoreFactory.newCacheStore();
        }
        if (ndDeploymentManagerConfig.isMemoryProjectCacheEnabled()) {
            this.SiPNxNM = new SiPNuKV(this.SiPNxNM);
        }
        this.SiPNxNN = ndExceptionListener;
        try {
            this.SiPNxNL = (Map)this.SiPNxNX();
        }
        catch (Throwable throwable) {
            throw this.SiPUlgJ(throwable);
        }
        if (this.SiPNxNL == null) {
            this.SiPNxNL = new HashMap();
        }
        if ((n = (Integer)this.SiPNxNL.get(SiPNxNP)) != null) {
            NdProjectCacheManager ndProjectCacheManager = this;
            synchronized (ndProjectCacheManager) {
                this.SiPNxNQ = n;
            }
        }
    }

    public byte[] readCache(String string, NdServiceConfig ndServiceConfig) {
        if (ndServiceConfig == null) {
            return null;
        }
        NdMutex ndMutex = null;
        try {
            String string2 = NdProjectCacheManager.SiPNxNR(ndServiceConfig);
            String string3 = this.SiPNxNT(string, string2, false);
            if (string3 == null) {
                byte[] byArray = null;
                return byArray;
            }
            ndMutex = this.SiPNxNO.getMutex(string3);
            ndMutex.acquire();
            byte[] byArray = this.SiPNxNM.readCache(string3);
            return byArray;
        }
        catch (InterruptedException interruptedException) {
            throw this.SiPUlgJ(interruptedException);
        }
        catch (Throwable throwable) {
            throw this.SiPUlgJ(throwable);
        }
        finally {
            if (ndMutex != null) {
                ndMutex.release();
            }
        }
    }

    private static String SiPNxNR(NdServiceConfig ndServiceConfig) {
        return SiPNvbI.SiPNvbH(ndServiceConfig.getServiceClientContextFactory());
    }

    public void writeCache(String string, NdServiceConfig ndServiceConfig, byte[] byArray) {
        NdMutex ndMutex = null;
        try {
            String string2 = NdProjectCacheManager.SiPNxNR(ndServiceConfig);
            String string3 = this.SiPNxNT(string, string2, true);
            ndMutex = this.SiPNxNO.getMutex(string3);
            ndMutex.acquire();
            this.SiPNxNM.writeCache(string3, byArray);
            this.SiPNxNL.put(string3 + SiPUlfI, ndServiceConfig);
        }
        catch (InterruptedException interruptedException) {
            throw this.SiPUlgJ(interruptedException);
        }
        catch (Throwable throwable) {
            throw this.SiPUlgJ(throwable);
        }
        finally {
            if (ndMutex != null) {
                ndMutex.release();
            }
        }
    }

    public void deleteCache(String string, NdServiceConfig ndServiceConfig) {
        NdMutex ndMutex = null;
        String string2 = null;
        try {
            String string3 = NdProjectCacheManager.SiPNxNR(ndServiceConfig);
            string2 = this.SiPNxNT(string, string3, false);
            if (string2 == null) {
                return;
            }
            ndMutex = this.SiPNxNO.getMutex(string2);
            ndMutex.acquire();
            this.SiPNxNM.deleteCache(string2);
            this.SiPNxNS(string, string3);
            this.SiPNxNW();
            this.SiPNxNO.removeMutex(string2);
        }
        catch (InterruptedException interruptedException) {
            throw this.SiPUlgJ(interruptedException);
        }
        catch (Throwable throwable) {
            throw this.SiPUlgJ(throwable);
        }
        finally {
            if (ndMutex != null) {
                ndMutex.release();
            }
        }
    }

    private void SiPNxNS(String string, String string2) throws IOException {
        Map map = (Map)this.SiPNxNL.get(string);
        if (map != null) {
            map.remove(string2);
        }
        if (map.isEmpty()) {
            this.SiPNxNL.remove(string);
        }
    }

    private String SiPNxNT(String string, String string2, boolean bl) throws IOException {
        String string3;
        boolean bl2 = false;
        HashMap<String, String> hashMap = (HashMap<String, String>)this.SiPNxNL.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            this.SiPNxNL.put(string, hashMap);
            bl2 = true;
        }
        if ((string3 = (String)hashMap.get(string2)) != null) {
            return string3;
        }
        if (!bl) {
            return null;
        }
        string3 = this.SiPNxNU();
        hashMap.put(string2, string3);
        bl2 = true;
        if (bl2 && bl) {
            this.SiPNxNW();
        }
        return string3;
    }

    private String SiPNxNU() {
        return "advisor-project-" + this.SiPNxNV();
    }

    private synchronized int SiPNxNV() {
        return ++this.SiPNxNQ;
    }

    private synchronized void SiPNxNW() throws IOException {
        this.SiPNxNL.put(SiPNxNP, new Integer(this.SiPNxNQ));
        byte[] byArray = WjHzFYN.WjHzWbN((Object)this.SiPNxNL);
        this.SiPNxNM.writeCache(this.SiPNxNK, byArray);
    }

    private synchronized Object SiPNxNX() throws Exception {
        byte[] byArray = this.SiPNxNM.readCache(this.SiPNxNK);
        if (byArray == null) {
            return null;
        }
        return WjHzFYN.WjHzWcO((byte[])byArray);
    }

    public Iterator getAllCache(String string) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Iterator iterator = this.SiPNxNY(string);
        byte[] byArray = null;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            NdMutex ndMutex = null;
            try {
                ndMutex = this.SiPNxNO.getMutex(string2);
                ndMutex.acquire();
                byArray = this.SiPNxNM.readCache(string2);
            }
            catch (InterruptedException interruptedException) {
                throw this.SiPUlgJ(interruptedException);
            }
            catch (Throwable throwable) {
                throw this.SiPUlgJ(throwable);
            }
            finally {
                if (ndMutex != null) {
                    ndMutex.release();
                }
            }
            if (byArray == null) continue;
            arrayList.add(byArray);
        }
        return arrayList.iterator();
    }

    private Iterator SiPNxNY(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map = (Map)this.SiPNxNL.get(string);
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getValue();
                if (string2 == null) continue;
                arrayList.add(string2);
            }
        }
        return arrayList.iterator();
    }

    public Iterator getAllProjectIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.SiPNxNL.entrySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next().getKey();
            if (SiPNxNP.equals(string) || string.endsWith(SiPUlfI)) continue;
            arrayList.add(string);
        }
        return arrayList.iterator();
    }

    public void deleteAllProjectCache(String string) {
        Iterator iterator = this.SiPNxNY(string);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 == null) continue;
            NdMutex ndMutex = null;
            try {
                ndMutex = this.SiPNxNO.getMutex(string2);
                ndMutex.acquire();
                this.SiPNxNM.deleteCache(string2);
                this.SiPNxNO.removeMutex(string2);
            }
            catch (InterruptedException interruptedException) {
                throw this.SiPUlgJ(interruptedException);
            }
            finally {
                if (ndMutex == null) continue;
                ndMutex.release();
            }
        }
        try {
            this.SiPNxNL.remove(string);
            this.SiPNxNW();
        }
        catch (Throwable throwable) {
            throw this.SiPUlgJ(throwable);
        }
    }

    public Date getLastModified(String string) {
        byte[] byArray = this.SiPNxNM.readCache(string);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            NdServerRulesSerializationHeader ndServerRulesSerializationHeader = NdServerRulesAgent.loadHeader(new ByteArrayInputStream(byArray), 1);
            return ndServerRulesSerializationHeader.getProjectLastModifiedDateTime();
        }
        catch (Exception exception) {
            throw this.SiPUlgJ(exception);
        }
    }

    public NdServiceConfig getServiceConfig(String string) {
        return (NdServiceConfig)this.SiPNxNL.get(string + SiPUlfI);
    }

    public NdCacheProjectInfo[] getCacheProjectInfos() {
        NdCacheProjectInfo[] ndCacheProjectInfoArray = null;
        ArrayList<NdCacheProjectInfo> arrayList = new ArrayList<NdCacheProjectInfo>();
        Iterator iterator = this.getAllProjectIds();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = this.SiPNxNY(string);
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                String string3 = "";
                NdServiceConfig ndServiceConfig = this.getServiceConfig(string2);
                if (ndServiceConfig != null) {
                    string3 = this.getServiceConfig(string2).getName();
                }
                Date date = this.getLastModified(string2);
                arrayList.add(new NdCacheProjectInfo(string, string3, string2, date));
            }
        }
        if (!arrayList.isEmpty()) {
            ndCacheProjectInfoArray = new NdCacheProjectInfo[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                ndCacheProjectInfoArray[i] = (NdCacheProjectInfo)arrayList.get(i);
            }
        }
        return ndCacheProjectInfoArray;
    }

    private NdDeploymentManagerRuntimeException SiPUlgJ(Throwable throwable) {
        NdDeploymentManagerRuntimeException ndDeploymentManagerRuntimeException = new NdDeploymentManagerRuntimeException(throwable);
        this.SiPNxNN.onException(new NdExceptionEvent((Throwable)((Object)ndDeploymentManagerRuntimeException)));
        return ndDeploymentManagerRuntimeException;
    }
}

