/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy.rmi.jni;

import com.blazesoft.server.base.NdServerId;
import com.blazesoft.server.base.NdServiceException;
import com.blazesoft.server.base.NdServiceSessionException;
import com.blazesoft.server.config.NdConfigOption;
import com.blazesoft.server.deploy.NdMonitoredStatelessServer;
import com.blazesoft.server.deploy.rmi.jni.NdRmiJniAuthorizer;
import com.blazesoft.server.deploy.rmi.jni.NdRmiJniStatelessServer;
import com.blazesoft.server.deploy.rmi.jni.NdStrings;
import com.blazesoft.server.local.NdLocalServerException;
import com.blazesoft.server.local.NdLocalServerRuntimeException;
import com.blazesoft.util.NdBaseObject;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public class NdRmiJniStatelessServerBase
extends UnicastRemoteObject
implements NdRmiJniStatelessServer {
    private NdMonitoredStatelessServer SiPsrSE;
    private int SiPsrSF = 1;
    private NdRmiJniAuthorizer SiPsrSG = null;

    private void SiPsrSH(String string, int n) throws RemoteException {
        Registry registry = LocateRegistry.createRegistry(n);
        registry.rebind(string, this);
    }

    private void SiPsrSI(String string, String[] stringArray) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NdLocalServerRuntimeException(this.SiPsrSE.getServerId(), NdStrings.SiPpmnU("CouldNotLoadClass", string), classNotFoundException);
        }
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length != stringArray.length) continue;
            boolean bl = true;
            for (int j = 0; j < stringArray.length && (stringArray[j] == null || (bl = NdBaseObject.isAssignableFrom(classArray[j], stringArray[j].getClass()))); ++j) {
            }
            if (!bl) continue;
            constructor = constructorArray[i];
            break;
        }
        if (constructor == null) {
            throw new NdLocalServerRuntimeException(this.SiPsrSE.getServerId(), NdStrings.SiPpmoV("CouldNotFindConstructor", string, "" + stringArray.length));
        }
        try {
            this.SiPsrSG = (NdRmiJniAuthorizer)constructor.newInstance(stringArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NdLocalServerRuntimeException(this.SiPsrSE.getServerId(), NdStrings.SiPpmnU("CouldNotInstantiateClass", string), invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new NdLocalServerRuntimeException(this.SiPsrSE.getServerId(), NdStrings.SiPpmnU("CouldNotInstantiateClass", string), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NdLocalServerRuntimeException(this.SiPsrSE.getServerId(), NdStrings.SiPpmnU("CouldNotInstantiateClass", string), illegalAccessException);
        }
        catch (RuntimeException runtimeException) {
            throw new NdLocalServerRuntimeException(this.SiPsrSE.getServerId(), NdStrings.SiPpmnU("CouldNotInstantiateClass", string), runtimeException);
        }
    }

    public NdRmiJniStatelessServerBase(String string) throws RemoteException {
        try {
            this.SiPsrSE = NdMonitoredStatelessServer.createMonitoredStatelessServer(string);
            boolean bl = false;
            NdConfigOption[] ndConfigOptionArray = this.SiPsrSE.getServerConfig().getConfigOption();
            if (ndConfigOptionArray != null) {
                String[] stringArray;
                String string2 = NdStrings.SiPpmlS("ConnectionOption");
                for (int i = 0; i < ndConfigOptionArray.length; ++i) {
                    String[] stringArray2;
                    if (!string2.equals(ndConfigOptionArray[i].getName()) || (stringArray2 = ndConfigOptionArray[i].getOptionValue()) == null || stringArray2.length <= 3) continue;
                    stringArray = stringArray2[0];
                    int n = Integer.parseInt(stringArray2[2]);
                    this.SiPsrSH((String)stringArray, n);
                    bl = true;
                    break;
                }
                String string3 = NdStrings.SiPpmlS("AuthorizationOption");
                for (int i = 0; i < ndConfigOptionArray.length; ++i) {
                    if (!string3.equals(ndConfigOptionArray[i].getName()) || (stringArray = ndConfigOptionArray[i].getOptionValue()) == null || stringArray.length <= 1) continue;
                    String string4 = stringArray[0];
                    String[] stringArray3 = new String[stringArray.length - 1];
                    System.arraycopy(stringArray, 1, stringArray3, 0, stringArray.length - 1);
                    this.SiPsrSI(string4, stringArray);
                    break;
                }
            }
            if (!bl) {
                throw new RemoteException(NdStrings.SiPpmnU("MissingConnectionOption", NdStrings.SiPpmlS("ConnectionOption")));
            }
        }
        catch (NdLocalServerException ndLocalServerException) {
            throw new RemoteException(ndLocalServerException.getMessage(), (Throwable)((Object)ndLocalServerException));
        }
    }

    private void SiPsrSJ(Serializable serializable) throws RemoteException {
        if (this.SiPsrSG != null && this.SiPsrSG.decryptAuthorization(serializable) == null) {
            throw new RemoteException(NdStrings.SiPpmlS("NotAuthorized"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Serializable serializable) throws RemoteException {
        this.SiPsrSJ(serializable);
        NdRmiJniStatelessServerBase ndRmiJniStatelessServerBase = this;
        synchronized (ndRmiJniStatelessServerBase) {
            ++this.SiPsrSF;
        }
    }

    public Object invokeService(Serializable serializable, String string, String string2, Object[] objectArray) throws RemoteException {
        this.SiPsrSJ(serializable);
        Object object = null;
        try {
            object = this.SiPsrSE.invokeService(string, string2, objectArray);
        }
        catch (NdLocalServerException ndLocalServerException) {
            throw new RemoteException(ndLocalServerException.getMessage(), (Throwable)((Object)ndLocalServerException));
        }
        catch (NdServiceSessionException ndServiceSessionException) {
            throw new RemoteException(ndServiceSessionException.getMessage(), (Throwable)((Object)ndServiceSessionException));
        }
        catch (NdServiceException ndServiceException) {
            throw new RemoteException(ndServiceException.getMessage(), (Throwable)((Object)ndServiceException));
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage(), exception);
        }
        return object;
    }

    public void resetService(Serializable serializable, String string) throws RemoteException {
        this.SiPsrSJ(serializable);
        try {
            this.SiPsrSE.resetService(string);
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Serializable serializable) throws RemoteException {
        this.SiPsrSJ(serializable);
        try {
            boolean bl = false;
            NdRmiJniStatelessServerBase ndRmiJniStatelessServerBase = this;
            synchronized (ndRmiJniStatelessServerBase) {
                --this.SiPsrSF;
                if (this.SiPsrSF == 0) {
                    bl = true;
                }
            }
            if (bl) {
                this.SiPsrSE.shutdown();
            }
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage(), exception);
        }
    }

    public NdServerId getServerId() throws RemoteException {
        try {
            return this.SiPsrSE.getServerId();
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage(), exception);
        }
    }

    public String[] getServiceNames() throws RemoteException {
        try {
            return this.SiPsrSE.getServiceNames();
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage(), exception);
        }
    }

    public void waitForServiceInitialization(String string, long l) throws RemoteException {
        try {
            this.SiPsrSE.waitForServiceInitialization(string, l);
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage(), exception);
        }
    }

    public void waitForServiceInitialization(String string) throws RemoteException {
        try {
            this.SiPsrSE.waitForServiceInitialization(string);
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage(), exception);
        }
    }

    public void resetServiceAndWaitForReset(Serializable serializable, String string, long l) throws RemoteException {
        this.SiPsrSJ(serializable);
        try {
            this.SiPsrSE.resetServiceAndWaitForReset(string, l);
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage(), exception);
        }
    }

    public void resetServiceAndWaitForReset(Serializable serializable, String string) throws RemoteException {
        this.SiPsrSJ(serializable);
        try {
            this.SiPsrSE.resetServiceAndWaitForReset(string);
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage(), exception);
        }
    }

    public Throwable getNextException() throws RemoteException {
        try {
            return this.SiPsrSE.getNextException();
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage(), exception);
        }
    }

    public String getServiceState(String string) throws RemoteException {
        try {
            return this.SiPsrSE.getServiceState(string);
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage(), exception);
        }
    }

    public static void main(String[] stringArray) {
        try {
            NdRmiJniStatelessServerBase ndRmiJniStatelessServerBase = new NdRmiJniStatelessServerBase(stringArray[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

