/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy.rmi.jni;

import com.blazesoft.server.base.NdServerException;
import com.blazesoft.server.base.NdServerId;
import com.blazesoft.server.base.NdServiceException;
import com.blazesoft.server.base.NdServiceSessionException;
import com.blazesoft.server.config.NdConfigOption;
import com.blazesoft.server.config.NdServerConfig;
import com.blazesoft.server.config.NdServerConfigLoader;
import com.blazesoft.server.deploy.rmi.jni.NdRmiJniAuthorizer;
import com.blazesoft.server.deploy.rmi.jni.NdRmiJniStatelessServer;
import com.blazesoft.server.deploy.rmi.jni.NdStrings;
import com.blazesoft.server.local.NdLocalServerException;
import com.blazesoft.server.local.NdLocalServerRuntimeException;
import com.blazesoft.util.NdBaseObject;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class NdRmiJniStatelessServerProxy {
    private NdRmiJniStatelessServer SiPspYY;
    private NdServerId SiPspYZ;
    private Serializable SiPspZA = null;
    private NdRmiJniAuthorizer SiPsqaB;

    private NdRmiJniStatelessServer SiPsqbC(String string, String string2, int n) throws NdLocalServerException {
        NdRmiJniStatelessServer ndRmiJniStatelessServer = null;
        try {
            Registry registry = LocateRegistry.getRegistry(string2, n);
            ndRmiJniStatelessServer = (NdRmiJniStatelessServer)registry.lookup(string);
        }
        catch (Exception exception) {
            throw new NdLocalServerException(this.SiPspYZ, NdStrings.SiPpmnU("CouldNotLocateServer", this.SiPspYZ));
        }
        return ndRmiJniStatelessServer;
    }

    protected Object getAuthorization() {
        return NdStrings.SiPpmlS("DefaultKey");
    }

    private synchronized NdRmiJniAuthorizer SiPsqcD(String string, String[] stringArray) throws NdLocalServerException {
        if (this.SiPsqaB == null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NdLocalServerRuntimeException(this.SiPspYZ, NdStrings.SiPpmnU("CouldNotLoadClass", string), classNotFoundException);
            }
            Constructor<?> constructor = null;
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray = constructorArray[i].getParameterTypes();
                if (classArray.length != stringArray.length) continue;
                boolean bl = true;
                for (int j = 0; j < stringArray.length && (stringArray[j] == null || (bl = NdBaseObject.isAssignableFrom(classArray[j], stringArray[j].getClass()))); ++j) {
                }
                if (!bl) continue;
                constructor = constructorArray[i];
                break;
            }
            if (constructor == null) {
                throw new NdLocalServerRuntimeException(this.SiPspYZ, NdStrings.SiPpmoV("CouldNotFindConstructor", string, "" + stringArray.length));
            }
            try {
                this.SiPsqaB = (NdRmiJniAuthorizer)constructor.newInstance(stringArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new NdLocalServerRuntimeException(this.SiPspYZ, NdStrings.SiPpmnU("CouldNotInstantiateClass", string), invocationTargetException);
            }
            catch (InstantiationException instantiationException) {
                throw new NdLocalServerRuntimeException(this.SiPspYZ, NdStrings.SiPpmnU("CouldNotInstantiateClass", string), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new NdLocalServerRuntimeException(this.SiPspYZ, NdStrings.SiPpmnU("CouldNotInstantiateClass", string), illegalAccessException);
            }
            catch (Exception exception) {
                throw new NdLocalServerRuntimeException(this.SiPspYZ, NdStrings.SiPpmnU("CouldNotInstantiateClass", string), exception);
            }
        }
        return this.SiPsqaB;
    }

    public NdRmiJniStatelessServerProxy(String string) throws NdLocalServerException {
        Object object;
        NdServerConfig ndServerConfig = null;
        this.SiPspYZ = new NdServerId(string);
        try {
            ndServerConfig = NdServerConfigLoader.getDefaultServerConfigLoader().load(string);
        }
        catch (NdServerException ndServerException) {
            throw new NdLocalServerException(this.SiPspYZ, (Throwable)((Object)ndServerException));
        }
        boolean bl = false;
        String string2 = "";
        NdConfigOption[] ndConfigOptionArray = ndServerConfig.getConfigOption();
        if (ndConfigOptionArray != null) {
            String string3;
            String[] stringArray;
            String string4 = NdStrings.SiPpmlS("ConnectionOption");
            for (int i = 0; i < ndConfigOptionArray.length; ++i) {
                String[] stringArray2;
                if (!string4.equals(ndConfigOptionArray[i].getName()) || (stringArray2 = ndConfigOptionArray[i].getOptionValue()) == null || stringArray2.length <= 3) continue;
                stringArray = stringArray2[0];
                string3 = stringArray2[1];
                int n = Integer.parseInt(stringArray2[2]);
                this.SiPspYY = this.SiPsqbC((String)stringArray, string3, n);
                break;
            }
            object = NdStrings.SiPpmlS("AuthorizationOption");
            for (int i = 0; i < ndConfigOptionArray.length; ++i) {
                if (!((String)object).equals(ndConfigOptionArray[i].getName()) || (stringArray = ndConfigOptionArray[i].getOptionValue()) == null || stringArray.length <= 1) continue;
                string3 = stringArray[0];
                String[] stringArray3 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, stringArray3, 0, stringArray.length - 1);
                this.SiPsqaB = this.SiPsqcD(string3, stringArray);
                break;
            }
        }
        if (this.SiPspYY == null) {
            throw new NdLocalServerException(this.SiPspYZ, NdStrings.SiPpmnU("MissingConnectionOption", NdStrings.SiPpmlS("ConnectionOption")));
        }
        try {
            this.SiPspYY.connect(this.SiPsqaB.encryptAuthorization(this.getAuthorization()));
        }
        catch (RemoteException remoteException) {
            object = remoteException.detail;
            if (object instanceof NdLocalServerException) {
                throw (NdLocalServerException)((Object)object);
            }
            throw new NdLocalServerException(this.SiPspYZ, NdStrings.SiPpmoV("CouldNotConnectToServer", this.SiPspYZ, remoteException), remoteException);
        }
    }

    public Object invokeService(String string, String string2, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        Object object = null;
        try {
            object = this.SiPspYY.invokeService(this.SiPsqaB.encryptAuthorization(this.getAuthorization()), string, string2, objectArray);
        }
        catch (RemoteException remoteException) {
            Throwable throwable = remoteException.detail;
            if (throwable instanceof NdLocalServerException) {
                throw (NdLocalServerException)((Object)throwable);
            }
            if (throwable instanceof NdServiceSessionException) {
                throw (NdServiceSessionException)((Object)throwable);
            }
            if (throwable instanceof NdServiceException) {
                throw (NdServiceException)((Object)throwable);
            }
            throw new NdLocalServerException(this.SiPspYZ, NdStrings.SiPpmpW("CouldNotInvoke", string, this.SiPspYZ, remoteException), remoteException);
        }
        return object;
    }

    public Object invokeService(String string, Object[] objectArray) throws NdLocalServerException, NdServiceSessionException, NdServiceException {
        return this.invokeService(string, null, objectArray);
    }

    public void resetService(String string) {
        try {
            this.SiPspYY.resetService(this.SiPsqaB.encryptAuthorization(this.getAuthorization()), string);
        }
        catch (RemoteException remoteException) {
            throw new NdLocalServerRuntimeException(this.SiPspYZ, NdStrings.SiPpmpW("CouldNotReset", string, this.SiPspYZ, remoteException), remoteException);
        }
    }

    public void shutdown() {
        try {
            this.SiPspYY.shutdown(this.SiPsqaB.encryptAuthorization(this.getAuthorization()));
        }
        catch (RemoteException remoteException) {
            throw new NdLocalServerRuntimeException(this.SiPspYZ, NdStrings.SiPpmoV("CouldNotShutdown", this.SiPspYZ, remoteException), remoteException);
        }
    }

    public NdServerId getServerId() {
        return this.SiPspYZ;
    }

    public String[] getServiceNames() {
        try {
            return this.SiPspYY.getServiceNames();
        }
        catch (RemoteException remoteException) {
            throw new NdLocalServerRuntimeException(this.SiPspYZ, NdStrings.SiPpmoV("CouldNotGetServiceNames", this.SiPspYZ, remoteException), remoteException);
        }
    }

    public void waitForServiceInitialization(String string, long l) throws NdLocalServerException, NdServiceException, InterruptedException {
        try {
            this.SiPspYY.waitForServiceInitialization(string, l);
        }
        catch (RemoteException remoteException) {
            Throwable throwable = remoteException.detail;
            if (throwable instanceof NdLocalServerException) {
                throw (NdLocalServerException)((Object)throwable);
            }
            if (throwable instanceof NdServiceException) {
                throw (NdServiceException)((Object)throwable);
            }
            if (throwable instanceof InterruptedException) {
                throw (InterruptedException)throwable;
            }
            throw new NdLocalServerException(this.SiPspYZ, NdStrings.SiPpmpW("CouldNotWaitForServiceInitialization", string, this.SiPspYZ, remoteException), remoteException);
        }
    }

    public void waitForServiceInitialization(String string) throws NdLocalServerException, NdServiceException, InterruptedException {
        try {
            this.SiPspYY.waitForServiceInitialization(string);
        }
        catch (RemoteException remoteException) {
            Throwable throwable = remoteException.detail;
            if (throwable instanceof NdLocalServerException) {
                throw (NdLocalServerException)((Object)throwable);
            }
            if (throwable instanceof NdServiceException) {
                throw (NdServiceException)((Object)throwable);
            }
            if (throwable instanceof InterruptedException) {
                throw (InterruptedException)throwable;
            }
            throw new NdLocalServerException(this.SiPspYZ, NdStrings.SiPpmpW("CouldNotWaitForServiceInitialization", string, this.SiPspYZ, remoteException), remoteException);
        }
    }

    public void resetServiceAndWaitForReset(Serializable serializable, String string, long l) throws NdLocalServerException, NdServiceException, InterruptedException {
        try {
            this.SiPspYY.resetServiceAndWaitForReset(this.SiPsqaB.encryptAuthorization(this.getAuthorization()), string, l);
        }
        catch (RemoteException remoteException) {
            Throwable throwable = remoteException.detail;
            if (throwable instanceof NdLocalServerException) {
                throw (NdLocalServerException)((Object)throwable);
            }
            if (throwable instanceof NdServiceException) {
                throw (NdServiceException)((Object)throwable);
            }
            if (throwable instanceof InterruptedException) {
                throw (InterruptedException)throwable;
            }
            throw new NdLocalServerException(this.SiPspYZ, NdStrings.SiPpmpW("CouldNotResetServiceAndWait", string, this.SiPspYZ, remoteException), remoteException);
        }
    }

    public void resetServiceAndWaitForReset(Serializable serializable, String string) throws NdLocalServerException, NdServiceException, InterruptedException {
        try {
            this.SiPspYY.resetServiceAndWaitForReset(this.SiPsqaB.encryptAuthorization(this.getAuthorization()), string);
        }
        catch (RemoteException remoteException) {
            Throwable throwable = remoteException.detail;
            if (throwable instanceof NdLocalServerException) {
                throw (NdLocalServerException)((Object)throwable);
            }
            if (throwable instanceof NdServiceException) {
                throw (NdServiceException)((Object)throwable);
            }
            if (throwable instanceof InterruptedException) {
                throw (InterruptedException)throwable;
            }
            throw new NdLocalServerException(this.SiPspYZ, NdStrings.SiPpmpW("CouldNotResetServiceAndWait", string, this.SiPspYZ, remoteException), remoteException);
        }
    }

    public Throwable getNextException() {
        try {
            return this.SiPspYY.getNextException();
        }
        catch (RemoteException remoteException) {
            throw new NdLocalServerRuntimeException(this.SiPspYZ, NdStrings.SiPpmoV("CouldNotGetNextException", this.SiPspYZ, remoteException), remoteException);
        }
    }

    public String getServiceState(String string) {
        try {
            return this.SiPspYY.getServiceState(string);
        }
        catch (RemoteException remoteException) {
            throw new NdLocalServerRuntimeException(this.SiPspYZ, NdStrings.SiPpmpW("CouldNotGetServiceState", string, this.SiPspYZ, remoteException), remoteException);
        }
    }

    public static NdRmiJniStatelessServerProxy createStatelessServer(String string) throws NdLocalServerException {
        return NdRmiJniStatelessServerProxy.createMonitoredStatelessServer(string);
    }

    public static NdRmiJniStatelessServerProxy createMonitoredStatelessServer(String string) throws NdLocalServerException {
        NdRmiJniStatelessServerProxy ndRmiJniStatelessServerProxy = new NdRmiJniStatelessServerProxy(string);
        return ndRmiJniStatelessServerProxy;
    }

    public static void main(String[] stringArray) {
        try {
            NdRmiJniStatelessServerProxy ndRmiJniStatelessServerProxy = NdRmiJniStatelessServerProxy.createStatelessServer(stringArray[0]);
            System.out.println("Got proxy = " + ndRmiJniStatelessServerProxy);
            Object[] objectArray = new Object[]{"Hello World"};
            ndRmiJniStatelessServerProxy.invokeService("Test Service", "Test Client", objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

