/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploy.webservice.java;

import com.blazesoft.engines.rules.xml.NdDefXmlClassProviderResource;
import com.blazesoft.server.base.NdServerException;
import com.blazesoft.server.deploy.webservice.NdWsdlDefinitionModel;
import com.blazesoft.server.deploy.webservice.java.NdStrings;
import com.blazesoft.util.xml.NdXMLParserFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class NdWsdlDefinitionModelImpl
implements NdWsdlDefinitionModel {
    public static final String XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String XMLNS = "http://schemas.xmlsoap.org/wsdl";
    public static final String SOAP = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String SOAP_HTTP = "http://schemas.xmlsoap.org/soap/http";
    public static final String DEFAULT_SCHEMA_NAME_BASE = "schema_";
    public static final String SCHEMA_NAME_SUFFIX = ".xsd";
    public static final String PREFIX_TNS = "tns";
    public static final String PREFIX_XSD = "xsd";
    public static final String PREFIX_SOAP = "soap";
    public static final String DEFAULT_PREFIX_BASE = "ns";
    private Hashtable SiQbGAV;
    private Hashtable SiQbGBW;
    private Hashtable SiQbGCX;
    private Hashtable SiQbGDY;
    private Hashtable SiQbGEZ;
    private Definition SiQbmwY;
    private WSDLFactory SiQbmxZ;
    private ExtensionRegistry SiQbmyA;
    private int SiQbmyB = 0;
    private int SiQbGFA = 0;
    private NdDefXmlClassProviderResource SiQbGFB;

    public NdWsdlDefinitionModelImpl() throws NdServerException {
        try {
            this.SiQbmxZ = WSDLFactory.newInstance();
            this.SiQbmwY = this.SiQbmxZ.newDefinition();
            this.SiQbmyA = this.SiQbmxZ.newPopulatedExtensionRegistry();
            this.SiQbmwY.setExtensionRegistry(this.SiQbmyA);
            this.SiQbGAV = new Hashtable();
            this.registerNamespace(PREFIX_XSD, XSD);
            this.registerNamespace(PREFIX_SOAP, SOAP);
            this.registerNamespace(null, XMLNS);
            this.SiQbGCX = new Hashtable();
            this.SiQbGDY = new Hashtable();
            this.SiQbGBW = new Hashtable();
            this.SiQbGEZ = new Hashtable();
        }
        catch (Exception exception) {
            throw new NdServerException(exception);
        }
    }

    public ExtensibilityElement createExtension(Class clazz, QName qName) throws WSDLException {
        return this.SiQbmyA.createExtension(clazz, qName);
    }

    public void setTargetNamespace(String string) {
        this.SiQbmwY.addNamespace(PREFIX_TNS, string);
        this.SiQbmwY.setTargetNamespace(string);
    }

    public Definition getDefinition() {
        return this.SiQbmwY;
    }

    public int numSchemas() {
        return this.SiQbGCX.size();
    }

    public Element getSchemaElement() throws ParserConfigurationException {
        String string;
        String string2;
        Object object;
        Object object2;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElementNS(XSD, "schema");
        element.setPrefix(PREFIX_XSD);
        element.setAttribute("xmlns", XSD);
        document.appendChild(element);
        Enumeration enumeration = this.SiQbGCX.keys();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                object2 = document.createElement("import");
                element.appendChild((Node)object2);
                object = (String)enumeration.nextElement();
                string2 = (String)this.SiQbGCX.get(object);
                string = this.getSchemaName((String)object);
                object2.setAttribute("namespace", string2);
                object2.setAttribute("schemaLocation", string);
            }
        }
        if ((object2 = this.SiQbGEZ.keys()) != null) {
            while (object2.hasMoreElements()) {
                object = document.createElement("import");
                element.appendChild((Node)object);
                string2 = (String)object2.nextElement();
                string = (String)this.SiQbGEZ.get(string2);
                object.setAttribute("namespace", string);
                object.setAttribute("schemaLocation", this.getFilePart(string2));
            }
        }
        return element;
    }

    public String getFilePart(String string) {
        int n;
        String string2 = string.toLowerCase();
        int n2 = string2.indexOf(SCHEMA_NAME_SUFFIX);
        if (n2 < 0) {
            return null;
        }
        for (n = n2 - 1; n >= 0 && Character.isJavaIdentifierPart(string.charAt(n)); --n) {
        }
        return string.substring(n + 1, n2 + 4);
    }

    public String getSchemaPrefix(String string) {
        String string2;
        if (this.SiQbGAV.get(string) != null) {
            string2 = (String)this.SiQbGAV.get(string);
        } else {
            string2 = DEFAULT_PREFIX_BASE + this.SiQbmyB++;
            this.registerNamespace(string2, string);
        }
        return string2;
    }

    public void registerNamespace(String string, String string2) {
        if (this.SiQbGAV.get(string2) == null) {
            if (string != null) {
                this.SiQbGAV.put(string2, string);
            }
            this.SiQbmwY.addNamespace(string, string2);
        }
    }

    public void registerSchema(String string, String string2, String string3) throws NdServerException {
        if (string == null) {
            this.SiQbGFC(string2, string3);
        } else {
            this.SiQbGFD(string, string2, string3);
        }
    }

    private void SiQbGFC(String string, String string2) throws NdServerException {
        if (string == null || !new File(string).exists()) {
            throw new NdServerException(NdStrings.SiQbmbV("SchemaFileNotFound", string));
        }
        if (this.SiQbGEZ.get(string) == null) {
            this.SiQbGEZ.put(string, string2);
        }
    }

    private void SiQbGFD(String string, String string2, String string3) {
        if (this.SiQbGCX.get(string) == null && string3 != null) {
            this.SiQbGCX.put(string, string3);
        }
        if (this.SiQbGDY.get(string) == null) {
            String string4 = this.SiQbGFE(string2);
            this.SiQbGDY.put(string, string4);
        }
    }

    private String SiQbGFE(String string) {
        if (string == null || this.getFilePart(string) == null) {
            return DEFAULT_SCHEMA_NAME_BASE + this.SiQbGFF() + SCHEMA_NAME_SUFFIX;
        }
        String string2 = this.getFilePart(string);
        if (this.SiQbGDY.size() == 0) {
            return string2;
        }
        Enumeration enumeration = this.SiQbGDY.elements();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string2.equals(string3)) continue;
                String string4 = string2.substring(0, string2.length() - 4);
                String string5 = string2.substring(string2.length() - 4);
                string2 = string4 + "_" + this.SiQbGFF() + string5;
                break;
            }
        }
        return string2;
    }

    private int SiQbGFF() {
        return this.SiQbGFA++;
    }

    public void registerElementQName(String string, String string2, QName qName) {
        Hashtable<String, QName> hashtable = (Hashtable<String, QName>)this.SiQbGBW.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, QName>();
            this.SiQbGBW.put(string, hashtable);
        }
        if (hashtable.get(string2) == null) {
            hashtable.put(string2, qName);
        }
    }

    public String[] getSchemaKeys() {
        if (this.SiQbGCX.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.SiQbGCX.size()];
        Enumeration enumeration = this.SiQbGCX.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public String[] getSchemaNames() {
        if (this.SiQbGEZ.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.SiQbGEZ.size()];
        Enumeration enumeration = this.SiQbGEZ.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchemaContent(String string) throws NdServerException {
        InputSource inputSource = null;
        String string2 = null;
        try {
            inputSource = this.SiQbGFG(string);
            if (inputSource == null) {
                inputSource = this.SiQbGFH(string);
            }
            Document document = NdXMLParserFactory.getDOMDocument((InputSource)inputSource);
            Hashtable hashtable = (Hashtable)this.SiQbGBW.get(string);
            if (hashtable != null) {
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    QName qName = (QName)enumeration.nextElement();
                    String string3 = qName.getLocalPart();
                    this.SiQbmyD(document, string3);
                }
            }
            this.SiQbZMP(document);
            string2 = this.marshallDocument(document);
        }
        finally {
            if (inputSource != null && inputSource.getByteStream() != null) {
                try {
                    inputSource.getByteStream().close();
                }
                catch (IOException iOException) {
                    throw new NdServerException(iOException);
                }
            }
        }
        return string2;
    }

    private void SiQbZMP(Document document) {
        boolean bl = false;
        Element element = document.getDocumentElement();
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap.getLength() != 0) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                String string;
                Node node;
                if ((node = namedNodeMap.item(n++)) == null || (string = node.getNodeName()) == null) continue;
                if ((string = string.toLowerCase()).equals("attributeformdefault") || string.equals("elementformdefault")) {
                    namedNodeMap.removeNamedItem(node.getNodeName());
                    --n;
                    continue;
                }
                if (!string.equals("targetNamespace".toLowerCase())) continue;
                bl = true;
            }
        }
        if (!bl) {
            element.setAttribute("targetNamespace", this.SiQbmwY.getTargetNamespace());
        }
    }

    private InputSource SiQbGFG(String string) {
        String string2 = this.SiQbGFB.getXmlSchemaContent(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        return new InputSource(new InputStreamReader(byteArrayInputStream));
    }

    private InputSource SiQbGFH(String string) throws NdServerException {
        File file = new File(string);
        try {
            return new InputSource(new InputStreamReader(new FileInputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NdServerException(fileNotFoundException);
        }
    }

    private void SiQbmyD(Document document, String string) throws NdServerException {
        Object object;
        Element element = document.getDocumentElement();
        Node node = null;
        NodeList nodeList = document.getElementsByTagNameNS(XSD, "element");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            object = element2.getAttribute("name");
            if (!string.equals(object)) continue;
            node = element2;
            break;
        }
        if (node == null) {
            throw new RuntimeException("did not find the element named as " + string);
        }
        Element element3 = null;
        nodeList = node.getChildNodes();
        if (nodeList == null) {
            throw new RuntimeException("Invalid element");
        }
        n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            object = nodeList.item(i);
            if (object.getNodeType() != 1) continue;
            String string2 = object.getLocalName();
            String string3 = object.getNamespaceURI();
            if (!"complexType".equals(string2) || !XSD.equals(string3)) continue;
            element3 = (Element)object;
            node.removeChild((Node)object);
            node.setAttribute("type", string);
            break;
        }
        if (element3 == null) {
            throw new RuntimeException("The element is not a complex type");
        }
        element3.setAttribute("name", string);
        element.appendChild(element3);
    }

    public String getWSDLContent() throws NdServerException {
        String string = this.marshallDefinition(this.SiQbmwY, this.SiQbmxZ);
        return string;
    }

    public NdDefXmlClassProviderResource getXmlClassProviderResource() {
        return this.SiQbGFB;
    }

    public void setXmlClassProviderResource(NdDefXmlClassProviderResource ndDefXmlClassProviderResource) {
        this.SiQbGFB = ndDefXmlClassProviderResource;
    }

    public String getSchemaName(String string) {
        return (String)this.SiQbGDY.get(string);
    }

    protected String marshallDefinition(Definition definition, WSDLFactory wSDLFactory) throws NdServerException {
        WSDLWriter wSDLWriter = wSDLFactory.newWSDLWriter();
        try {
            Document document = wSDLWriter.getDocument(definition);
            return this.marshallDocument(document);
        }
        catch (WSDLException wSDLException) {
            throw new NdServerException(wSDLException);
        }
    }

    public String marshallDocument(Document document) throws NdServerException {
        try {
            OutputFormat outputFormat = new OutputFormat(document);
            outputFormat.setLineWidth(65);
            outputFormat.setIndenting(true);
            outputFormat.setIndent(2);
            StringWriter stringWriter = new StringWriter();
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.serialize(document);
            return ((Object)stringWriter).toString();
        }
        catch (IOException iOException) {
            throw new NdServerException(iOException);
        }
    }
}

