/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.definitions;

import com.blazesoft.dynobj.xml.NdConfigurationException;
import com.blazesoft.server.config.NdDeploymentManagerServerManagerFactory;
import com.blazesoft.server.deploygen.NdDeploymentConstants;
import com.blazesoft.server.deploygen.NdInvalidConfigPropertyException;
import com.blazesoft.server.deploygen.definitions.NdConfigDefinition;
import com.blazesoft.server.deploygen.definitions.NdConfigDefinitionVisitor;
import com.blazesoft.server.deploygen.definitions.NdDeploymentConfigDefinition;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.NdDeploymentManagerOptionsWithDefaults;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironmentMgr;
import com.blazesoft.server.deploygen.generation.NdDeploymentManagerConfigGenerator;

public class NdDeploymentManagerOptions
extends NdDeploymentConfigDefinition {
    public static final String ENABLED = "enabled";
    public static final String NAME = "name";
    public static final String RULE_SOURCE_ID = "ruleSourceID";
    public static final String MONITOR_CHANGES = "monitorChanges";
    public static final String CHANGE_MONITORING_HEARTBEAT = "dm.changeMonitoringHeartbeat";
    public static final String CONNECTION_MONITORING_HEARTBEAT = "dm.connectionMonitoringHeartbeat";
    public static final String SERVER_MANAGER_NAME = "serverManagerName";
    public static final String SERVER_MANAGER_TYPE = "serverManagerType";
    public static final String CONFIG_FILE_NAME = "configFileName";
    private NdDeploymentManagerServerManagerFactory SiPGgBI;

    public NdDeploymentManagerOptions() {
    }

    public NdDeploymentManagerOptions(NdDeploymentEnvironmentMgr ndDeploymentEnvironmentMgr, NdDeploymentDefinition ndDeploymentDefinition) {
        this(ndDeploymentEnvironmentMgr, ndDeploymentDefinition, null);
    }

    protected NdDeploymentManagerOptions(NdDeploymentEnvironmentMgr ndDeploymentEnvironmentMgr, NdDeploymentDefinition ndDeploymentDefinition, NdDeploymentManagerOptions ndDeploymentManagerOptions) {
        super(ndDeploymentEnvironmentMgr, ndDeploymentDefinition, ndDeploymentManagerOptions);
    }

    public NdDeploymentDefinition getDeploymentDefinition() {
        return (NdDeploymentDefinition)this.getParentDefinition();
    }

    NdDeploymentManagerOptions SiPGgCJ(NdDeploymentDefinition ndDeploymentDefinition, NdConfigDefaultsContext ndConfigDefaultsContext) {
        return new NdDeploymentManagerOptionsWithDefaults(this.getEnvironmentMgr(), ndDeploymentDefinition, this, ndConfigDefaultsContext);
    }

    public void copyFrom(NdConfigDefinition ndConfigDefinition) throws NdConfigurationException {
        super.copyFrom(ndConfigDefinition);
        NdDeploymentManagerOptions ndDeploymentManagerOptions = (NdDeploymentManagerOptions)ndConfigDefinition;
        this.setEnabled(ndDeploymentManagerOptions.getEnabled());
        this.setName(ndDeploymentManagerOptions.getName());
        this.setRuleSourceID(ndDeploymentManagerOptions.getRuleSourceID());
        this.setMonitorChanges(ndDeploymentManagerOptions.getMonitorChanges());
        this.setChangeMonitoringHeartbeat(ndDeploymentManagerOptions.getChangeMonitoringHeartbeat());
        this.setServerManagerName(ndDeploymentManagerOptions.getServerManagerName());
        this.setEnumServerManagerType(ndDeploymentManagerOptions.getServerManagerTypeEnum());
        this.setConfigFileName(ndDeploymentManagerOptions.getConfigFileName());
    }

    public String getName() {
        return this.get(NAME);
    }

    public Boolean getEnabled() {
        return this.getBoolean(ENABLED);
    }

    public Integer getChangeMonitoringHeartbeat() {
        return this.getInteger(CHANGE_MONITORING_HEARTBEAT);
    }

    public Integer getConnectionMonitoringHeartbeat() {
        return this.getInteger(CONNECTION_MONITORING_HEARTBEAT);
    }

    public Boolean getMonitorChanges() {
        return this.getBoolean(MONITOR_CHANGES);
    }

    public void setName(String string) {
        this.set(NAME, string);
    }

    public void setEnabled(Boolean bl) {
        this.setBoolean(ENABLED, bl);
    }

    public void setChangeMonitoringHeartbeat(Integer n) {
        this.setInteger(CHANGE_MONITORING_HEARTBEAT, n);
    }

    public void setConnectionMonitoringHeartbeat(Integer n) {
        this.setInteger(CONNECTION_MONITORING_HEARTBEAT, n);
    }

    public void setMonitorChanges(Boolean bl) {
        this.setBoolean(MONITOR_CHANGES, bl);
    }

    public String getRuleSourceID() {
        return this.get(RULE_SOURCE_ID);
    }

    public void setRuleSourceID(String string) {
        this.set(RULE_SOURCE_ID, string);
    }

    public NdDeploymentConstants.ServerManagerType getServerManagerTypeEnum() {
        NdDeploymentConstants.ServerManagerType serverManagerType = null;
        if (this.SiPGgBI == null) {
            String string = this.get(SERVER_MANAGER_TYPE);
            if (string != null) {
                serverManagerType = NdDeploymentConstants.ServerManagerType.valueOf(string);
            }
        } else {
            NdDeploymentConstants.ServerManagerType.valueOf(this.SiPGgBI.getJavaName());
        }
        return serverManagerType;
    }

    public void setEnumServerManagerType(NdDeploymentConstants.ServerManagerType serverManagerType) {
        this.set(SERVER_MANAGER_TYPE, serverManagerType == null ? null : serverManagerType.toString());
    }

    public String getServerManagerType() {
        return this.get(SERVER_MANAGER_TYPE);
    }

    public void setServerManagerType(String string) {
        this.set(SERVER_MANAGER_TYPE, string);
    }

    public String getConfigFileName() {
        return this.get(CONFIG_FILE_NAME);
    }

    public void setConfigFileName(String string) throws NdInvalidConfigPropertyException {
        this.set(CONFIG_FILE_NAME, string);
        this.SiPGgDK();
    }

    public String getServerManagerName() {
        return this.get(SERVER_MANAGER_NAME);
    }

    public void setServerManagerName(String string) throws NdInvalidConfigPropertyException {
        this.set(SERVER_MANAGER_NAME, string);
        this.SiPGgDK();
    }

    public boolean isRemote() {
        NdDeploymentConstants.ServerManagerType serverManagerType = this.getServerManagerTypeEnum();
        return serverManagerType == NdDeploymentConstants.ServerManagerType.RMI || serverManagerType == NdDeploymentConstants.ServerManagerType.GENERIC_REMOTE;
    }

    private void SiPGgDK() throws NdInvalidConfigPropertyException {
        this.SiPGgBI = NdDeploymentManagerConfigGenerator.loadServerManager(this.get(CONFIG_FILE_NAME), this.get(SERVER_MANAGER_NAME));
    }

    public void enableChangeMonitoring(Integer n) {
        this.setMonitorChanges(Boolean.TRUE);
        this.setChangeMonitoringHeartbeat(n);
    }

    public boolean useInConfig(String string) {
        if ("serverManagerTypeEnum".equals(string)) {
            return false;
        }
        return super.useInConfig(string);
    }

    public void accept(NdConfigDefinitionVisitor ndConfigDefinitionVisitor) {
        ndConfigDefinitionVisitor.visit(this);
    }
}

