/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.environments;

import com.blazesoft.dynobj.xml.NdConfigurationException;
import com.blazesoft.server.deploy.rules.NdDeployRulesServiceEntryPointConfig;
import com.blazesoft.server.deploygen.NdDeploymentConstants;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.NdRuleServiceDefinition;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaults;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaultsImpl;
import com.blazesoft.server.deploygen.definitions.defaults.NdDeploymentConfigDefaultsContext;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironmentImpl;
import com.blazesoft.server.deploygen.environments.NdStrings;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerFileGeneratorImpl;

public class NdCDeploymentEnvironment
extends NdDeploymentEnvironmentImpl {
    private static final NdConfigDefinitionDefaults SiQaYgJ = new SiQaVlB();
    private static final NdConfigDefinitionDefaults SiQaYgK = new SiQaVnF();
    private static final NdConfigDefinitionDefaults SiQaYgL = new SiQaVMW();
    private static final NdConfigDefinitionDefaults SiQaYgM = new SiQaWFP();
    private static final NdConfigDefinitionDefaults SiQaYgN = new SiQaYOR();
    public static final String DEFAULT_PROGRAM_NAME = "CPGM";
    public static final String DEFAULT_MAX_STRING_LENGTH = "500";
    public static final String DEFAULT_SUBPROGRAM_PREFIX = "BA";
    public static final String DEFAULT_LINE_LIMIT = "100000";
    public static final String DEFAULT_COPYBOOK_PREFIX = "C";
    public static final String DEFAULT_CHARS_PER_LINE = "300";

    protected NdCDeploymentEnvironment() {
        super(DEFAULT_COPYBOOK_PREFIX);
    }

    protected NdCDeploymentEnvironment(String string) {
        super(string);
    }

    public NdConfigDefinitionDefaults getRuleServiceDefinitionDefaults() {
        return SiQaYgJ;
    }

    public NdConfigDefinitionDefaults getDeploymentDefinitionDefaults() {
        return SiQaYgL;
    }

    public NdConfigDefinitionDefaults getCodeGenerationDefaults() {
        return SiQaYgK;
    }

    public NdConfigDefinitionDefaults getDeploymentManagerDefaults() {
        return SiQaYgM;
    }

    public NdConfigDefinitionDefaults getRemoteDebuggingDefaults() {
        return SiQaYgN;
    }

    public String getTemplateSubdir(NdDeploymentConstants.TargetLanguage targetLanguage) {
        return null;
    }

    public NdQDeployerFileGeneratorImpl createFileGenerator() {
        return null;
    }

    public static NdDeployRulesServiceEntryPointConfig getCEntryPoint(NdRuleServiceDefinition ndRuleServiceDefinition) throws NdConfigurationException {
        return NdCDeploymentEnvironment.getCEntryPoint(ndRuleServiceDefinition.getEntryPoints());
    }

    public static NdDeployRulesServiceEntryPointConfig getCEntryPoint(NdDeployRulesServiceEntryPointConfig[] ndDeployRulesServiceEntryPointConfigArray) throws NdConfigurationException {
        if (ndDeployRulesServiceEntryPointConfigArray.length == 0) {
            return null;
        }
        if (ndDeployRulesServiceEntryPointConfigArray.length > 1) {
            throw new NdConfigurationException(NdStrings.SiPGgwN("NonCCompatibleEntryPoints"));
        }
        NdDeployRulesServiceEntryPointConfig ndDeployRulesServiceEntryPointConfig = ndDeployRulesServiceEntryPointConfigArray[0];
        if (!NdCDeploymentEnvironment.isCCompatible(ndDeployRulesServiceEntryPointConfig)) {
            throw new NdConfigurationException(NdStrings.SiPGgwN("NonCCompatibleEntryPoints"));
        }
        return ndDeployRulesServiceEntryPointConfig;
    }

    public static boolean isCCompatible(NdDeployRulesServiceEntryPointConfig ndDeployRulesServiceEntryPointConfig) {
        return ndDeployRulesServiceEntryPointConfig.getSrlInvocationFunctional() != null;
    }

    private static class SiQaYOR
    extends NdConfigDefinitionDefaultsImpl {
        private SiQaYOR() {
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("debug.enabled".equals(string)) {
                return Boolean.FALSE.toString();
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("debug.enabled".equals(string)) {
                return new String[]{Boolean.FALSE.toString()};
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }

        public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            return "debug.enabled".equals(string) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static class SiQaWFP
    extends NdConfigDefinitionDefaultsImpl {
        private SiQaWFP() {
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("enabled".equals(string)) {
                return Boolean.FALSE.toString();
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("enabled".equals(string)) {
                return new String[]{Boolean.FALSE.toString()};
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }

        public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            return "enabled".equals(string) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static class SiQaVMW
    extends NdConfigDefinitionDefaultsImpl {
        private SiQaVMW() {
        }

        public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            return "name".equals(string) || "description".equals(string) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static class SiQaVnF
    extends NdConfigDefinitionDefaultsImpl {
        private SiQaVnF() {
        }

        public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            NdDeploymentConfigDefaultsContext ndDeploymentConfigDefaultsContext = (NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext;
            if ("cProgramName".equals(string)) {
                return Boolean.TRUE;
            }
            if ("charsPerLine".equals(string)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("cProgramName".equals(string)) {
                return NdCDeploymentEnvironment.DEFAULT_PROGRAM_NAME;
            }
            if ("trigraph".equals(string)) {
                return Boolean.FALSE.toString();
            }
            if ("obfuscate".equals(string)) {
                return Boolean.FALSE.toString();
            }
            if ("charsPerLine".equals(string)) {
                return NdCDeploymentEnvironment.DEFAULT_CHARS_PER_LINE;
            }
            if ("appStartedOnInit".equals(string)) {
                return Boolean.TRUE.toString();
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }
    }

    private static class SiQaVlB
    extends NdConfigDefinitionDefaultsImpl {
        private SiQaVlB() {
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("cCompatible".equals(string)) {
                NdDeploymentDefinition ndDeploymentDefinition = ((NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext).getDeploymentDefinition();
                if (ndDeploymentDefinition != null && NdCDeploymentEnvironment.DEFAULT_COPYBOOK_PREFIX.equals(ndDeploymentDefinition.getDeploymentEnvironment())) {
                    return Boolean.TRUE.toString();
                }
                return Boolean.FALSE.toString();
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            Boolean bl;
            NdRuleServiceDefinition ndRuleServiceDefinition = ((NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext).getRuleServiceDefinition();
            if (ndRuleServiceDefinition != null && (bl = ndRuleServiceDefinition.getCCompatible()) != null && bl.booleanValue()) {
                return "cCompatible".equals(string) || "description".equals(string) || "entryPoint".equals(string) || "name".equals(string) ? Boolean.TRUE : Boolean.FALSE;
            }
            return super.uses(string, ndConfigDefaultsContext);
        }
    }
}

