/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.environments;

import com.blazesoft.dynobj.xml.NdConfigurationException;
import com.blazesoft.server.deploy.rules.NdDeployRulesServiceEntryPointConfig;
import com.blazesoft.server.deploygen.NdDeploymentConstants;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.NdRuleServiceDefinition;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaults;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaultsImpl;
import com.blazesoft.server.deploygen.definitions.defaults.NdDeploymentConfigDefaultsContext;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironmentImpl;
import com.blazesoft.server.deploygen.environments.NdStrings;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerFileGeneratorImpl;

public class NdCobolDeploymentEnvironment
extends NdDeploymentEnvironmentImpl {
    private static final NdConfigDefinitionDefaults SiPQIbX = new SiPQKeX();
    private static final NdConfigDefinitionDefaults SiPQIcY = new SiPQKwJ();
    private static final NdConfigDefinitionDefaults SiPQIdZ = new SiPQKGK();
    private static final NdConfigDefinitionDefaults SiPQIeA = new SiPQGBM();
    private static final NdConfigDefinitionDefaults SiPQIeB = new SiPQGMP();
    public static final String DEFAULT_PROGRAM_NAME = "CBLPGM";
    public static final String DEFAULT_MAX_STRING_LENGTH = "500";
    public static final String DEFAULT_SUBPROGRAM_PREFIX = "BA";
    public static final String DEFAULT_LINE_LIMIT = "100000";
    public static final String DEFAULT_COPYBOOK_PREFIX = "CBL";

    protected NdCobolDeploymentEnvironment() {
        super("COBOL");
    }

    protected NdCobolDeploymentEnvironment(String string) {
        super(string);
    }

    public NdConfigDefinitionDefaults getRuleServiceDefinitionDefaults() {
        return SiPQIbX;
    }

    public NdConfigDefinitionDefaults getDeploymentDefinitionDefaults() {
        return SiPQIdZ;
    }

    public NdConfigDefinitionDefaults getCodeGenerationDefaults() {
        return SiPQIcY;
    }

    public NdConfigDefinitionDefaults getDeploymentManagerDefaults() {
        return SiPQIeA;
    }

    public NdConfigDefinitionDefaults getRemoteDebuggingDefaults() {
        return SiPQIeB;
    }

    public String getTemplateSubdir(NdDeploymentConstants.TargetLanguage targetLanguage) {
        return null;
    }

    public NdQDeployerFileGeneratorImpl createFileGenerator() {
        return null;
    }

    public static NdDeployRulesServiceEntryPointConfig getCobolEntryPoint(NdRuleServiceDefinition ndRuleServiceDefinition) throws NdConfigurationException {
        return NdCobolDeploymentEnvironment.getCobolEntryPoint(ndRuleServiceDefinition.getEntryPoints());
    }

    public static NdDeployRulesServiceEntryPointConfig getCobolEntryPoint(NdDeployRulesServiceEntryPointConfig[] ndDeployRulesServiceEntryPointConfigArray) throws NdConfigurationException {
        if (ndDeployRulesServiceEntryPointConfigArray.length == 0) {
            return null;
        }
        if (ndDeployRulesServiceEntryPointConfigArray.length > 1) {
            throw new NdConfigurationException(NdStrings.SiPGgwN("NonCobolCompatibleEntryPoints"));
        }
        NdDeployRulesServiceEntryPointConfig ndDeployRulesServiceEntryPointConfig = ndDeployRulesServiceEntryPointConfigArray[0];
        if (!NdCobolDeploymentEnvironment.isCobolCompatible(ndDeployRulesServiceEntryPointConfig)) {
            throw new NdConfigurationException(NdStrings.SiPGgwN("NonCobolCompatibleEntryPoints"));
        }
        return ndDeployRulesServiceEntryPointConfig;
    }

    public static boolean isCobolCompatible(NdDeployRulesServiceEntryPointConfig ndDeployRulesServiceEntryPointConfig) {
        return ndDeployRulesServiceEntryPointConfig.getSrlInvocationFunctional() != null;
    }

    private static class SiPQGMP
    extends NdConfigDefinitionDefaultsImpl {
        private SiPQGMP() {
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("debug.enabled".equals(string)) {
                return Boolean.FALSE.toString();
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("debug.enabled".equals(string)) {
                return new String[]{Boolean.FALSE.toString()};
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }

        public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            return "debug.enabled".equals(string) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static class SiPQGBM
    extends NdConfigDefinitionDefaultsImpl {
        private SiPQGBM() {
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("enabled".equals(string)) {
                return Boolean.FALSE.toString();
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("enabled".equals(string)) {
                return new String[]{Boolean.FALSE.toString()};
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }

        public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            return "enabled".equals(string) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static class SiPQKGK
    extends NdConfigDefinitionDefaultsImpl {
        private SiPQKGK() {
        }

        public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            return "name".equals(string) || "description".equals(string) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static class SiPQKwJ
    extends NdConfigDefinitionDefaultsImpl {
        private SiPQKwJ() {
        }

        public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            NdDeploymentDefinition ndDeploymentDefinition;
            NdDeploymentConfigDefaultsContext ndDeploymentConfigDefaultsContext = (NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext;
            if ("cobolProgramName".equals(string) || "maxCobolStringLength".equals(string) || "nestedCobol".equals(string) || "splitCobolCode".equals(string) || "cobolSubprogramPrefix".equals(string)) {
                return Boolean.TRUE;
            }
            if ("splitCobolCodeByProgram".equals(string)) {
                NdDeploymentDefinition ndDeploymentDefinition2 = ndDeploymentConfigDefaultsContext.getDeploymentDefinition();
                return ndDeploymentDefinition2.getCodeGenerationOptions().getSplitCobolCode();
            }
            if ("cobolLineLimit".equals(string)) {
                NdDeploymentDefinition ndDeploymentDefinition3 = ndDeploymentConfigDefaultsContext.getDeploymentDefinition();
                return ndDeploymentDefinition3.getCodeGenerationOptions().getSplitCobolCode();
            }
            if ("cobolCopybookPrefix".equals(string) && (ndDeploymentDefinition = ndDeploymentConfigDefaultsContext.getDeploymentDefinition()).getCodeGenerationOptions().getSplitCobolCode() == Boolean.TRUE && ndDeploymentDefinition.getCodeGenerationOptions().getSplitCobolCodeByProgram() == Boolean.FALSE) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("cobolProgramName".equals(string)) {
                return NdCobolDeploymentEnvironment.DEFAULT_PROGRAM_NAME;
            }
            if ("maxCobolStringLength".equals(string)) {
                return NdCobolDeploymentEnvironment.DEFAULT_MAX_STRING_LENGTH;
            }
            if ("cobolSubprogramPrefix".equals(string)) {
                return NdCobolDeploymentEnvironment.DEFAULT_SUBPROGRAM_PREFIX;
            }
            if ("nestedCobol".equals(string)) {
                return Boolean.FALSE.toString();
            }
            if ("splitCobolCode".equals(string)) {
                return Boolean.FALSE.toString();
            }
            if ("splitCobolCodeByProgram".equals(string)) {
                return Boolean.FALSE.toString();
            }
            if ("cobolLineLimit".equals(string)) {
                return NdCobolDeploymentEnvironment.DEFAULT_LINE_LIMIT;
            }
            if ("cobolCopybookPrefix".equals(string)) {
                return NdCobolDeploymentEnvironment.DEFAULT_COPYBOOK_PREFIX;
            }
            if ("appStartedOnInit".equals(string)) {
                return Boolean.TRUE.toString();
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }
    }

    private static class SiPQKeX
    extends NdConfigDefinitionDefaultsImpl {
        private SiPQKeX() {
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("cobolCompatible".equals(string)) {
                NdDeploymentDefinition ndDeploymentDefinition = ((NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext).getDeploymentDefinition();
                if (ndDeploymentDefinition != null && "COBOL".equals(ndDeploymentDefinition.getDeploymentEnvironment())) {
                    return Boolean.TRUE.toString();
                }
                return Boolean.FALSE.toString();
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            Boolean bl;
            NdRuleServiceDefinition ndRuleServiceDefinition = ((NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext).getRuleServiceDefinition();
            if (ndRuleServiceDefinition != null && (bl = ndRuleServiceDefinition.getCobolCompatible()) != null && bl.booleanValue()) {
                return "cobolCompatible".equals(string) || "description".equals(string) || "entryPoint".equals(string) || "name".equals(string) ? Boolean.TRUE : Boolean.FALSE;
            }
            return super.uses(string, ndConfigDefaultsContext);
        }
    }
}

