/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.environments;

import com.blazesoft.server.base.NdServerException;
import com.blazesoft.server.deploygen.NdDeploymentConstants;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.NdRuleServiceDefinition;
import com.blazesoft.server.deploygen.definitions.NdSystemDefinition;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaults;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaultsImpl;
import com.blazesoft.server.deploygen.definitions.defaults.NdDeploymentConfigDefaultsContext;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironment;
import com.blazesoft.server.deploygen.environments.NdDeploymentTemplatesMgr;
import com.blazesoft.server.deploygen.environments.NdJ2EEDeploymentEnvironment;
import com.blazesoft.server.deploygen.generation.NdConfigGenerator;
import com.blazesoft.server.deploygen.generation.NdEJBConfigGenerator;
import com.blazesoft.server.qdeployer.NdQDeployerModel;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerEJBExtractor;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerEJBFileGeneratorImpl;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerExtractor;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerFileGeneratorImpl;
import com.blazesoft.template.repository.NdPromProject;
import com.blazesoft.template.repository.NdPromRulesProject;
import com.blazesoft.template.repository.NdRomException;
import com.blazesoft.template.repository.util.NdRomSchemaSupport;
import com.blazesoft.util.NdWrappedRuntimeException;
import java.rmi.server.UID;
import java.util.Vector;

public class NdEjbDeploymentEnvironment
extends NdJ2EEDeploymentEnvironment {
    private static final String SiPGdNY = "weblogic.jndi.WLInitialContextFactory";
    private static final String SiPGdOZ = "WebLogic";
    private static final String SiPGdPA = "JBoss";
    private static final NdConfigDefinitionDefaults SiPGdPB = new SiPGfYQ();
    private static final NdConfigDefinitionDefaults SiPGdPC = new SiPGgbT();
    private static final NdConfigDefinitionDefaults SiPGdPD = new SiPGeLU();
    private static final NdConfigDefinitionDefaults SiPGdPE = new SiPGayC();
    private static final NdConfigDefinitionDefaults SiPGdPF = new SiPGbcL();
    public static final String[] VALID_WEBLOGIC_PROTOCOLS = new String[]{"t3", "rmi"};

    protected NdEjbDeploymentEnvironment(String string) {
        super(string);
    }

    NdEjbDeploymentEnvironment() {
        super("EJBinline");
    }

    public boolean hasRequiredTemplates(NdQDeployerModel ndQDeployerModel, Vector vector) {
        boolean bl = super.hasRequiredTemplates(ndQDeployerModel, vector);
        if (bl) {
            bl = vector.contains("PrefixTitleBean.java") && vector.contains("PrefixTitleBusiness.java") && vector.contains("PrefixTitleHome.java") && vector.contains("PrefixTitleRemote.java") && vector.contains("PrefixClient.java");
        }
        return bl;
    }

    public NdConfigDefinitionDefaults getDeploymentDefinitionDefaults() {
        return SiPGdPF;
    }

    public NdConfigDefinitionDefaults getSystemDefinitionDefaults() {
        return SiPGdPB;
    }

    public NdConfigDefinitionDefaults getCodeGenerationDefaults() {
        return SiPGdPD;
    }

    public NdConfigDefinitionDefaults getRemoteDebuggingDefaults() {
        return SiPGdPC;
    }

    public NdConfigDefinitionDefaults getDeploymentManagerDefaults() {
        return SiPGdPE;
    }

    static String SiPGdPG(NdConfigDefaultsContext ndConfigDefaultsContext) {
        return NdEjbDeploymentEnvironment.SiPGdPJ(ndConfigDefaultsContext, SiPGdOZ) ? "t3" : "rmi";
    }

    static String[] SiPGdPH(NdConfigDefaultsContext ndConfigDefaultsContext) {
        String[] stringArray;
        if (NdEjbDeploymentEnvironment.SiPGdPJ(ndConfigDefaultsContext, SiPGdOZ)) {
            stringArray = VALID_WEBLOGIC_PROTOCOLS;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "rmi";
        }
        return stringArray;
    }

    static String SiPGdPI(NdConfigDefaultsContext ndConfigDefaultsContext) {
        if (NdEjbDeploymentEnvironment.SiPGdPJ(ndConfigDefaultsContext, SiPGdOZ)) {
            return "7001";
        }
        if (NdEjbDeploymentEnvironment.SiPGdPJ(ndConfigDefaultsContext, SiPGdPA)) {
            return "51099";
        }
        return "1099";
    }

    static boolean SiPGdPJ(NdConfigDefaultsContext ndConfigDefaultsContext, String string) {
        String string2 = ((NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext).getSystemDefinition().getVendor();
        return string2 != null && string2.indexOf(string) >= 0;
    }

    public String getTemplateSubdir(NdDeploymentConstants.TargetLanguage targetLanguage) {
        return "ejb";
    }

    public NdQDeployerFileGeneratorImpl createFileGenerator() {
        return new NdQDeployerEJBFileGeneratorImpl();
    }

    public NdQDeployerExtractor createExtractor(NdPromRulesProject ndPromRulesProject, NdRomSchemaSupport ndRomSchemaSupport, String string) throws NdRomException {
        return ndPromRulesProject == null ? null : new NdQDeployerEJBExtractor(ndPromRulesProject, ndRomSchemaSupport, string);
    }

    public NdConfigGenerator createConfigGenerator(NdPromProject ndPromProject, NdRuleServiceDefinition ndRuleServiceDefinition, NdDeploymentDefinition ndDeploymentDefinition, NdSystemDefinition ndSystemDefinition) {
        return new NdEJBConfigGenerator(ndPromProject, ndRuleServiceDefinition, ndDeploymentDefinition, ndSystemDefinition);
    }

    public String createRmiUid() {
        return new UID().toString();
    }

    protected static class SiPGayC
    extends NdConfigDefinitionDefaultsImpl {
        protected SiPGayC() {
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("connectionProtocol".equals(string)) {
                return NdEjbDeploymentEnvironment.SiPGdPG(ndConfigDefaultsContext);
            }
            if ("connectionPort".equals(string)) {
                return NdEjbDeploymentEnvironment.SiPGdPI(ndConfigDefaultsContext);
            }
            if ("rmiContextFactory".equals(string)) {
                if (NdEjbDeploymentEnvironment.SiPGdPJ(ndConfigDefaultsContext, NdEjbDeploymentEnvironment.SiPGdOZ)) {
                    return NdEjbDeploymentEnvironment.SiPGdNY;
                }
            } else if ("monitorChanges".equals(string)) {
                return Boolean.TRUE.toString();
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("connectionProtocol".equals(string)) {
                return NdEjbDeploymentEnvironment.SiPGdPH(ndConfigDefaultsContext);
            }
            if ("monitorChanges".equals(string)) {
                return new String[]{Boolean.TRUE.toString()};
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }
    }

    protected static class SiPGgbT
    extends NdConfigDefinitionDefaultsImpl {
        protected SiPGgbT() {
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("debug.connectionProtocol".equals(string)) {
                return NdEjbDeploymentEnvironment.SiPGdPG(ndConfigDefaultsContext);
            }
            if ("debug.connectionPort".equals(string)) {
                return NdEjbDeploymentEnvironment.SiPGdPI(ndConfigDefaultsContext);
            }
            if ("debug.contextFactoryClass".equals(string) && NdEjbDeploymentEnvironment.SiPGdPJ(ndConfigDefaultsContext, NdEjbDeploymentEnvironment.SiPGdOZ)) {
                return NdEjbDeploymentEnvironment.SiPGdNY;
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("debug.connectionProtocol".equals(string)) {
                return NdEjbDeploymentEnvironment.SiPGdPH(ndConfigDefaultsContext);
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }
    }

    protected static class SiPGeLU
    extends NdConfigDefinitionDefaultsImpl {
        protected SiPGeLU() {
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            NdDeploymentDefinition ndDeploymentDefinition;
            if ("appStartedOnInit".equals(string) && (ndDeploymentDefinition = ((NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext).getDeploymentDefinition()) != null) {
                if (ndDeploymentDefinition.getServerTypeEnum() == NdDeploymentConstants.ServerType.SYNCHRONOUS_STATEFUL) {
                    return new String[]{Boolean.FALSE.toString()};
                }
                return TRUE_FALSE_VALUES;
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }

        public Boolean requiresValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            return super.requiresValue(string, ndConfigDefaultsContext);
        }

        public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("serverConfigURL".equals(string)) {
                return Boolean.TRUE;
            }
            if ("serverConfigFileName".equals(string)) {
                return Boolean.FALSE;
            }
            return super.uses(string, ndConfigDefaultsContext);
        }
    }

    protected static class SiPGfYQ
    extends NdConfigDefinitionDefaultsImpl {
        private static final String SiPGfXP = "j2ee";

        protected SiPGfYQ() {
        }

        protected String SiPGBrY() {
            return SiPGfXP;
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            String[] stringArray;
            if ("vendor".equals(string) && (stringArray = this.getValidValues("vendor", ndConfigDefaultsContext)) != null) {
                String string2 = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].toLowerCase().indexOf(this.SiPGBrY()) < 0 || string2 != null && stringArray[i].compareTo(string2) <= 0) continue;
                    string2 = stringArray[i];
                }
                if (string2 != null) {
                    return string2;
                }
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            NdSystemDefinition ndSystemDefinition;
            if ("serverType".equals(string)) {
                return new String[]{NdDeploymentConstants.ServerType.STATELESS.toString(), NdDeploymentConstants.ServerType.SYNCHRONOUS_STATEFUL.toString()};
            }
            if ("vendor".equals(string) && (ndSystemDefinition = ((NdDeploymentConfigDefaultsContext)ndConfigDefaultsContext).getSystemDefinition()) != null) {
                try {
                    NdDeploymentEnvironment ndDeploymentEnvironment = ndSystemDefinition.getDeploymentEnvironmentEnum();
                    NdDeploymentConstants.ServerType serverType = ndSystemDefinition.getServerTypeEnum();
                    String[] stringArray = ndDeploymentEnvironment == null || serverType == null ? null : NdDeploymentTemplatesMgr.getVendorList(ndDeploymentEnvironment, serverType);
                    return stringArray == null ? new String[]{} : stringArray;
                }
                catch (NdServerException ndServerException) {
                    throw new NdWrappedRuntimeException((Throwable)((Object)ndServerException));
                }
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }
    }

    protected static class SiPGbcL
    extends NdConfigDefinitionDefaultsImpl {
        protected SiPGbcL() {
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("ruleAgentPoolingPolicy".equals(string)) {
                return NdDeploymentConstants.RuleAgentPoolingPolicy.CONTAINER_MANAGED.toString();
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("serverType".equals(string)) {
                return new String[]{NdDeploymentConstants.ServerType.STATELESS.toString(), NdDeploymentConstants.ServerType.SYNCHRONOUS_STATEFUL.toString()};
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }
    }
}

