/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.environments;

import com.blazesoft.server.deploygen.NdDeploymentConstants;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.NdRuleServiceDefinition;
import com.blazesoft.server.deploygen.definitions.NdSystemDefinition;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaults;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaultsImpl;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironmentImpl;
import com.blazesoft.server.deploygen.generation.NdConfigGenerator;
import com.blazesoft.server.deploygen.generation.NdJavaConfigGenerator;
import com.blazesoft.server.qdeployer.NdQDeployerModel;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerFileGeneratorImpl;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerJavaFileGeneratorImpl;
import com.blazesoft.template.repository.NdPromProject;
import java.util.Vector;

public class NdJavaDeploymentEnvironment
extends NdDeploymentEnvironmentImpl {
    private static final NdConfigDefinitionDefaults SiPGeeF = new SiPGaFT();
    private static final NdConfigDefinitionDefaults SiPGeeG = new SiPGchO();
    private static final NdConfigDefinitionDefaults SiPGeeH = new SiPGbkG();

    NdJavaDeploymentEnvironment() {
        super("Java");
    }

    NdJavaDeploymentEnvironment(String string) {
        super(string);
    }

    public boolean hasRequiredTemplates(NdQDeployerModel ndQDeployerModel, Vector vector) {
        boolean bl = super.hasRequiredTemplates(ndQDeployerModel, vector);
        if (bl) {
            String string = ndQDeployerModel.getDeploymentEnvironmentDirectory();
            bl = string.equals("J#") ? vector.contains("PrefixServer.jsl") && vector.contains("PrefixClient.jsl") : (string.equals("C#") ? vector.contains("PrefixServer.cs") && vector.contains("PrefixClient.cs") : (string.equals("VB") ? vector.contains("PrefixServer.vb") && vector.contains("PrefixClient.vb") : vector.contains("PrefixServer.java") && vector.contains("PrefixClient.java")));
        }
        return bl;
    }

    public NdConfigDefinitionDefaults getDeploymentDefinitionDefaults() {
        return SiPGeeF;
    }

    public NdConfigDefinitionDefaults getDeploymentManagerDefaults() {
        return SiPGeeG;
    }

    public NdConfigDefinitionDefaults getCodeGenerationDefaults() {
        return SiPGeeH;
    }

    public String getTemplateSubdir(NdDeploymentConstants.TargetLanguage targetLanguage) {
        return "java";
    }

    public NdQDeployerFileGeneratorImpl createFileGenerator() {
        return new NdQDeployerJavaFileGeneratorImpl();
    }

    public NdConfigGenerator createConfigGenerator(NdPromProject ndPromProject, NdRuleServiceDefinition ndRuleServiceDefinition, NdDeploymentDefinition ndDeploymentDefinition, NdSystemDefinition ndSystemDefinition) {
        return new NdJavaConfigGenerator(ndPromProject, ndRuleServiceDefinition, ndDeploymentDefinition, ndSystemDefinition);
    }

    protected static class SiPGbkG
    extends NdConfigDefinitionDefaultsImpl {
        protected SiPGbkG() {
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("appStartedOnInit".equals(string)) {
                return new String[]{Boolean.FALSE.toString()};
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }
    }

    protected static class SiPGchO
    extends NdConfigDefinitionDefaultsImpl {
        private static final String[] SiPGcgN = new String[]{NdDeploymentConstants.ServerManagerType.JAVA.toString(), NdDeploymentConstants.ServerManagerType.RMI.toString()};

        protected SiPGchO() {
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("serverManagerType".equals(string)) {
                return SiPGcgN[0];
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("serverManagerType".equals(string)) {
                return SiPGcgN;
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }
    }

    protected static class SiPGaFT
    extends NdConfigDefinitionDefaultsImpl {
        private static final String SiPGaDR = Boolean.TRUE.toString();
        private static final String[] SiPGaES = new String[]{NdDeploymentConstants.RuleAgentPoolingPolicy.FIXED.toString(), NdDeploymentConstants.RuleAgentPoolingPolicy.DYNAMIC.toString()};

        protected SiPGaFT() {
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("threaded".equals(string)) {
                return SiPGaDR;
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("threaded".equals(string)) {
                return new String[]{String.valueOf(false), String.valueOf(true)};
            }
            if ("ruleAgentPoolingPolicy".equals(string)) {
                return SiPGaES;
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }
    }
}

