/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.environments;

import com.blazesoft.server.deploygen.NdDeploymentConstants;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.NdRuleServiceDefinition;
import com.blazesoft.server.deploygen.definitions.NdSystemDefinition;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaults;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefinitionDefaultsImpl;
import com.blazesoft.server.deploygen.environments.NdEjbDeploymentEnvironment;
import com.blazesoft.server.deploygen.generation.NdConfigGenerator;
import com.blazesoft.server.deploygen.generation.NdMDBConfigGenerator;
import com.blazesoft.server.qdeployer.NdQDeployerModel;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerFileGeneratorImpl;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerMDBFileGeneratorImpl;
import com.blazesoft.template.repository.NdPromProject;
import java.util.Vector;

public class NdMDBDeploymentEnvironment
extends NdEjbDeploymentEnvironment {
    private static final NdConfigDefinitionDefaults SiPGckB = new SiPGeoN();
    private static final NdConfigDefinitionDefaults SiPGclC = new SiPGdYP();
    private static final NdConfigDefinitionDefaults SiPGyES = new SiPGAnE();

    public NdMDBDeploymentEnvironment() {
        super("MDB");
    }

    public NdConfigDefinitionDefaults getDeploymentDefinitionDefaults() {
        return SiPGckB;
    }

    public NdConfigDefinitionDefaults getSystemDefinitionDefaults() {
        return SiPGclC;
    }

    public NdConfigDefinitionDefaults getSystemEnvironmentDefaults() {
        return SiPGyES;
    }

    public boolean hasRequiredTemplates(NdQDeployerModel ndQDeployerModel, Vector vector) {
        boolean bl = true;
        if (ndQDeployerModel.getDeploymentManagerConfig() != null && ndQDeployerModel.usesDManagerConfig() && !vector.contains("PrefixDManager.java")) {
            bl = false;
        }
        if (bl) {
            bl = vector.contains("PrefixTitleBean.java") && vector.contains("PrefixClient.java");
        }
        return bl;
    }

    public String getTemplateSubdir(NdDeploymentConstants.TargetLanguage targetLanguage) {
        return "mdb";
    }

    public NdQDeployerFileGeneratorImpl createFileGenerator() {
        return new NdQDeployerMDBFileGeneratorImpl();
    }

    public NdConfigGenerator createConfigGenerator(NdPromProject ndPromProject, NdRuleServiceDefinition ndRuleServiceDefinition, NdDeploymentDefinition ndDeploymentDefinition, NdSystemDefinition ndSystemDefinition) {
        return new NdMDBConfigGenerator(ndPromProject, ndRuleServiceDefinition, ndDeploymentDefinition, ndSystemDefinition);
    }

    protected static class SiPGAnE
    extends NdConfigDefinitionDefaultsImpl {
        protected SiPGAnE() {
        }

        public String getDefaultValue(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("reply".equals(string)) {
                return String.valueOf(Boolean.FALSE);
            }
            if ("requestDomainType".equals(string)) {
                return "Queue";
            }
            return super.getDefaultValue(string, ndConfigDefaultsContext);
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("requestDomainType".equals(string)) {
                return new String[]{"Queue", "Topic"};
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }

        public Boolean uses(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("requestDomainType".equals(string) || "reply".equals(string)) {
                return Boolean.TRUE;
            }
            return super.uses(string, ndConfigDefaultsContext);
        }
    }

    protected static class SiPGdYP
    extends NdEjbDeploymentEnvironment.SiPGfYQ {
        protected SiPGdYP() {
        }

        protected String SiPGBrY() {
            return "websphere";
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("serverType".equals(string)) {
                return new String[]{NdDeploymentConstants.ServerType.STATELESS.toString()};
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }
    }

    protected static class SiPGeoN
    extends NdEjbDeploymentEnvironment.SiPGbcL {
        protected SiPGeoN() {
        }

        public String[] getValidValues(String string, NdConfigDefaultsContext ndConfigDefaultsContext) {
            if ("serverType".equals(string)) {
                return new String[]{NdDeploymentConstants.ServerType.STATELESS.toString()};
            }
            return super.getValidValues(string, ndConfigDefaultsContext);
        }
    }
}

