/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.generation;

import com.blazesoft.dynobj.xml.NdConfigurationException;
import com.blazesoft.engines.rules.NdCompilationException;
import com.blazesoft.engines.rules.NdResourceException;
import com.blazesoft.proxy.rules.NdRuleAgentDevProxy;
import com.blazesoft.server.deploy.NdCompilationSupport;
import com.blazesoft.server.deploy.rules.NdDeployRulesServiceEntryPointConfig;
import com.blazesoft.server.deploy.rules.NdSrlInvocationFunctional;
import com.blazesoft.server.deploygen.definitions.NdCodeGenerationOptions;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.NdRuleServiceDefinition;
import com.blazesoft.server.deploygen.environments.NdCobolDeploymentEnvironment;
import com.blazesoft.server.deploygen.generation.NdDeploymentCodeGenerator;
import com.blazesoft.template.repository.NdPromRulesProject;
import com.blazesoft.template.repository.NdRomException;
import java.io.File;
import java.util.Hashtable;

public class NdCobolDeploymentGenerator
implements NdDeploymentCodeGenerator {
    private final NdPromRulesProject SiPQSGR;
    private final boolean SiPQSHS;
    private NdCompilationSupport SiPTPyC;
    private NdRuleAgentDevProxy SiPQSJU;

    public NdCobolDeploymentGenerator(NdPromRulesProject ndPromRulesProject) {
        this(ndPromRulesProject, true);
    }

    public NdCobolDeploymentGenerator(NdPromRulesProject ndPromRulesProject, boolean bl) {
        this.SiPQSGR = ndPromRulesProject;
        this.SiPQSHS = bl;
    }

    private NdRuleAgentDevProxy SiPQSKV() throws NdRomException, NdResourceException {
        if (this.SiPQSJU == null) {
            this.SiPTPyC = new NdCompilationSupport(this.SiPQSGR, this.SiPQSHS);
            NdRuleAgentDevProxy ndRuleAgentDevProxy = this.SiPTPyC.getRuleAgent();
            ndRuleAgentDevProxy.getProjectResource().setCodeGenFactoryClass("com.blazesoft.engines.rules.expressions.NdSRLExpressionTreeToCobolCodeGeneratorFactory");
            this.SiPTPyC.compile();
            this.SiPQSJU = ndRuleAgentDevProxy;
        }
        return this.SiPQSJU;
    }

    public NdCompilationSupport getCompilationSupport() {
        return this.SiPTPyC;
    }

    public void generateCode(NdRuleServiceDefinition ndRuleServiceDefinition, NdDeploymentDefinition ndDeploymentDefinition, String string) throws NdRomException, NdResourceException, NdCompilationException, NdConfigurationException {
        new File(string).mkdirs();
        Hashtable hashtable = NdCobolDeploymentGenerator.SiPQGPK(ndRuleServiceDefinition, ndDeploymentDefinition, string);
        NdRuleAgentDevProxy ndRuleAgentDevProxy = this.SiPQSKV();
        hashtable.put("doNotReturnSourceCode", new Boolean(true));
        ndRuleAgentDevProxy.generateSourceCode(hashtable);
        NdCompilationException ndCompilationException = ndRuleAgentDevProxy.getCompilationException();
        if (ndCompilationException.getErrorCount() != 0 || ndCompilationException.getWarningCount() != 0) {
            throw ndCompilationException;
        }
    }

    private static Hashtable SiPQGPK(NdRuleServiceDefinition ndRuleServiceDefinition, NdDeploymentDefinition ndDeploymentDefinition, String string) throws NdConfigurationException {
        String[] stringArray;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        NdCodeGenerationOptions ndCodeGenerationOptions = ndDeploymentDefinition.getCodeGenerationOptions();
        NdDeployRulesServiceEntryPointConfig ndDeployRulesServiceEntryPointConfig = NdCobolDeploymentEnvironment.getCobolEntryPoint(ndRuleServiceDefinition);
        NdSrlInvocationFunctional ndSrlInvocationFunctional = ndDeployRulesServiceEntryPointConfig.getSrlInvocationFunctional();
        hashtable.put("entrypointname", ndSrlInvocationFunctional.getSrlName());
        String string2 = ndSrlInvocationFunctional.getSrlReturnType();
        if (string2 != null) {
            hashtable.put("entrypointreturntype", string2);
        }
        if ((stringArray = ndSrlInvocationFunctional.getSrlArgumentType()) != null) {
            hashtable.put("entrypointparametertypes", stringArray);
        }
        hashtable.put("prefix", ndCodeGenerationOptions.getCobolProgramName());
        hashtable.put("outputpath", string);
        hashtable.put("formatgeneratedcode", Boolean.TRUE);
        hashtable.put("maxstringlength", ndCodeGenerationOptions.getMaxCobolStringLength());
        hashtable.put("usenestedprograms", ndCodeGenerationOptions.getNestedCobol());
        hashtable.put("subprogramprefix", ndCodeGenerationOptions.getCobolSubprogramPrefix());
        if (ndCodeGenerationOptions.getSplitCobolCode().booleanValue()) {
            hashtable.put("splitgeneratedcode", Boolean.TRUE);
            hashtable.put("copyfileprefix", ndCodeGenerationOptions.getCobolCopybookPrefix());
            hashtable.put("linelimit", ndCodeGenerationOptions.getCobolLineLimit());
            hashtable.put("splitbyprogram", ndCodeGenerationOptions.getSplitCobolCodeByProgram());
        }
        return hashtable;
    }
}

