/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.generation;

import com.blazesoft.server.config.NdDeploymentManagerConfig;
import com.blazesoft.server.config.NdDeploymentManagerConfigLoader;
import com.blazesoft.server.config.NdDeploymentManagerMonitorFactory;
import com.blazesoft.server.config.NdDeploymentManagerServerManagerFactory;
import com.blazesoft.server.config.NdDeploymentManagerSupportFactory;
import com.blazesoft.server.deploy.manager.NdDeploymentManagerException;
import com.blazesoft.server.deploygen.NdDeploymentUtil;
import com.blazesoft.server.deploygen.NdInvalidConfigPropertyException;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.NdDeploymentManagerOptions;
import com.blazesoft.server.deploygen.definitions.NdDeploymentManagerSystemOptions;
import com.blazesoft.server.deploygen.definitions.NdSystemDefinition;
import java.io.File;

public class NdDeploymentManagerConfigGenerator {
    public static final String DMANAGER_CHANGE_MONITOR_CLASS = "com.blazesoft.server.deploy.manager.NdDeploymentManagerChangeMonitor";
    private NdDeploymentDefinition SiPGgyT;
    private NdSystemDefinition SiPGgyU;

    public NdDeploymentManagerConfigGenerator(NdDeploymentDefinition ndDeploymentDefinition, NdSystemDefinition ndSystemDefinition) {
        this.SiPGgyT = ndDeploymentDefinition;
        this.SiPGgyU = ndSystemDefinition;
    }

    public NdDeploymentManagerConfig generateConfig() throws NdInvalidConfigPropertyException {
        NdDeploymentManagerServerManagerFactory ndDeploymentManagerServerManagerFactory;
        NdDeploymentManagerOptions ndDeploymentManagerOptions = this.SiPGgyT.getDeploymentManagerOptions();
        NdDeploymentManagerConfig ndDeploymentManagerConfig = NdDeploymentManagerConfigGenerator.loadDeploymentManagerConfig(ndDeploymentManagerOptions.getConfigFileName());
        if (ndDeploymentManagerConfig == null) {
            ndDeploymentManagerConfig = this.SiPGgyX(ndDeploymentManagerOptions.getName());
        }
        if ((ndDeploymentManagerServerManagerFactory = NdDeploymentManagerConfigGenerator.loadServerManager(ndDeploymentManagerOptions.getConfigFileName(), ndDeploymentManagerOptions.getServerManagerName())) == null) {
            ndDeploymentManagerServerManagerFactory = this.SiPGgyW();
            this._addServerManagerToDeploymentManager(ndDeploymentManagerConfig, ndDeploymentManagerServerManagerFactory);
        }
        this.SiPGgyV(ndDeploymentManagerConfig, ndDeploymentManagerOptions);
        return ndDeploymentManagerConfig;
    }

    public void _addServerManagerToDeploymentManager(NdDeploymentManagerConfig ndDeploymentManagerConfig, NdDeploymentManagerServerManagerFactory ndDeploymentManagerServerManagerFactory) {
        NdDeploymentManagerServerManagerFactory[] ndDeploymentManagerServerManagerFactoryArray = ndDeploymentManagerConfig.getDeploymentManagerServerManagerFactory();
        int n = ndDeploymentManagerServerManagerFactoryArray != null ? ndDeploymentManagerServerManagerFactoryArray.length + 1 : 1;
        NdDeploymentManagerServerManagerFactory[] ndDeploymentManagerServerManagerFactoryArray2 = new NdDeploymentManagerServerManagerFactory[n];
        if (n > 1) {
            System.arraycopy(ndDeploymentManagerServerManagerFactoryArray, 0, ndDeploymentManagerServerManagerFactoryArray2, 0, n - 1);
        }
        ndDeploymentManagerServerManagerFactoryArray2[n - 1] = ndDeploymentManagerServerManagerFactory;
        ndDeploymentManagerConfig.setDeploymentManagerServerManagerFactory(ndDeploymentManagerServerManagerFactoryArray2);
    }

    private void SiPGgyV(NdDeploymentManagerConfig ndDeploymentManagerConfig, NdDeploymentManagerOptions ndDeploymentManagerOptions) {
        if (ndDeploymentManagerOptions.getMonitorChanges().booleanValue()) {
            NdDeploymentManagerSupportFactory[] ndDeploymentManagerSupportFactoryArray;
            NdDeploymentManagerSupportFactory ndDeploymentManagerSupportFactory = new NdDeploymentManagerSupportFactory();
            ndDeploymentManagerSupportFactory.setJavaName(DMANAGER_CHANGE_MONITOR_CLASS);
            if (ndDeploymentManagerOptions.getChangeMonitoringHeartbeat() != null) {
                int n = ndDeploymentManagerOptions.getChangeMonitoringHeartbeat();
                ndDeploymentManagerSupportFactory.setJavaMethodArg(new Object[]{String.valueOf(n)});
            }
            if ((ndDeploymentManagerSupportFactoryArray = ndDeploymentManagerConfig.getDeploymentManagerSupportFactory()) == null || ndDeploymentManagerSupportFactoryArray.length == 0) {
                ndDeploymentManagerConfig.setDeploymentManagerSupportFactory(new NdDeploymentManagerSupportFactory[]{ndDeploymentManagerSupportFactory});
            }
            if (ndDeploymentManagerSupportFactoryArray != null && ndDeploymentManagerSupportFactoryArray.length > 0) {
                boolean bl = false;
                for (int i = 0; i < ndDeploymentManagerSupportFactoryArray.length; ++i) {
                    if (!ndDeploymentManagerSupportFactoryArray[i].getJavaName().equals(DMANAGER_CHANGE_MONITOR_CLASS)) continue;
                    ndDeploymentManagerConfig.setDeploymentManagerSupportFactory(i, ndDeploymentManagerSupportFactory);
                    bl = true;
                    break;
                }
                if (!bl) {
                    NdDeploymentManagerSupportFactory[] ndDeploymentManagerSupportFactoryArray2 = new NdDeploymentManagerSupportFactory[ndDeploymentManagerSupportFactoryArray.length + 1];
                    System.arraycopy(ndDeploymentManagerSupportFactoryArray, 0, ndDeploymentManagerSupportFactoryArray2, 0, ndDeploymentManagerSupportFactoryArray.length);
                    ndDeploymentManagerSupportFactoryArray2[ndDeploymentManagerSupportFactoryArray2.length - 1] = ndDeploymentManagerSupportFactory;
                    ndDeploymentManagerConfig.setDeploymentManagerSupportFactory(ndDeploymentManagerSupportFactoryArray2);
                }
            }
        } else {
            NdDeploymentManagerSupportFactory[] ndDeploymentManagerSupportFactoryArray = ndDeploymentManagerConfig.getDeploymentManagerSupportFactory();
            if (ndDeploymentManagerSupportFactoryArray != null && ndDeploymentManagerSupportFactoryArray.length > 0) {
                int n = -1;
                for (int i = 0; i < ndDeploymentManagerSupportFactoryArray.length; ++i) {
                    if (!ndDeploymentManagerSupportFactoryArray[i].getJavaName().equals(DMANAGER_CHANGE_MONITOR_CLASS)) continue;
                    n = i;
                    break;
                }
                if (n != -1) {
                    NdDeploymentManagerSupportFactory[] ndDeploymentManagerSupportFactoryArray3 = new NdDeploymentManagerSupportFactory[ndDeploymentManagerSupportFactoryArray.length - 1];
                    System.arraycopy(ndDeploymentManagerSupportFactoryArray, 0, ndDeploymentManagerSupportFactoryArray3, 0, n);
                    for (int i = n + 1; i < ndDeploymentManagerSupportFactoryArray.length; ++i) {
                        ndDeploymentManagerSupportFactoryArray3[i - 1] = ndDeploymentManagerSupportFactoryArray[i];
                    }
                    ndDeploymentManagerConfig.setDeploymentManagerSupportFactory(ndDeploymentManagerSupportFactoryArray3);
                }
            }
        }
    }

    private NdDeploymentManagerServerManagerFactory SiPGgyW() {
        NdDeploymentManagerOptions ndDeploymentManagerOptions = this.SiPGgyT.getDeploymentManagerOptions();
        NdDeploymentManagerSystemOptions ndDeploymentManagerSystemOptions = this.SiPGgyU.getDeploymentManagerSystemOptions();
        NdDeploymentManagerServerManagerFactory ndDeploymentManagerServerManagerFactory = new NdDeploymentManagerServerManagerFactory();
        ndDeploymentManagerServerManagerFactory.setServerManagerName(ndDeploymentManagerOptions.getServerManagerName());
        ndDeploymentManagerServerManagerFactory.setJavaName(ndDeploymentManagerOptions.getServerManagerTypeEnum().getServerManagerClass());
        boolean bl = NdDeploymentUtil.isDotNetDeployment(this.SiPGgyT.getDeploymentEnvironmentEnum());
        if (ndDeploymentManagerOptions.isRemote()) {
            ndDeploymentManagerServerManagerFactory.setConnectionProtocol(ndDeploymentManagerSystemOptions.getConnectionProtocol());
            ndDeploymentManagerServerManagerFactory.setConnectionHost(ndDeploymentManagerSystemOptions.getConnectionHost());
            Integer n = ndDeploymentManagerSystemOptions.getConnectionPort();
            if (n != null) {
                ndDeploymentManagerServerManagerFactory.setConnectionPort(n.toString());
            }
            if (!bl) {
                String string;
                String string2;
                String string3 = ndDeploymentManagerSystemOptions.getRmiContextFactory();
                if (string3 != null) {
                    ndDeploymentManagerServerManagerFactory.setInitContextFactory(string3);
                }
                if ((string2 = ndDeploymentManagerSystemOptions.getSecurityPrincipal()) != null) {
                    ndDeploymentManagerServerManagerFactory.setSecurityPrincipal(string2);
                }
                if ((string = ndDeploymentManagerSystemOptions.getSecurityCredentials()) != null) {
                    ndDeploymentManagerServerManagerFactory.setSecurityCredentials(string);
                }
            }
        }
        return ndDeploymentManagerServerManagerFactory;
    }

    private NdDeploymentManagerConfig SiPGgyX(String string) {
        NdDeploymentManagerConfig ndDeploymentManagerConfig = new NdDeploymentManagerConfig(string);
        NdDeploymentManagerMonitorFactory[] ndDeploymentManagerMonitorFactoryArray = new NdDeploymentManagerMonitorFactory[]{new NdDeploymentManagerMonitorFactory("com.blazesoft.server.deploy.manager.NdDeploymentManagerOutputStreamAudit")};
        ndDeploymentManagerConfig.setDeploymentManagerMonitorFactory(ndDeploymentManagerMonitorFactoryArray);
        return ndDeploymentManagerConfig;
    }

    public static NdDeploymentManagerConfig loadDeploymentManagerConfig(String string) throws NdInvalidConfigPropertyException {
        NdDeploymentManagerConfig ndDeploymentManagerConfig = null;
        if (string != null && new File(string).exists()) {
            try {
                ndDeploymentManagerConfig = NdDeploymentManagerConfigLoader.getDefaultDeploymentManagerConfigLoader().load(string);
            }
            catch (NdDeploymentManagerException ndDeploymentManagerException) {
                throw new NdInvalidConfigPropertyException("configFileName", string, (Exception)((Object)ndDeploymentManagerException));
            }
        }
        return ndDeploymentManagerConfig;
    }

    public static NdDeploymentManagerServerManagerFactory loadServerManager(String string, String string2) throws NdInvalidConfigPropertyException {
        NdDeploymentManagerServerManagerFactory ndDeploymentManagerServerManagerFactory = null;
        NdDeploymentManagerConfig ndDeploymentManagerConfig = NdDeploymentManagerConfigGenerator.loadDeploymentManagerConfig(string);
        if (ndDeploymentManagerConfig != null && string2 != null) {
            NdDeploymentManagerServerManagerFactory[] ndDeploymentManagerServerManagerFactoryArray = ndDeploymentManagerConfig.getDeploymentManagerServerManagerFactory();
            for (int i = 0; i < ndDeploymentManagerServerManagerFactoryArray.length && ndDeploymentManagerServerManagerFactory == null; ++i) {
                if (!ndDeploymentManagerServerManagerFactoryArray[i].getServerManagerName().equals(string2)) continue;
                ndDeploymentManagerServerManagerFactory = ndDeploymentManagerServerManagerFactoryArray[i];
            }
        }
        return ndDeploymentManagerServerManagerFactory;
    }
}

