/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.deploygen.validation;

import com.blazesoft.dynobj.xml.NdConfigurationException;
import com.blazesoft.server.deploy.rules.NdDeployRulesServiceEntryPointConfig;
import com.blazesoft.server.deploygen.NdDeploymentConstants;
import com.blazesoft.server.deploygen.NdDeploymentUtil;
import com.blazesoft.server.deploygen.definitions.NdCodeGenerationOptions;
import com.blazesoft.server.deploygen.definitions.NdConfigDefinition;
import com.blazesoft.server.deploygen.definitions.NdDeploymentDefinition;
import com.blazesoft.server.deploygen.definitions.NdDeploymentManagerOptions;
import com.blazesoft.server.deploygen.definitions.NdDeploymentManagerSystemOptions;
import com.blazesoft.server.deploygen.definitions.NdRemoteDebuggingOptions;
import com.blazesoft.server.deploygen.definitions.NdRemoteDebuggingSystemOptions;
import com.blazesoft.server.deploygen.definitions.NdRuleServiceDefinition;
import com.blazesoft.server.deploygen.definitions.NdSystemDefinition;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContext;
import com.blazesoft.server.deploygen.definitions.defaults.NdConfigDefaultsContextImpl;
import com.blazesoft.server.deploygen.definitions.defaults.NdDeploymentConfigDefaultsContext;
import com.blazesoft.server.deploygen.environments.NdCobolDeploymentEnvironment;
import com.blazesoft.server.deploygen.environments.NdDeploymentEnvironmentMgr;
import com.blazesoft.server.deploygen.validation.NdDeploymentValidationException;
import com.blazesoft.server.deploygen.validation.NdDeploymentValidationIssue;
import com.blazesoft.server.deploygen.validation.NdIncompatibleCobolEntryPoints;
import com.blazesoft.server.deploygen.validation.NdIncompatibleValuesIssue;
import com.blazesoft.server.deploygen.validation.NdInvalidPropertyValueIssue;
import com.blazesoft.server.deploygen.validation.NdStrings;
import com.blazesoft.server.deploygen.validation.NdValidationSkippedIssue;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class NdDeploymentValidator {
    private List SiPGhwG;
    private NdDeploymentEnvironmentMgr SiPTPwW;
    private NdConfigDefaultsContext SiPGhwH;

    public NdDeploymentValidator(NdDeploymentEnvironmentMgr ndDeploymentEnvironmentMgr) {
        this(ndDeploymentEnvironmentMgr, null);
    }

    public NdDeploymentValidator(NdDeploymentEnvironmentMgr ndDeploymentEnvironmentMgr, NdConfigDefaultsContext ndConfigDefaultsContext) {
        this.SiPTPwW = ndDeploymentEnvironmentMgr;
        this.SiPGhwH = ndConfigDefaultsContext;
        this.SiPGhwI();
    }

    private void SiPGhwI() {
        this.SiPGhwG = new ArrayList();
    }

    public void setContext(NdConfigDefaultsContext ndConfigDefaultsContext) {
        this.SiPGhwH = ndConfigDefaultsContext;
    }

    public void validate(NdRuleServiceDefinition ndRuleServiceDefinition, NdDeploymentDefinition ndDeploymentDefinition, NdSystemDefinition ndSystemDefinition) throws NdDeploymentValidationException {
        this.SiPGhwI();
        this.setContext(new NdConfigDefaultsContextImpl(this.SiPTPwW, ndRuleServiceDefinition, ndDeploymentDefinition, ndSystemDefinition));
        this.SiPGhwL(ndRuleServiceDefinition);
        this.SiPGhwM(ndDeploymentDefinition);
        this.SiPGhwN(ndSystemDefinition);
        this.SiPUgoC(ndDeploymentDefinition, ndSystemDefinition);
        this.SiPGhCF();
    }

    private void SiPUgoC(NdDeploymentDefinition ndDeploymentDefinition, NdSystemDefinition ndSystemDefinition) {
        if (ndSystemDefinition == null) {
            return;
        }
        if (!"Spring_2_5_6".equals(ndSystemDefinition.getVendor()) || "Spring_3_0_2".equals(ndSystemDefinition.getVendor())) {
            return;
        }
        if (NdDeploymentConstants.RuleAgentPoolingPolicy.DYNAMIC.toString().equals(ndDeploymentDefinition.getRuleAgentPoolingPolicy())) {
            return;
        }
        if (NdDeploymentConstants.RuleAgentPoolingPolicy.FIXED.toString().equals(ndDeploymentDefinition.getRuleAgentPoolingPolicy())) {
            return;
        }
        this.SiPGhwG.add(new NdIncompatibleValuesIssue(ndDeploymentDefinition, "ruleAgentPoolingPolicy", ndDeploymentDefinition.getRuleAgentPoolingPolicy(), ndSystemDefinition, "vendor", ndSystemDefinition.getVendor()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateRuleServiceDefinition(NdRuleServiceDefinition ndRuleServiceDefinition) throws NdDeploymentValidationException {
        NdConfigDefaultsContext ndConfigDefaultsContext = this.SiPGhwH;
        try {
            if (this.SiPGhwH == null) {
                this.SiPGhwH = new NdConfigDefaultsContextImpl(this.SiPTPwW, ndRuleServiceDefinition, null, null);
            }
            this.SiPGhwL(ndRuleServiceDefinition);
            this.SiPGhCF();
            Object var4_3 = null;
            this.SiPGhwH = ndConfigDefaultsContext;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.SiPGhwH = ndConfigDefaultsContext;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateDeploymentDefinition(NdDeploymentDefinition ndDeploymentDefinition) throws NdDeploymentValidationException {
        NdConfigDefaultsContext ndConfigDefaultsContext = this.SiPGhwH;
        try {
            if (this.SiPGhwH == null) {
                this.SiPGhwH = new NdConfigDefaultsContextImpl(this.SiPTPwW, null, ndDeploymentDefinition, null);
            }
            this.SiPGhwM(ndDeploymentDefinition);
            this.SiPGhCF();
            Object var4_3 = null;
            this.SiPGhwH = ndConfigDefaultsContext;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.SiPGhwH = ndConfigDefaultsContext;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSystemDefinition(NdSystemDefinition ndSystemDefinition) throws NdDeploymentValidationException {
        NdConfigDefaultsContext ndConfigDefaultsContext = this.SiPGhwH;
        try {
            if (this.SiPGhwH == null) {
                this.SiPGhwH = new NdConfigDefaultsContextImpl(this.SiPTPwW, null, null, ndSystemDefinition);
            }
            this.SiPGhwN(ndSystemDefinition);
            this.SiPGhCF();
            Object var4_3 = null;
            this.SiPGhwH = ndConfigDefaultsContext;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.SiPGhwH = ndConfigDefaultsContext;
            throw throwable;
        }
    }

    private NdRuleServiceDefinition SiPGhwJ() {
        NdRuleServiceDefinition ndRuleServiceDefinition = ((NdDeploymentConfigDefaultsContext)this.SiPGhwH).getRuleServiceDefinition();
        if (ndRuleServiceDefinition != null) {
            ndRuleServiceDefinition = ndRuleServiceDefinition.createWithDefaults(this.SiPGhwH);
        }
        return ndRuleServiceDefinition;
    }

    private NdDeploymentDefinition SiPGhwK() {
        NdDeploymentDefinition ndDeploymentDefinition = ((NdDeploymentConfigDefaultsContext)this.SiPGhwH).getDeploymentDefinition();
        if (ndDeploymentDefinition != null) {
            ndDeploymentDefinition = ndDeploymentDefinition.createWithDefaults(this.SiPGhwH);
        }
        return ndDeploymentDefinition;
    }

    private void SiPGhwL(NdRuleServiceDefinition ndRuleServiceDefinition) {
        NdIncompatibleCobolEntryPoints ndIncompatibleCobolEntryPoints;
        if ("COBOL".equals(this.SiPGhwK().getDeploymentEnvironment()) && (ndIncompatibleCobolEntryPoints = NdDeploymentValidator.validateCobolRsd(ndRuleServiceDefinition)) != null) {
            this.SiPGhwG.add(ndIncompatibleCobolEntryPoints);
        }
    }

    public static NdIncompatibleCobolEntryPoints validateCobolRsd(NdRuleServiceDefinition ndRuleServiceDefinition) {
        try {
            NdDeployRulesServiceEntryPointConfig ndDeployRulesServiceEntryPointConfig = NdCobolDeploymentEnvironment.getCobolEntryPoint(ndRuleServiceDefinition);
            if (ndDeployRulesServiceEntryPointConfig == null) {
                return new NdIncompatibleCobolEntryPoints(ndRuleServiceDefinition, NdStrings.SiPGjjR("NoEntryPointInRsd", ndRuleServiceDefinition.getName()));
            }
        }
        catch (NdConfigurationException ndConfigurationException) {
            return new NdIncompatibleCobolEntryPoints(ndRuleServiceDefinition, ndConfigurationException);
        }
        return null;
    }

    private void SiPGhwM(NdDeploymentDefinition ndDeploymentDefinition) {
        if ((ndDeploymentDefinition = ndDeploymentDefinition.createWithDefaults(this.SiPGhwH)).getRuleAgentPoolingPolicyEnum() == NdDeploymentConstants.RuleAgentPoolingPolicy.FIXED && ndDeploymentDefinition.getNumRuleAgents() < 1) {
            this.SiPGhwG.add(new NdInvalidPropertyValueIssue(ndDeploymentDefinition, "numRuleAgents", String.valueOf(ndDeploymentDefinition.getNumRuleAgents())));
        }
        this.SiPGhwO(ndDeploymentDefinition.getDeploymentManagerOptions());
        this.SiPGhwT(ndDeploymentDefinition);
        this.SiPGhwX(ndDeploymentDefinition);
        this.SiPXVJC(ndDeploymentDefinition);
        this.SiPGhBE(ndDeploymentDefinition, "serverType");
        this.SiPGhBE(ndDeploymentDefinition, "ruleAgentPoolingPolicy");
    }

    private void SiPGhwN(NdSystemDefinition ndSystemDefinition) {
        if (ndSystemDefinition == null) {
            return;
        }
        ndSystemDefinition = ndSystemDefinition.createWithDefaults(this.SiPGhwH);
        NdDeploymentDefinition ndDeploymentDefinition = this.SiPGhwK();
        if (ndDeploymentDefinition == null) {
            this.SiPGhwG.add(new NdValidationSkippedIssue(ndSystemDefinition));
        } else {
            this.SiPGhzC(ndDeploymentDefinition, ndSystemDefinition);
            this.SiPGhyB(ndSystemDefinition);
            this.SiPGhwP(ndSystemDefinition.getDeploymentManagerSystemOptions(), ndDeploymentDefinition);
            this.SiPGhwU(ndSystemDefinition.getRemoteDebuggingSystemOptions(), ndDeploymentDefinition);
        }
    }

    private void SiPGhwO(NdDeploymentManagerOptions ndDeploymentManagerOptions) {
        this.SiPGhBE(ndDeploymentManagerOptions, "enabled");
        if (!ndDeploymentManagerOptions.getEnabled().booleanValue()) {
            return;
        }
        this.SiPGhAD(ndDeploymentManagerOptions, "name");
        this.SiPGhwS(ndDeploymentManagerOptions);
        this.SiPGhAD(ndDeploymentManagerOptions, "ruleSourceID");
        this.SiPGhAD(ndDeploymentManagerOptions, "serverManagerName");
        this.SiPGhBE(ndDeploymentManagerOptions, "serverManagerType");
        this.SiPGhwR(ndDeploymentManagerOptions);
    }

    private void SiPGhwP(NdDeploymentManagerSystemOptions ndDeploymentManagerSystemOptions, NdDeploymentDefinition ndDeploymentDefinition) {
        if (ndDeploymentDefinition.getDeploymentManagerOptions().isRemote()) {
            this.SiPGhBE(ndDeploymentManagerSystemOptions, "connectionProtocol");
            this.SiPGhwQ(ndDeploymentManagerSystemOptions, "connectionPort");
        }
    }

    private void SiPGhwQ(NdConfigDefinition ndConfigDefinition, String string) {
        Integer n = ndConfigDefinition.getInteger(string);
        if (n != null && n <= 0) {
            this.SiPGhwG.add(new NdInvalidPropertyValueIssue(ndConfigDefinition, string, n));
        }
    }

    private void SiPGhwR(NdDeploymentManagerOptions ndDeploymentManagerOptions) {
        File file;
        String string = ndDeploymentManagerOptions.getConfigFileName();
        File file2 = file = string == null ? null : new File(string);
        if (file == null || file.exists() && !file.isFile()) {
            this.SiPGhwG.add(new NdInvalidPropertyValueIssue(ndDeploymentManagerOptions, "configFileName", string));
        }
    }

    private void SiPGhwS(NdDeploymentManagerOptions ndDeploymentManagerOptions) {
        boolean bl = ndDeploymentManagerOptions.getMonitorChanges();
        Integer n = ndDeploymentManagerOptions.getChangeMonitoringHeartbeat();
        if (bl && n != null && n <= 0) {
            this.SiPGhwG.add(new NdInvalidPropertyValueIssue(ndDeploymentManagerOptions, "dm.changeMonitoringHeartbeat", n));
        }
    }

    private void SiPGhwT(NdDeploymentDefinition ndDeploymentDefinition) {
        NdRemoteDebuggingOptions ndRemoteDebuggingOptions = ndDeploymentDefinition.getRemoteDebuggingOptions();
        this.SiPGhBE(ndRemoteDebuggingOptions, "debug.enabled");
        if (ndRemoteDebuggingOptions.getEnabled().booleanValue()) {
            this.SiPGhAD(ndRemoteDebuggingOptions, "debug.connectionName");
            if (ndRemoteDebuggingOptions.getUsingSessionFilter().booleanValue()) {
                NdRuleServiceDefinition ndRuleServiceDefinition = this.SiPGhwJ();
                if (ndRuleServiceDefinition == null) {
                    this.SiPGhwG.add(new NdValidationSkippedIssue((NdConfigDefinition)ndRemoteDebuggingOptions, 2));
                } else {
                    this.SiPGhwV(ndDeploymentDefinition, ndRuleServiceDefinition);
                }
            }
        }
    }

    private void SiPGhwU(NdRemoteDebuggingSystemOptions ndRemoteDebuggingSystemOptions, NdDeploymentDefinition ndDeploymentDefinition) {
        if (ndDeploymentDefinition.getRemoteDebuggingOptions().getEnabled().booleanValue()) {
            this.SiPGhBE(ndRemoteDebuggingSystemOptions, "debug.connectionProtocol");
            this.SiPGhwQ(ndRemoteDebuggingSystemOptions, "debug.connectionPort");
        }
    }

    private void SiPGhwV(NdDeploymentDefinition ndDeploymentDefinition, NdRuleServiceDefinition ndRuleServiceDefinition) {
        this.SiPGhAD(ndDeploymentDefinition.getRemoteDebuggingOptions(), "debug.filterClass");
        this.SiPGhwW(ndDeploymentDefinition, ndRuleServiceDefinition);
    }

    private void SiPGhwW(NdDeploymentDefinition ndDeploymentDefinition, NdRuleServiceDefinition ndRuleServiceDefinition) {
        String string = ndDeploymentDefinition.getRemoteDebuggingOptions().getFilterEntryPointID();
        if (string == null || ndDeploymentDefinition.getServerTypeEnum() != NdDeploymentConstants.ServerType.STATELESS) {
            return;
        }
        try {
            ndRuleServiceDefinition.getEntryPoint(string);
        }
        catch (NdConfigurationException ndConfigurationException) {
            this.SiPGhwG.add(new NdInvalidPropertyValueIssue(ndDeploymentDefinition.getRemoteDebuggingOptions(), "debug.filterEntryPointID", string));
        }
    }

    private void SiPXVJC(NdDeploymentDefinition ndDeploymentDefinition) {
        boolean bl;
        NdDeploymentManagerOptions ndDeploymentManagerOptions = ndDeploymentDefinition.getDeploymentManagerOptions();
        boolean bl2 = ndDeploymentManagerOptions.getEnabled();
        boolean bl3 = ndDeploymentManagerOptions.isRemote();
        Boolean bl4 = ndDeploymentDefinition.getThreaded();
        boolean bl5 = bl = bl4 == null ? false : bl4;
        if (!(bl2 && bl3 && bl)) {
            return;
        }
    }

    private void SiPGhwX(NdDeploymentDefinition ndDeploymentDefinition) {
        NdCodeGenerationOptions ndCodeGenerationOptions = ndDeploymentDefinition.getCodeGenerationOptions();
        this.SiPGhwZ(ndCodeGenerationOptions);
        this.SiPGhxA(ndCodeGenerationOptions);
        this.SiPGhAD(ndCodeGenerationOptions, "serverConfigFileName");
        String string = ndDeploymentDefinition.getClientType();
        if ("JSP".equals(string) && ndCodeGenerationOptions.getSourcePackageName() == null) {
            this.SiPGhwG.add(new NdIncompatibleValuesIssue(ndDeploymentDefinition, "clientType", string, ndCodeGenerationOptions, "sourcePackageName", "null"));
        }
        this.SiPGhwY(ndDeploymentDefinition, ndCodeGenerationOptions);
    }

    private void SiPGhwY(NdDeploymentDefinition ndDeploymentDefinition, NdCodeGenerationOptions ndCodeGenerationOptions) {
        if (ndDeploymentDefinition.getUsingSourceCodeConfig() == Boolean.TRUE) {
            return;
        }
        String string = ndCodeGenerationOptions.getServerConfigURL();
        if (ndDeploymentDefinition.getCodeGenerationOptions().requires("serverConfigURL") && string == null) {
            this.SiPGhwG.add(new NdInvalidPropertyValueIssue(ndCodeGenerationOptions, "serverConfigURL", string));
        }
    }

    private void SiPGhwZ(NdCodeGenerationOptions ndCodeGenerationOptions) {
        String string = ndCodeGenerationOptions.getClassNamePrefix();
        if (string != null && string.length() > 0 && !NdDeploymentUtil.isValidJavaName(string, false)) {
            this.SiPGhwG.add(new NdInvalidPropertyValueIssue(ndCodeGenerationOptions, "classNamePrefix", string));
        }
    }

    private void SiPGhxA(NdCodeGenerationOptions ndCodeGenerationOptions) {
        String string = ndCodeGenerationOptions.getSourcePackageName();
        if (string != null && string.length() > 0 && !NdDeploymentUtil.isValidJavaName(string, true)) {
            this.SiPGhwG.add(new NdInvalidPropertyValueIssue(ndCodeGenerationOptions, "sourcePackageName", string));
        }
    }

    private void SiPGhyB(NdSystemDefinition ndSystemDefinition) {
        File file;
        String string = ((NdDeploymentConfigDefaultsContext)this.SiPGhwH).getTargetDirectory();
        if (string == null) {
            this.SiPGhwG.add(new NdInvalidPropertyValueIssue(ndSystemDefinition, "targetDirectory", string));
        }
        if ((file = new File(string)).exists() && !file.isDirectory()) {
            this.SiPGhwG.add(new NdInvalidPropertyValueIssue(ndSystemDefinition, "targetDirectory", string));
        }
    }

    private void SiPGhzC(NdDeploymentDefinition ndDeploymentDefinition, NdSystemDefinition ndSystemDefinition) {
        if (ndDeploymentDefinition.getDeploymentEnvironmentEnum() != ndSystemDefinition.getDeploymentEnvironmentEnum()) {
            this.SiPGhwG.add(new NdIncompatibleValuesIssue(ndDeploymentDefinition, "deploymentEnvironment", ndDeploymentDefinition.getDeploymentEnvironment(), ndSystemDefinition, "deploymentEnvironment", ndSystemDefinition.getDeploymentEnvironment()));
        }
        if (ndDeploymentDefinition.getServerTypeEnum() != ndSystemDefinition.getServerTypeEnum()) {
            this.SiPGhwG.add(new NdIncompatibleValuesIssue(ndDeploymentDefinition, "serverType", ndDeploymentDefinition.getServerType(), ndSystemDefinition, "serverType", ndSystemDefinition.getServerType()));
        }
    }

    private void SiPGhAD(NdConfigDefinition ndConfigDefinition, String string) {
        String string2 = ndConfigDefinition.get(string);
        if (string2 == null || string2.length() == 0) {
            this.SiPGhwG.add(new NdInvalidPropertyValueIssue(ndConfigDefinition, string, string2));
        }
    }

    private void SiPGhBE(NdConfigDefinition ndConfigDefinition, String string) {
        String string2 = ndConfigDefinition.get(string);
        String[] stringArray = ndConfigDefinition.getValidValues(string);
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return;
        }
        this.SiPGhwG.add(new NdInvalidPropertyValueIssue(ndConfigDefinition, string, string2));
    }

    private void SiPGhCF() throws NdDeploymentValidationException {
        if (this.SiPGhwG.size() > 0) {
            NdDeploymentValidationIssue[] ndDeploymentValidationIssueArray = this.SiPGhwG.toArray(new NdDeploymentValidationIssue[this.SiPGhwG.size()]);
            throw new NdDeploymentValidationException(ndDeploymentValidationIssueArray);
        }
    }
}

