/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.logging;

import com.blazesoft.server.base.NdServer;
import com.blazesoft.server.base.NdService;
import com.blazesoft.server.base.NdServiceQuestion;
import com.blazesoft.server.base.NdServiceQuestionAnswer;
import com.blazesoft.server.base.NdServiceQuestionsEvent;
import com.blazesoft.server.base.NdServiceQuestionsListener;
import com.blazesoft.server.base.NdServiceUnansweredQuestionsEvent;
import com.blazesoft.server.logging.NdServiceSessionLoggingMonitorBase;
import com.blazesoft.server.logging.NdStrings;
import com.blazesoft.server.rules.NdRulesServiceQuestionDescriptor;
import com.blazesoft.util.NdSystemProperties;
import com.blazesoft.util.logging.NdLogLevel;
import java.util.EventObject;

public class NdServiceQuestionsLoggingMonitor
extends NdServiceSessionLoggingMonitorBase
implements NdServiceQuestionsListener {
    private final String SiPZYjE = NdSystemProperties.getLineSeparator();

    public NdServiceQuestionsLoggingMonitor(NdServer ndServer, NdService ndService) {
        super(ndServer, ndService);
    }

    protected NdLogLevel getLogLevel(EventObject eventObject) {
        return NdLogLevel.INFO;
    }

    protected String getLogMessage(EventObject eventObject) {
        StringBuffer stringBuffer = new StringBuffer("[" + this.getLogLevel(eventObject).getName() + "] ").append(this.SiPZYjE);
        if (eventObject instanceof NdServiceQuestionsEvent) {
            stringBuffer.append(this.SiPNxKX((NdServiceQuestionsEvent)eventObject));
        } else if (eventObject instanceof NdServiceUnansweredQuestionsEvent) {
            stringBuffer.append(this.SiPNxLY((NdServiceUnansweredQuestionsEvent)eventObject));
        }
        return stringBuffer.toString();
    }

    private String SiPNxKX(NdServiceQuestionsEvent ndServiceQuestionsEvent) {
        StringBuffer stringBuffer = new StringBuffer("on service questions event:").append(this.SiPZYjE);
        NdServiceQuestion[] ndServiceQuestionArray = ndServiceQuestionsEvent.getQuestions();
        stringBuffer.append(this.SiPNxMZ(ndServiceQuestionArray));
        return stringBuffer.toString();
    }

    private String SiPNxLY(NdServiceUnansweredQuestionsEvent ndServiceUnansweredQuestionsEvent) {
        StringBuffer stringBuffer = new StringBuffer("on service unanswered questions event:").append(this.SiPZYjE);
        NdServiceQuestion[] ndServiceQuestionArray = ndServiceUnansweredQuestionsEvent.getAnsweredQuestions();
        stringBuffer.append(this.SiPNxMZ(ndServiceQuestionArray));
        return stringBuffer.toString();
    }

    private String SiPNxMZ(NdServiceQuestion[] ndServiceQuestionArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < ndServiceQuestionArray.length; ++i) {
            NdRulesServiceQuestionDescriptor ndRulesServiceQuestionDescriptor = (NdRulesServiceQuestionDescriptor)ndServiceQuestionArray[i].getDescriptor();
            String string = ndRulesServiceQuestionDescriptor.getPrompt();
            stringBuffer.append(NdStrings.SiPNwfU("Question", null) + "[").append(i).append("]: ").append(string).append(this.SiPZYjE);
            stringBuffer.append(NdStrings.SiPNwfU("Answer", null) + "[").append(i).append("]: ");
            if (ndServiceQuestionArray[i].getAnswer() != null) {
                String string2 = ndServiceQuestionArray[i].getAnswer() instanceof NdServiceQuestionAnswer ? ((NdServiceQuestionAnswer)ndServiceQuestionArray[i].getAnswer()).getValueString() : ndServiceQuestionArray[i].getAnswer().toString();
                stringBuffer.append(string2);
            }
            stringBuffer.append(this.SiPZYjE);
        }
        return stringBuffer.toString();
    }

    public void onServiceQuestionsEvent(NdServiceQuestionsEvent ndServiceQuestionsEvent) {
        if (this.isEventEnabled(ndServiceQuestionsEvent)) {
            this.logEvent(ndServiceQuestionsEvent);
        }
    }

    public void onServiceUnansweredQuestionsEvent(NdServiceUnansweredQuestionsEvent ndServiceUnansweredQuestionsEvent) {
        this.logEvent(ndServiceUnansweredQuestionsEvent);
    }
}

