/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.management.jmx;

import com.blazesoft.server.management.NdManagementException;
import com.blazesoft.server.management.NdMgmtBeanPublisherServer;
import com.blazesoft.server.management.NdMgmtConnector;
import com.blazesoft.server.management.jmx.NdDefaultJMXPublisherServer;
import com.blazesoft.server.management.jmx.NdJMXMBeanServerPublisherServer;
import com.blazesoft.server.management.jmx.NdStrings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class NdMgmtRMIConnector
implements NdMgmtConnector {
    private static final String SiPVlOL = "localhost";
    private static final String SiPVlPM = "service:jmx:rmi://";
    private static final String SiPVlQN = "/jndi/rmi://localhost:";
    private static final String SiPVlRO = ":";
    private static final String SiPVlSP = "/";
    private NdMgmtBeanPublisherServer SiPUkQZ;
    private JMXConnectorServer SiPUkRA;
    private String SiPUkSB;
    private String SiPUkTC;
    private String SiPUkUD;
    private String SiPUkVE;
    private String SiPUkWF;

    public NdMgmtRMIConnector(NdMgmtBeanPublisherServer ndMgmtBeanPublisherServer) throws NdManagementException {
        this.SiPUkQZ = ndMgmtBeanPublisherServer;
    }

    public JMXServiceURL getJMXServiceURL() throws NdManagementException {
        Object object;
        if (this.SiPUkSB == null) {
            if (this.SiPUkUD == null) {
                this.SiPUkUD = String.valueOf(1099);
            }
            object = "";
            if (this.SiPUkVE != null) {
                object = "localhost:" + this.SiPUkVE;
            }
            if (this.SiPUkTC == null) {
                this.SiPUkTC = SiPVlOL;
            }
            this.SiPUkSB = SiPVlPM + (String)object + SiPVlQN + this.SiPUkUD + SiPVlSP + this.SiPUkWF;
        }
        try {
            object = new JMXServiceURL(this.SiPUkSB);
        }
        catch (MalformedURLException malformedURLException) {
            throw new NdManagementException(malformedURLException);
        }
        return object;
    }

    public void initialize() throws NdManagementException {
        if (!(this.SiPUkQZ instanceof NdJMXMBeanServerPublisherServer)) {
            return;
        }
        MBeanServer mBeanServer = ((NdDefaultJMXPublisherServer)this.SiPUkQZ).getMBeanServer();
        if (mBeanServer == null) {
            return;
        }
        JMXServiceURL jMXServiceURL = this.getJMXServiceURL();
        try {
            String string = jMXServiceURL.getURLPath();
            if (string.indexOf("/rmi://") < 0) {
                throw new NdManagementException(NdStrings.SiPOcfZ("InvalidRMIServiceURL"));
            }
            int n = string.lastIndexOf(58);
            int n2 = string.lastIndexOf(47);
            String string2 = string.substring(n + 1, n2);
            int n3 = Integer.parseInt(string2);
            try {
                Registry registry = LocateRegistry.getRegistry(n3);
                registry.list();
            }
            catch (RemoteException remoteException) {
                Registry registry = LocateRegistry.createRegistry(n3);
                registry.list();
            }
            Properties properties = System.getProperties();
            this.SiPUkRA = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, properties, mBeanServer);
            this.SiPUkRA.start();
        }
        catch (MalformedURLException malformedURLException) {
            throw new NdManagementException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new NdManagementException(iOException);
        }
    }

    public void shutdown() throws NdManagementException {
        if (this.SiPUkRA != null) {
            try {
                this.SiPUkRA.stop();
                this.SiPUkRA = null;
            }
            catch (IOException iOException) {
                throw new NdManagementException(iOException);
            }
        }
    }

    public String getServiceURL() {
        return this.SiPUkSB;
    }

    public void setServiceURL(String string) throws NdManagementException {
        this.SiPUkSB = string;
    }

    public void setRegistryHostName(String string) {
        this.SiPUkTC = string;
    }

    public String getRegistryHostName() {
        return this.SiPUkTC;
    }

    public void setRegistryPort(String string) {
        this.SiPUkUD = string;
    }

    public String getRegistryPort() {
        return this.SiPUkUD;
    }

    public void setConnectionName(String string) {
        this.SiPUkWF = string;
    }

    public String getConnectionName() {
        return this.SiPUkWF;
    }

    public void setCommunicationPort(String string) {
        this.SiPUkVE = string;
    }

    public String getCommunicationPort() {
        return this.SiPUkVE;
    }
}

