/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.qdeployer;

import com.blazesoft.engines.rules.NdResource;
import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.server.base.NdServerException;
import com.blazesoft.server.config.NdServiceAgentValueMapperFactory;
import com.blazesoft.server.config.NdServiceClientContextFactory;
import com.blazesoft.server.config.NdServiceEntryPointConfig;
import com.blazesoft.server.deploy.rules.NdDeployRulesServerConfig;
import com.blazesoft.server.deploy.rules.NdDeployRulesServiceConfig;
import com.blazesoft.server.deploy.rules.NdDeployRulesServiceEntryPointConfig;
import com.blazesoft.server.qdeployer.NdQDeployerDetails;
import com.blazesoft.server.qdeployer.NdQDeployerFileInfo;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerDeploymentGenerator;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerJavaExtractor;
import com.blazesoft.server.qdeployer.filegen.NdQDeployerJavaFileGeneratorImpl;
import com.blazesoft.server.qdeployer.subconfig.NdJavaQDeployerSubConfig;
import com.blazesoft.template.repository.NdRomException;
import com.blazesoft.util.NdWrappedRuntimeException;
import java.util.ArrayList;
import java.util.Vector;

public class NdQDeployerJavaDetails
extends NdQDeployerDetails {
    public NdQDeployerJavaDetails() throws NdRomException {
        this.setDeploymentGenerator(new NdQDeployerDeploymentGenerator(new NdQDeployerJavaFileGeneratorImpl()));
    }

    protected void setServiceDefaultsForDepEnv() {
        if (NdDotNETLib.isDotNETSupportEnabled()) {
            this.getService().setServiceAgentValueMapperFactory(new NdServiceAgentValueMapperFactory("com.blazesoft.engines.rules.dotnet.NdRulesDotNETValueMapper"));
        }
    }

    public String getDeploymentEnvironmentDirectory() {
        String string = this.getSubConfig().getTargetLanguage();
        String string2 = "java";
        if (string != null) {
            if (string.equals("J#")) {
                string2 = "J#";
            } else if (string.equals("C#")) {
                string2 = "C#";
            } else if (string.equals("Visual Basic")) {
                string2 = "VB";
            }
        }
        return string2;
    }

    public void createExtractor() throws NdRomException {
        if (this.getProject() != null) {
            this.setExtractor(new NdQDeployerJavaExtractor(this.getProject(), this.getSchemaSupport(), this.getSubConfig().getTargetLanguage()));
        }
    }

    public void createSubConfig() {
        this.setSubConfig(new NdJavaQDeployerSubConfig());
    }

    public void addDeploymentCode() throws NdServerException {
        String string = this.getDeploymentCode().getPrefix();
        String string2 = this.getDeploymentCode().getPackage();
        String string3 = string + "Server";
        if (NdDotNETLib.isDotNETSupportEnabled()) {
            this.getAssemblyManager().loadImportedAssemblyTables((NdResource[])this.getProject().getBomSupport().getClassProviderResources());
        }
        String[] stringArray = this.getDeploymentGenerator().getFileGenerator().getTemplates(this);
        this.addDepCodeTemplatesToList(stringArray);
        this.setDisplaySuppressionTemplatesInList();
        if (!this.getServerConfig().getServerFactory().getJavaName().equals("com.blazesoft.server.deploy.NdSynchronousStatefulServer")) {
            if (string2 != null && string2.length() > 0) {
                string3 = string2 + "." + string3;
            }
            this.getServerConfig().getServerFactory().setJavaName(string3);
        }
        try {
            this.SiPOgBI();
        }
        catch (NdRomException ndRomException) {
            throw new NdWrappedRuntimeException((Throwable)ndRomException);
        }
    }

    private void SiPOgBI() throws NdRomException, NdServerException {
        this.getDeploymentFiles().remove(this.getInvokerMapperEntryPointResultTemplate());
        NdDeployRulesServerConfig ndDeployRulesServerConfig = this.getServerConfig();
        NdDeployRulesServiceConfig[] ndDeployRulesServiceConfigArray = ndDeployRulesServerConfig.getDeployRulesServiceConfig();
        if (ndDeployRulesServiceConfigArray == null || ndDeployRulesServiceConfigArray.length == 0) {
            return;
        }
        NdServiceClientContextFactory ndServiceClientContextFactory = ndDeployRulesServiceConfigArray[0].getServiceClientContextFactory();
        if (!ndServiceClientContextFactory.getJavaName().equals("com.blazesoft.server.deploy.rules.NdDeployInvokerMapperRulesServiceClientContext")) {
            return;
        }
        NdServiceEntryPointConfig[] ndServiceEntryPointConfigArray = ndServiceClientContextFactory.getServiceEntryPointConfig();
        if (ndServiceEntryPointConfigArray == null || ndServiceEntryPointConfigArray.length == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(8);
        for (int i = 0; i < ndServiceEntryPointConfigArray.length; ++i) {
            String string;
            NdDeployRulesServiceEntryPointConfig ndDeployRulesServiceEntryPointConfig = (NdDeployRulesServiceEntryPointConfig)ndServiceEntryPointConfigArray[i];
            String string2 = null;
            String string3 = null;
            this.registerEntryPointResultInfo((NdDeployRulesServiceEntryPointConfig)ndServiceEntryPointConfigArray[i], string2, string3);
            NdQDeployerJavaExtractor ndQDeployerJavaExtractor = (NdQDeployerJavaExtractor)this.getExtractor();
            boolean bl = ndQDeployerJavaExtractor.hasMappingArguments(this.getService(), ndDeployRulesServiceEntryPointConfig);
            if (!bl || "void".equalsIgnoreCase(string = ndQDeployerJavaExtractor.extractFunctionalBoxedReturnType(this.getService(), ndDeployRulesServiceEntryPointConfig, true))) continue;
            string2 = this._createFileNameFromTemplateName(this.getInvokerMapperEntryPointResultTemplate());
            string2 = this.SiPOgBK(string2, ndServiceEntryPointConfigArray[i].getEntryPointId());
            arrayList.add(string2);
            string3 = this.SiPOgBJ(string2);
            this.registerEntryPointResultInfo((NdDeployRulesServiceEntryPointConfig)ndServiceEntryPointConfigArray[i], string2, string3);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        this.addDepCodeTemplateToList(this.getInvokerMapperEntryPointResultTemplate(), new NdQDeployerFileInfo(stringArray));
    }

    private String SiPOgBJ(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    private String SiPOgBK(String string, String string2) {
        string = this._replaceSubstring(string, "EntryPoint", this.makeFileNameValid(string2));
        return string;
    }

    public boolean hasRequiredTemplates(Vector vector) {
        boolean bl = super.hasRequiredTemplates(vector);
        if (bl) {
            String string = this.getDeploymentEnvironmentDirectory();
            bl = string.equals("J#") ? vector.contains("PrefixServer.jsl") && vector.contains("PrefixClient.jsl") : (string.equals("C#") ? vector.contains("PrefixServer.cs") && vector.contains("PrefixClient.cs") : (string.equals("VB") ? vector.contains("PrefixServer.vb") && vector.contains("PrefixClient.vb") : vector.contains("PrefixServer.java") && vector.contains("PrefixClient.java")));
        }
        return bl;
    }
}

