/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.rules;

import com.blazesoft.engines.rules.NdDefProjectResource;
import com.blazesoft.engines.rules.NdFileResource;
import com.blazesoft.engines.rules.NdProjectAttributes;
import com.blazesoft.engines.rules.NdProjectResource;
import com.blazesoft.objects.java.NdCalendar;
import com.blazesoft.server.rules.NdServerRulesSerializationVersionInfo;
import com.blazesoft.server.rules.NdStrings;
import com.blazesoft.util.NdSystemProperties;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class NdServerRulesSerializationHeader
implements Serializable {
    private String SiPpddR;
    private Locale SiPpdeS;
    private String SiPpdfT;
    private InetAddress SiPpdgU;
    private Locale SiPpdhV;
    private Date SiPpdiW;
    private Date SiPNwPZ;
    private TimeZone SiPpdjX;
    private int SiPpdkY;
    private int SiPpdlZ;
    private boolean SiPtwqN;
    private int SiPtSlI = 0;
    private int SiPtSlJ = 0;
    private int SiPtSlK = 0;
    private int SiPtSlL = 0;
    private int SiPtSlM = 0;
    private int SiPtSlN = 0;
    private int SiPtSlO = 0;
    public static final String PROJECT_LAST_MODIFIED_DATE_TIME = "___PROJECT_LAST_MODIFIED_DATE_TIME___";

    NdServerRulesSerializationHeader(String string, Locale locale, InetAddress inetAddress, Locale locale2, Date date, Date date2, TimeZone timeZone, int n, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.SiPpddR = string;
        this.SiPpdeS = locale;
        this.SiPpdgU = inetAddress;
        this.SiPpdhV = locale2;
        this.SiPpdiW = date;
        this.SiPNwPZ = date2;
        this.SiPpdjX = timeZone;
        this.SiPpdkY = n;
        this.SiPpdlZ = n2;
        this.SiPtwqN = bl;
        this.SiPtSlI = n3;
        this.SiPtSlJ = n4;
        this.SiPtSlK = n5;
        this.SiPtSlL = n6;
        this.SiPtSlM = n7;
        this.SiPtSlN = n8;
        this.SiPtSlO = n9;
        if (NdSystemProperties.isSupportLibDebugModeEnabled()) {
            System.out.println("sup lib out =  " + this.SiPtSlI + this.SiPtSlJ + this.SiPtSlK + this.SiPtSlL + this.SiPtSlM + this.SiPtSlN + this.SiPtSlO);
        }
    }

    static NdServerRulesSerializationHeader SiPtwrO(NdProjectResource ndProjectResource, NdServerRulesSerializationVersionInfo ndServerRulesSerializationVersionInfo, boolean bl) {
        InetAddress inetAddress;
        String string;
        Serializable serializable;
        String string2 = ndProjectResource.getLocation();
        if (ndProjectResource instanceof NdFileResource) {
            serializable = new File(string2);
            try {
                string = ((File)serializable).getCanonicalPath();
            }
            catch (IOException iOException) {
                string = string2;
            }
        } else {
            string = string2;
        }
        serializable = NdDefProjectResource.getLocale((NdProjectAttributes)ndProjectResource);
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = null;
        }
        Locale locale = Locale.getDefault();
        TimeZone timeZone = NdCalendar.safeTimeZoneGetDefault();
        Date date = new Date();
        Date date2 = (Date)ndProjectResource.getTransientProperty((Object)PROJECT_LAST_MODIFIED_DATE_TIME);
        return new NdServerRulesSerializationHeader(string, (Locale)serializable, inetAddress, locale, date, date2, timeZone, ndServerRulesSerializationVersionInfo.getMajorVersion(), ndServerRulesSerializationVersionInfo.getMinorVersion(), bl, ndProjectResource.getSupportLibraryRequest(0), ndProjectResource.getSupportLibraryRequest(1), ndProjectResource.getSupportLibraryRequest(2), ndProjectResource.getSupportLibraryRequest(3), ndProjectResource.getSupportLibraryRequest(4), ndProjectResource.getSupportLibraryRequest(5), ndProjectResource.getSupportLibraryRequest(6));
    }

    public String getProjectLocation() {
        return this.SiPpddR;
    }

    public Locale getProjectLocale() {
        return this.SiPpdeS;
    }

    public InetAddress getSerializationHostIP() {
        return this.SiPpdgU;
    }

    public Locale getSerializationLocale() {
        return this.SiPpdhV;
    }

    public Date getSerializationDateTime() {
        return this.SiPpdiW;
    }

    public Date getProjectLastModifiedDateTime() {
        return this.SiPNwPZ;
    }

    public TimeZone getSerializationTimeZone() {
        return this.SiPpdjX;
    }

    public int getSerializationFormatMajorVersion() {
        return this.SiPpdkY;
    }

    public int getSerializationFormatMinorVersion() {
        return this.SiPpdlZ;
    }

    public boolean isRemoteDebuggingEnabled() {
        return this.SiPtwqN;
    }

    public int getComEnabledRequest() {
        return this.SiPtSlI;
    }

    public int getCorbaEnabledRequest() {
        return this.SiPtSlJ;
    }

    public int getOrbixEnabledRequest() {
        return this.SiPtSlK;
    }

    public int getOrbix2EnabledRequest() {
        return this.SiPtSlL;
    }

    public int getEJBEnabledRequest() {
        return this.SiPtSlM;
    }

    public int getJava2EnabledRequest() {
        return this.SiPtSlN;
    }

    public int getXmlEnabledRequest() {
        return this.SiPtSlO;
    }

    public String getDescription() {
        Locale locale = Locale.getDefault();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0, locale);
        dateFormat.setTimeZone(this.SiPpdjX);
        String string = dateFormat.format(this.SiPpdiW);
        String string2 = NdStrings.SiPpkUQ("ServerRulesSerialiationHeaderDescription", new Object[]{this.SiPpddR, this.SiPpdeS.getDisplayName(locale), string, this.SiPpdhV.getDisplayName(locale), this.SiPpdgU == null ? "null" : this.SiPpdgU.getHostName(), this.SiPpdgU == null ? "null" : this.SiPpdgU.getHostAddress(), Integer.toString(this.SiPpdkY), Integer.toString(this.SiPpdlZ), String.valueOf(this.SiPtwqN), Integer.toString(this.SiPtSlI), Integer.toString(this.SiPtSlJ), Integer.toString(this.SiPtSlK), Integer.toString(this.SiPtSlL), Integer.toString(this.SiPtSlM), Integer.toString(this.SiPtSlN), Integer.toString(this.SiPtSlO)});
        return string2;
    }

    public String toString() {
        return this.getDescription();
    }
}

