/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.server.util.servlets.http;

import com.blazesoft.server.util.servlets.http.NdStrings;
import com.blazesoft.util.NdWrappedRuntimeException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class NdHttpServer {
    protected void configure(String[] stringArray) {
        String string = NdHttpServer.getArg(stringArray, "-serverProps");
        String string2 = this.getPort(stringArray);
        String string3 = this.getInet(stringArray);
        String string4 = NdHttpServer.getArg(stringArray, "-docbase");
        if (string4 == null) {
            string4 = "webpages";
        }
        ServletProperty[] servletPropertyArray = this.processPropertyArguments(stringArray);
        this.configureServer(string, string2, string3, string4, servletPropertyArray);
    }

    protected ServletProperty[] processPropertyArguments(String[] stringArray) {
        Vector<ServletProperty> vector = new Vector<ServletProperty>();
        int n = stringArray.length;
        for (int i = 0; i < n - 1; ++i) {
            if (!stringArray[i].equals("-setProp")) continue;
            vector.addElement(this.processPropertyArg(stringArray[i + 1]));
            ++i;
        }
        int n2 = vector.size();
        Object[] objectArray = new ServletProperty[n2];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected ServletProperty processPropertyArg(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = null;
        String string3 = null;
        if (stringTokenizer.hasMoreTokens()) {
            if (string2 == null) {
                string2 = stringTokenizer.nextToken();
            }
            string3 = stringTokenizer.nextToken();
        }
        if (string2 != null) {
            if (string3 == null) {
                string3 = "";
            }
        } else {
            throw new IllegalArgumentException(NdStrings.SiPpaeM("IllegalPropertyArgument", string));
        }
        ServletProperty servletProperty = new ServletProperty(string2, string3);
        return servletProperty;
    }

    protected String getPort(String[] stringArray) {
        String string = NdHttpServer.getArg(stringArray, "-port");
        if (string == null) {
            string = "8080";
        }
        return string;
    }

    protected String getInet(String[] stringArray) {
        String string = NdHttpServer.getArg(stringArray, "-inet");
        if (string == null) {
            string = "localhost";
        }
        return string;
    }

    protected void showUsage() {
        System.out.println(NdStrings.SiPpaeM("HttpServerUsage", NdStrings.SiPpaeK("HttpServerArgs")));
    }

    protected boolean checkIsRunning(String[] stringArray) {
        boolean bl = false;
        String string = this.getInet(stringArray);
        String string2 = this.getPort(stringArray);
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            int n = Integer.parseInt(string2);
            ServerSocket serverSocket = new ServerSocket(n, 1, inetAddress);
            serverSocket.close();
        }
        catch (BindException bindException) {
            bl = true;
        }
        catch (IOException iOException) {
            throw new NdWrappedRuntimeException((Throwable)iOException);
        }
        return bl;
    }

    protected abstract void configureServer(String var1, String var2, String var3, String var4, ServletProperty[] var5);

    protected abstract void startServer();

    protected abstract void shutdownServer();

    private void SiPpvaR(String[] stringArray) {
        try {
            this.configure(stringArray);
        }
        catch (RuntimeException runtimeException) {
            this.showUsage();
            throw new NdWrappedRuntimeException(NdStrings.SiPpaeK("HttpServerConfigException"), (Throwable)runtimeException);
        }
    }

    public void start(String[] stringArray) {
        if (NdHttpServer.hasArg(stringArray, "-help")) {
            this.showUsage();
            return;
        }
        if (NdHttpServer.hasArg(stringArray, "-silentAfterStart")) {
            System.setOut(new SiPoUWD(System.out));
            System.setErr(new SiPpeUL(System.err));
        }
        boolean bl = NdHttpServer.hasArg(stringArray, "-shutdown");
        boolean bl2 = false;
        boolean bl3 = true;
        if (NdHttpServer.hasArg(stringArray, "-noCheckIsRunning")) {
            bl3 = false;
        }
        if (bl3) {
            bl2 = this.checkIsRunning(stringArray);
        }
        if (bl) {
            if (!bl3) {
                bl2 = true;
            }
            if (bl2) {
                this.SiPpvaR(stringArray);
                try {
                    this.shutdownServer();
                }
                catch (RuntimeException runtimeException) {
                    throw new NdWrappedRuntimeException(NdStrings.SiPpaeK("HttpServerException"), (Throwable)runtimeException);
                }
            }
        } else if (!bl2) {
            this.SiPpvaR(stringArray);
            try {
                this.startServer();
            }
            catch (RuntimeException runtimeException) {
                throw new NdWrappedRuntimeException(NdStrings.SiPpaeK("HttpServerException"), (Throwable)runtimeException);
            }
        }
    }

    public void shutdown() {
        this.shutdownServer();
    }

    public static boolean hasArg(String[] stringArray, String string) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            bl = true;
        }
        return bl;
    }

    public static String getArg(String[] stringArray, String string) {
        String string2 = null;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!stringArray[i].equals(string)) continue;
            string2 = stringArray[i + 1];
        }
        return string2;
    }

    private static class SiPpeUL
    extends PrintStream {
        private boolean SiPpeUK;

        public SiPpeUL(PrintStream printStream) {
            super(printStream);
        }

        public void write(byte[] byArray, int n, int n2) {
            if (!this.SiPpeUK) {
                ((PrintStream)this.out).write(byArray, n, n2);
                this.SiPpeUK = true;
            }
        }
    }

    private static class SiPoUWD
    extends PrintStream {
        public SiPoUWD(PrintStream printStream) {
            super(printStream);
        }

        public void write(byte[] byArray, int n, int n2) {
        }
    }

    public static class ServletProperty {
        public String name;
        public String value;

        public ServletProperty(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

