/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.psextensions.customprovider;

import com.blazesoft.template.engine.NdProviderContext;
import com.blazesoft.template.engine.NdTemplateException;
import cz.nextiraone.blazesoft.psextensions.customprovider.NdHttpProvider;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class IdCodeNdJdbcProvider
extends NdHttpProvider {
    private static Category log = Logger.getLogger(IdCodeNdJdbcProvider.class);
    private static Properties dbProps = new Properties();
    private static String dbPassword;
    private static String dbUser;
    private static String dbUrl;
    private static final String IDCODE_SEPERATOR;
    private String[] originalValues = null;
    private String[] ids;
    private Map<String, String> mappedValues = null;

    public IdCodeNdJdbcProvider() {
        log.debug((Object)"init");
    }

    public String convertFromDisplayValue(NdProviderContext arg0, Object arg1) throws NdTemplateException {
        String str = super.convertFromDisplayValue(arg0, arg1);
        str = this.findDisplayValue(arg1);
        return str;
    }

    public String findDisplayValue(Object displayValue) {
        String retStr = this.getIdSplit(IDCODE_SEPERATOR, displayValue.toString());
        if (retStr == null) {
            retStr = displayValue.toString();
        }
        return retStr;
    }

    public Object convertToDisplayValue(NdProviderContext arg0, String id) throws NdTemplateException {
        Object obj = super.convertToDisplayValue(arg0, id);
        if (this.originalValues == null) {
            this.getAllowedInstantiationValues(arg0);
        }
        obj = this.findInstanceValue(id);
        return obj;
    }

    public Object findInstanceValue(String instanceValue) {
        String retObj = new String(instanceValue == null ? "__NULL__" : instanceValue);
        if (this.originalValues != null && this.originalValues.length > 0 && this.mappedValues.containsKey(instanceValue)) {
            return this.mappedValues.get(instanceValue);
        }
        return retObj;
    }

    @Override
    protected void processArgument(String argName, String argVal, NdProviderContext providerContext) {
        if (argName.equals("url")) {
            argVal = this.setValueOrDefault(dbUrl, argVal);
        }
        if (argName.equals("password")) {
            argVal = this.setValueOrDefault(dbPassword, argVal);
        }
        if (argName.equals("user")) {
            argVal = this.setValueOrDefault(dbUser, argVal);
        }
        super.processArgument(argName, argVal, providerContext);
    }

    @Override
    public String[] getAllowedInstantiationValues(NdProviderContext arg0) throws NdTemplateException {
        String[] strArr = super.getAllowedInstantiationValues(arg0);
        strArr = this.convertInstanceValues(strArr);
        return strArr;
    }

    public String[] convertInstanceValues(String[] strArr) {
        if (this.ids != null) {
            return this.ids;
        }
        if (strArr != null && strArr.length > 0) {
            log.info((Object)String.format("init mappedValues for: %s", this.getSelectionQuery()));
            this.mappedValues = new HashMap<String, String>();
            this.originalValues = new String[strArr.length];
            this.ids = new String[strArr.length];
            for (int idx = 0; idx < strArr.length; ++idx) {
                String id;
                String original;
                this.originalValues[idx] = original = strArr[idx];
                int splitPos = original.indexOf("::", 0);
                if (splitPos <= -1) continue;
                this.ids[idx] = id = original.substring(0, splitPos);
                this.mappedValues.put(id, original);
            }
        } else {
            this.originalValues = null;
        }
        return this.ids;
    }

    public String getIdSplit(String sep, String original) {
        String copy = null;
        int splitPos = original.indexOf(sep, 0);
        if (splitPos > -1) {
            copy = original.substring(0, splitPos);
        }
        return copy;
    }

    public String getCodeSplit(String sep, String original) {
        String copy = null;
        int strLen = original.length();
        int splitPos = original.indexOf(sep, 0);
        if (splitPos > -1 && strLen > splitPos + 3) {
            copy = original.substring(splitPos + 2, strLen);
        }
        return copy;
    }

    private String setValueOrDefault(String value, String defValue) {
        return value != null ? value : defValue;
    }

    static {
        try {
            dbProps.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("advdb.properties"));
            dbUrl = dbProps.getProperty("cz.nextiraone.tmobile.wintell.https.provider.url");
            dbUser = dbProps.getProperty("cz.nextiraone.tmobile.wintell.https.provider.user");
            dbPassword = dbProps.getProperty("cz.nextiraone.tmobile.wintell.https.provider.password");
            log.info((Object)("reading advdb.properties: dbUrl=" + dbUrl + ",dbUser=" + dbUser));
        }
        catch (Exception exception) {
            StringWriter strWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(strWriter);
            exception.printStackTrace(printWriter);
            String stackTrace = strWriter.getBuffer().toString();
            printWriter.close();
            try {
                strWriter.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            log.error((Object)("cannot read advdb.properties: " + exception.getMessage()));
            log.error((Object)("\t" + stackTrace));
        }
        IDCODE_SEPERATOR = new String("::");
    }
}

