/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.psextensions.customprovider;

import com.blazesoft.repository.naming.NdRepositoryItemReference;
import com.blazesoft.template.engine.NdMissingArgumentException;
import com.blazesoft.template.engine.NdMissingDynamicArgumentException;
import com.blazesoft.template.engine.NdProviderArgDescriptor;
import com.blazesoft.template.engine.NdProviderContext;
import com.blazesoft.template.engine.NdProviderStaticArg;
import com.blazesoft.template.engine.NdTemplateException;
import com.blazesoft.template.engine.provider.NdDesignProviderArg;
import com.blazesoft.template.engine.provider.NdJdbcProvider;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class LoggedNdJdbcProvider
extends NdJdbcProvider {
    private static final String IDCODE_SEPERATOR = new String("::");
    private static Category log = Logger.getLogger(LoggedNdJdbcProvider.class);
    private String[] originalValues = null;

    public LoggedNdJdbcProvider() {
        log.debug((Object)"LoggedNdJdbcProvider()");
    }

    public String convertFromDisplayValue(NdProviderContext arg0, Object arg1) throws NdTemplateException {
        String str = super.convertFromDisplayValue(arg0, arg1);
        log.debug((Object)("convertFromDisplayValue:" + arg1.toString() + ":" + str));
        str = this.findDisplayValue(arg1);
        return str;
    }

    public String findDisplayValue(Object displayValue) {
        String retStr = this.getIdSplit(IDCODE_SEPERATOR, displayValue.toString());
        if (retStr == null) {
            retStr = displayValue.toString();
        }
        log.debug((Object)("findDisplayValue:" + displayValue + ":" + retStr));
        return retStr;
    }

    public String convertFromJavaObject(NdProviderContext arg0, Object arg1) throws NdTemplateException {
        String str = super.convertFromJavaObject(arg0, arg1);
        log.debug((Object)("convertFromJavaObject:" + arg1.toString() + ":" + str));
        return str;
    }

    public String convertToContentValue(NdProviderContext arg0, String arg1) throws NdTemplateException {
        String str = super.convertToContentValue(arg0, arg1);
        log.debug((Object)("convertToContentValue:" + arg1 + ":" + str));
        return str;
    }

    public Object convertToDisplayValue(NdProviderContext arg0, String arg1) throws NdTemplateException {
        Object obj = super.convertToDisplayValue(arg0, arg1);
        log.debug((Object)("convertToDisplayValue:" + arg1 + ":" + obj));
        if (this.originalValues == null) {
            this.getAllowedInstantiationValues(arg0);
        }
        log.debug((Object)"original values:");
        if (this.originalValues == null) {
            log.debug((Object)"original values = null");
        } else if (this.originalValues.length == 0) {
            log.debug((Object)"original values contains no entries");
        } else {
            int idx = 0;
            while (idx < this.originalValues.length) {
                log.debug((Object)("    Original Value:" + this.originalValues[idx]));
                ++idx;
            }
        }
        obj = this.findInstanceValue(arg1);
        return obj;
    }

    public Object findInstanceValue(String instanceValue) {
        String retObj = new String(instanceValue);
        if (this.originalValues != null && this.originalValues.length > 0) {
            int idx = 0;
            while (idx < this.originalValues.length) {
                String id = this.getIdSplit(IDCODE_SEPERATOR, this.originalValues[idx]);
                if (id != null && id.equals(instanceValue)) {
                    retObj = this.originalValues[idx];
                    break;
                }
                ++idx;
            }
        }
        log.debug((Object)("findInstanceValue:" + instanceValue + ":" + retObj));
        return retObj;
    }

    public Object convertToJavaObject(NdProviderContext arg0, String arg1) throws NdTemplateException {
        Object obj = super.convertToJavaObject(arg0, arg1);
        log.debug((Object)("convertToJavaObject:" + arg1 + ":" + obj));
        return obj;
    }

    public Object[] getAllowedDisplayValues(NdProviderContext arg0) throws NdTemplateException {
        Object[] objArr = super.getAllowedDisplayValues(arg0);
        log.debug((Object)"getAllowedDisplayValues:");
        if (objArr != null && objArr.length > 0) {
            int idx = 0;
            while (idx < objArr.length) {
                log.debug((Object)("    Allowed Display Value:" + objArr[idx]));
                ++idx;
            }
        }
        return objArr;
    }

    public String[] getAllowedInstantiationValues(NdProviderContext arg0) throws NdTemplateException {
        String[] strArr = super.getAllowedInstantiationValues(arg0);
        log.debug((Object)"getAllowedInstantiationValues:");
        if (strArr != null && strArr.length > 0) {
            int idx = 0;
            while (idx < strArr.length) {
                log.debug((Object)("    Allowed Instatiation Value:" + strArr[idx]));
                ++idx;
            }
        }
        strArr = this.convertInstanceValues(strArr);
        return strArr;
    }

    public String[] convertInstanceValues(String[] strArr) {
        int idx;
        if (strArr != null && strArr.length > 0) {
            this.originalValues = new String[strArr.length];
            idx = 0;
            while (idx < strArr.length) {
                String original;
                this.originalValues[idx] = original = strArr[idx];
                int splitPos = original.indexOf("::", 0);
                if (splitPos > -1) {
                    strArr[idx] = original.substring(0, splitPos);
                }
                ++idx;
            }
        } else {
            this.originalValues = null;
        }
        log.debug((Object)"convertInstanceValues:");
        if (strArr != null && strArr.length > 0) {
            idx = 0;
            while (idx < strArr.length) {
                log.debug((Object)("    Converted Instatiation Value:" + strArr[idx]));
                ++idx;
            }
        }
        return strArr;
    }

    public String getIdSplit(String sep, String original) {
        String copy = null;
        int splitPos = original.indexOf(sep, 0);
        if (splitPos > -1) {
            copy = original.substring(0, splitPos);
        }
        return copy;
    }

    public String getCodeSplit(String sep, String original) {
        String copy = null;
        int strLen = original.length();
        int splitPos = original.indexOf(sep, 0);
        if (splitPos > -1 && strLen > splitPos + 3) {
            copy = original.substring(splitPos + 2, strLen);
        }
        return copy;
    }

    public Object[] getAllowedJavaValues(NdProviderContext arg0) throws NdTemplateException {
        Object[] objArr = super.getAllowedJavaValues(arg0);
        log.debug((Object)"getAllowedJavaValues:");
        if (objArr != null && objArr.length > 0) {
            int idx = 0;
            while (idx < objArr.length) {
                log.debug((Object)("    Allowed Java Value:" + objArr[idx]));
                ++idx;
            }
        }
        return objArr;
    }

    public NdDesignProviderArg[] getArgumentDescriptors(NdProviderContext arg0) throws NdTemplateException {
        NdDesignProviderArg[] argArr = super.getArgumentDescriptors(arg0);
        log.debug((Object)"getArgumentDescriptors:");
        if (argArr != null && argArr.length > 0) {
            int idx = 0;
            while (idx < argArr.length) {
                log.debug((Object)("    Argument Descriptor:" + argArr[idx].getName() + ":" + argArr[idx].getDisplayKey() + ":" + argArr[idx].getDisplayName() + ":" + argArr[idx].getDescription()));
                ++idx;
            }
        }
        return argArr;
    }

    public String getDescription(NdProviderContext arg0) throws NdTemplateException {
        String str = super.getDescription(arg0);
        log.debug((Object)("getDescription:" + str));
        return str;
    }

    public NdProviderArgDescriptor getDescriptor(String arg0) throws NdTemplateException {
        NdProviderArgDescriptor arg = super.getDescriptor(arg0);
        log.debug((Object)("getDescriptor:" + arg));
        return arg;
    }

    public String getDisplayKey(NdProviderContext arg0) throws NdTemplateException {
        String str = super.getDisplayKey(arg0);
        log.debug((Object)("getDisplayKey:" + str));
        return str;
    }

    public String getDisplayName(NdProviderContext arg0) throws NdTemplateException {
        String str = super.getDisplayName(arg0);
        log.debug((Object)("getDisplayName:" + str));
        return str;
    }

    public String getProviderType(NdProviderContext arg0) {
        String str = super.getProviderType(arg0);
        log.debug((Object)("getProviderType:" + str));
        return str;
    }

    public NdRepositoryItemReference getTemplateRefOfInstance(NdProviderContext arg0) throws NdTemplateException {
        NdRepositoryItemReference ref = super.getTemplateRefOfInstance(arg0);
        log.debug((Object)("getTemplateRefOfInstance:" + ref.toString()));
        return ref;
    }

    public int getValueType(NdProviderContext arg0) throws NdTemplateException {
        int retInt = super.getValueType(arg0);
        log.debug((Object)("getValueType:" + retInt));
        return retInt;
    }

    public void reset(NdProviderContext arg0) throws NdTemplateException {
        super.reset(arg0);
        log.debug((Object)"reset:");
    }

    public void setArgs(NdProviderContext arg0, NdProviderStaticArg[] arg1) throws NdTemplateException {
        super.setArgs(arg0, arg1);
        log.debug((Object)"setArgs:");
        if (arg1 != null && arg1.length > 0) {
            int idx = 0;
            while (idx < arg1.length) {
                log.debug((Object)("    Argument:" + arg1[idx].getName() + ":" + arg1[idx].getValue() + ":" + arg1[idx].getFullName() + ":" + arg1[idx].getTarget()));
                ++idx;
            }
        }
    }

    public boolean validateInstantiationValue(NdProviderContext arg0, String arg1) throws NdTemplateException {
        boolean bool = super.validateInstantiationValue(arg0, arg1);
        log.debug((Object)("validateInstantiationValue:" + arg1 + ":" + bool));
        return bool;
    }

    protected boolean areValuesCached() {
        boolean bool = super.areValuesCached();
        log.debug((Object)("areValuesCached:" + bool));
        return bool;
    }

    protected void closeConnection(NdProviderContext arg0) throws NdTemplateException, SQLException {
        super.closeConnection(arg0);
        log.debug((Object)"closeConnection:");
    }

    protected void finishArgumentProcessing() {
        super.finishArgumentProcessing();
        log.debug((Object)"finishArgumentProcessing:");
    }

    protected String[] getCachedValues(NdProviderContext arg0) {
        String[] strArr = super.getCachedValues(arg0);
        log.debug((Object)"getCachedValues:");
        if (strArr != null && strArr.length > 0) {
            int idx = 0;
            while (idx < strArr.length) {
                log.debug((Object)("    Cached Value:" + strArr[idx]));
                ++idx;
            }
        }
        return strArr;
    }

    protected String getDriver() {
        String str = super.getDriver();
        log.debug((Object)("getDriver:" + str));
        return str;
    }

    protected String getPassword() {
        String str = super.getPassword();
        log.debug((Object)("getPassword:" + str));
        return str;
    }

    protected String[] getSelectionParameters() {
        String[] strArr = super.getSelectionParameters();
        log.debug((Object)"getSelectionParameters:");
        if (strArr != null && strArr.length > 0) {
            int idx = 0;
            while (idx < strArr.length) {
                log.debug((Object)("    Selection Parameter:" + strArr[idx]));
                ++idx;
            }
        }
        return strArr;
    }

    protected String getSelectionQuery() {
        String str = super.getSelectionQuery();
        log.debug((Object)("getSelectionQuery:" + str));
        return str;
    }

    protected String getUrl() {
        String str = super.getUrl();
        log.debug((Object)("getUrl:" + str));
        return str;
    }

    protected String getUser() {
        String str = super.getUser();
        log.debug((Object)("getUser:" + str));
        return str;
    }

    protected Connection openConnection(NdProviderContext arg0) throws NdTemplateException, SQLException {
        Connection conn = super.openConnection(arg0);
        log.debug((Object)("openConnection:" + conn.isClosed()));
        return conn;
    }

    protected void processArgument(String arg0, String arg1) {
        super.processArgument(arg0, arg1);
        log.debug((Object)("processArgument:" + arg0 + ":" + arg1));
    }

    protected void storeCachedValue(NdProviderContext arg0, String arg1) {
        super.storeCachedValue(arg0, arg1);
        log.debug((Object)("storeCachedValue:" + arg1));
    }

    protected void storeCachedValues(NdProviderContext arg0, String[] arg1) {
        super.storeCachedValues(arg0, arg1);
        log.debug((Object)"storeCachedValues:");
        if (arg1 != null && arg1.length > 0) {
            int idx = 0;
            while (idx < arg1.length) {
                log.debug((Object)("    Cached Value:" + arg1[idx]));
                ++idx;
            }
        }
    }

    protected void checkInstantiationValue(NdProviderContext arg0, String arg1) throws NdTemplateException {
        super.checkInstantiationValue(arg0, arg1);
        log.debug((Object)("checkInstantiationValue:" + arg1));
    }

    public NdRepositoryItemReference createRepositoryItemReference(NdProviderContext arg0, String arg1) throws NdTemplateException {
        NdRepositoryItemReference ref = super.createRepositoryItemReference(arg0, arg1);
        log.debug((Object)("createRepositoryItemReference:" + ref));
        return ref;
    }

    protected void missingArgument(String arg0, NdProviderContext arg1) throws NdMissingArgumentException {
        super.missingArgument(arg0, arg1);
        log.debug((Object)("missingArgument:" + arg1));
    }

    protected void missingDynamicArgument(String arg0, NdProviderContext arg1, NdTemplateException arg2) throws NdMissingDynamicArgumentException {
        super.missingDynamicArgument(arg0, arg1, arg2);
        log.debug((Object)("missingDynamicArgument:" + arg1 + ":" + arg2));
    }
}

