/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.blazesoft.psextensions.customprovider;

import com.blazesoft.repository.naming.NdRepositoryItemReference;
import com.blazesoft.template.engine.NdConstrainedListProvider;
import com.blazesoft.template.engine.NdDefaultTemplateValueProvider;
import com.blazesoft.template.engine.NdInvalidAllowedValuesException;
import com.blazesoft.template.engine.NdProviderArgDescriptor;
import com.blazesoft.template.engine.NdProviderArgInfo;
import com.blazesoft.template.engine.NdProviderContext;
import com.blazesoft.template.engine.NdProviderStaticArg;
import com.blazesoft.template.engine.NdTemplateException;
import com.blazesoft.template.engine.NdUnsupportedProviderArgException;
import com.blazesoft.template.engine.provider.NdDesignProvider;
import com.blazesoft.template.engine.provider.NdDesignProviderArg;
import com.blazesoft.template.engine.provider.NdDesignProviderBooleanArg;
import com.blazesoft.template.engine.provider.NdDesignProviderTypedArg;
import com.blazesoft.util.NdBaseObject;
import cz.nextiraone.tmobile.http.ws.client.ProvidersServiceImpl;
import cz.nextiraone.tmobile.http.ws.client.ProvidersServiceImplService;
import cz.nextiraone.tmobile.http.ws.client.Result;
import cz.nextiraone.tmobile.http.ws.client.Row;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class NdHttpProvider
extends NdDefaultTemplateValueProvider
implements NdDesignProvider,
NdProviderArgInfo,
NdConstrainedListProvider {
    private static Category log = Logger.getLogger(NdHttpProvider.class);
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};
    private static HostnameVerifier hostnameVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private static Map<String, ProvidersServiceImpl> ports;
    private static Map<QueryObject, String[]> cached;
    public static final String ARG_URL = "url";
    public static final String ARG_USER = "user";
    public static final String ARG_PASSWORD = "password";
    public static final String ARG_SELECTION_QUERY = "query";
    public static final String ARG_SELECTION_PARAM = "param";
    public static final String ARG_CACHE_VALUES = "cache-values";
    private static Hashtable hashArgs;
    private String url;
    private String user;
    private String password;
    private String selectionQuery;
    private Vector queryParam;
    private String[] selectionParameters;
    private boolean cacheValues;
    private NdProviderStaticArg andproviderstaticarg;
    private boolean validateInList;
    private NdRepositoryItemReference repositoryIntemReference;
    private boolean cipherJavaClass;

    public NdProviderArgDescriptor getDescriptor(String s) throws NdTemplateException {
        NdProviderArgDescriptor ndproviderargdescriptor = (NdProviderArgDescriptor)hashArgs.get(s);
        if (ndproviderargdescriptor == null) {
            throw new NdUnsupportedProviderArgException("InvalidArgumentName: " + s + "for the class=" + ((Object)((Object)this)).getClass().getName());
        }
        return ndproviderargdescriptor;
    }

    protected void processArgument(String s, String s1, NdProviderContext ndprovidercontext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("processArgument(%s,%s)", s, s1));
        }
        if (s.equals(ARG_URL)) {
            this.url = s1;
        } else if (s.equals(ARG_USER)) {
            this.user = s1;
        } else if (s.equals(ARG_PASSWORD)) {
            this.password = s1;
        } else if (s.equals(ARG_SELECTION_QUERY)) {
            this.selectionQuery = s1;
        } else if (s.equals(ARG_SELECTION_PARAM)) {
            this.queryParam.addElement(s1);
        } else if (s.equals(ARG_CACHE_VALUES)) {
            this.cacheValues = Boolean.valueOf(s1);
        } else if (s.equals("cipher-java-class")) {
            this.cipherJavaClass = true;
        }
    }

    protected void finishArgumentProcessing() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("finishArgumentProcessing()", new Object[0]));
        }
        this.selectionParameters = new String[this.queryParam.size()];
        this.queryParam.copyInto(this.selectionParameters);
    }

    protected String getUrl() {
        return this.url;
    }

    protected String getUser() {
        return this.user;
    }

    protected String getPassword() {
        return this.password;
    }

    protected String getSelectionQuery() {
        return this.selectionQuery;
    }

    protected String[] getSelectionParameters() {
        String[] as = new String[this.selectionParameters.length];
        System.arraycopy(this.selectionParameters, 0, as, 0, as.length);
        return as;
    }

    protected boolean areValuesCached() {
        return true;
    }

    public void reset(NdProviderContext ndprovidercontext) throws NdTemplateException {
        this.url = null;
        this.user = null;
        this.password = null;
        this.selectionQuery = null;
        this.queryParam = new Vector();
        this.cacheValues = true;
        this.cipherJavaClass = false;
    }

    protected ProvidersServiceImpl openConnection(NdProviderContext ndprovidercontext) throws NdTemplateException {
        URL endpoint_new;
        if (ports.containsKey(this.url)) {
            log.debug((Object)String.format("openConnection(url=%s) -> reusing port", this.url));
            return ports.get(this.url);
        }
        try {
            endpoint_new = new URL(this.url);
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            throw new NdTemplateException((Throwable)e);
        }
        QName qname = new QName("http://cz.nextoraone.tmobile.wintell/http-providers", "ProvidersServiceImplService");
        ProvidersServiceImpl port = new ProvidersServiceImplService(endpoint_new, qname).getProvidersServiceImplPort();
        BindingProvider bp = (BindingProvider)port;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.url);
        log.info((Object)String.format("openConnection(url=%s) -> allocating port", this.url));
        ports.put(this.url, port);
        return port;
    }

    protected void closeConnection(NdProviderContext ndprovidercontext) throws NdTemplateException {
    }

    private void checkUrl(NdProviderContext ndprovidercontext) throws NdTemplateException {
        if (this.url == null) {
            this.missingArgument(ARG_URL, ndprovidercontext);
        }
    }

    protected String[] getCachedValues(NdProviderContext ndprovidercontext) {
        QueryObject o = new QueryObject(this.url, this.user, this.password, this.selectionQuery, this.selectionParameters);
        if (cached.containsKey(o)) {
            return cached.get(o);
        }
        return null;
    }

    protected void storeCachedValues(NdProviderContext ndprovidercontext, String[] as) {
        QueryObject o = new QueryObject(this.url, this.user, this.password, this.selectionQuery, this.selectionParameters);
        String[] as1 = new String[as.length];
        System.arraycopy(as, 0, as1, 0, as.length);
        log.debug((Object)String.format("storeCachedValues for selectionQuery=%s", this.selectionQuery));
        cached.put(o, as1);
    }

    public NdDesignProviderArg[] getArgumentDescriptors(NdProviderContext ndprovidercontext) throws NdTemplateException {
        NdDesignProviderTypedArg nddesignprovidertypedarg = new NdDesignProviderTypedArg("driver");
        nddesignprovidertypedarg.setDisplayName("JdbcDriversArgDisplayName");
        nddesignprovidertypedarg.setDescription("JdbcDriversDescription");
        nddesignprovidertypedarg.setType(5);
        nddesignprovidertypedarg.setDefaultValue((Object)"");
        nddesignprovidertypedarg.setMandatory(true);
        NdDesignProviderTypedArg nddesignprovidertypedarg1 = new NdDesignProviderTypedArg(ARG_URL);
        nddesignprovidertypedarg1.setDisplayName("JdbcUrlArgDisplayName");
        nddesignprovidertypedarg1.setDescription("JdbcUrlArgDescription");
        nddesignprovidertypedarg1.setType(5);
        nddesignprovidertypedarg1.setDefaultValue((Object)"");
        nddesignprovidertypedarg1.setMandatory(true);
        NdDesignProviderTypedArg nddesignprovidertypedarg2 = new NdDesignProviderTypedArg(ARG_USER);
        nddesignprovidertypedarg2.setDisplayName("JdbcUserArgDisplayName");
        nddesignprovidertypedarg2.setDescription("JdbcUserArgDescription");
        nddesignprovidertypedarg2.setType(5);
        nddesignprovidertypedarg2.setDefaultValue((Object)"");
        NdDesignProviderTypedArg nddesignproviderencryptedarg = new NdDesignProviderTypedArg(ARG_PASSWORD);
        nddesignproviderencryptedarg.setDisplayName("JdbcPasswordArgDisplayName");
        nddesignproviderencryptedarg.setDescription("JdbcPasswordDescripton");
        nddesignproviderencryptedarg.setType(41);
        nddesignproviderencryptedarg.setMandatory(true);
        nddesignproviderencryptedarg.setDefaultValue((Object)"");
        NdDesignProviderTypedArg nddesignprovidertypedarg3 = new NdDesignProviderTypedArg(ARG_SELECTION_QUERY);
        nddesignprovidertypedarg3.setDisplayName("JdbcSelectionQueryArgDisplayName");
        nddesignprovidertypedarg3.setDescription("JdbcSelectionQueryDescription");
        nddesignprovidertypedarg3.setType(5);
        nddesignprovidertypedarg3.setDefaultValue((Object)"");
        nddesignprovidertypedarg3.setMandatory(true);
        NdDesignProviderTypedArg nddesignprovidertypedarg4 = new NdDesignProviderTypedArg(ARG_SELECTION_PARAM);
        nddesignprovidertypedarg4.setDisplayName("JdbcSelectionParamArgDisplayName");
        nddesignprovidertypedarg4.setDescription("JdbcSelectionParamDescription");
        nddesignprovidertypedarg4.setType(5);
        nddesignprovidertypedarg4.setDefaultValue((Object)"");
        nddesignprovidertypedarg4.setGroup("SelectionQueryParameter");
        nddesignprovidertypedarg4.setNewCmdName("NewSelectionParamDisplayName");
        nddesignprovidertypedarg4.setMandatory(false);
        nddesignprovidertypedarg4.setMultiple(true);
        NdDesignProviderBooleanArg nddesignproviderbooleanarg = new NdDesignProviderBooleanArg(ARG_CACHE_VALUES, true);
        nddesignproviderbooleanarg.setDisplayName("JdbcCacheValuesArgDisplayName");
        nddesignproviderbooleanarg.setDescription("JdbcCacheValuesDescription");
        nddesignproviderbooleanarg.setMandatory(true);
        return new NdDesignProviderArg[]{nddesignprovidertypedarg, nddesignprovidertypedarg1, nddesignprovidertypedarg2, nddesignproviderencryptedarg, nddesignprovidertypedarg3, nddesignprovidertypedarg4, nddesignproviderbooleanarg};
    }

    public void setArgs(NdProviderContext ndprovidercontext, NdProviderStaticArg[] andproviderstaticarg) throws NdTemplateException {
        for (int i = 0; i < andproviderstaticarg.length; ++i) {
            String s = andproviderstaticarg[i].getName();
            String s1 = andproviderstaticarg[i].getValue();
            if (s1 == null || s1.length() == 0) continue;
            if (s.equals("type")) {
                this.andproviderstaticarg = andproviderstaticarg[i];
                this.repositoryIntemReference = this.createRepositoryItemReference(ndprovidercontext, s1);
                continue;
            }
            if (s.equals("validate-in-list")) {
                this.validateInList = Boolean.valueOf(s1);
                continue;
            }
            this.processArgument(s, s1, ndprovidercontext);
        }
        this.finishArgumentProcessing();
    }

    public Object[] getAllowedDisplayValues(NdProviderContext ndprovidercontext) throws NdTemplateException {
        Object[] aobj = null;
        String[] as = this.getAllowedInstantiationValues(ndprovidercontext);
        if (as != null) {
            Class class1 = this.getDisplayValueClass(ndprovidercontext);
            Vector<Object> vector = new Vector<Object>(as.length);
            Vector<NdTemplateException> vector1 = new Vector<NdTemplateException>(as.length);
            for (int i = 0; i < as.length; ++i) {
                try {
                    vector.addElement(this.convertToDisplayValue(ndprovidercontext, as[i]));
                    continue;
                }
                catch (NdTemplateException ndtemplateexception) {
                    vector1.addElement(ndtemplateexception);
                }
            }
            aobj = (Object[])Array.newInstance(class1, vector.size());
            vector.copyInto(aobj);
            if (vector1.size() != 0) {
                throw new NdInvalidAllowedValuesException(aobj, vector1, ndprovidercontext.getValuedTemplate());
            }
        }
        return aobj;
    }

    public String[] getAllowedInstantiationValues(NdProviderContext ndprovidercontext) throws NdTemplateException {
        String[] as;
        if (this.areValuesCached() && (as = this.getCachedValues(ndprovidercontext)) != null) {
            return as;
        }
        String[] as1 = null;
        try {
            as1 = this.selectByQuery(ndprovidercontext);
        }
        catch (Exception e) {
            as1 = new String[]{};
            log.error((Object)String.format("selectByQuery(%s) -> %s", this.selectionQuery, e.getMessage()), (Throwable)e);
        }
        if (this.areValuesCached()) {
            this.storeCachedValues(ndprovidercontext, as1);
        }
        return as1;
    }

    private String[] selectByQuery(NdProviderContext ndprovidercontext) throws NdTemplateException {
        String[] as;
        ProvidersServiceImpl connection = null;
        connection = this.openConnection(ndprovidercontext);
        String[] as1 = as = this.selectOnConnection(connection, ndprovidercontext);
        return as1;
    }

    private String[] selectOnConnection(ProvidersServiceImpl connection, NdProviderContext ndprovidercontext) throws NdTemplateException {
        if (this.getSelectionQuery() == null) {
            this.missingArgument(ARG_SELECTION_QUERY, ndprovidercontext);
        }
        Vector<String> vector = new Vector<String>();
        log.info((Object)String.format("selectOnConnection(url=%s,user=%s,selectionQuery=%s)", this.url, this.user, this.selectionQuery));
        Result res = connection.select(this.user, this.password, this.selectionQuery, false);
        if (null != res.getErrorMessage()) {
            String msg = String.format("Error in select: %s\n", res.getErrorMessage());
            log.error((Object)msg);
            throw new NdTemplateException(msg);
        }
        try {
            for (Row r : res.getRows()) {
                String v = (String)r.getValues().get(0);
                vector.addElement(v);
            }
            log.debug((Object)String.format("selectOnConnection --> vector.size=%d", vector.size()));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        Object[] as1 = new String[vector.size()];
        vector.copyInto(as1);
        return as1;
    }

    public Object[] getAllowedJavaValues(NdProviderContext ndprovidercontext) throws NdTemplateException {
        Object[] aobj = null;
        String[] as = this.getAllowedInstantiationValues(ndprovidercontext);
        if (as != null) {
            Class class1 = this.getValueClass(ndprovidercontext);
            Vector<Object> vector = new Vector<Object>(as.length);
            Vector<NdTemplateException> vector1 = new Vector<NdTemplateException>(as.length);
            for (int i = 0; i < as.length; ++i) {
                try {
                    vector.addElement(this.convertToJavaObject(ndprovidercontext, as[i]));
                    continue;
                }
                catch (NdTemplateException ndtemplateexception) {
                    vector1.addElement(ndtemplateexception);
                }
            }
            aobj = (Object[])Array.newInstance(class1, vector.size());
            vector.copyInto(aobj);
            if (vector1.size() != 0) {
                throw new NdInvalidAllowedValuesException(aobj, vector1, ndprovidercontext.getValuedTemplate());
            }
        }
        return aobj;
    }

    public String getDescription(NdProviderContext arg0) throws NdTemplateException {
        return "JdbcProviderDescription";
    }

    public String getDisplayKey(NdProviderContext arg0) throws NdTemplateException {
        return "JdbcProvider";
    }

    public String getDisplayName(NdProviderContext arg0) throws NdTemplateException {
        return "JdbcProviderDisplayName";
    }

    static {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        }
        catch (Exception e) {
            System.out.printf("Cannot set trust certificate and host name verifier: %s", e.getMessage());
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource("log4j.properties");
        long delayMs = 15000L;
        PropertyConfigurator.configureAndWatch((String)url.getFile(), (long)delayMs);
        ports = new HashMap<String, ProvidersServiceImpl>();
        cached = new HashMap<QueryObject, String[]>();
        hashArgs = new Hashtable(11, 1.0f);
        hashArgs.put(ARG_URL, new NdProviderArgDescriptor(NdProviderArgDescriptor.SINGLE_VALUE, false));
        hashArgs.put(ARG_USER, new NdProviderArgDescriptor(NdProviderArgDescriptor.SINGLE_VALUE, false));
        hashArgs.put(ARG_PASSWORD, new NdProviderArgDescriptor(NdProviderArgDescriptor.SINGLE_VALUE, false));
        hashArgs.put(ARG_SELECTION_QUERY, new NdProviderArgDescriptor(NdProviderArgDescriptor.SINGLE_VALUE, false));
        hashArgs.put(ARG_SELECTION_PARAM, new NdProviderArgDescriptor(NdProviderArgDescriptor.SINGLE_VALUE, true));
        hashArgs.put(ARG_CACHE_VALUES, new NdProviderArgDescriptor(NdProviderArgDescriptor.SINGLE_VALUE, false));
        hashArgs.put("cipher-name", new NdProviderArgDescriptor(NdProviderArgDescriptor.SINGLE_VALUE, false));
        hashArgs.put("cipher-provider", new NdProviderArgDescriptor(NdProviderArgDescriptor.SINGLE_VALUE, false));
        hashArgs.put("cipher-param-factory", new NdProviderArgDescriptor(NdProviderArgDescriptor.SINGLE_VALUE, false));
        hashArgs.put("cipher-java-class", new NdProviderArgDescriptor(NdProviderArgDescriptor.SINGLE_VALUE, false));
    }

    private static class QueryObject {
        private String url;
        private String user;
        private String password;
        private String selectionQuery;
        private String[] as;
        private int hashCode;

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof QueryObject) {
                QueryObject wjidnpn = (QueryObject)obj;
                return NdBaseObject.areEqual((Object)this.url, (Object)wjidnpn.url) && NdBaseObject.areEqual((Object)this.user, (Object)wjidnpn.user) && NdBaseObject.areEqual((Object)this.password, (Object)wjidnpn.password) && NdBaseObject.areEqual((Object)this.selectionQuery, (Object)wjidnpn.selectionQuery) && NdBaseObject.areEqual((String[])this.as, (String[])wjidnpn.as);
            }
            return false;
        }

        QueryObject(String url, String user, String password, String selectionQuery, String[] as) {
            this.url = url;
            this.user = user;
            this.password = password;
            this.selectionQuery = selectionQuery;
            this.as = new String[as.length];
            System.arraycopy(this.as, 0, as, 0, as.length);
            this.hashCode = selectionQuery == null ? 0 : selectionQuery.hashCode();
        }
    }
}

