/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.http.ws.client;

import cz.nextiraone.tmobile.http.ws.client.Column;
import cz.nextiraone.tmobile.http.ws.client.Flags;
import cz.nextiraone.tmobile.http.ws.client.LogMessage;
import cz.nextiraone.tmobile.http.ws.client.ProvidersServiceImpl;
import cz.nextiraone.tmobile.http.ws.client.Result;
import cz.nextiraone.tmobile.http.ws.client.Return;
import cz.nextiraone.tmobile.http.ws.client.Row;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DbService
implements ProvidersServiceImpl {
    private String connectionString;
    private String driverClass;

    public DbService(String driverClass, String connectionString) {
        this.driverClass = driverClass;
        this.connectionString = connectionString;
    }

    public Connection getConnection(String user, String password, Return ret) {
        Connection conn;
        try {
            Class.forName(this.driverClass);
            conn = DriverManager.getConnection(this.connectionString, user, password);
        }
        catch (SQLException e) {
            this.error(ret, "authentication error - bad login or password: " + e.getMessage());
            return null;
        }
        catch (ClassNotFoundException e) {
            this.error(ret, "ERROR: no class for the driver: " + e.getMessage());
            return null;
        }
        ret.setStatusCode("OK");
        return conn;
    }

    public Result select(String login, String password, String query, boolean requireColumns) {
        Result result = new Result();
        Connection con = this.getConnection(login, password, (Return)result);
        if (!"OK".equals(result.getStatusCode())) {
            return result;
        }
        try {
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            ResultSetMetaData md = rs.getMetaData();
            int n = md.getColumnCount();
            if (requireColumns) {
                for (int i = 1; i <= n; ++i) {
                    Column col = new Column();
                    col.setName(md.getColumnName(i));
                    col.setClassName(md.getColumnClassName(i));
                    col.setColId(Integer.valueOf(i - 1));
                    result.getColumns().add(col);
                }
            }
            while (rs.next()) {
                Row row = new Row();
                for (int i = 1; i <= n; ++i) {
                    String val = rs.getString(i);
                    if (val == null) {
                        row.getNullValues().add(row.getValues().size());
                        val = "";
                    }
                    row.getValues().add(val);
                }
                result.getRows().add(row);
            }
            try {
                rs.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                con.close();
            }
            catch (Exception ignore) {}
        }
        catch (Exception e) {
            result.setErrorMessage(e.getClass().getName() + " : " + e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Return update(String login, String password, String table, String keyColumnJoin, Flags flags, Result data) {
        boolean doDelete = flags.getF() == null ? false : flags.getF().contains("DEL");
        Return updateResult = new Return();
        updateResult.setStatusCode("");
        String[] keyColumns = keyColumnJoin.split(",");
        Counters cnt = new Counters();
        HashMap<String, Column> srcColumns = new HashMap<String, Column>();
        int nn = 0;
        for (Column c : data.getColumns()) {
            if (c.getColId() == null) {
                c.setColId(Integer.valueOf(nn));
            }
            ++nn;
            srcColumns.put(c.getName(), c);
            System.err.printf("%s => src.id=%d\n", c.getName(), ((Column)srcColumns.get(c.getName())).getColId());
        }
        HashMap<String, Column> dstColumns = new HashMap<String, Column>();
        ArrayList<String> commonColumns = new ArrayList<String>();
        Connection con = this.getConnection(login, password, updateResult);
        if (!"OK".equals(updateResult.getStatusCode())) {
            return updateResult;
        }
        Result result = new Result();
        String query = String.format("select * from %s", table);
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData md = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(query);
            md = rs.getMetaData();
            int n = md.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                Column col = new Column();
                col.setName(md.getColumnName(i));
                col.setClassName(md.getColumnClassName(i));
                col.setColId(Integer.valueOf(i - 1));
                if (srcColumns.containsKey(col.getName())) {
                    result.getColumns().add(col);
                }
                dstColumns.put(col.getName(), col);
            }
            String update_values = "";
            String insert_values = "";
            String insert_columns = "";
            int nIndexKeys = 0;
            HashMap<String, Integer> mappedColumnsDelete = new HashMap<String, Integer>();
            HashMap<String, Integer> mappedColumnsUpdate = new HashMap<String, Integer>();
            HashMap<String, Integer> mappedColumnsInsert = new HashMap<String, Integer>();
            int mappedColumnIdDelete = 1;
            int mappedColumnIdUpdate = 1;
            int mappedColumnIdInsert = 1;
            for (Column c : result.getColumns()) {
                String columnName = c.getName();
                commonColumns.add(columnName);
                if (!"".equals(insert_values)) {
                    insert_values = insert_values + ",";
                }
                if (!"".equals(insert_columns)) {
                    insert_columns = insert_columns + ",";
                }
                insert_values = insert_values + "?";
                insert_columns = insert_columns + columnName;
                mappedColumnsInsert.put(c.getName(), mappedColumnIdInsert++);
                boolean isIndexKey = false;
                for (String keyColumn : keyColumns) {
                    if (!keyColumn.equals(c.getName())) continue;
                    ++nIndexKeys;
                    isIndexKey = true;
                    break;
                }
                if (isIndexKey) continue;
                if (!"".equals(update_values)) {
                    update_values = update_values + ",";
                }
                update_values = update_values + String.format("%s=?", columnName);
                mappedColumnsUpdate.put(c.getName(), mappedColumnIdUpdate++);
            }
            if (nIndexKeys != keyColumns.length) {
                Return i$ = this.error(updateResult, String.format("no keyColumn=[%s]: in common columns set =  ", keyColumnJoin, insert_columns));
                return i$;
            }
            String where_values = "";
            for (String keyColumn : keyColumns) {
                if (!"".equals(where_values)) {
                    where_values = where_values + " and ";
                }
                where_values = where_values + String.format("%s=?", keyColumn);
                mappedColumnsUpdate.put(keyColumn, mappedColumnIdUpdate++);
                mappedColumnsDelete.put(keyColumn, mappedColumnIdDelete++);
            }
            String delete = String.format("delete from %s where %s", table, where_values);
            String update = String.format("update %s set %s where %s", table, update_values, where_values);
            String insert = String.format("insert into %s(%s) values(%s)", table, insert_columns, insert_values);
            if (doDelete) {
                this.logResult(updateResult, "DEBUG", String.format("delete=%s", "" + doDelete, delete));
            }
            this.logResult(updateResult, "DEBUG", String.format("update=%s", update));
            this.logResult(updateResult, "DEBUG", String.format("insert=%s", insert));
            PreparedStatement prepareDelete = con.prepareStatement(delete);
            PreparedStatement prepareUpdate = con.prepareStatement(update);
            PreparedStatement prepareInsert = con.prepareStatement(insert);
            ArrayList<Integer> srcKeyColumnIds = new ArrayList<Integer>();
            ArrayList<Integer> dstKeyColumnIds = new ArrayList<Integer>();
            for (String keyColumn : keyColumns) {
                this.logResult(updateResult, "DEBUG", String.format("%s => src.id=%d,dst.id=%d\n", keyColumn, ((Column)srcColumns.get(keyColumn)).getColId(), ((Column)dstColumns.get(keyColumn)).getColId()));
                srcKeyColumnIds.add(((Column)srcColumns.get(keyColumn)).getColId());
                dstKeyColumnIds.add(((Column)dstColumns.get(keyColumn)).getColId());
            }
            int dstOrigCount = 0;
            HashMap<String, Row> dstMappedRows = new HashMap<String, Row>();
            HashMap<String, Row> srcMappedRows = new HashMap<String, Row>();
            while (rs.next()) {
                Row row = new Row();
                for (Column c : result.getColumns()) {
                    String val = rs.getString(c.getName());
                    if (val == null) {
                        row.getNullValues().add(row.getValues().size());
                        val = "";
                    }
                    row.getValues().add(val);
                }
                String keyValue = this.getKeyValue(row.getValues(), dstKeyColumnIds);
                dstMappedRows.put(keyValue, row);
                ++dstOrigCount;
            }
            cnt.setDstOrigCount(dstOrigCount, dstMappedRows.size());
            con.setAutoCommit(false);
            int srcOrigCount = 0;
            for (Row r : data.getRows()) {
                List srcVals = r.getValues();
                String keyValue = this.getKeyValue(srcVals, srcKeyColumnIds);
                srcMappedRows.put(keyValue, r);
                ++srcOrigCount;
            }
            cnt.setSrcOrigCount(srcOrigCount, srcMappedRows.size());
            HashSet allKeys = new HashSet(srcMappedRows.keySet());
            allKeys.addAll(dstMappedRows.keySet());
            for (String keyValue : allKeys) {
                Row srcRow = (Row)srcMappedRows.get(keyValue);
                Row dstRow = (Row)dstMappedRows.get(keyValue);
                List srcVals = srcRow == null ? null : srcRow.getValues();
                List dstVals = dstRow == null ? null : dstRow.getValues();
                PreparedStatement prepare = null;
                HashMap<String, Integer> mappedColumns = null;
                String op = "";
                if (srcRow != null) {
                    if (dstRow != null) {
                        prepare = prepareUpdate;
                        mappedColumns = mappedColumnsUpdate;
                        op = "update";
                    } else {
                        prepare = prepareInsert;
                        mappedColumns = mappedColumnsInsert;
                        op = "insert";
                    }
                } else {
                    if (!doDelete) continue;
                    prepare = prepareDelete;
                    mappedColumns = mappedColumnsDelete;
                    op = "delete";
                }
                this.syncRow(op, keyValue, updateResult, cnt, commonColumns, srcColumns, dstColumns, con, mappedColumns, prepare, dstRow, srcRow, srcVals, dstVals);
            }
            con.commit();
        }
        catch (Exception e) {
            String msg = "ERROR:" + e.getClass().getName() + " : " + e.getMessage();
            for (StackTraceElement se : e.getStackTrace()) {
                msg = msg + "\n\t" + se.toString();
            }
            Return return_ = this.error(updateResult, msg);
            return return_;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ignore) {}
            try {
                stmt.close();
            }
            catch (Exception ignore) {}
            try {
                con.close();
            }
            catch (Exception ignore) {}
        }
        cnt.getResult(updateResult, this);
        updateResult.setErrorMessage("");
        return updateResult;
    }

    private void syncRow(String op, String keyValue, Return ret, Counters cnt, List<String> commonColumns, Map<String, Column> srcColumns, Map<String, Column> dstColumns, Connection con, Map<String, Integer> mappedColumns, PreparedStatement prepare, Row dstRow, Row srcRow, List<String> srcVals, List<String> dstVals) throws SQLException {
        String line = String.format("[key=%s]", keyValue);
        boolean updateNeaded = false;
        for (String col : commonColumns) {
            Column srcCol = srcColumns.get(col);
            Column dstCol = dstColumns.get(col);
            int srcColId = srcCol.getColId();
            int dstColId = dstCol.getColId();
            String sqlType = dstCol.getClassName();
            String srcVal = null;
            if (srcRow != null) {
                srcVal = srcVals.get(srcColId);
                boolean srcIsNull = srcRow.getNullValues().contains(srcColId);
                if (dstVals != null) {
                    boolean dstIsNull = dstRow.getNullValues().contains(dstColId);
                    String dstVal = dstVals.get(dstColId);
                    if (!dstVal.equals(srcVal) || dstIsNull != srcIsNull) {
                        updateNeaded = true;
                    }
                }
                if (srcIsNull) {
                    srcVal = null;
                }
            } else if (dstVals != null) {
                boolean dstIsNull = dstRow.getNullValues().contains(dstColId);
                String dstVal = dstVals.get(dstColId);
                if (!dstIsNull) {
                    srcVal = dstVal;
                }
            }
            line = line + "," + String.format("%s=%s", col, srcVal);
            int t = 12;
            Object o = null;
            if (sqlType.equals("INTEGER")) {
                t = 4;
                if (srcVal != null) {
                    o = Long.valueOf(srcVal);
                }
            } else if (sqlType.equals("NUMBER")) {
                t = 2;
                if (srcVal != null) {
                    o = Double.valueOf(srcVal);
                }
            } else if (sqlType.equals("java.sql.Timestamp")) {
                t = 93;
                if (srcVal != null) {
                    o = Timestamp.valueOf(srcVal);
                }
            } else {
                t = 12;
                o = srcVal;
            }
            if (!mappedColumns.containsKey(col)) continue;
            int mappedColId = mappedColumns.get(col);
            if (srcVal == null) {
                prepare.setNull(mappedColId, t);
                continue;
            }
            prepare.setObject(mappedColId, o);
        }
        if ("update".equals(op) && !updateNeaded) {
            return;
        }
        this.logResult(ret, "INFO", String.format("%s: %s", op, line));
        cnt.updateCounter(op, prepare.executeUpdate());
        if (cnt.check()) {
            con.commit();
        }
    }

    private String getKeyValue(List<String> vals, List<Integer> columnIds) {
        String ret = "";
        for (Integer columnId : columnIds) {
            String kv;
            if (!"".equals(ret)) {
                ret = ret + ",";
            }
            if ((kv = vals.get(columnId)) == null) {
                kv = "__NULL__";
            }
            ret = ret + vals.get(columnId);
        }
        return ret;
    }

    private Return error(Return ret, String msg) {
        ret.setStatusCode("ERROR");
        ret.setErrorMessage(msg);
        return ret;
    }

    private void logResult(Return ret, String level, String msg) {
        LogMessage lm = new LogMessage();
        lm.setPriority(level);
        lm.setMessage(msg);
        if (ret.logMessages == null) {
            ret.logMessages = new ArrayList();
        }
        ret.logMessages.add(lm);
        if ("ERROR".equals(level)) {
            ret.setStatusCode("ERROR");
            ret.setErrorMessage(msg);
        }
    }

    static class Counters {
        private int totalCounter = 0;
        private int updatedCounter = 0;
        private int insertedCounter = 0;
        private int deletedCounter = 0;
        private int operations2Commit = 40;
        private int commitCounter = this.totalCounter + this.operations2Commit;
        private int dstUniqCount;
        private int dstOrigCount;
        private int srcUniqCount;
        private int srcOrigCount;

        public boolean check() {
            if (this.totalCounter >= this.commitCounter) {
                this.commitCounter = this.totalCounter + this.operations2Commit;
                return true;
            }
            return false;
        }

        public void updateCounter(String t, int n) {
            if ("update".equals(t)) {
                this.updatedCounter += n;
            } else if ("insert".equals(t)) {
                this.insertedCounter += n;
            } else if ("delete".equals(t)) {
                this.deletedCounter += n;
            }
            this.totalCounter += n;
        }

        public void getResult(Return updateResult, DbService s) {
            int dstFinalCount = this.dstOrigCount + this.insertedCounter - this.deletedCounter;
            if (this.srcOrigCount != this.srcUniqCount) {
                s.logResult(updateResult, "WARN", String.format("srcOrigCount=%d != srcUniqCount=%d", this.srcOrigCount, this.srcUniqCount));
            }
            if (this.dstOrigCount != this.dstUniqCount) {
                s.logResult(updateResult, "WARN", String.format("dstOrigCount=%d != dstUniqCount=%d", this.dstOrigCount, this.dstUniqCount));
            }
            if (dstFinalCount != this.srcOrigCount) {
                s.logResult(updateResult, "WARN", String.format("dstFinal=%d != srcOrigCount=%d", dstFinalCount, this.srcOrigCount));
            }
            s.logResult(updateResult, "INFO", String.format("dstOrigCount=%d: 0updatedCount=%d, +insertedCount=%d, -deletedCount=%d => dstFinalCount=%d", this.dstOrigCount, this.updatedCounter, this.insertedCounter, this.deletedCounter, dstFinalCount));
        }

        public void setSrcOrigCount(int srcOrigCount, int srcUniqCount) {
            this.srcOrigCount = srcOrigCount;
            this.srcUniqCount = srcUniqCount;
        }

        public void setDstOrigCount(int dstOrigCount, int dstUniqCount) {
            this.dstOrigCount = dstOrigCount;
            this.dstUniqCount = dstUniqCount;
        }
    }
}

