/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.http.ws.client;

import cz.nextiraone.tmobile.http.ws.client.Column;
import cz.nextiraone.tmobile.http.ws.client.ProvidersServiceImpl;
import cz.nextiraone.tmobile.http.ws.client.Result;
import cz.nextiraone.tmobile.http.ws.client.Row;
import cz.nextiraone.tmobile.http.ws.client.ServiceFactory;
import java.util.List;
import org.apache.log4j.Logger;

class Select {
    private static Logger log = Logger.getLogger(Select.class);

    Select() {
    }

    public static void main(String[] args) {
        try {
            String password;
            String user;
            String src_url_user_pass = args[0];
            String query = args[1];
            String[] src = src_url_user_pass.split("\\|");
            if (src.length != 3) {
                throw new IllegalArgumentException("src_url_user_pass not in correct format: url|user|pass");
            }
            ProvidersServiceImpl src_port = ServiceFactory.getServiceProvider(src[0]);
            Result res = src_port.select(user = src[1], password = src[2], query, true);
            if (null != res.getErrorMessage()) {
                log.error((Object)String.format("Error in select: %s", res.getErrorMessage()));
                System.exit(-1);
            }
            for (Column c : res.getColumns()) {
                System.out.printf("\tcol: %s / %s\n", c.getName(), c.getClassName());
            }
            for (Row r : res.getRows()) {
                String line = null;
                List nulls = r.getNullValues();
                int i = 0;
                for (String v : r.getValues()) {
                    if (nulls.contains(i)) {
                        v = "_NULL_";
                    }
                    ++i;
                    if (line == null) {
                        line = v;
                        continue;
                    }
                    line = line + "|" + v;
                }
                System.out.printf("%s\n", line);
            }
        }
        catch (Exception e) {
            log.error((Object)(e.getClass().getName() + " : " + e.getMessage()), (Throwable)e);
        }
    }
}

