/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.http.ws.client;

import cz.nextiraone.tmobile.http.ws.client.Flags;
import cz.nextiraone.tmobile.http.ws.client.LogMessage;
import cz.nextiraone.tmobile.http.ws.client.ProvidersServiceImpl;
import cz.nextiraone.tmobile.http.ws.client.Result;
import cz.nextiraone.tmobile.http.ws.client.Return;
import cz.nextiraone.tmobile.http.ws.client.ServiceFactory;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class Update {
    private static Logger log = Logger.getLogger(Update.class);

    Update() {
    }

    public static void main(String[] args) {
        try {
            String src_url_user_pass = args[0];
            String dst_url_user_pass = args[1];
            String table = args[2];
            String table_key = args[3];
            String flagsS = args.length <= 4 ? null : args[4];
            String[] src = src_url_user_pass.split("\\|");
            if (src.length != 3) {
                throw new IllegalArgumentException("src_url_user_pass not in correct format: url|user|pass");
            }
            ProvidersServiceImpl src_port = ServiceFactory.getServiceProvider(src[0]);
            String[] dst = dst_url_user_pass.split("\\|");
            if (dst.length != 3) {
                throw new IllegalArgumentException("dst_url_user_pass not in correct format: url|user|pass");
            }
            ProvidersServiceImpl dst_port = ServiceFactory.getServiceProvider(dst[0]);
            Flags flags = new Flags();
            if (flagsS != null) {
                for (String f : flagsS.split(",")) {
                    if (flags.f == null) {
                        flags.f = new ArrayList();
                    }
                    flags.f.add(f);
                }
            }
            log.info((Object)String.format("Update(%s/%s)", table, table_key));
            if (flags.f != null) {
                for (String f : flags.f) {
                    log.info((Object)String.format("\tflag=%s", f));
                }
            }
            log.info((Object)String.format("\tSELECT", new Object[0]));
            Result res = src_port.select(src[1], src[2], String.format("select * from %s", table), true);
            if (null != res.getErrorMessage()) {
                log.info((Object)String.format("Error in select: %s", res.getErrorMessage()));
                System.exit(-1);
            }
            log.info((Object)String.format("\tUPDATE", new Object[0]));
            Return dst_res = dst_port.update(dst[1], dst[2], table, table_key, flags, res);
            for (LogMessage lm : dst_res.getLogMessages()) {
                Priority prio = Priority.toPriority((String)lm.getPriority(), (Priority)Priority.DEBUG);
                log.log(prio, (Object)lm.getMessage());
            }
            log.info((Object)String.format("----> response=%s:%s", dst_res.getStatusCode(), dst_res.getErrorMessage()));
        }
        catch (Exception e) {
            log.error((Object)(e.getClass().getName() + " : " + e.getMessage()), (Throwable)e);
        }
    }
}

