/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.psextensions.utilities;

public class PrintCheck {
    public static final int PRINT_LEVEL_NONE = 0;
    public static final int PRINT_LEVEL_PRINT = 1;
    public static final int PRINT_LEVEL_FATAL = 2;
    public static final int PRINT_LEVEL_ERROR = 4;
    public static final int PRINT_LEVEL_WARN = 8;
    public static final int PRINT_LEVEL_INFO = 16;
    public static final int PRINT_LEVEL_DEBUG = 32;
    public static final int PRINT_LEVEL_EXT1 = 64;
    public static final int PRINT_LEVEL_EXT2 = 128;
    public static final int PRINT_LEVEL_ALL = 255;
    public static final int PRINT_TARGET_NONE = 0;
    public static final int PRINT_TARGET_PRINT = 1;
    public static final int PRINT_TARGET_LOGGER = 2;
    public static final int PRINT_TARGET_EXT1 = 4;
    public static final int PRINT_TARGET_EXT2 = 8;
    public static final int PRINT_TARGET_ALL = 15;
    public static final int PRINT_EVENT_NONE = 0;
    public static final int PRINT_EVENT_FUNCTION = 1;
    public static final int PRINT_EVENT_RULEFLOW = 2;
    public static final int PRINT_EVENT_RULESET = 4;
    public static final int PRINT_EVENT_RULE = 8;
    public static final int PRINT_EVENT_EXT1 = 16;
    public static final int PRINT_EVENT_EXT2 = 32;
    public static final int PRINT_EVENT_ALL = 63;

    public static void printLevelHelp() {
        System.out.print("Help for PrintCheck print level");
        System.out.println("\tTo output no print statements use PRINT_LEVEL_NONE (0)");
        System.out.println("\tTo output normal print statements use PRINT_LEVEL_PRINT (1)");
        System.out.println("\tTo output normal fatal statements use PRINT_LEVEL_FATAL (2)");
        System.out.println("\tTo output normal error statements use PRINT_LEVEL_ERROR (4)");
        System.out.println("\tTo output normal warning statements use PRINT_LEVEL_WARN (8)");
        System.out.println("\tTo output normal info statements use PRINT_LEVEL_INFO (16)");
        System.out.println("\tTo output normal debug statements use PRINT_LEVEL_DEBUG (32)");
        System.out.println("\tTo output all print statements use PRINT_LEVEL_ALL (255)");
        System.out.println("\tReserved for future use PRINT_LEVEL_EXT1 (64)");
        System.out.println("\tReserved for future use PRINT_LEVEL_EXT2 (128)");
    }

    public static void printTargetHelp() {
        System.out.print("Help for PrintCheck print target");
        System.out.println("\tTo output print statements to no target use PRINT_TARGET_NONE (0)");
        System.out.println("\tTo output print statements to the built-in print statement use PRINT_TARGET_PRINT (1)");
        System.out.println("\tTo output print statements to the BlazeLogger use PRINT_TARGET_LOGGER (2)");
        System.out.println("\tTo output print statements to all print targets use PRINT_TARGET_ALL (15)");
        System.out.println("\tReserved for future use PRINT_TARGET_EXT1 (4)");
        System.out.println("\tReserved for future use PRINT_TARGET_EXT2 (8)");
    }

    public static void printEventHelp() {
        System.out.print("Help for PrintCheck print event");
        System.out.println("\tTo output print statements for no events use PRINT_EVENT_NONE (0)");
        System.out.println("\tTo output print statements for function level events use PRINT_EVENT_FUNCTION (1)");
        System.out.println("\tTo output print statements for function level events use PRINT_EVENT_RULEFLOW (2)");
        System.out.println("\tTo output print statements for function level events use PRINT_EVENT_RULESET (4)");
        System.out.println("\tTo output print statements for function level events use PRINT_EVENT_RULE (8)");
        System.out.println("\tTo output print statements to all print events use PRINT_EVENT_ALL (63)");
        System.out.println("\tReserved for future use PRINT_EVENT_EXT1 (16)");
        System.out.println("\tReserved for future use PRINT_EVENT_EXT2 (32)");
    }

    public static boolean checkPrintLevelPrint(int requestLevel) {
        return PrintCheck.checkLevel(1, requestLevel);
    }

    public static boolean checkPrintLevelFatal(int requestLevel) {
        return PrintCheck.checkLevel(2, requestLevel);
    }

    public static boolean checkPrintLevelError(int requestLevel) {
        return PrintCheck.checkLevel(4, requestLevel);
    }

    public static boolean checkPrintLevelWarn(int requestLevel) {
        return PrintCheck.checkLevel(8, requestLevel);
    }

    public static boolean checkPrintLevelInfo(int requestLevel) {
        return PrintCheck.checkLevel(16, requestLevel);
    }

    public static boolean checkPrintLevelDebug(int requestLevel) {
        return PrintCheck.checkLevel(32, requestLevel);
    }

    public static boolean checkPrintTargetPrint(int requestLevel) {
        return PrintCheck.checkLevel(1, requestLevel);
    }

    public static boolean checkPrintTargetLogger(int requestLevel) {
        return PrintCheck.checkLevel(2, requestLevel);
    }

    public static boolean checkPrintEventRuleflow(int requestLevel) {
        return PrintCheck.checkLevel(2, requestLevel);
    }

    public static boolean checkPrintEventRuleset(int requestLevel) {
        return PrintCheck.checkLevel(4, requestLevel);
    }

    public static boolean checkPrintEventRule(int requestLevel) {
        return PrintCheck.checkLevel(8, requestLevel);
    }

    public static boolean checkPrintEventFunction(int requestLevel) {
        return PrintCheck.checkLevel(1, requestLevel);
    }

    public static boolean checkLevel(int level, int requestLevel) {
        return (level & requestLevel) == level;
    }
}

