/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.base;

import com.blazesoft.objects.java2.NdDefaultClassLoadingContext;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryFactoryException;
import com.blazesoft.repository.base.NdStrings;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigSupport;
import com.blazesoft.repository.config.legacy.NdBaseRepositoryConfig;
import com.blazesoft.repository.file.NdFileRepositoryConnection;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryConnection;
import com.blazesoft.repository.jndi.NdJndiLdapRepositoryConnection;
import com.blazesoft.repository.local.NdLocalRepository;
import com.blazesoft.repository.local.NdNonCachingWorkspace;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.util.NdClassLoadingContext;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class NdRepositoryFactory {
    public static final String REPOSITORY_CLASS_TAG = "com.blazesoft.repository.base.repositoryclass";
    public static final String REPOSITORY_CONNECTION_URL_TAG = "com.blazesoft.repository.connection.url";
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$com$blazesoft$repository$base$NdRepositoryConnection;
    static /* synthetic */ Class class$com$blazesoft$repository$config$NdRepositoryConfig;
    static /* synthetic */ Class class$com$blazesoft$repository$base$NdWorkspaceConnection;

    private static Constructor WjHIEME(Class clazz, Class clazz2) {
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length != 1 || !NdBaseObject.isAssignableFrom(classArray[0], (Class)clazz2)) continue;
            constructor = constructorArray[i];
            break;
        }
        return constructor;
    }

    public static NdRepositoryConnection newRepositoryConnection(Hashtable hashtable) throws NdRepositoryFactoryException {
        return NdRepositoryFactory.newRepositoryConnection(hashtable, null);
    }

    public static NdRepositoryConnection newRepositoryConnection(Hashtable hashtable, NdClassLoadingContext ndClassLoadingContext) throws NdRepositoryFactoryException {
        NdRepositoryConnection ndRepositoryConnection;
        Class clazz;
        String string = (String)hashtable.get("com_blazesoft_repository_connectionclass");
        if (string == null || string.length() == 0) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDdH("FailedToGetConnectionClassFromConnectionTable"));
        }
        try {
            clazz = NdDefaultClassLoadingContext.classForName((NdClassLoadingContext)ndClassLoadingContext, (String)string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDfJ("CouldNotFindClass", string), classNotFoundException);
        }
        if (clazz == null) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDfJ("CouldNotFindClass", string));
        }
        Constructor constructor = NdRepositoryFactory.WjHIEME(clazz, class$java$util$Hashtable == null ? (class$java$util$Hashtable = NdRepositoryFactory.class$("java.util.Hashtable")) : class$java$util$Hashtable);
        if (constructor == null) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDfJ("CouldNotFindConstructor", string));
        }
        try {
            Object[] objectArray = new Object[]{hashtable};
            ndRepositoryConnection = (NdRepositoryConnection)constructor.newInstance(objectArray);
            ndRepositoryConnection.setClassLoadingContext(ndClassLoadingContext);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDgK("ExceptionWhileConstructingRepositoryConnection", string, invocationTargetException), invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDgK("ExceptionWhileConstructingRepositoryConnection", string, instantiationException), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDgK("ExceptionWhileConstructingRepositoryConnection", string, illegalAccessException), illegalAccessException);
        }
        catch (RuntimeException runtimeException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDgK("ExceptionWhileConstructingRepositoryConnection", string, runtimeException), runtimeException);
        }
        return ndRepositoryConnection;
    }

    public static NdRepository newStorageRepository(NdWorkspaceConnection ndWorkspaceConnection) throws NdRepositoryException {
        NdRepository ndRepository;
        Class<?> clazz;
        String string = ndWorkspaceConnection.getRepositoryClassName();
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDfJ("CouldNotFindClass", string), classNotFoundException);
        }
        if (clazz == null) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDfJ("CouldNotFindClass", string));
        }
        Constructor constructor = NdRepositoryFactory.WjHIEME(clazz, class$com$blazesoft$repository$base$NdRepositoryConnection == null ? (class$com$blazesoft$repository$base$NdRepositoryConnection = NdRepositoryFactory.class$("com.blazesoft.repository.base.NdRepositoryConnection")) : class$com$blazesoft$repository$base$NdRepositoryConnection);
        if (constructor == null) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDfJ("CouldNotFindConstructor", string));
        }
        try {
            Object[] objectArray = new Object[]{ndWorkspaceConnection};
            ndRepository = (NdRepository)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDgK("ExceptionWhileConstructingRepository", string, invocationTargetException), invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDgK("ExceptionWhileConstructingRepository", string, instantiationException), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDgK("ExceptionWhileConstructingRepository", string, illegalAccessException), illegalAccessException);
        }
        catch (RuntimeException runtimeException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDgK("ExceptionWhileConstructingRepository", string, runtimeException), runtimeException);
        }
        return ndRepository;
    }

    public static NdRepository newRepository(NdWorkspaceConnection ndWorkspaceConnection) throws NdRepositoryException {
        return NdRepositoryFactory.newWorkspace(ndWorkspaceConnection);
    }

    public static NdWorkspace newWorkspace(NdWorkspaceConnection ndWorkspaceConnection) throws NdRepositoryException {
        NdRepository ndRepository = NdRepositoryFactory.newStorageRepository(ndWorkspaceConnection);
        return ndWorkspaceConnection.isLocalRepositoryEnabled() ? new NdLocalRepository(ndRepository) : new NdNonCachingWorkspace(ndRepository);
    }

    public static NdRepository newRepository(NdRepositoryConfig ndRepositoryConfig) throws NdRepositoryException {
        NdRepository ndRepository;
        Class<?> clazz;
        String string = ndRepositoryConfig.getRepositoryClassName();
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDfJ("CouldNotFindClass", string), classNotFoundException);
        }
        if (clazz == null) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDfJ("CouldNotFindClass", string));
        }
        Constructor constructor = NdRepositoryFactory.WjHIEME(clazz, class$com$blazesoft$repository$config$NdRepositoryConfig == null ? (class$com$blazesoft$repository$config$NdRepositoryConfig = NdRepositoryFactory.class$("com.blazesoft.repository.config.NdRepositoryConfig")) : class$com$blazesoft$repository$config$NdRepositoryConfig);
        if (constructor == null) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDfJ("CouldNotFindConstructor", string));
        }
        try {
            Object[] objectArray = new Object[]{ndRepositoryConfig};
            ndRepository = (NdRepository)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDgK("ExceptionWhileConstructingRepository", string, invocationTargetException), invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDgK("ExceptionWhileConstructingRepository", string, instantiationException), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDgK("ExceptionWhileConstructingRepository", string, illegalAccessException), illegalAccessException);
        }
        catch (RuntimeException runtimeException) {
            throw new NdRepositoryFactoryException(NdStrings.WjHzDgK("ExceptionWhileConstructingRepository", string, runtimeException), runtimeException);
        }
        return ndRepositoryConfig.isLocalRepositoryEnabled() ? new NdLocalRepository(ndRepository) : new NdNonCachingWorkspace(ndRepository);
    }

    private static NdWorkspaceConnection WjIlKIH(String string, Hashtable hashtable) throws NdRepositoryException {
        NdWorkspaceConnection ndWorkspaceConnection = null;
        String string2 = (String)hashtable.get(REPOSITORY_CONNECTION_URL_TAG);
        if (string2 != null && string2.length() > 0) {
            try {
                Class<?> clazz = Class.forName("com.blazesoft.repository.rmi.NdRmiRepositoryConnection");
                Constructor<?> constructor = clazz.getConstructor(class$java$util$Hashtable == null ? (class$java$util$Hashtable = NdRepositoryFactory.class$("java.util.Hashtable")) : class$java$util$Hashtable);
                ndWorkspaceConnection = (NdWorkspaceConnection)constructor.newInstance(NdRepositoryConfigSupport.convertLegacyArgs(hashtable));
                hashtable.remove(REPOSITORY_CONNECTION_URL_TAG);
                NdWorkspaceConnection ndWorkspaceConnection2 = NdRepositoryFactory.WjIlKIH((String)hashtable.get(REPOSITORY_CLASS_TAG), hashtable);
                Method method = (class$com$blazesoft$repository$base$NdWorkspaceConnection == null ? (class$com$blazesoft$repository$base$NdWorkspaceConnection = NdRepositoryFactory.class$("com.blazesoft.repository.base.NdWorkspaceConnection")) : class$com$blazesoft$repository$base$NdWorkspaceConnection).getMethod("setWorkspaceConnection", class$com$blazesoft$repository$base$NdWorkspaceConnection == null ? (class$com$blazesoft$repository$base$NdWorkspaceConnection = NdRepositoryFactory.class$("com.blazesoft.repository.base.NdWorkspaceConnection")) : class$com$blazesoft$repository$base$NdWorkspaceConnection);
                method.invoke((Object)ndWorkspaceConnection, ndWorkspaceConnection2);
            }
            catch (Exception exception) {
                throw new NdRepositoryException(exception);
            }
        } else if (string.equals("com.blazesoft.repository.file.NdFileRepository")) {
            ndWorkspaceConnection = new NdFileRepositoryConnection(NdRepositoryConfigSupport.convertLegacyArgs(hashtable));
        } else if (string.equals("com.blazesoft.repository.jdbc.NdJdbcRepository")) {
            ndWorkspaceConnection = new NdJdbcRepositoryConnection(NdRepositoryConfigSupport.convertLegacyArgs(hashtable));
        } else if (string.equals("com.blazesoft.repository.jdbc.NdJdbcRepository")) {
            ndWorkspaceConnection = new NdJdbcRepositoryConnection(NdRepositoryConfigSupport.convertLegacyArgs(hashtable));
        } else if (string.equals("com.blazesoft.repository.jndi.NdJndiLdapRepository")) {
            ndWorkspaceConnection = new NdJndiLdapRepositoryConnection(NdRepositoryConfigSupport.convertLegacyArgs(hashtable));
        }
        return ndWorkspaceConnection;
    }

    public static NdRepository newRepository(String string, Hashtable hashtable) throws NdRepositoryException {
        NdWorkspaceConnection ndWorkspaceConnection = NdRepositoryFactory.WjIlKIH(string, hashtable);
        return NdRepositoryFactory.newRepository(ndWorkspaceConnection);
    }

    public static NdRepository newRepository(Hashtable hashtable) throws NdRepositoryException {
        return NdRepositoryFactory.newRepository((String)hashtable.get(REPOSITORY_CLASS_TAG), hashtable);
    }

    public static NdRepository newRepository(NdBaseRepositoryConfig ndBaseRepositoryConfig) throws NdRepositoryException {
        NdRepositoryConfig ndRepositoryConfig = NdRepositoryConfigSupport.convertLegacyConfig(null, ndBaseRepositoryConfig.getRepositoryConfig());
        return NdRepositoryFactory.newRepository(ndRepositoryConfig);
    }

    public static Hashtable getArgsHashtableFromRepositoryBean(Object object) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(13, 1.0f);
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Method method = propertyDescriptorArray[i].getReadMethod();
            Object object2 = method.invoke(object, null);
            if (object2 == null) continue;
            hashtable.put(propertyDescriptorArray[i].getName(), object2);
        }
        String string = (String)hashtable.get(REPOSITORY_CLASS_TAG);
        if (string == null || string.length() == 0) {
            string = object.getClass().getName();
            NdBaseObject.advAssert((boolean)string.endsWith("Properties"));
            string = string.substring(0, string.length() - "Properties".length());
            hashtable.put(REPOSITORY_CLASS_TAG, string);
        }
        return hashtable;
    }

    public static Object getRepositoryBeanFromArgsHashtable(Hashtable hashtable) throws ClassNotFoundException, InstantiationException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        String string = (String)hashtable.get("com.blazesoft.repository.base.repositorybeanclass");
        if (string == null || string.length() == 0) {
            string = hashtable.get(REPOSITORY_CLASS_TAG) + "Properties";
        }
        Class<?> clazz = Class.forName(string);
        Object obj = clazz.newInstance();
        BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Object v = hashtable.get(propertyDescriptorArray[i].getName());
            if (v == null) continue;
            Object[] objectArray = new Object[]{v};
            Method method = propertyDescriptorArray[i].getWriteMethod();
            method.invoke(obj, objectArray);
        }
        return obj;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

