/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.config;

import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryFactory;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryRuntimeException;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.config.NdRepositoryVersionManagerConfig;
import com.blazesoft.repository.config.NdRepositoryVersionManagerFactory;
import com.blazesoft.repository.config.NdStrings;
import com.blazesoft.repository.config.legacy.NdCmRepositoryConnection;
import com.blazesoft.repository.config.legacy.NdRepositoryCmVersionManagerConfig;
import com.blazesoft.repository.config.legacy.NdRepositoryConfig;
import com.blazesoft.repository.config.legacy.NdRepositoryNativeVersionManagerConfig;
import com.blazesoft.repository.file.NdFileCVSServerConnection;
import com.blazesoft.repository.file.NdFileRepositoryConfig;
import com.blazesoft.repository.file.NdFileRepositoryConnection;
import com.blazesoft.repository.generic.version.NdNativeVersioningRepositoryConnection;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryConfig;
import com.blazesoft.repository.jndi.NdLdapRepositoryConfig;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public class NdRepositoryConfigSupport {
    private static ConfigUpdateHandler WjIvqTQ;
    private static String WjIvqUR;

    private static String WjIeiBD(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        File file = new File(string);
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new NdRepositoryRuntimeException(iOException);
        }
        return string2;
    }

    private static void WjIveTP(NdRepository ndRepository) throws NdRepositoryException {
        NdRepositoryEntry[] ndRepositoryEntryArray = ndRepository.getRepositoryEntries();
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            NdRepositoryEntry ndRepositoryEntry = ndRepositoryEntryArray[i];
            if (ndRepositoryEntry.getName().equals("system") || ndRepositoryEntry.getName().equals("__Attic")) continue;
            if (ndRepositoryEntry instanceof NdRepositoryDirectory) {
                NdRepositoryConfigSupport.WjIveUQ((NdRepositoryDirectory)ndRepositoryEntry);
                continue;
            }
            NdRepositoryConfigSupport.WjIveVR(ndRepository, (NdRepositoryItem)ndRepositoryEntry);
        }
    }

    private static void WjIveUQ(NdRepositoryDirectory ndRepositoryDirectory) throws NdRepositoryException {
        NdRepositoryEntry[] ndRepositoryEntryArray = ndRepositoryDirectory.getRepositoryEntries();
        for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
            NdRepositoryEntry ndRepositoryEntry = ndRepositoryEntryArray[i];
            if (ndRepositoryEntry.getName().equals("__Attic")) continue;
            if (ndRepositoryEntry instanceof NdRepositoryDirectory) {
                NdRepositoryConfigSupport.WjIveUQ((NdRepositoryDirectory)ndRepositoryEntry);
                continue;
            }
            NdRepositoryConfigSupport.WjIveVR(ndRepositoryDirectory, (NdRepositoryItem)ndRepositoryEntry);
        }
    }

    private static void WjIveVR(NdRepositoryDirectory ndRepositoryDirectory, NdRepositoryItem ndRepositoryItem) throws NdRepositoryException {
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = ndRepositoryDirectory.getRepositoryEntryAttributes(ndRepositoryItem);
        for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
            NdRepositoryEntryAttribute ndRepositoryEntryAttribute = ndRepositoryEntryAttributeArray[i];
            if (!"innovatorItemDeletedFlag".equals(ndRepositoryEntryAttribute.getAttbId()) || !"com.blazesoft.item.flag.deleted".equalsIgnoreCase(ndRepositoryEntryAttribute.getAttbValue()) && !"true".equalsIgnoreCase(ndRepositoryEntryAttribute.getAttbValue())) continue;
            ndRepositoryDirectory.removeRepositoryItem(ndRepositoryItem);
            break;
        }
    }

    private static NdRepositoryVersionManagerConfig WjIvqVS(NdRepositoryConnection ndRepositoryConnection, com.blazesoft.repository.config.legacy.NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig) {
        NdVersioningRepositoryConnection ndVersioningRepositoryConnection;
        if (ndRepositoryVersionManagerConfig == null) {
            return null;
        }
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig2 = new NdRepositoryVersionManagerConfig();
        ndRepositoryVersionManagerConfig2.setName(ndRepositoryVersionManagerConfig.getName());
        ndRepositoryVersionManagerConfig2.setPrivateWorkspaceSupported(ndRepositoryVersionManagerConfig.isPrivateWorkspaceSupported());
        ndRepositoryVersionManagerConfig2.setRepositoryVersionManagerFactory(ndRepositoryVersionManagerConfig.getRepositoryVersionManagerFactory());
        if (ndRepositoryVersionManagerConfig instanceof NdRepositoryNativeVersionManagerConfig) {
            ndVersioningRepositoryConnection = new NdNativeVersioningRepositoryConnection();
            NdCmRepositoryConnection ndCmRepositoryConnection = ((NdRepositoryNativeVersionManagerConfig)ndRepositoryVersionManagerConfig).getCmRepositoryConnection();
            if (ndCmRepositoryConnection != null) {
                if (ndCmRepositoryConnection.getCmConnection() instanceof NdFileRepositoryConnection) {
                    try {
                        ((NdFileRepositoryConnection)ndCmRepositoryConnection.getCmConnection()).updateBaseFilePath(ndCmRepositoryConnection.obtainBaseFilePath());
                    }
                    catch (IOException iOException) {
                        throw new NdRepositoryRuntimeException(iOException);
                    }
                }
                ((NdNativeVersioningRepositoryConnection)ndVersioningRepositoryConnection).setRepositoryConnection(ndCmRepositoryConnection.getCmConnection());
            } else if (!ndRepositoryVersionManagerConfig2.isPrivateWorkspaceSupported() && ndRepositoryConnection instanceof NdWorkspaceConnection) {
                NdWorkspaceConnection ndWorkspaceConnection = (NdWorkspaceConnection)ndRepositoryConnection;
                ((NdNativeVersioningRepositoryConnection)ndVersioningRepositoryConnection).setRepositoryConnection(ndWorkspaceConnection);
            }
        } else if (ndRepositoryVersionManagerConfig instanceof NdRepositoryCmVersionManagerConfig) {
            ndVersioningRepositoryConnection = ndRepositoryConnection instanceof NdFileCVSServerConnection ? (NdVersioningRepositoryConnection)ndRepositoryConnection : new NdFileCVSServerConnection();
            NdRepositoryVersionManagerFactory ndRepositoryVersionManagerFactory = new NdRepositoryVersionManagerFactory("com.blazesoft.repository.file.NdFileCVSWorkspaceVersionManager");
            ndRepositoryVersionManagerConfig2.setRepositoryVersionManagerFactory(ndRepositoryVersionManagerFactory);
        } else {
            throw new NdRepositoryRuntimeException(NdStrings.WjHDHAS("FoundUnknownConfiguration", ndRepositoryVersionManagerConfig.getClass().getName()));
        }
        if (ndRepositoryVersionManagerConfig.getRepositoryUser() != null && ndRepositoryVersionManagerConfig.getRepositoryUser().length() > 0) {
            ndVersioningRepositoryConnection.setUser(ndRepositoryVersionManagerConfig.getRepositoryUser());
            if (ndRepositoryVersionManagerConfig2.isPrivateWorkspaceSupported()) {
                ndRepositoryVersionManagerConfig2.setWorkspaceUser(ndRepositoryVersionManagerConfig.getRepositoryUser());
            }
        }
        ndRepositoryVersionManagerConfig2.setVersioningRepositoryConnection(ndVersioningRepositoryConnection);
        return ndRepositoryVersionManagerConfig2;
    }

    public static com.blazesoft.repository.config.NdRepositoryConfig convertLegacyConfig(NdRepositoryConnection ndRepositoryConnection, NdRepositoryConfig ndRepositoryConfig) {
        if (ndRepositoryConfig == null) {
            return null;
        }
        com.blazesoft.repository.config.NdRepositoryConfig ndRepositoryConfig2 = new com.blazesoft.repository.config.NdRepositoryConfig();
        if (ndRepositoryConfig instanceof NdFileRepositoryConfig) {
            ndRepositoryConfig2.setRepositoryClassName("com.blazesoft.repository.file.NdFileRepository");
        } else if (ndRepositoryConfig instanceof NdJdbcRepositoryConfig) {
            ndRepositoryConfig2.setRepositoryClassName("com.blazesoft.repository.jdbc.NdJdbcRepository");
        } else if (ndRepositoryConfig instanceof NdLdapRepositoryConfig) {
            ndRepositoryConfig2.setRepositoryClassName("com.blazesoft.repository.jndi.NdJndiRepository");
        }
        ndRepositoryConfig2.setEntryFactoryClassName(ndRepositoryConfig.getEntryFactoryClassName());
        ndRepositoryConfig2.setRepositoryExplicitLockManagerFactory(ndRepositoryConfig.getRepositoryExplicitLockManagerFactory());
        ndRepositoryConfig2.setRepositoryImplicitLockManagerFactory(ndRepositoryConfig.getRepositoryImplicitLockManagerFactory());
        ndRepositoryConfig2.setRepositoryAuthorizationManagerFactory(ndRepositoryConfig.getRepositoryAuthorizationManagerFactory());
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig = NdRepositoryConfigSupport.WjIvqVS(ndRepositoryConnection, ndRepositoryConfig.getRepositoryVersionManagerConfig());
        if (ndRepositoryVersionManagerConfig != null) {
            ndRepositoryConfig2.setRepositoryVersionManagerConfig(ndRepositoryVersionManagerConfig);
        }
        ndRepositoryConfig2.setConnectToCMRepository(ndRepositoryConfig.getConnectToCMRepository());
        ndRepositoryConfig2.setAtticRepository(ndRepositoryConfig.isAtticRepository());
        if (ndRepositoryConnection instanceof NdWorkspaceConnection) {
            NdWorkspaceConnection ndWorkspaceConnection = (NdWorkspaceConnection)ndRepositoryConnection;
            Hashtable hashtable = ndWorkspaceConnection.getConnectionArgs();
            try {
                boolean bl;
                NdRepository ndRepository = NdRepositoryFactory.newStorageRepository(ndWorkspaceConnection);
                ndRepository.openConnection(1);
                boolean bl2 = bl = hashtable.get(WjIvqUR) == null;
                if (bl && !ndRepositoryConfig.isAtticRepository()) {
                    boolean bl3 = bl = WjIvqTQ == null || WjIvqTQ.allowSaveConfig(ndWorkspaceConnection, ndRepositoryConfig2);
                    if (!bl) {
                        hashtable.put(WjIvqUR, WjIvqUR);
                    }
                }
                if (bl) {
                    ndRepository.setRepositoryConfig(ndRepositoryConfig2);
                    if (ndRepositoryConfig.getRepositoryVersionManagerConfig() instanceof NdRepositoryNativeVersionManagerConfig && !ndRepositoryConfig.isAtticRepository()) {
                        try {
                            NdRepositoryConfigSupport.WjIveTP(ndRepository);
                        }
                        catch (NdRepositoryException ndRepositoryException) {
                            throw new NdRepositoryRuntimeException((Throwable)((Object)ndRepositoryException));
                        }
                    }
                }
                if (!ndRepositoryConfig.isAtticRepository()) {
                    NdWorkspace ndWorkspace;
                    NdRepositoryItem ndRepositoryItem = (NdRepositoryItem)ndRepository.lookupRepositoryEntry("com_blazesoft_rom_config.cfg");
                    if (ndRepositoryItem == null) {
                        ndRepositoryItem = NdRepositoryConfigSupport.migrateRomConfiguration(ndRepository);
                    }
                    if (ndRepositoryItem != null && ndWorkspaceConnection.getUser() != null) {
                        ndRepository.setRepositoryEntryAttributes(ndRepositoryItem, new NdRepositoryEntryAttribute[]{new NdRepositoryEntryAttribute("innovatorItemCreationId", ndWorkspaceConnection.getUser())});
                    }
                    ndRepository.closeConnection();
                    if (bl && (ndWorkspace = NdRepositoryFactory.newWorkspace(ndWorkspaceConnection)).getWorkspaceVersionManager() != null && ndWorkspace.getWorkspaceVersionManager().isFeatureSupported(1)) {
                        ndWorkspace.getWorkspaceVersionManager().checkIn(new NdRepositoryEntry[]{ndRepositoryItem}, "Repository Migration");
                    }
                }
            }
            catch (NdRepositoryException ndRepositoryException) {
                throw new NdRepositoryRuntimeException((Throwable)((Object)ndRepositoryException));
            }
        }
        return ndRepositoryConfig2;
    }

    public static Hashtable convertLegacyArgs(Hashtable hashtable) {
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        String string = (String)hashtable.get("com.blazesoft.repository.base.repositoryclass");
        if (string == null || string.length() == 0) {
            if (hashtable.get("com.blazesoft.repository.file.baselocation") != null) {
                string = "com.blazesoft.repository.file.NdFileRepository";
            } else if (hashtable.get("JDBC.database.url") != null) {
                string = "com.blazesoft.repository.jdbc.NdJdbcRepository";
            } else if (hashtable.get("java.naming.provider.url") != null) {
                string = "com.blazesoft.repository.jndi.NdJndiLdapRepository";
            } else if (hashtable.get("com.blazesoft.repository.url.baselocation") != null) {
                string = "com.blazesoft.repository.url.NdUrlRepository";
            } else if (hashtable.get("RMI.repository.key") != null) {
                string = "com.blazesoft.repository.rmi.NdRmiRepository";
            } else {
                throw new NdRepositoryRuntimeException(NdStrings.WjHDHyQ("RepositoryClassCouldNotBeDetermined"));
            }
        }
        hashtable2.put("com_blazesoft_repository_connectionclass", string);
        String string2 = (String)hashtable.get("com.blazesoft.repository.base.repositoryname");
        hashtable2.put("com_blazesoft_repository_repositoryname", string2);
        if (string.equals("com.blazesoft.repository.file.NdFileRepository")) {
            if (hashtable.get("file.repository.user.id") != null) {
                hashtable2.put("com_blazesoft_repository_username", (String)hashtable.get("file.repository.user.id"));
            }
            if (hashtable.get("file.repository.user.password") != null) {
                hashtable2.put("com_blazesoft_repository_password", (String)hashtable.get("file.repository.user.password"));
            }
            String string3 = hashtable.get("com.blazesoft.repository.file.baselocation") + File.separator + string2;
            hashtable2.put("com_blazesoft_repository_repositoryfolder", NdRepositoryConfigSupport.WjIeiBD(string3));
        } else if (string.equals("com.blazesoft.repository.jdbc.NdJdbcRepository")) {
            if (hashtable.get("JDBC.accessor.class") != null) {
                hashtable2.put("com_blazesoft_repository_jdbc_accessor", (String)hashtable.get("JDBC.accessor.class"));
            }
            if (hashtable.get("JDBC.database.url") != null) {
                hashtable2.put("com_blazesoft_repository_jdbc_url", (String)hashtable.get("JDBC.database.url"));
            }
            if (hashtable.get("JDBC.driver") != null) {
                hashtable2.put("com_blazesoft_repository_jdbc_driver", (String)hashtable.get("JDBC.driver"));
            }
            if (hashtable.get("JDBC.username") != null) {
                hashtable2.put("com_blazesoft_repository_username", (String)hashtable.get("JDBC.username"));
            }
            if (hashtable.get("JDBC.password") != null) {
                hashtable2.put("com_blazesoft_repository_password", (String)hashtable.get("JDBC.password"));
            }
            if (hashtable.get("JDBC.repository.table") != null) {
                hashtable2.put("com_blazesoft_repository_jdbc_table", (String)hashtable.get("JDBC.repository.table"));
            }
        } else if (string.equals("com.blazesoft.repository.jndi.NdJndiLdapRepository")) {
            if (hashtable.get("java.naming.provider.url") != null) {
                hashtable2.put("com_blazesoft_repository_jndi_url", (String)hashtable.get("java.naming.provider.url"));
            }
            if (hashtable.get("java.naming.factory.initial") != null) {
                hashtable2.put("com_blazesoft_repository_initialcontext_factory", (String)hashtable.get("java.naming.factory.initial"));
            }
            if (hashtable.get("java.naming.security.principal") != null) {
                hashtable2.put("com_blazesoft_repository_username", (String)hashtable.get("java.naming.security.principal"));
            }
            if (hashtable.get("java.naming.security.credentials") != null) {
                hashtable2.put("com_blazesoft_repository_password", (String)hashtable.get("java.naming.security.credentials"));
            }
        } else if (string.equals("com.blazesoft.repository.rmi.NdRmiRepository")) {
            if (hashtable.get("RMI.clientinfo") != null) {
                hashtable2.put("com_blazesoft_repository_clientdesp", (String)hashtable.get("RMI.clientinfo"));
            }
            if (hashtable.get("RMI.client.user.id") != null) {
                hashtable2.put("com_blazesoft_repository_username", (String)hashtable.get("RMI.client.user.id"));
            }
            if (hashtable.get("RMI.client.user.password") != null) {
                hashtable2.put("com_blazesoft_repository_password", (String)hashtable.get("RMI.client.user.password"));
            }
            if (hashtable.get("RMI.connection.url") != null) {
                hashtable2.put("com_blazesoft_repository_rmi_url", (String)hashtable.get("RMI.connection.url"));
            } else {
                String string4 = (String)hashtable.get("RMI.serverhost");
                String string5 = (String)hashtable.get("RMI.serverport");
                String string6 = (String)hashtable.get("RMI.serverprotocol");
                if (string4 == null || string4.length() == 0) {
                    string4 = "localhost";
                }
                if (string5 == null || string5.length() == 0) {
                    string5 = "1099";
                }
                if (string6 == null || string6.length() == 0) {
                    string6 = "rmi";
                }
                String string7 = string6 + "://" + string4 + ":" + string5;
                hashtable2.put("com_blazesoft_repository_rmi_url", string7);
            }
            if (hashtable.get("RMI.repository.key") != null) {
                hashtable2.put("com_blazesoft_repository_repositorykey", (String)hashtable.get("RMI.repository.key"));
            }
        }
        return hashtable2;
    }

    public static void setConfigUpdateHandler(ConfigUpdateHandler configUpdateHandler) {
        WjIvqTQ = configUpdateHandler;
    }

    public static NdRepositoryItem migrateRomConfiguration(NdRepository ndRepository) {
        NdRepositoryItem ndRepositoryItem = null;
        try {
            ndRepository.openConnection(1);
            NdRepositoryItem ndRepositoryItem2 = (NdRepositoryItem)ndRepository.lookupRepositoryEntry("_ext_config_obj_com_blazesoft_rom_config_cfg");
            if (ndRepositoryItem2 != null) {
                ndRepositoryItem = ndRepository.createRepositoryItem("com_blazesoft_rom_config.cfg");
                ndRepository.addRepositoryItem(ndRepositoryItem, ndRepositoryItem2.getContent(), null);
                ndRepository.removeRepositoryItem(ndRepositoryItem2);
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw new NdRepositoryRuntimeException((Throwable)((Object)ndRepositoryException));
        }
        return ndRepositoryItem;
    }

    static {
        WjIvqUR = "not.save.configuration";
    }

    public static interface ConfigUpdateHandler {
        public boolean allowSaveConfig(NdWorkspaceConnection var1, com.blazesoft.repository.config.NdRepositoryConfig var2);
    }
}

