/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.file;

import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryFactory;
import com.blazesoft.repository.base.NdRepositoryNotSupportedException;
import com.blazesoft.repository.base.NdRepositoryVersionSystemAdmin;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigWriter;
import com.blazesoft.repository.config.NdRepositoryVersionManagerConfig;
import com.blazesoft.repository.file.NdFileCVSCommandException;
import com.blazesoft.repository.file.NdFileCVSServerConnection;
import com.blazesoft.repository.file.NdFileCVSUpdatedDirectoryHandler;
import com.blazesoft.repository.file.NdFileRepositoryConnection;
import com.blazesoft.repository.file.NdStrings;
import com.blazesoft.repository.file.WjIqjAO;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.util.WjHzAhT;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.commit.CommitCommand;
import org.netbeans.lib.cvsclient.command.importcmd.ImportCommand;
import org.netbeans.lib.cvsclient.command.status.StatusCommand;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.CVSAdapter;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.file.FileStatus;

public class NdFileCVSRepositoryVersionSystemAdmin
extends CVSAdapter
implements NdRepositoryVersionSystemAdmin {
    private static final String WjIqlNN = "Created configuration file for Blaze Advisor repository";
    private static final String WjIqlNO = "Updated configuration file for Blaze Advisor repository";
    private static final String WjIqlNP = "Created Blaze Advisor repository";
    private Vector WjIqlNQ;
    private boolean WjIvhxC;

    public void createVersioningRepository(NdRepositoryConfig ndRepositoryConfig) throws NdRepositoryException {
        File file;
        Object object;
        NdFileCVSServerConnection ndFileCVSServerConnection = null;
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig = ndRepositoryConfig.getRepositoryVersionManagerConfig();
        if (ndRepositoryVersionManagerConfig == null) {
            throw new NdRepositoryException(NdStrings.WjHzCXY("CouldNotFindVersionManagerConfiguration"));
        }
        try {
            ndFileCVSServerConnection = (NdFileCVSServerConnection)ndRepositoryVersionManagerConfig.getVersioningRepositoryConnection();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (ndFileCVSServerConnection == null) {
            throw new NdRepositoryException(NdStrings.WjHzCXY("CouldNotFindVersioningConnectionFromConfig"));
        }
        CVSRoot cVSRoot = WjIqjAO.WjIqjAN(ndFileCVSServerConnection);
        try {
            object = File.createTempFile(new WjHzAhT().toString(), null);
            file = new File(((File)object).getParentFile(), new WjHzAhT().toString());
            ((File)object).delete();
            if (!file.mkdir()) {
                throw new NdRepositoryException(NdStrings.WjHzCYA("UnableToCreateTemporaryDirectory", file.getCanonicalPath()));
            }
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
        try {
            object = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
        this.WjIvhxC = ndFileCVSServerConnection.getDisableMultipleCommands();
        Client client = this.WjIvhzE(cVSRoot, (String)object);
        ImportCommand importCommand = new ImportCommand();
        importCommand.setVendorTag("DummyVendorTag");
        importCommand.setReleaseTag("DummyReleaseTag");
        String string = ndFileCVSServerConnection.getRepositoryName();
        if (string == null || string.length() == 0) {
            throw new NdRepositoryException(NdStrings.WjHzCXY("NoRepositoryNameSpecified"));
        }
        importCommand.setModule(string);
        importCommand.setLogMessage(WjIqlNP);
        this.WjIqlNS(client, (Command)importCommand, cVSRoot);
        client = this.WjIvhyD(client, cVSRoot);
        CheckoutCommand checkoutCommand = new CheckoutCommand();
        checkoutCommand.setRecursive(false);
        checkoutCommand.setModule(string);
        this.WjIqlNS(client, (Command)checkoutCommand, cVSRoot);
        String string2 = ndFileCVSServerConnection.getBranch();
        if (string2 != null) {
            try {
                WjIqjAO.WjIyrlI(new File((String)object, string), string2);
            }
            catch (IOException iOException) {
                throw new NdRepositoryException(iOException);
            }
        }
        NdRepositoryConfigWriter ndRepositoryConfigWriter = new NdRepositoryConfigWriter();
        File file2 = new File((String)object, string);
        File file3 = new File(file2, "com_blazesoft_repository_config.cfg");
        try {
            ndRepositoryConfigWriter.save(file3.getCanonicalPath(), ndRepositoryConfig);
        }
        catch (IOException iOException) {
            this.WjIqlNT(client);
            throw new NdRepositoryException(iOException);
        }
        client = this.WjIvhyD(client, cVSRoot);
        client.setLocalPath(file2.getPath());
        AddCommand addCommand = new AddCommand();
        addCommand.setFiles(new File[]{file3});
        this.WjIqlNS(client, (Command)addCommand, cVSRoot);
        client = this.WjIvhyD(client, cVSRoot);
        CommitCommand commitCommand = new CommitCommand();
        commitCommand.setFiles(new File[]{file3});
        commitCommand.setMessage(WjIqlNN);
        commitCommand.setRecursive(false);
        this.WjIqlNS(client, (Command)commitCommand, cVSRoot);
        this.WjIqlNT(client);
        this.WjIqlNU(file);
    }

    private Client WjIvhyD(Client client, CVSRoot cVSRoot) throws NdRepositoryException {
        if (this.WjIvhxC && !client.isFirstCommand()) {
            String string = client.getLocalPath();
            this.WjIqlNT(client);
            client = this.WjIvhzE(cVSRoot, string);
        }
        return client;
    }

    private Client WjIvhzE(CVSRoot cVSRoot, String string) throws NdRepositoryException {
        Client client = WjIqjAO.WjIvgdQ(cVSRoot, string);
        client.getEventManager().addCVSListener((CVSListener)this);
        return client;
    }

    private void WjIqlNS(Client client, Command command, CVSRoot cVSRoot) throws NdRepositoryException {
        this.WjIrgsM(client, command, cVSRoot, null);
    }

    private void WjIrgsM(Client client, Command command, CVSRoot cVSRoot, CVSListener cVSListener) throws NdRepositoryException {
        this.WjIqlNQ = new Vector();
        GlobalOptions globalOptions = new GlobalOptions();
        globalOptions.setCompressionLevel(0);
        globalOptions.setUseGzip(false);
        globalOptions.setCVSRoot(cVSRoot.toString());
        if (cVSListener != null) {
            client.getEventManager().addCVSListener(cVSListener);
        }
        try {
            if (!client.executeCommand(command, globalOptions)) {
                Object[] objectArray = new String[this.WjIqlNQ.size()];
                this.WjIqlNQ.copyInto(objectArray);
                throw new NdFileCVSCommandException(command.getCVSCommand(), (String[])objectArray);
            }
        }
        catch (CommandAbortedException commandAbortedException) {
            this.WjIqlNT(client);
            throw new NdRepositoryException(commandAbortedException);
        }
        catch (CommandException commandException) {
            this.WjIqlNT(client);
            throw new NdRepositoryException(commandException);
        }
        catch (AuthenticationException authenticationException) {
            this.WjIqlNT(client);
            throw new NdRepositoryException(authenticationException);
        }
        finally {
            this.WjIqlNQ = null;
            if (cVSListener != null) {
                client.getEventManager().removeCVSListener(cVSListener);
            }
        }
    }

    private void WjIqlNT(Client client) throws NdRepositoryException {
        WjIqjAO.WjIvgdR(client);
    }

    private void WjIqlNU(File file) throws NdRepositoryException {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.WjIqlNU(fileArray[i]);
            }
        }
        if (!file.delete()) {
            try {
                throw new NdRepositoryException(NdStrings.WjHzCYA("UnableToDeleteFile", file.getCanonicalPath()));
            }
            catch (IOException iOException) {
                throw new NdRepositoryException(iOException);
            }
        }
    }

    public void removeVersioningRepository(NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "removeVersioningRepository");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRepositoryWorkspace(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        String[] stringArray;
        NdFileCVSServerConnection ndFileCVSServerConnection = this.WjIqlNW(ndVersioningRepositoryConnection);
        NdFileRepositoryConnection ndFileRepositoryConnection = this.WjIqlNV(ndWorkspaceConnection);
        CVSRoot cVSRoot = WjIqjAO.WjIqjAN(ndFileCVSServerConnection);
        File file = new File(ndFileRepositoryConnection.getRepositoryFolder());
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new NdRepositoryException(NdStrings.WjHzCYA("FailedToCreateWorkspaceBecauseFileAlreadyExists", file.getAbsolutePath()));
            }
            stringArray = file.list();
            if (stringArray != null && stringArray.length > 0) {
                throw new NdRepositoryException(NdStrings.WjHzCYA("FailedToCreateWorkspaceBecauseIsNotEmpty", file.getAbsolutePath()));
            }
        }
        try {
            stringArray = file.getCanonicalPath();
            file = new File((String)stringArray);
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdir();
        }
        this.WjIvhxC = ndFileCVSServerConnection.getDisableMultipleCommands();
        Client client = this.WjIvhzE(cVSRoot, file2.getPath());
        String string = ndFileCVSServerConnection.getRepositoryName();
        if (string == null || string.length() == 0) {
            throw new NdRepositoryException(NdStrings.WjHzCXY("NoRepositoryNameSpecified"));
        }
        CheckoutCommand checkoutCommand = new CheckoutCommand();
        checkoutCommand.setRecursive(false);
        checkoutCommand.setModule(string);
        NdFileCVSUpdatedDirectoryHandler ndFileCVSUpdatedDirectoryHandler = new NdFileCVSUpdatedDirectoryHandler();
        String string2 = ndFileCVSServerConnection.getBranch();
        if (string2 != null) {
            checkoutCommand.setCheckoutByRevision(string2);
        }
        this.WjIrgsM(client, (Command)checkoutCommand, cVSRoot, (CVSListener)ndFileCVSUpdatedDirectoryHandler);
        File file3 = new File(file2, string);
        client = this.WjIvhyD(client, cVSRoot);
        client.setLocalPath(file3.getPath());
        StatusCommand statusCommand = new StatusCommand();
        statusCommand.setRecursive(false);
        statusCommand.setIncludeTags(false);
        File file4 = new File(file3, "com_blazesoft_repository_config.cfg");
        statusCommand.setFiles(new File[]{file4});
        WjIqfTZ wjIqfTZ = new WjIqfTZ();
        client.getEventManager().addCVSListener((CVSListener)wjIqfTZ);
        try {
            this.WjIqlNS(client, (Command)statusCommand, cVSRoot);
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)wjIqfTZ);
        }
        String string3 = wjIqfTZ.WjIqfTX();
        if (string3 == null || string3.trim().length() == 0) {
            this.WjIqlNT(client);
            throw new NdRepositoryException(NdStrings.WjHzCYA("CouldNotObtainVersion", "com_blazesoft_repository_config.cfg"));
        }
        client = this.WjIvhyD(client, cVSRoot);
        UpdateCommand updateCommand = new UpdateCommand();
        updateCommand.setFiles(new File[]{file4});
        updateCommand.setUpdateByRevision(string3);
        updateCommand.setRecursive(false);
        this.WjIqlNS(client, (Command)updateCommand, cVSRoot);
        client = this.WjIvhyD(client, cVSRoot);
        client.getEventManager().removeCVSListener((CVSListener)this);
        GlobalOptions globalOptions = new GlobalOptions();
        globalOptions.setCompressionLevel(0);
        globalOptions.setUseGzip(false);
        globalOptions.setCVSRoot(cVSRoot.toString());
        ndFileCVSUpdatedDirectoryHandler.WjIvcxA(client, file3, string, globalOptions, cVSRoot, this.WjIvhxC);
        this.WjIqlNT(client);
        if (!string.equals(file.getName())) {
            if (file.exists() && !file.delete()) {
                throw new NdRepositoryException(NdStrings.WjHzCYA("WorkspaceNotEmpty", file.getPath()));
            }
            if (!file3.renameTo(file)) {
                throw new NdRepositoryException(NdStrings.WjHzDaC("UnableToRenameModule", string, file.getName(), file2.getPath()));
            }
        }
        NdRepository ndRepository = NdRepositoryFactory.newStorageRepository(ndFileRepositoryConnection);
        ndRepository.openConnection(1);
        NdRepositoryConfig ndRepositoryConfig = ndRepository.getRepositoryConfig();
        ndRepositoryConfig.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection().setUser(ndFileRepositoryConnection.getUser());
        ndRepositoryConfig.getRepositoryVersionManagerConfig().setWorkspaceUser(ndFileRepositoryConnection.getUser());
        if (!ndFileCVSServerConnection.isPersistCredentials()) {
            ndRepositoryConfig.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection().setCredentials(null);
        }
        ndRepository.setRepositoryConfig(ndRepositoryConfig);
        ndRepository.closeConnection();
    }

    private NdFileRepositoryConnection WjIqlNV(NdWorkspaceConnection ndWorkspaceConnection) throws NdRepositoryException {
        NdFileRepositoryConnection ndFileRepositoryConnection;
        try {
            ndFileRepositoryConnection = (NdFileRepositoryConnection)ndWorkspaceConnection;
        }
        catch (ClassCastException classCastException) {
            throw new NdRepositoryException(NdStrings.WjHzCXY("InvalidWorkspaceConnection"));
        }
        return ndFileRepositoryConnection;
    }

    private NdFileCVSServerConnection WjIqlNW(NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        if (!(ndVersioningRepositoryConnection instanceof NdFileCVSServerConnection)) {
            throw new NdRepositoryException(NdStrings.WjHzCXY("InvalidRepositoryConnection"));
        }
        NdFileCVSServerConnection ndFileCVSServerConnection = (NdFileCVSServerConnection)ndVersioningRepositoryConnection;
        return ndFileCVSServerConnection;
    }

    public void removeRepositoryWorkspace(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "removeRepositoryWorkspace");
    }

    public NdRepositoryEntryLockInfo[] listCheckedOutEntries(NdLocation ndLocation, boolean bl, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "listCheckedOutEntries");
    }

    public void releaseCheckedOutEntries(NdLocation ndLocation, boolean bl, String string, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "releaseCheckedOutEntries");
    }

    public void releaseCheckedOutEntries(NdLocation[] ndLocationArray, String string, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "releaseCheckedOutEntries");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitWorkspaceConfiguration(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        NdFileCVSServerConnection ndFileCVSServerConnection = this.WjIqlNW(ndVersioningRepositoryConnection);
        NdFileRepositoryConnection ndFileRepositoryConnection = this.WjIqlNV(ndWorkspaceConnection);
        CVSRoot cVSRoot = WjIqjAO.WjIqjAN(ndFileCVSServerConnection);
        this.WjIvhxC = ndFileCVSServerConnection.getDisableMultipleCommands();
        Client client = this.WjIvhzE(cVSRoot, ndFileRepositoryConnection.getRepositoryFolder());
        File file = new File(ndFileRepositoryConnection.getRepositoryFolder());
        File file2 = new File(file, "com_blazesoft_repository_config.cfg");
        this.WjIqlNX(ndWorkspaceConnection, client, file2, cVSRoot);
        client = this.WjIvhyD(client, cVSRoot);
        CommitCommand commitCommand = new CommitCommand();
        commitCommand.setFiles(new File[]{file2});
        commitCommand.setRecursive(false);
        commitCommand.setMessage(WjIqlNO);
        this.WjIqlNS(client, (Command)commitCommand, cVSRoot);
        client = this.WjIvhyD(client, cVSRoot);
        StatusCommand statusCommand = new StatusCommand();
        statusCommand.setRecursive(false);
        statusCommand.setIncludeTags(false);
        statusCommand.setFiles(new File[]{file2});
        WjIqfTZ wjIqfTZ = new WjIqfTZ();
        client.getEventManager().addCVSListener((CVSListener)wjIqfTZ);
        try {
            this.WjIqlNS(client, (Command)statusCommand, cVSRoot);
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)wjIqfTZ);
        }
        client = this.WjIvhyD(client, cVSRoot);
        String string = wjIqfTZ.WjIqfTX();
        UpdateCommand updateCommand = new UpdateCommand();
        updateCommand.setRecursive(false);
        updateCommand.setFiles(new File[]{file2});
        updateCommand.setUpdateByRevision(string);
        this.WjIqlNS(client, (Command)updateCommand, cVSRoot);
        this.WjIqlNT(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void WjIqlNX(NdWorkspaceConnection ndWorkspaceConnection, Client client, File file, CVSRoot cVSRoot) throws NdRepositoryException {
        StatusCommand statusCommand = new StatusCommand();
        statusCommand.setRecursive(false);
        statusCommand.setIncludeTags(false);
        statusCommand.setFiles(new File[]{file});
        WjIqfTZ wjIqfTZ = new WjIqfTZ();
        client.getEventManager().addCVSListener((CVSListener)wjIqfTZ);
        try {
            this.WjIqlNS(client, (Command)statusCommand, cVSRoot);
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)wjIqfTZ);
        }
        String string = wjIqfTZ.WjIqfTX();
        NdRepository ndRepository = NdRepositoryFactory.newStorageRepository(ndWorkspaceConnection);
        NdRepositoryConfig ndRepositoryConfig = ndRepository.getRepositoryConfig();
        client = this.WjIvhyD(client, cVSRoot);
        UpdateCommand updateCommand = new UpdateCommand();
        updateCommand.setRecursive(false);
        updateCommand.setFiles(new File[]{file});
        updateCommand.setResetStickyOnes(true);
        this.WjIqlNS(client, (Command)updateCommand, cVSRoot);
        client = this.WjIvhyD(client, cVSRoot);
        statusCommand = new StatusCommand();
        statusCommand.setRecursive(false);
        statusCommand.setIncludeTags(false);
        statusCommand.setFiles(new File[]{file});
        wjIqfTZ = new WjIqfTZ();
        client.getEventManager().addCVSListener((CVSListener)wjIqfTZ);
        try {
            this.WjIqlNS(client, (Command)statusCommand, cVSRoot);
        }
        finally {
            client.getEventManager().removeCVSListener((CVSListener)wjIqfTZ);
        }
        if (wjIqfTZ.WjIqfTY()) {
            this.WjIqlNU(file);
            client = this.WjIvhyD(client, cVSRoot);
            updateCommand = new UpdateCommand();
            updateCommand.setRecursive(false);
            updateCommand.setFiles(new File[]{file});
            updateCommand.setUpdateByRevision(string);
            this.WjIqlNS(client, (Command)updateCommand, cVSRoot);
            this.WjIqlNT(client);
            ndRepository.setRepositoryConfig(ndRepositoryConfig);
            throw new NdRepositoryException(NdStrings.WjHzCYA("ConflictWhileUpdatingOutOfDateFile", file.getPath()));
        }
    }

    public void updateWorkspaceConfiguration(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        NdFileCVSServerConnection ndFileCVSServerConnection = this.WjIqlNW(ndVersioningRepositoryConnection);
        NdFileRepositoryConnection ndFileRepositoryConnection = this.WjIqlNV(ndWorkspaceConnection);
        CVSRoot cVSRoot = WjIqjAO.WjIqjAN(ndFileCVSServerConnection);
        this.WjIvhxC = ndFileCVSServerConnection.getDisableMultipleCommands();
        Client client = this.WjIvhzE(cVSRoot, ndFileRepositoryConnection.getRepositoryFolder());
        File file = new File(ndFileRepositoryConnection.getRepositoryFolder());
        File file2 = new File(file, "com_blazesoft_repository_config.cfg");
        this.WjIqlNX(ndWorkspaceConnection, client, file2, cVSRoot);
        this.WjIqlNT(client);
    }

    public void messageSent(MessageEvent messageEvent) {
        if (messageEvent.isError()) {
            this.WjIqlNQ.addElement(messageEvent.getMessage());
        }
    }

    static {
        System.getProperties().put("javacvs.multiple_commands_warning", "false");
    }

    private class WjIqfTZ
    extends CVSAdapter {
        private String WjIqfTV;
        private boolean WjIqfTW;

        private WjIqfTZ() {
        }

        public void fileInfoGenerated(FileInfoEvent fileInfoEvent) {
            StatusInformation statusInformation = (StatusInformation)fileInfoEvent.getInfoContainer();
            this.WjIqfTV = statusInformation.getWorkingRevision();
            FileStatus fileStatus = statusInformation.getStatus();
            this.WjIqfTW = fileStatus == FileStatus.HAS_CONFLICTS || fileStatus == FileStatus.UNRESOLVED_CONFLICT;
        }

        String WjIqfTX() {
            return this.WjIqfTV;
        }

        boolean WjIqfTY() {
            return this.WjIqfTW;
        }
    }
}

