/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.file;

import com.blazesoft.repository.config.legacy.NdRepositoryVersionCommand;
import com.blazesoft.repository.file.NdStrings;
import com.blazesoft.scm.NdScmCommandExecution;
import com.blazesoft.scm.config.NdScmCmdOption;
import com.blazesoft.scm.config.NdScmCommand;
import com.blazesoft.scm.config.NdScmException;
import com.blazesoft.util.NdSystemProperties;
import com.blazesoft.util.WjHBnHN;
import com.blazesoft.util.WjHBnPQ;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class NdFileCmdVersionCommandExecutionImpl
implements NdScmCommandExecution {
    protected NdScmCommand scmCommand;
    protected String[] commandDirs;
    protected Vector argvGroup;
    protected String[] env;

    public void setEnvVariables(String[] stringArray) throws NdScmException {
        this.env = stringArray;
    }

    public void setCommand(NdScmCommand ndScmCommand) throws NdScmException {
        this.scmCommand = ndScmCommand;
        if (ndScmCommand instanceof NdRepositoryVersionCommand) {
            this.scmCommand.setOption((NdScmCmdOption[])((NdRepositoryVersionCommand)ndScmCommand).getRepositoryVersionCommandOption());
        }
        this.setupArgvGroups();
    }

    public String execute() throws NdScmException {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = null;
        if (this.commandDirs != null && this.commandDirs.length > 0) {
            for (int i = 0; i < this.commandDirs.length; ++i) {
                stringArray = (String[])this.argvGroup.elementAt(i);
                String string = null;
                string = this.executeCommand(this.commandDirs[i], stringArray);
                stringBuffer.append(string);
            }
        } else {
            return this.executeCommand((String[])this.argvGroup.elementAt(0));
        }
        return stringBuffer.toString();
    }

    protected String executeCommand(String[] stringArray) throws NdScmException {
        return this.executeCommand(null, stringArray);
    }

    protected String extractCommandResult(WjHBnHN wjHBnHN, File file) throws NdScmException {
        if (wjHBnHN.WjHBnHM() == 0) {
            this.scmCommand.setCommandSuccessful(true);
        } else {
            this.scmCommand.setCommandSuccessful(false);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = wjHBnHN.WjHBnHK();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + "\n");
        }
        String[] stringArray2 = wjHBnHN.WjHBnHL();
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuffer.append(stringArray2[i] + "\n");
        }
        String string = stringBuffer.toString();
        if (file != null) {
            file.delete();
            if (string != null) {
                for (int i = 0; i < 2; ++i) {
                    int n = string.trim().indexOf(10);
                    if (n < 0) continue;
                    string = string.substring(n).trim();
                }
            }
        }
        return string;
    }

    protected void setupArgvGroups() {
        int n;
        Serializable serializable;
        Vector<String> vector;
        int n2 = 0;
        String[] stringArray = null;
        Hashtable<String, Vector<String>> hashtable = null;
        String[] stringArray2 = this.scmCommand.getCommandContent();
        if (stringArray2 != null && stringArray2.length > 0) {
            n2 = stringArray2.length;
        }
        if ((stringArray = this.scmCommand.getFiles()) != null && stringArray.length > 0) {
            String string = null;
            Vector<String> vector2 = new Vector<String>();
            vector = null;
            serializable = null;
            hashtable = new Hashtable<String, Vector<String>>();
            for (n = 0; n < stringArray.length; ++n) {
                serializable = new File(stringArray[n]);
                string = ((File)serializable).getName();
                String string2 = this.scmCommand.getGoSelectedDirectory() && ((File)serializable).isDirectory() ? ((File)serializable).getAbsolutePath() : ((File)serializable).getParent();
                if (string2 == null) {
                    string2 = NdSystemProperties.getSystemProperty((String)"user.dir");
                }
                if ((vector = (Vector)hashtable.get(string2)) == null) {
                    vector = new Vector<String>();
                    vector.addElement(string);
                    vector2.addElement(string2);
                    hashtable.put(string2, vector);
                    continue;
                }
                vector.addElement(string);
            }
            this.commandDirs = new String[vector2.size()];
            vector2.copyInto(this.commandDirs);
        }
        this.argvGroup = new Vector();
        if (this.commandDirs != null && this.commandDirs.length > 0) {
            boolean bl = NdSystemProperties.isOSWindows();
            for (int i = 0; i < this.commandDirs.length; ++i) {
                vector = (Vector<String>)hashtable.get(this.commandDirs[i]);
                serializable = new Vector();
                if (!bl) {
                    for (n = 0; n < stringArray2.length; ++n) {
                        if (!stringArray2[n].startsWith("\"") || !stringArray2[n].endsWith("\"")) continue;
                        stringArray2[n] = stringArray2[n].substring(1, stringArray2[n].length() - 1);
                    }
                }
                if (!this.scmCommand.getGoSelectedDirectory()) {
                    for (n = 0; n < vector.size(); ++n) {
                        String string = (String)vector.elementAt(n);
                        if (bl && !string.startsWith("\"") && string.indexOf(" ") > 0) {
                            string = "\"" + string + "\"";
                        }
                        ((Vector)serializable).addElement(string);
                    }
                }
                String[] stringArray3 = new String[n2 + ((Vector)serializable).size()];
                System.arraycopy(stringArray2, 0, stringArray3, 0, n2);
                int n3 = ((Vector)serializable).size();
                for (int j = 0; j < n3; ++j) {
                    stringArray3[j + n2] = (String)((Vector)serializable).elementAt(j);
                }
                this.argvGroup.addElement(stringArray3);
            }
        } else {
            this.argvGroup.addElement(stringArray2);
        }
    }

    protected String executeCommand(String string, String[] stringArray) throws NdScmException {
        WjHBnHN wjHBnHN;
        String[] stringArray2;
        File file = new File(string);
        if (!file.exists()) {
            throw new NdScmException(NdStrings.WjHzCXY("RepositoryItemOrEntryDoesNotExist"));
        }
        if (stringArray.length > 1) {
            stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        } else {
            stringArray2 = null;
        }
        try {
            wjHBnHN = WjHBnPQ.WjHBnPO((String)stringArray[0], (String[])stringArray2, (String[])this.env, (String)string);
        }
        catch (IOException iOException) {
            throw new NdScmException((Throwable)iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new NdScmException((Throwable)interruptedException);
        }
        return this.extractCommandResult(wjHBnHN, null);
    }
}

