/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.file;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAlreadyExistsException;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryEntryAttributeFilter;
import com.blazesoft.repository.base.NdRepositoryEntryAttributeProvider;
import com.blazesoft.repository.base.NdRepositoryEntryNotFoundException;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositoryItemContentDefConverterContext;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.file.NdFileEntryRepositoryException;
import com.blazesoft.repository.file.NdFileRepository;
import com.blazesoft.repository.file.NdFileRepositoryEntry;
import com.blazesoft.repository.file.NdFileRepositoryEntryFactory;
import com.blazesoft.repository.file.NdFileRepositoryItem;
import com.blazesoft.repository.file.NdStrings;
import com.blazesoft.repository.file.WjHAtgC;
import com.blazesoft.repository.file.WjHzzPL;
import com.blazesoft.util.NdHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class NdFileRepositoryDirectory
extends NdFileRepositoryEntry
implements NdRepositoryDirectory,
NdRepositoryEntryAttributeFilter {
    private static final NdRepositoryEntryAttribute[] WjIegTT = new NdRepositoryEntryAttribute[0];
    private WjHzzPL WjIadkP;

    NdFileRepositoryDirectory(NdFileRepositoryDirectory ndFileRepositoryDirectory, String string, File file) throws NdRepositoryException {
        super(ndFileRepositoryDirectory, string, file);
        this.createAttributeSupport();
    }

    NdFileRepositoryDirectory() {
    }

    protected void createAttributeSupport() throws NdRepositoryException {
        if (this.WjIadkP == null && this.getFile() != null) {
            this.WjIadkP = new WjHAtgC(this);
        }
    }

    public NdRepositoryEntry[] getRepositoryEntries() throws NdRepositoryException {
        Object[] objectArray;
        try {
            String[] stringArray = this.getFile().list();
            if (stringArray != null) {
                NdHashMap ndHashMap = new NdHashMap(stringArray.length, 1.0f);
                for (int i = 0; i < stringArray.length; ++i) {
                    ndHashMap.put((Object)stringArray[i], (Object)Boolean.TRUE);
                }
                Vector<NdRepositoryEntry> vector = new Vector<NdRepositoryEntry>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string;
                    NdRepositoryEntry ndRepositoryEntry;
                    if (stringArray[i].startsWith(".") || stringArray[i].endsWith(".innovator_attbs") || (ndRepositoryEntry = this.lookupRepositoryEntry(stringArray[i])) == null || ndRepositoryEntry instanceof NdRepositoryItem && !ndHashMap.containsKey((Object)(string = stringArray[i] + ".innovator_attbs"))) continue;
                    vector.addElement(ndRepositoryEntry);
                }
                objectArray = new NdRepositoryEntry[vector.size()];
                if (vector.size() > 0) {
                    vector.copyInto(objectArray);
                }
            } else {
                objectArray = new NdRepositoryEntry[]{};
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("CouldNotListFiles", this.getName()), this, exception);
        }
        return objectArray;
    }

    public NdRepositoryDirectory createRepositoryDirectory(String string) throws NdRepositoryException {
        this.checkWriteMode();
        return new NdFileRepositoryDirectory(this, string, null);
    }

    public void addRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        try {
            this.checkWriteMode();
            File file = ((NdFileRepositoryDirectory)ndRepositoryDirectory).getFile();
            if (file == null) {
                file = new File(this.getFile(), ndRepositoryDirectory.getName());
                ((NdFileRepositoryDirectory)ndRepositoryDirectory).WjIahLZ(file);
            }
            if (file.exists()) {
                throw new NdRepositoryEntryAlreadyExistsException(NdStrings.WjHzCZB("EntryAlreadyExist", ndRepositoryDirectory.getName(), this.getName()));
            }
            file.mkdir();
            this.createAttributeSupport();
            if (ndRepositoryEntryAttributeArray != null && ndRepositoryEntryAttributeArray.length > 0) {
                this.WjIadkP.WjHzzPJ(ndRepositoryDirectory, ndRepositoryEntryAttributeArray);
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("CouldNotCreateDirectory", ndRepositoryDirectory.getName()), this, exception);
        }
    }

    private static void WjIadkR(File file) throws IOException {
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (file2.isDirectory()) {
                    NdFileRepositoryDirectory.WjIadkR(file2);
                }
                file2.delete();
            }
        }
        file.delete();
    }

    public void removeRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory) throws NdRepositoryException {
        try {
            this.checkWriteMode();
            if (!((NdFileRepositoryDirectory)ndRepositoryDirectory).getFile().exists()) {
                throw new NdRepositoryEntryNotFoundException(NdRepositorySupport.getLocation(this).appendExternalComponent(ndRepositoryDirectory.getName()));
            }
            File file = ((NdFileRepositoryDirectory)ndRepositoryDirectory).getFile();
            NdFileRepositoryDirectory.WjIadkR(file);
            this.WjIadkP.WjHAsXI(ndRepositoryDirectory);
            file.delete();
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("CouldNotRemoveDirectory", ndRepositoryDirectory.getName()), this, exception);
        }
    }

    public NdRepositoryItem createRepositoryItem(String string) throws NdRepositoryException {
        this.checkWriteMode();
        return new NdFileRepositoryItem(this, string, null);
    }

    public void addRepositoryItem(NdRepositoryItem ndRepositoryItem, NdRepositoryItemContent ndRepositoryItemContent, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        NdFileRepository ndFileRepository = (NdFileRepository)NdRepositorySupport.getRepository(this);
        try {
            this.checkWriteMode();
            ndRepositoryItemContent.setItemContentConverter(ndFileRepository.getRepositoryItemContentConverter());
            ndRepositoryItemContent.setItemContentConverterContext(new NdRepositoryItemContentDefConverterContext(ndFileRepository, ndRepositoryItem));
            File file = ((NdFileRepositoryItem)ndRepositoryItem).getFile();
            if (file == null) {
                file = new File(this.getFile(), ndRepositoryItem.getName());
                ((NdFileRepositoryItem)ndRepositoryItem).WjIahLZ(file);
            }
            if (file.exists()) {
                throw new NdRepositoryEntryAlreadyExistsException(NdStrings.WjHzCZB("EntryAlreadyExist", ndRepositoryItem.getName(), this.getName()));
            }
            byte[] byArray = ndRepositoryItemContent.getRawData();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            this.createAttributeSupport();
            this.WjIadkP.WjHzzPJ(ndRepositoryItem, ndRepositoryEntryAttributeArray);
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("CouldNotCreateFile", ndRepositoryItem.getName()), this, exception);
        }
    }

    public void removeRepositoryItem(NdRepositoryItem ndRepositoryItem) throws NdRepositoryException {
        try {
            this.checkWriteMode();
            File file = ((NdFileRepositoryItem)ndRepositoryItem).getFile();
            if (!file.exists()) {
                throw new NdRepositoryEntryNotFoundException(NdRepositorySupport.getLocation(this).appendExternalComponent(ndRepositoryItem.getName()));
            }
            this.WjIadkP.WjHAsXI(ndRepositoryItem);
            NdDotNETLib.getFileSupport().getFile(((NdFileRepositoryItem)ndRepositoryItem).getFile().getAbsolutePath()).delete();
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("CouldNotRemoveFile", ndRepositoryItem.getName()), this, exception);
        }
    }

    public NdRepositoryEntryAttribute[] getRepositoryEntryAttributes(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        if (ndRepositoryEntry instanceof NdRepositoryEntryAttributeProvider) {
            return ((NdRepositoryEntryAttributeProvider)((Object)ndRepositoryEntry)).getRepositoryEntryAttributes(null);
        }
        this.createAttributeSupport();
        try {
            return this.WjIadkP.WjHKcKV(ndRepositoryEntry);
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("CouldNotGetEntryAttributes", ndRepositoryEntry.getName()), this, exception);
        }
    }

    public NdRepositoryEntryAttribute[] getFilteredAttributes(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        if (ndRepositoryEntry instanceof NdRepositoryEntryAttributeProvider) {
            if (ndRepositoryEntry instanceof NdRepositoryEntryAttributeFilter) {
                return ((NdRepositoryEntryAttributeFilter)((Object)ndRepositoryEntry)).getFilteredAttributes(ndRepositoryEntry);
            }
            return WjIegTT;
        }
        this.createAttributeSupport();
        try {
            return this.WjIadkP.getFilteredAttributes(ndRepositoryEntry);
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("CouldNotGetEntryAttributes", ndRepositoryEntry.getName()), this, exception);
        }
    }

    public void setRepositoryEntryAttributes(NdRepositoryEntry ndRepositoryEntry, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        this.checkWriteMode();
        this.createAttributeSupport();
        try {
            this.WjIadkP.WjHzzPJ(ndRepositoryEntry, ndRepositoryEntryAttributeArray);
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdFileEntryRepositoryException(NdStrings.WjHzCYA("CouldNotSetEntryAttributes", ndRepositoryEntry.getName()), this, exception);
        }
    }

    public NdRepositoryEntry lookupRepositoryEntry(String string) throws NdRepositoryException {
        NdFileRepository ndFileRepository = (NdFileRepository)NdRepositorySupport.getRepository(this);
        NdFileRepositoryEntryFactory ndFileRepositoryEntryFactory = ndFileRepository.getRepositoryEntryFactory();
        return ndFileRepositoryEntryFactory.getFileRepositoryEntry(this, string);
    }
}

