/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.generic.version;

import com.blazesoft.repository.base.NdCredentialsProviderUtil;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryAdmin;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryFactory;
import com.blazesoft.repository.base.NdRepositoryVersionException;
import com.blazesoft.repository.base.NdRepositoryVersionSystemAdmin;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.config.NdRepositoryAdminFactory;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryVersionManagerConfig;
import com.blazesoft.repository.file.NdFileRepositoryConnection;
import com.blazesoft.repository.generic.version.NdNativeRepositoryVersionManager;
import com.blazesoft.repository.generic.version.NdNativeVersioningRepositoryConnection;
import com.blazesoft.repository.generic.version.NdStrings;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.naming.NdLocationFactory;
import com.blazesoft.util.NdIOUtil;
import java.io.File;

public class NdNativeRepositoryVersionSystemAdmin
implements NdRepositoryVersionSystemAdmin {
    public void createVersioningRepository(NdRepositoryConfig ndRepositoryConfig) throws NdRepositoryException {
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig = ndRepositoryConfig.getRepositoryVersionManagerConfig();
        if (ndRepositoryVersionManagerConfig == null) {
            throw new NdRepositoryException(NdStrings.WjHDPoN("CouldNotFindVersionManagerConfiguration"));
        }
        NdRepositoryConnection ndRepositoryConnection = ndRepositoryVersionManagerConfig.getVersioningRepositoryConnection();
        if (!(ndRepositoryConnection instanceof NdNativeVersioningRepositoryConnection)) {
            throw new NdRepositoryException(NdStrings.WjHDPoN("CouldNotFindNativeVersioningConnectionFromRepositoryConfiguration"));
        }
        NdNativeVersioningRepositoryConnection ndNativeVersioningRepositoryConnection = (NdNativeVersioningRepositoryConnection)ndRepositoryConnection;
        ndRepositoryConnection = (NdWorkspaceConnection)ndNativeVersioningRepositoryConnection.getRepositoryConnection();
        if (ndRepositoryConnection == null) {
            throw new NdRepositoryException(NdStrings.WjHDPoN("CouldNotFindVersionRepositoryConnection"));
        }
        NdRepositoryAdminFactory ndRepositoryAdminFactory = ndRepositoryConnection.getRepositoryAdminFactory();
        NdRepositoryAdmin ndRepositoryAdmin = ndRepositoryAdminFactory.newRepositoryAdmin();
        ndRepositoryConfig.setAtticRepository(true);
        if (ndRepositoryVersionManagerConfig.isPrivateWorkspaceSupported()) {
            ndRepositoryConfig.getRepositoryVersionManagerConfig().setVersioningRepositoryConnection(null);
        }
        ndRepositoryAdmin.createWorkspace((NdWorkspaceConnection)ndRepositoryConnection, ndRepositoryConfig);
        if (!ndRepositoryVersionManagerConfig.isPrivateWorkspaceSupported() && ndRepositoryConnection instanceof NdFileRepositoryConnection) {
            NdRepository ndRepository = NdRepositoryFactory.newStorageRepository((NdWorkspaceConnection)ndRepositoryConnection);
            NdRepositoryConfig ndRepositoryConfig2 = ndRepository.getRepositoryConfig();
            ((NdFileRepositoryConnection)((NdNativeVersioningRepositoryConnection)ndRepositoryConfig2.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection()).getRepositoryConnection()).setRepositoryFolder(".");
            ((NdNativeVersioningRepositoryConnection)ndRepositoryConfig2.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection()).getRepositoryConnection().setUser(null);
            if (((NdNativeVersioningRepositoryConnection)ndRepositoryConfig2.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection()).getRepositoryConnection().getPassword() != null) {
                ((NdNativeVersioningRepositoryConnection)ndRepositoryConfig2.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection()).getRepositoryConnection().setPassword(null);
            }
            ndRepositoryConfig2.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection().setUser(null);
            ndRepository.setRepositoryConfig(ndRepositoryConfig2);
        }
    }

    public void removeVersioningRepository(NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        if (!(ndVersioningRepositoryConnection instanceof NdNativeVersioningRepositoryConnection)) {
            throw new NdRepositoryException(NdStrings.WjHDPoN("InvalidNativeVersionRepositoryConnection"));
        }
        NdNativeVersioningRepositoryConnection ndNativeVersioningRepositoryConnection = (NdNativeVersioningRepositoryConnection)ndVersioningRepositoryConnection;
        NdWorkspaceConnection ndWorkspaceConnection = (NdWorkspaceConnection)ndNativeVersioningRepositoryConnection.getRepositoryConnection();
        if (ndWorkspaceConnection == null) {
            throw new NdRepositoryException(NdStrings.WjHDPoN("CouldNotFindVersionRepositoryConnection"));
        }
        NdRepositoryAdminFactory ndRepositoryAdminFactory = ndWorkspaceConnection.getRepositoryAdminFactory();
        if (ndRepositoryAdminFactory == null) {
            throw new NdRepositoryException(NdStrings.WjHDPoN("CouldNotFindRepositoryAdminFactoryConfiguration"));
        }
        NdRepositoryAdmin ndRepositoryAdmin = ndRepositoryAdminFactory.newRepositoryAdmin();
        ndRepositoryAdmin.removeWorkspace(ndWorkspaceConnection);
    }

    public void createRepositoryWorkspace(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        if (!(ndVersioningRepositoryConnection instanceof NdNativeVersioningRepositoryConnection)) {
            throw new NdRepositoryException(NdStrings.WjHDPoN("InvalidNativeVersionRepositoryConnection"));
        }
        NdNativeVersioningRepositoryConnection ndNativeVersioningRepositoryConnection = (NdNativeVersioningRepositoryConnection)ndVersioningRepositoryConnection;
        NdRepositoryAdminFactory ndRepositoryAdminFactory = ndWorkspaceConnection.getRepositoryAdminFactory();
        if (ndRepositoryAdminFactory != null) {
            Object object;
            NdRepositoryAdmin ndRepositoryAdmin = ndRepositoryAdminFactory.newRepositoryAdmin();
            ndRepositoryAdmin.createWorkspace(ndWorkspaceConnection, null);
            NdWorkspaceConnection ndWorkspaceConnection2 = (NdWorkspaceConnection)ndNativeVersioningRepositoryConnection.getRepositoryConnection();
            NdRepository ndRepository = NdRepositoryFactory.newStorageRepository(ndWorkspaceConnection2);
            NdRepositoryConfig ndRepositoryConfig = ndRepository.getRepositoryConfig();
            NdWorkspaceConnection ndWorkspaceConnection3 = (NdWorkspaceConnection)ndNativeVersioningRepositoryConnection.getRepositoryConnection();
            ndRepositoryConfig.getRepositoryVersionManagerConfig().setWorkspaceUser(ndWorkspaceConnection.getUser());
            String string = ndVersioningRepositoryConnection.getUser();
            String string2 = ndVersioningRepositoryConnection.getPassword();
            if (ndVersioningRepositoryConnection.getCredentialsFactory() == null) {
                ndVersioningRepositoryConnection.setCredentialsFactory(NdCredentialsProviderUtil.getDefaultCredentialsFactory(ndVersioningRepositoryConnection));
            }
            if (!ndVersioningRepositoryConnection.isPersistCredentials()) {
                ndVersioningRepositoryConnection.setCredentials(null);
            } else {
                if (string != null) {
                    ndVersioningRepositoryConnection.setUser(string);
                }
                if (string2 != null) {
                    ndVersioningRepositoryConnection.setPassword(string2);
                }
            }
            String string3 = null;
            if (ndWorkspaceConnection3 instanceof NdFileRepositoryConnection && ndWorkspaceConnection instanceof NdFileRepositoryConnection) {
                string3 = ((NdFileRepositoryConnection)ndWorkspaceConnection3).getRepositoryFolder();
                object = new File(string3);
                if (!((File)object).isAbsolute()) {
                    String string4 = ((NdFileRepositoryConnection)ndWorkspaceConnection).getRepositoryFolder();
                    String string5 = NdIOUtil.getRelativePath((String)string4, (String)string3);
                    ((NdFileRepositoryConnection)ndWorkspaceConnection3).setRepositoryFolder(string5);
                } else {
                    string3 = null;
                }
            }
            ndRepositoryConfig.setAtticRepository(false);
            ndRepositoryConfig.getRepositoryVersionManagerConfig().setVersioningRepositoryConnection(ndVersioningRepositoryConnection);
            object = NdRepositoryFactory.newStorageRepository(ndWorkspaceConnection);
            object.openConnection(1);
            object.setRepositoryConfig(ndRepositoryConfig);
            if (string3 != null) {
                ((NdFileRepositoryConnection)ndWorkspaceConnection3).setRepositoryFolder(string3);
            }
            if (string != null) {
                ndVersioningRepositoryConnection.setUser(string);
            }
            if (string2 != null) {
                ndVersioningRepositoryConnection.setPassword(string2);
            }
        } else {
            throw new NdRepositoryException(NdStrings.WjHDPoN("CouldNotFindRepositoryAdminFactoryConfiguration"));
        }
    }

    public void removeRepositoryWorkspace(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        if (!(ndVersioningRepositoryConnection instanceof NdNativeVersioningRepositoryConnection)) {
            throw new NdRepositoryException(NdStrings.WjHDPoN("InvalidNativeVersionRepositoryConnection"));
        }
        NdNativeVersioningRepositoryConnection ndNativeVersioningRepositoryConnection = (NdNativeVersioningRepositoryConnection)ndVersioningRepositoryConnection;
        String string = ndWorkspaceConnection.getUser();
        NdLocation ndLocation = NdLocationFactory.createLocation(new String[0], true);
        this.releaseCheckedOutEntries(ndLocation, true, string, ndNativeVersioningRepositoryConnection);
        NdRepositoryAdminFactory ndRepositoryAdminFactory = ndWorkspaceConnection.getRepositoryAdminFactory();
        if (ndRepositoryAdminFactory == null) {
            throw new NdRepositoryException(NdStrings.WjHDPoN("CouldNotFindRepositoryAdminFactoryConfiguration"));
        }
        NdRepositoryAdmin ndRepositoryAdmin = ndRepositoryAdminFactory.newRepositoryAdmin();
        ndRepositoryAdmin.removeWorkspace(ndWorkspaceConnection);
    }

    public NdRepositoryEntryLockInfo[] listCheckedOutEntries(NdLocation ndLocation, boolean bl, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        if (!(ndVersioningRepositoryConnection instanceof NdNativeVersioningRepositoryConnection)) {
            throw new NdRepositoryException(NdStrings.WjHDPoN("InvalidNativeVersionRepositoryConnection"));
        }
        NdNativeVersioningRepositoryConnection ndNativeVersioningRepositoryConnection = (NdNativeVersioningRepositoryConnection)ndVersioningRepositoryConnection;
        NdNativeRepositoryVersionManager ndNativeRepositoryVersionManager = new NdNativeRepositoryVersionManager(ndNativeVersioningRepositoryConnection);
        ndNativeRepositoryVersionManager.openConnection();
        return ndNativeRepositoryVersionManager.WjIqhmC(ndLocation, bl);
    }

    public void releaseCheckedOutEntries(NdLocation ndLocation, boolean bl, String string, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        if (!(ndVersioningRepositoryConnection instanceof NdNativeVersioningRepositoryConnection)) {
            throw new NdRepositoryException(NdStrings.WjHDPoN("InvalidNativeVersionRepositoryConnection"));
        }
        NdNativeVersioningRepositoryConnection ndNativeVersioningRepositoryConnection = (NdNativeVersioningRepositoryConnection)ndVersioningRepositoryConnection;
        NdNativeRepositoryVersionManager ndNativeRepositoryVersionManager = new NdNativeRepositoryVersionManager(ndNativeVersioningRepositoryConnection);
        ndNativeRepositoryVersionManager.openConnection();
        ndNativeRepositoryVersionManager.WjIqhmE(ndLocation, bl, string);
        ndNativeRepositoryVersionManager.closeConnection();
    }

    public void releaseCheckedOutEntries(NdLocation[] ndLocationArray, String string, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        if (!(ndVersioningRepositoryConnection instanceof NdNativeVersioningRepositoryConnection)) {
            throw new NdRepositoryException(NdStrings.WjHDPoN("InvalidNativeVersionRepositoryConnection"));
        }
        NdNativeVersioningRepositoryConnection ndNativeVersioningRepositoryConnection = (NdNativeVersioningRepositoryConnection)ndVersioningRepositoryConnection;
        NdNativeRepositoryVersionManager ndNativeRepositoryVersionManager = new NdNativeRepositoryVersionManager(ndNativeVersioningRepositoryConnection);
        ndNativeRepositoryVersionManager.openConnection();
        ndNativeRepositoryVersionManager.WjIqhmF(ndLocationArray, string);
        ndNativeRepositoryVersionManager.closeConnection();
    }

    public void commitWorkspaceConfiguration(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryVersionException {
        if (ndVersioningRepositoryConnection instanceof NdNativeVersioningRepositoryConnection) {
            try {
                NdRepository ndRepository = NdRepositoryFactory.newStorageRepository(ndWorkspaceConnection);
                NdRepositoryConfig ndRepositoryConfig = ndRepository.getRepositoryConfig();
                NdWorkspaceConnection ndWorkspaceConnection2 = (NdWorkspaceConnection)((NdNativeVersioningRepositoryConnection)ndVersioningRepositoryConnection).getRepositoryConnection();
                NdRepository ndRepository2 = NdRepositoryFactory.newStorageRepository(ndWorkspaceConnection2);
                ndRepositoryConfig.setAtticRepository(true);
                ndRepositoryConfig.getRepositoryVersionManagerConfig().setVersioningRepositoryConnection(null);
                ndRepository2.setRepositoryConfig(ndRepositoryConfig);
            }
            catch (NdRepositoryException ndRepositoryException) {
                throw new NdRepositoryVersionException((Throwable)((Object)ndRepositoryException));
            }
        } else {
            throw new NdRepositoryVersionException(NdStrings.WjHDPoP("IsNotANativeVersioningRepositoryConnection", ndVersioningRepositoryConnection.getName()));
        }
    }

    public void updateWorkspaceConfiguration(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryVersionException {
        if (ndVersioningRepositoryConnection instanceof NdNativeVersioningRepositoryConnection) {
            try {
                NdRepository ndRepository = NdRepositoryFactory.newStorageRepository(ndWorkspaceConnection);
                NdRepositoryConfig ndRepositoryConfig = ndRepository.getRepositoryConfig();
                NdWorkspaceConnection ndWorkspaceConnection2 = (NdWorkspaceConnection)((NdNativeVersioningRepositoryConnection)ndVersioningRepositoryConnection).getRepositoryConnection();
                NdRepository ndRepository2 = NdRepositoryFactory.newStorageRepository(ndWorkspaceConnection2);
                NdRepositoryConfig ndRepositoryConfig2 = ndRepository2.getRepositoryConfig();
                ndRepositoryConfig2.setAtticRepository(false);
                NdVersioningRepositoryConnection ndVersioningRepositoryConnection2 = ndRepositoryConfig.getRepositoryVersionManagerConfig().getVersioningRepositoryConnection();
                ndRepositoryConfig2.getRepositoryVersionManagerConfig().setVersioningRepositoryConnection(ndVersioningRepositoryConnection2);
                ndRepository.setRepositoryConfig(ndRepositoryConfig2);
            }
            catch (NdRepositoryException ndRepositoryException) {
                throw new NdRepositoryVersionException((Throwable)((Object)ndRepositoryException));
            }
        } else {
            throw new NdRepositoryVersionException(NdStrings.WjHDPoP("IsNotANativeVersioningRepositoryConnection", ndVersioningRepositoryConnection.getName()));
        }
    }
}

