/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.jdbc;

import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.jdbc.NdDataSourceRepositoryConnection;
import com.blazesoft.repository.jdbc.NdDefaultJdbcRepositoryAccessor;
import com.blazesoft.repository.jdbc.NdJdbcEntryRepositoryException;
import com.blazesoft.repository.jdbc.NdJdbcRepository;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryConnection;
import com.blazesoft.repository.jdbc.NdStrings;
import com.blazesoft.util.NdSystemProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class NdDataSourceRepositoryAccessor
extends NdDefaultJdbcRepositoryAccessor {
    private String WjIwzlL;

    public NdDataSourceRepositoryAccessor(NdJdbcRepository ndJdbcRepository) {
        super(ndJdbcRepository);
    }

    public void openConnection(NdJdbcRepositoryConnection ndJdbcRepositoryConnection) throws NdRepositoryException {
        if (ndJdbcRepositoryConnection instanceof NdDataSourceRepositoryConnection) {
            this.WjIwzlL = ((NdDataSourceRepositoryConnection)ndJdbcRepositoryConnection).getDataSourceName();
        }
        super.openConnection(ndJdbcRepositoryConnection);
    }

    public void openConnection(Hashtable hashtable) throws NdRepositoryException {
        this.WjIwzlL = (String)hashtable.get("com_blazesoft_repository_datasource_name");
        super.openConnection(hashtable);
    }

    protected void open() throws NdRepositoryException {
        block8: {
            if (this.isNativeConnection()) {
                return;
            }
            try {
                Connection connection = this.getConnection();
                if (connection != null && !connection.isClosed()) break block8;
                if (this.WjIwzlL != null) {
                    InitialContext initialContext = new InitialContext();
                    DataSource dataSource = (DataSource)initialContext.lookup(this.WjIwzlL);
                    connection = dataSource.getConnection();
                    if (!connection.getAutoCommit()) {
                        connection.setAutoCommit(true);
                    }
                    this.setConnection(connection);
                    break block8;
                }
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotConnectDB", this.WjIwzlL), this.getJdbcRepository(), null);
            }
            catch (SQLException sQLException) {
                if (NdSystemProperties.isDebugModeEnabled()) {
                    sQLException.printStackTrace();
                }
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotConnectDB", this.WjIwzlL), this.getJdbcRepository(), sQLException);
            }
            catch (NamingException namingException) {
                if (NdSystemProperties.isDebugModeEnabled()) {
                    namingException.printStackTrace();
                }
                throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotConnectDB", this.WjIwzlL), this.getJdbcRepository(), namingException);
            }
        }
    }
}

