/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.jdbc;

import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositoryItemContentDefConverterContext;
import com.blazesoft.repository.jdbc.NdJdbcEntryRepositoryException;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryAccessor;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryEntry;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryItem;
import com.blazesoft.repository.jdbc.NdStrings;

public class NdJdbcRepositoryDirectory
extends NdJdbcRepositoryEntry
implements NdRepositoryDirectory {
    public NdJdbcRepositoryDirectory(NdJdbcRepositoryDirectory ndJdbcRepositoryDirectory, String string, Object object) {
        super(ndJdbcRepositoryDirectory, string, object);
    }

    NdJdbcRepositoryDirectory(NdJdbcRepositoryDirectory ndJdbcRepositoryDirectory, String string) {
        super(ndJdbcRepositoryDirectory, string, null);
    }

    NdJdbcRepositoryDirectory() {
    }

    public NdRepositoryEntry[] getRepositoryEntries() throws NdRepositoryException {
        NdRepositoryEntry[] ndRepositoryEntryArray = this.getJdbcRepositoryAccessor().getEntries(this);
        return ndRepositoryEntryArray;
    }

    public NdRepositoryDirectory createRepositoryDirectory(String string) throws NdRepositoryException {
        this.checkWriteMode();
        return new NdJdbcRepositoryDirectory(this, string);
    }

    public void addRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        this.checkWriteMode();
        Object object = this.getJdbcRepositoryAccessor().addDirectory(this, (NdJdbcRepositoryDirectory)ndRepositoryDirectory, ndRepositoryEntryAttributeArray);
        ((NdJdbcRepositoryDirectory)ndRepositoryDirectory).setKey(object);
    }

    public void removeRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory) throws NdRepositoryException {
        NdRepositoryEntry[] ndRepositoryEntryArray = ndRepositoryDirectory.getRepositoryEntries();
        if (ndRepositoryEntryArray.length > 0) {
            for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
                NdRepositoryEntry ndRepositoryEntry = ndRepositoryEntryArray[i];
                if (ndRepositoryEntry instanceof NdRepositoryItem) {
                    this.removeRepositoryItem((NdRepositoryItem)ndRepositoryEntry);
                    continue;
                }
                this.removeRepositoryDirectory((NdRepositoryDirectory)ndRepositoryEntry);
            }
        }
        this.checkWriteMode();
        this.getJdbcRepositoryAccessor().removeDirectory((NdJdbcRepositoryDirectory)ndRepositoryDirectory);
    }

    public NdRepositoryItem createRepositoryItem(String string) throws NdRepositoryException {
        this.checkWriteMode();
        return new NdJdbcRepositoryItem(this, string);
    }

    public void addRepositoryItem(NdRepositoryItem ndRepositoryItem, NdRepositoryItemContent ndRepositoryItemContent, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        try {
            this.checkWriteMode();
            ndRepositoryItemContent.setItemContentConverter(this.WjIairN().getRepositoryItemContentConverter());
            ndRepositoryItemContent.setItemContentConverterContext(new NdRepositoryItemContentDefConverterContext(this.WjIairN(), ndRepositoryItem));
            NdJdbcRepositoryAccessor ndJdbcRepositoryAccessor = this.getJdbcRepositoryAccessor();
            Object object = ndJdbcRepositoryAccessor.addItem(this, (NdJdbcRepositoryItem)ndRepositoryItem, ndRepositoryItemContent.getRawData(), ndRepositoryEntryAttributeArray);
            ((NdJdbcRepositoryItem)ndRepositoryItem).setKey(object);
        }
        catch (Exception exception) {
            throw new NdJdbcEntryRepositoryException(NdStrings.WjHBadS("CouldNotCreateItem", ndRepositoryItem.getName()), this, exception);
        }
    }

    public void removeRepositoryItem(NdRepositoryItem ndRepositoryItem) throws NdRepositoryException {
        this.checkWriteMode();
        this.getJdbcRepositoryAccessor().removeItem((NdJdbcRepositoryItem)ndRepositoryItem);
    }

    public NdRepositoryEntryAttribute[] getRepositoryEntryAttributes(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        return this.getJdbcRepositoryAccessor().getEntryAttributes((NdJdbcRepositoryEntry)ndRepositoryEntry);
    }

    public void setRepositoryEntryAttributes(NdRepositoryEntry ndRepositoryEntry, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        this.checkWriteMode();
        this.getJdbcRepositoryAccessor().setEntryAttributes((NdJdbcRepositoryEntry)ndRepositoryEntry, ndRepositoryEntryAttributeArray);
    }

    public NdRepositoryEntry lookupRepositoryEntry(String string) throws NdRepositoryException {
        return this.getJdbcRepositoryAccessor().lookupEntry(this, string);
    }
}

