/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.jdbc;

import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.jdbc.NdDefaultJdbcRepositoryAccessor;
import com.blazesoft.repository.jdbc.NdJdbcEntryRepositoryException;
import com.blazesoft.repository.jdbc.NdJdbcRepository;
import com.blazesoft.util.NdSystemProperties;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.BLOB;

public class NdOracleJdbcRepositoryAccessor
extends NdDefaultJdbcRepositoryAccessor {
    public NdOracleJdbcRepositoryAccessor(NdJdbcRepository ndJdbcRepository) {
        super(ndJdbcRepository);
    }

    public byte[] getKeyItemContent(Object object) throws NdRepositoryException {
        this.open();
        return NdOracleJdbcRepositoryAccessor.WjIwzfA(object, this.getConnection(), this.getRepositoryTable());
    }

    static byte[] WjIwzfA(Object object, Connection connection, String string) throws NdRepositoryException {
        String string2 = "SELECT contentLength, itemContent FROM " + string + " WHERE id=?";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, (String)object);
            ResultSet resultSet = preparedStatement.executeQuery();
            byte[] byArray = null;
            if (resultSet.next()) {
                Object object2;
                int n = resultSet.getInt(1);
                InputStream inputStream = null;
                try {
                    object2 = ((OracleResultSet)resultSet).getBLOB(2);
                    if (object2 != null) {
                        inputStream = object2.getBinaryStream();
                    }
                }
                catch (Exception exception) {
                    throw new NdJdbcEntryRepositoryException(exception);
                }
                if (inputStream != null) {
                    int n2;
                    object2 = new byte[n];
                    while ((n2 = inputStream.read((byte[])object2)) != -1) {
                        if (byArray == null) {
                            byArray = new byte[n2];
                            System.arraycopy(object2, 0, byArray, 0, n2);
                            continue;
                        }
                        byte[] byArray2 = new byte[byArray.length + n2];
                        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                        System.arraycopy(object2, 0, byArray2, byArray.length, n2);
                        byArray = byArray2;
                    }
                    inputStream.close();
                }
            }
            resultSet.close();
            preparedStatement.close();
            if (byArray == null) {
                byArray = new byte[]{};
            }
            return byArray;
        }
        catch (Exception exception) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                exception.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(exception);
        }
    }

    public void setKeyItemContent(Object object, byte[] byArray) throws NdRepositoryException {
        this.open();
        NdOracleJdbcRepositoryAccessor.WjIwzfB(object, byArray, this.getConnection(), this.getRepositoryTable());
    }

    static void WjIwzfB(Object object, byte[] byArray, Connection connection, String string) throws NdRepositoryException {
        String string2 = "UPDATE " + string + " SET contentLength=?, itemContent=empty_blob(), lastModified=? WHERE id=?";
        String string3 = "SELECT itemContent FROM " + string + " WHERE id=?";
        try {
            connection.setAutoCommit(false);
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            Timestamp timestamp = new Timestamp(new Date().getTime());
            if (byArray != null) {
                preparedStatement.setInt(1, byArray.length);
            } else {
                preparedStatement.setInt(1, 0);
            }
            preparedStatement.setTimestamp(2, timestamp);
            preparedStatement.setString(3, (String)object);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            if (byArray != null) {
                preparedStatement = connection.prepareStatement(string3);
                preparedStatement.setString(1, (String)object);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    BLOB bLOB = ((OracleResultSet)resultSet).getBLOB(1);
                    OutputStream outputStream = bLOB.getBinaryOutputStream();
                    outputStream.write(byArray, 0, byArray.length);
                    outputStream.close();
                }
                preparedStatement.close();
            }
            connection.commit();
        }
        catch (Exception exception) {
            if (NdSystemProperties.isDebugModeEnabled()) {
                exception.printStackTrace();
            }
            throw new NdJdbcEntryRepositoryException(exception);
        }
    }
}

