/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.jndi;

import com.blazesoft.repository.base.NdAbstractRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.config.NdRepositoryAdminFactory;
import com.blazesoft.repository.jndi.NdStrings;
import java.util.Hashtable;

public class NdJndiLdapRepositoryConnection
extends NdAbstractRepositoryConnection
implements NdWorkspaceConnection {
    public static final String REPOSITORY_JNDI_CONTEXT_FACTORY_TAG = "com_blazesoft_repository_initialcontext_factory";
    public static final String REPOSITORY_CONNECTION_JNDI_URL_TAG = "com_blazesoft_repository_jndi_url";
    private String WjHIzTD;
    private String WjHIONF;
    private String WjIypkA;
    private Hashtable WjHIONH;
    private Hashtable WjHJWuD;
    private static NdRepositoryAdminFactory WjIlkaU = new NdRepositoryAdminFactory("com.blazesoft.repository.jndi.NdJndiLdapRepositoryAdmin");

    public NdJndiLdapRepositoryConnection() {
    }

    public NdJndiLdapRepositoryConnection(Hashtable hashtable) {
        this.WjHJWuD = hashtable;
        this.setUser((String)hashtable.get("com_blazesoft_repository_username"));
        this.setPassword((String)hashtable.get("com_blazesoft_repository_password"));
        this.setRepositoryName((String)hashtable.get("com_blazesoft_repository_repositoryname"));
        this.WjHIONF = (String)hashtable.get(REPOSITORY_CONNECTION_JNDI_URL_TAG);
        this.WjHIzTD = (String)hashtable.get(REPOSITORY_JNDI_CONTEXT_FACTORY_TAG);
    }

    public String getSystemDescription() {
        if (this.WjIypkA == null) {
            this.WjIypkA = NdStrings.WjHzGqJ("LdapRepository", this.getRepositoryName());
            if (this.WjHIONF != null) {
                this.WjIypkA = NdStrings.WjHzGqK("LdapRepositoryAt", this.WjIypkA, this.WjHIONF);
            }
        }
        return this.WjIypkA;
    }

    public void setSystemDescription(String string) {
        this.WjIypkA = string;
    }

    public String getJndiUrl() {
        return this.WjHIONF;
    }

    public void setJndiUrl(String string) {
        this.WjHIONF = string;
    }

    public String getInitialContextFactory() {
        if (this.WjHIzTD == null) {
            this.WjHIzTD = "com.sun.jndi.ldap.LdapCtxFactory";
        }
        return this.WjHIzTD;
    }

    public void setInitialContextFactory(String string) {
        this.WjHIzTD = string;
    }

    public Hashtable getLdapConnectionArgs() {
        if (this.WjHIONH == null) {
            this.WjHIONH = new Hashtable();
            this.WjHIONH.put("java.naming.factory.initial", this.getInitialContextFactory());
            if (this.WjHIONF != null) {
                this.WjHIONH.put("java.naming.provider.url", this.WjHIONF);
            }
            if (this.getRepositoryName() != null) {
                this.WjHIONH.put("com.blazesoft.repository.base.repositoryname", this.getRepositoryName());
            }
            if (this.getUser() != null) {
                this.WjHIONH.put("java.naming.security.principal", this.getUser());
            }
            if (this.getPassword() != null) {
                this.WjHIONH.put("java.naming.security.credentials", this.getPassword());
            }
            this.WjHIONH.put("com.blazesoft.repository.base.repositoryclass", this.getRepositoryClassName());
        }
        return this.WjHIONH;
    }

    public Hashtable getConnectionArgs() {
        if (this.WjHJWuD == null) {
            this.WjHJWuD = new Hashtable();
            if (this.getUser() != null) {
                this.WjHJWuD.put("com_blazesoft_repository_username", this.getUser());
            }
            if (this.getPassword() != null) {
                this.WjHJWuD.put("com_blazesoft_repository_password", this.getPassword());
            }
            if (this.WjHIONF != null) {
                this.WjHJWuD.put(REPOSITORY_CONNECTION_JNDI_URL_TAG, this.WjHIONF);
            }
            if (this.WjHIzTD != null) {
                this.WjHJWuD.put(REPOSITORY_JNDI_CONTEXT_FACTORY_TAG, this.WjHIzTD);
            }
            if (this.getRepositoryName() != null) {
                this.WjHJWuD.put("com_blazesoft_repository_repositoryname", this.getRepositoryName());
            }
            this.WjHJWuD.put("com_blazesoft_repository_connectionclass", this.getClass().getName());
        }
        return this.WjHJWuD;
    }

    public NdRepositoryAdminFactory getRepositoryAdminFactory() {
        return WjIlkaU;
    }

    public String getRepositoryClassName() {
        return "com.blazesoft.repository.jndi.NdJndiLdapRepository";
    }

    public boolean equals(NdRepositoryConnection ndRepositoryConnection) {
        if (!(ndRepositoryConnection instanceof NdJndiLdapRepositoryConnection)) {
            return false;
        }
        if (!super.equals(ndRepositoryConnection)) {
            return false;
        }
        NdJndiLdapRepositoryConnection ndJndiLdapRepositoryConnection = (NdJndiLdapRepositoryConnection)ndRepositoryConnection;
        if (this.WjHIONF != null) {
            return this.WjHIONF.equals(ndJndiLdapRepositoryConnection.getJndiUrl());
        }
        return false;
    }
}

