/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.jndi;

import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryEntryLocationManager;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositoryItemContentConverter;
import com.blazesoft.repository.base.NdRepositoryListener;
import com.blazesoft.repository.base.NdRepositoryRuntimeException;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigLoader;
import com.blazesoft.repository.config.NdRepositoryConfigWriter;
import com.blazesoft.repository.jndi.NdJndiEntryRepositoryException;
import com.blazesoft.repository.jndi.NdJndiLdapRepositoryConnection;
import com.blazesoft.repository.jndi.NdJndiRepositoryBindingsEntryFactory;
import com.blazesoft.repository.jndi.NdJndiRepositoryConstants;
import com.blazesoft.repository.jndi.NdJndiRepositoryDirectory;
import com.blazesoft.repository.jndi.NdJndiRepositoryEntryFactory;
import com.blazesoft.repository.jndi.NdJndiRepositoryItem;
import com.blazesoft.repository.jndi.NdStrings;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public abstract class NdJndiRepository
extends NdJndiRepositoryDirectory
implements NdRepository,
NdJndiRepositoryConstants {
    private Hashtable WjIadWT;
    private Context WjIadXU = null;
    private String WjIadYV;
    private int WjIadZW = -1;
    private NdJndiRepositoryEntryFactory WjIaeaX = null;
    private NdRepositoryConfig WjIehnE = null;
    private boolean WjIaedE;
    private String WjIaedG;
    private String WjIaedH = "";
    private NdRepositoryConnection WjIqgRG;

    public NdJndiRepository(NdRepositoryConnection ndRepositoryConnection) throws NdRepositoryException {
        super(null, null);
        this.WjIaedH = ndRepositoryConnection.getUser();
        if (this.WjIaedH == null || this.WjIaedH.length() == 0) {
            throw new NdRepositoryException(NdStrings.WjHzGqH("CouldNotFindValidJndiRepositoryUser"));
        }
        this.WjIqgRG = ndRepositoryConnection;
        this.WjIadWT = ((NdJndiLdapRepositoryConnection)ndRepositoryConnection).getLdapConnectionArgs();
        this.WjIadYV = (String)this.WjIadWT.get("com.blazesoft.repository.jndi.repositorytype");
        if (this.WjIadYV == null) {
            this.WjIadYV = "attribute-based";
        }
        this.WjIaedE = false;
    }

    NdJndiRepository WjIagGV() {
        return this;
    }

    protected Context getRepDirContext() {
        return this.WjIadXU;
    }

    private void WjIlkkA() throws NdJndiEntryRepositoryException {
        String string = (String)this.WjIadWT.get("com.blazesoft.repository.base.entryfactoryclass");
        if (string != null) {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (Exception exception) {
                throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotFindClass", string), this, (Throwable)exception);
            }
            try {
                this.WjIaeaX = (NdJndiRepositoryEntryFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotInstantiateClass", string), this, (Throwable)exception);
            }
        }
        this.WjIaeaX = new NdJndiRepositoryBindingsEntryFactory();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void WjIaedL() throws NdRepositoryException {
        Object object;
        String[] stringArray;
        String string = (String)this.WjIadWT.get("com.blazesoft.repository.base.repositoryname");
        NdRepositoryEntryLocationManager ndRepositoryEntryLocationManager = this.getRepositoryEntryLocationManager();
        try {
            stringArray = new InitialDirContext(this.WjIadWT);
            if (string != null) {
                object = stringArray.lookup(ndRepositoryEntryLocationManager.translateLocation(ndRepositoryEntryLocationManager.translatePhysicalLocation(string)));
                if (!(object instanceof Context)) throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("EntryIsNotRepository", string), this);
                Context context = (Context)object;
            } else {
                String[] stringArray2 = stringArray;
            }
        }
        catch (NamingException namingException) {
            throw new NdRepositoryException(namingException);
        }
        try {
            void var2_9;
            stringArray = new String[]{"innovatorItemContent"};
            object = ndRepositoryEntryLocationManager.translateLocation(ndRepositoryEntryLocationManager.translatePhysicalLocation("_com_blazesoft_repository_config_object"));
            Attributes attributes = ((DirContext)var2_9).getAttributes((String)object, stringArray);
            if (attributes != null) {
                this.WjIaedG = (String)attributes.get("innovatorItemContent").get();
            }
            this.WjIehnE = NdRepositoryConfigLoader.getDefaultRepositoryConfigLoader(this.WjIqgRG.getClassLoadingContext()).load(new StringBuffer(this.WjIaedG), this.WjIqgRG);
            return;
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    String WjIaedP() {
        return this.WjIaedH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void openConnection(int n) throws NdRepositoryException {
        NdJndiRepository ndJndiRepository = this;
        synchronized (ndJndiRepository) {
            if (this.WjIaedE) {
                return;
            }
            try {
                String string = (String)this.WjIadWT.get("java.naming.factory.initial");
                if (string == null || string.length() == 0) {
                    this.WjIadWT.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                }
                InitialDirContext initialDirContext = new InitialDirContext(this.WjIadWT);
                String string2 = (String)this.WjIadWT.get("com.blazesoft.repository.base.repositoryname");
                if (string2 != null) {
                    NdRepositoryEntryLocationManager ndRepositoryEntryLocationManager = this.getRepositoryEntryLocationManager();
                    Object object = initialDirContext.lookup(ndRepositoryEntryLocationManager.translateLocation(ndRepositoryEntryLocationManager.translatePhysicalLocation(string2)));
                    if (!(object instanceof Context)) throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("EntryIsNotRepository", string2), this);
                    this.WjIadXU = (Context)object;
                } else {
                    this.WjIadXU = initialDirContext;
                }
                this.WjIadYV = (String)this.WjIadWT.get("com.blazesoft.repository.jndi.repositorytype");
                if (this.WjIadYV == null) {
                    this.WjIadYV = "attribute-based";
                }
                this.WjIlkkA();
                this.WjIadZW = n;
                this.WjIaedH = (String)this.WjIadWT.get("java.naming.security.principal");
                this.WjIaedE = true;
            }
            catch (NdRepositoryException ndRepositoryException) {
                throw ndRepositoryException;
            }
            catch (Exception exception) {
                throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqH("CouldNotOpenRepository"), this, (Throwable)exception);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() throws NdRepositoryException {
        NdJndiRepository ndJndiRepository = this;
        synchronized (ndJndiRepository) {
            if (this.WjIaedE) {
                this.WjIaeaX = null;
                this.WjIadXU = null;
                this.WjIadZW = -1;
                this.WjIaedE = false;
            }
        }
    }

    public Object getRepEntry() {
        return this.WjIadXU;
    }

    public int getRepositoryMode() {
        return this.WjIadZW;
    }

    public String getRepositoryType() {
        return this.WjIadYV;
    }

    public NdJndiRepositoryEntryFactory getRepositoryEntryFactory() {
        return this.WjIaeaX;
    }

    public void addRepositoryListener(NdRepositoryListener ndRepositoryListener) {
    }

    public void removeRepositoryListener(NdRepositoryListener ndRepositoryListener) {
    }

    public NdRepositoryItemContentConverter getRepositoryItemContentConverter() {
        return null;
    }

    public void setRepositoryItemContentConverter(NdRepositoryItemContentConverter ndRepositoryItemContentConverter) {
    }

    public NdRepositoryConnection getRepositoryConnection() {
        return this.WjIqgRG;
    }

    public NdRepositoryConfig getRepositoryConfig() {
        if (this.WjIehnE == null) {
            try {
                this.WjIaedL();
            }
            catch (NdRepositoryException ndRepositoryException) {
                throw new NdRepositoryRuntimeException((Throwable)((Object)ndRepositoryException));
            }
        }
        return this.WjIehnE;
    }

    public void setRepositoryConfig(NdRepositoryConfig ndRepositoryConfig) throws NdRepositoryException {
        try {
            String string = NdRepositoryConfigWriter.getDefaultRepositoryConfigWriter().save(ndRepositoryConfig);
            NdJndiRepositoryItem ndJndiRepositoryItem = (NdJndiRepositoryItem)this.createRepositoryItem("_com_blazesoft_repository_config_object");
            NdRepositoryItemContent ndRepositoryItemContent = new NdRepositoryItemContent(string);
            this.addRepositoryItem(ndJndiRepositoryItem, ndRepositoryItemContent, null);
        }
        catch (Exception exception) {
            throw new NdRepositoryException(exception);
        }
    }

    public abstract /* synthetic */ NdRepositoryEntryLocationManager getRepositoryEntryLocationManager();
}

