/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.jndi;

import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAlreadyExistsException;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.jndi.NdJndiEntryRepositoryException;
import com.blazesoft.repository.jndi.NdJndiRepository;
import com.blazesoft.repository.jndi.NdJndiRepositoryDirectoryData;
import com.blazesoft.repository.jndi.NdJndiRepositoryEntry;
import com.blazesoft.repository.jndi.NdJndiRepositoryEntryFactory;
import com.blazesoft.repository.jndi.NdJndiRepositoryEntryLocationManager;
import com.blazesoft.repository.jndi.NdJndiRepositoryItem;
import com.blazesoft.repository.jndi.NdJndiRepositoryItemData;
import com.blazesoft.repository.jndi.NdStrings;
import com.blazesoft.repository.naming.NdLocation;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;

public class NdJndiRepositoryDirectory
extends NdJndiRepositoryEntry
implements NdRepositoryDirectory {
    private static final String WjIakmJ = "innovatorClass";
    private static final String WjIakmK = "innovatorName";
    private static final String WjIakmL = "objectclass";
    private static final String WjIakmM = "innovatorItemContent";
    private static final String WjIakmN = "innovatorLastModified";
    private static final String WjIakmO = "top";
    private static final String WjIakmP = "innovatorEntry";
    private static final String WjIakmQ = "innovatorDirectory";
    private static final String WjIakmR = "innovatorItem";
    private static final String WjIakmS = "innovatorExtensibleAttributes";
    private static final String WjIakmT = "javanamingreference";
    private static final Hashtable WjIqmxU;
    private static final Hashtable WjIqmxV;
    private static final NdRepositoryEntryAttribute[] WjIekoG;

    NdJndiRepositoryDirectory(NdJndiRepositoryDirectory ndJndiRepositoryDirectory, NdLocation ndLocation, Object object) {
        super(ndJndiRepositoryDirectory, ndLocation, object);
    }

    NdJndiRepositoryDirectory(NdJndiRepositoryDirectory ndJndiRepositoryDirectory, Context context) {
        this(ndJndiRepositoryDirectory, null, context);
    }

    private NdJndiRepositoryEntry WjIakmV(NdJndiRepositoryDirectory ndJndiRepositoryDirectory, String string) throws NdRepositoryException {
        NdJndiRepositoryEntry ndJndiRepositoryEntry;
        try {
            if ("".equals(string)) {
                ndJndiRepositoryEntry = this.WjIagGV();
            } else {
                Object object = ((Context)ndJndiRepositoryDirectory.getRepEntry()).lookup(string);
                NdJndiRepositoryEntryFactory ndJndiRepositoryEntryFactory = this.WjIagGV().getRepositoryEntryFactory();
                switch (this.getEntryClass((Context)ndJndiRepositoryDirectory.getRepEntry(), string, object)) {
                    case 1: {
                        ndJndiRepositoryEntry = ndJndiRepositoryEntryFactory.getJndiRepositoryEntry(ndJndiRepositoryDirectory, this.WjIagGV().getRepositoryEntryLocationManager().translatePhysicalLocation(string), object, true);
                        break;
                    }
                    case 2: {
                        ndJndiRepositoryEntry = ndJndiRepositoryEntryFactory.getJndiRepositoryEntry(ndJndiRepositoryDirectory, this.WjIagGV().getRepositoryEntryLocationManager().translatePhysicalLocation(string), object, false);
                        break;
                    }
                    default: {
                        ndJndiRepositoryEntry = null;
                    }
                }
            }
        }
        catch (NamingException namingException) {
            ndJndiRepositoryEntry = null;
        }
        catch (Exception exception) {
            throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotFindEntry", string), this, (Throwable)exception);
        }
        return ndJndiRepositoryEntry;
    }

    private String WjIakmW(NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) {
        String string = "";
        if (ndRepositoryEntryAttributeArray != null && ndRepositoryEntryAttributeArray.length > 0) {
            for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
                NdRepositoryEntryAttribute ndRepositoryEntryAttribute = ndRepositoryEntryAttributeArray[i];
                string = i == 0 ? string + ndRepositoryEntryAttribute.getAttbId() + "=" + ndRepositoryEntryAttribute.getAttbValue() : string + ";" + ndRepositoryEntryAttribute.getAttbId() + "=" + ndRepositoryEntryAttribute.getAttbValue();
            }
        }
        return string;
    }

    private Attributes WjIakmX(NdJndiRepositoryEntry ndJndiRepositoryEntry) throws NdRepositoryException {
        BasicAttributes basicAttributes = new BasicAttributes();
        NdJndiRepositoryDirectory ndJndiRepositoryDirectory = (NdJndiRepositoryDirectory)ndJndiRepositoryEntry.getContainerDirectory();
        if (ndJndiRepositoryDirectory == null) {
            return basicAttributes;
        }
        try {
            String[] stringArray = new String[]{WjIakmS};
            Attributes attributes = ((DirContext)ndJndiRepositoryDirectory.getRepEntry()).getAttributes(ndJndiRepositoryEntry.getRepName(), stringArray);
            Attribute attribute = attributes.get(WjIakmS);
            String string = null;
            if (attribute != null) {
                string = (String)attribute.get();
            }
            if (string != null && string.indexOf("=") > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    int n = string2.indexOf("=");
                    if (n <= 0) continue;
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    basicAttributes.put(string3, string4);
                }
            }
        }
        catch (NamingException namingException) {
            throw new NdRepositoryException(namingException);
        }
        return basicAttributes;
    }

    private NdRepositoryEntryAttribute[] WjIqmxW(NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray, boolean bl) {
        if (ndRepositoryEntryAttributeArray == null || ndRepositoryEntryAttributeArray.length == 0) {
            return null;
        }
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
            NdRepositoryEntryAttribute ndRepositoryEntryAttribute = ndRepositoryEntryAttributeArray[i];
            if (bl) {
                if (WjIqmxV.get(ndRepositoryEntryAttribute.getAttbId()) == null) continue;
                vector.addElement(ndRepositoryEntryAttribute);
                continue;
            }
            if (WjIqmxU.get(ndRepositoryEntryAttribute.getAttbId()) == null) continue;
            vector.addElement(ndRepositoryEntryAttribute);
        }
        if (vector.size() > 0) {
            Object[] objectArray = new NdRepositoryEntryAttribute[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    private NdRepositoryEntryAttribute[] WjIqmxX(NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray, boolean bl) {
        int n;
        if (ndRepositoryEntryAttributeArray == null || ndRepositoryEntryAttributeArray.length == 0) {
            return null;
        }
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        if (bl) {
            for (n = 0; n < ndRepositoryEntryAttributeArray.length; ++n) {
                NdRepositoryEntryAttribute ndRepositoryEntryAttribute = ndRepositoryEntryAttributeArray[n];
                if (WjIqmxV.get(ndRepositoryEntryAttribute.getAttbId()) != null) continue;
                vector.addElement(ndRepositoryEntryAttribute);
            }
        } else {
            for (n = 0; n < ndRepositoryEntryAttributeArray.length; ++n) {
                NdRepositoryEntryAttribute ndRepositoryEntryAttribute = ndRepositoryEntryAttributeArray[n];
                if (WjIqmxU.get(ndRepositoryEntryAttribute.getAttbId()) != null) continue;
                vector.addElement(ndRepositoryEntryAttribute);
            }
        }
        if (vector.size() > 0) {
            Object[] objectArray = new NdRepositoryEntryAttribute[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public NdRepositoryEntry[] getRepositoryEntries() throws NdRepositoryException {
        Object[] objectArray;
        try {
            NamingEnumeration<Binding> namingEnumeration = this.getRepDirContext().listBindings(this.getRepName());
            if (namingEnumeration != null) {
                Vector<NdJndiRepositoryEntry> vector = new Vector<NdJndiRepositoryEntry>();
                while (namingEnumeration.hasMoreElements()) {
                    Binding binding = (Binding)namingEnumeration.nextElement();
                    String string = binding.getName();
                    NdJndiRepositoryEntryLocationManager ndJndiRepositoryEntryLocationManager = (NdJndiRepositoryEntryLocationManager)this.WjIagGV().getRepositoryEntryLocationManager();
                    String string2 = ndJndiRepositoryEntryLocationManager.getComponentName(string);
                    if (string2.startsWith("_com_blazesoft_repository_config_object") || string2.startsWith("_ext_config_obj_")) continue;
                    Object object = binding.getObject();
                    NdJndiRepositoryEntry ndJndiRepositoryEntry = null;
                    NdJndiRepositoryEntryFactory ndJndiRepositoryEntryFactory = this.WjIagGV().getRepositoryEntryFactory();
                    switch (this.getEntryClass((Context)this.getRepEntry(), string, object)) {
                        case 1: {
                            if (string2.equals("__Attic")) break;
                            ndJndiRepositoryEntry = ndJndiRepositoryEntryFactory.getJndiRepositoryEntry(this, ndJndiRepositoryEntryLocationManager.translatePhysicalLocation(string2), object, true);
                            break;
                        }
                        case 2: {
                            ndJndiRepositoryEntry = ndJndiRepositoryEntryFactory.getJndiRepositoryEntry(this, ndJndiRepositoryEntryLocationManager.translatePhysicalLocation(string2), object, false);
                            break;
                        }
                        default: {
                            ndJndiRepositoryEntry = null;
                        }
                    }
                    if (ndJndiRepositoryEntry == null) continue;
                    vector.addElement(ndJndiRepositoryEntry);
                }
                objectArray = new NdRepositoryEntry[vector.size()];
                if (vector.size() > 0) {
                    vector.copyInto(objectArray);
                }
            } else {
                objectArray = new NdRepositoryEntry[]{};
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotListEntries", this.getName()), this, (Throwable)exception);
        }
        return objectArray;
    }

    public NdRepositoryDirectory createRepositoryDirectory(NdLocation ndLocation) throws NdRepositoryException {
        this.checkWriteMode();
        NdJndiRepositoryEntryFactory ndJndiRepositoryEntryFactory = this.WjIagGV().getRepositoryEntryFactory();
        return (NdJndiRepositoryDirectory)ndJndiRepositoryEntryFactory.getJndiRepositoryEntry(this, ndLocation, null, true);
    }

    public NdRepositoryDirectory createRepositoryDirectory(String string) throws NdRepositoryException {
        return this.createRepositoryDirectory(this.WjIagGV().getRepositoryEntryLocationManager().translatePhysicalLocation(string));
    }

    public void addRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        try {
            this.checkWriteMode();
            if (this.WjIagGV().getRepositoryType().equals("attribute-based")) {
                String string;
                BasicAttributes basicAttributes = new BasicAttributes(true);
                BasicAttribute basicAttribute = new BasicAttribute(WjIakmL);
                basicAttribute.add(WjIakmO);
                basicAttribute.add(WjIakmP);
                basicAttribute.add(WjIakmQ);
                basicAttributes.put(basicAttribute);
                basicAttributes.put(WjIakmJ, "Directory");
                basicAttributes.put(WjIakmK, ((NdJndiRepositoryDirectory)ndRepositoryDirectory).WjIagFU());
                NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray2 = this.WjIqmxW(ndRepositoryEntryAttributeArray, true);
                NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray3 = this.WjIqmxX(ndRepositoryEntryAttributeArray, true);
                if (ndRepositoryEntryAttributeArray2 != null && ndRepositoryEntryAttributeArray2.length > 0) {
                    for (int i = 0; i < ndRepositoryEntryAttributeArray2.length; ++i) {
                        if (ndRepositoryEntryAttributeArray2[i].getAttbId().equals(WjIakmN) || ndRepositoryEntryAttributeArray2[i].getAttbId().equals("innovatorItemCreationId") || ndRepositoryEntryAttributeArray2[i].getAttbValue() == null) continue;
                        basicAttributes.put(ndRepositoryEntryAttributeArray2[i].getAttbId(), ndRepositoryEntryAttributeArray2[i].getAttbValue());
                    }
                }
                if ((string = this.WjIakmW(ndRepositoryEntryAttributeArray3)).length() > 0) {
                    basicAttributes.put(WjIakmS, string);
                }
                DirContext dirContext = ((DirContext)this.getRepEntry()).createSubcontext(((NdJndiRepositoryEntry)((Object)ndRepositoryDirectory)).getRepName(), (Attributes)basicAttributes);
                ((NdJndiRepositoryEntry)((Object)ndRepositoryDirectory)).setRepEntry(dirContext);
            } else if (this.WjIagGV().getRepositoryType().equals("referenceable-based")) {
                Context context = ((Context)this.getRepEntry()).createSubcontext(((NdJndiRepositoryEntry)((Object)ndRepositoryDirectory)).getRepName());
                NdJndiRepositoryDirectoryData ndJndiRepositoryDirectoryData = new NdJndiRepositoryDirectoryData();
                ndJndiRepositoryDirectoryData.setEntryName(ndRepositoryDirectory.getName());
                ndJndiRepositoryDirectoryData.setAttributes(ndRepositoryEntryAttributeArray);
                Object object = this.WjIagGV().getRepositoryEntryFactory().getObjectReference("_ND_", (Context)this.getRepEntry(), ndJndiRepositoryDirectoryData);
                ((Context)((NdJndiRepositoryEntry)((Object)ndRepositoryDirectory)).getRepEntry()).bind("_ND_", object);
                ((NdJndiRepositoryEntry)((Object)ndRepositoryDirectory)).setRepEntry(context);
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            String string = this.getRepName();
            if (string.length() == 0) {
                string = "repository root";
            }
            throw new NdRepositoryEntryAlreadyExistsException(NdStrings.WjHzGqK("EntryAlreadyExist", ((NdJndiRepositoryDirectory)ndRepositoryDirectory).getRepName(), string));
        }
        catch (Exception exception) {
            throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotCreateDirectory", ((NdJndiRepositoryEntry)((Object)ndRepositoryDirectory)).getRepName()), this, (Throwable)exception);
        }
    }

    public void removeRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory) throws NdRepositoryException {
        try {
            this.checkWriteMode();
            if (this.WjIagGV().getRepositoryType().equals("referenceable-based")) {
                ((Context)((NdJndiRepositoryEntry)((Object)ndRepositoryDirectory)).getRepEntry()).unbind("_ND_");
            } else {
                Context context = (Context)this.getRepEntry();
                String string = ((NdJndiRepositoryEntry)((Object)ndRepositoryDirectory)).getRepName();
                context.destroySubcontext(string);
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotRemoveDirectory", ndRepositoryDirectory.getName()), this, (Throwable)exception);
        }
    }

    public NdRepositoryItem createRepositoryItem(NdLocation ndLocation) throws NdRepositoryException {
        this.checkWriteMode();
        NdJndiRepositoryEntryFactory ndJndiRepositoryEntryFactory = this.WjIagGV().getRepositoryEntryFactory();
        return (NdJndiRepositoryItem)ndJndiRepositoryEntryFactory.getJndiRepositoryEntry(this, ndLocation, null, false);
    }

    public NdRepositoryItem createRepositoryItem(String string) throws NdRepositoryException {
        return this.createRepositoryItem(this.WjIagGV().getRepositoryEntryLocationManager().translatePhysicalLocation(string));
    }

    public void addRepositoryItem(NdRepositoryItem ndRepositoryItem, NdRepositoryItemContent ndRepositoryItemContent, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        try {
            this.checkWriteMode();
            if (this.WjIagGV().getRepositoryType().equals("attribute-based")) {
                BasicAttributes basicAttributes = new BasicAttributes(true);
                BasicAttribute basicAttribute = new BasicAttribute(WjIakmL);
                basicAttribute.add(WjIakmO);
                basicAttribute.add(WjIakmP);
                basicAttribute.add(WjIakmR);
                basicAttributes.put(basicAttribute);
                basicAttributes.put(WjIakmJ, "Item");
                basicAttributes.put(WjIakmK, ((NdJndiRepositoryItem)ndRepositoryItem).WjIagFU());
                basicAttributes.put(WjIakmM, ndRepositoryItemContent.getData());
                NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray2 = this.WjIqmxW(ndRepositoryEntryAttributeArray, false);
                NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray3 = this.WjIqmxX(ndRepositoryEntryAttributeArray, false);
                if (ndRepositoryEntryAttributeArray2 != null && ndRepositoryEntryAttributeArray2.length > 0) {
                    for (int i = 0; i < ndRepositoryEntryAttributeArray2.length; ++i) {
                        if (ndRepositoryEntryAttributeArray2[i].getAttbValue() == null) continue;
                        basicAttributes.put(ndRepositoryEntryAttributeArray2[i].getAttbId(), ndRepositoryEntryAttributeArray2[i].getAttbValue());
                    }
                }
                basicAttributes.put(WjIakmN, DateFormat.getInstance().format(new Date()));
                String string = this.WjIakmW(ndRepositoryEntryAttributeArray3);
                if (string.length() > 0) {
                    basicAttributes.put(WjIakmS, string);
                }
                ((DirContext)this.getRepEntry()).bind(((NdJndiRepositoryEntry)((Object)ndRepositoryItem)).getRepName(), null, (Attributes)basicAttributes);
            } else if (this.WjIagGV().getRepositoryType().equals("referenceable-based")) {
                NdJndiRepositoryItemData ndJndiRepositoryItemData = new NdJndiRepositoryItemData();
                ndJndiRepositoryItemData.setEntryName(ndRepositoryItem.getName());
                ndJndiRepositoryItemData.setItemContent(ndRepositoryItemContent.getData());
                ndJndiRepositoryItemData.setAttributes(ndRepositoryEntryAttributeArray);
                Object object = this.WjIagGV().getRepositoryEntryFactory().getObjectReference(ndRepositoryItem.getName(), (Context)this.getRepEntry(), ndJndiRepositoryItemData);
                BasicAttributes basicAttributes = new BasicAttributes(true);
                BasicAttribute basicAttribute = new BasicAttribute(WjIakmL);
                basicAttribute.add(WjIakmT);
                basicAttributes.put(WjIakmJ, "Item");
                ((DirContext)this.getRepEntry()).rebind(((NdJndiRepositoryEntry)((Object)ndRepositoryItem)).getRepName(), object, (Attributes)basicAttributes);
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            String string = this.getRepName();
            if (string.length() == 0) {
                string = "repository root";
            }
            throw new NdRepositoryEntryAlreadyExistsException(NdStrings.WjHzGqK("EntryAlreadyExist", ((NdJndiRepositoryItem)ndRepositoryItem).getRepName(), string));
        }
        catch (CommunicationException communicationException) {
            this.WjIagGV().closeConnection();
            this.WjIagGV().openConnection(1);
            throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("GotConnectionErrorWhenAddingEntry", ((NdJndiRepositoryItem)ndRepositoryItem).getRepName()), this, (Throwable)communicationException);
        }
        catch (Exception exception) {
            throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotCreateEntry", ((NdJndiRepositoryItem)ndRepositoryItem).getRepName()), this, (Throwable)exception);
        }
    }

    public void removeRepositoryItem(NdRepositoryItem ndRepositoryItem) throws NdRepositoryException {
        try {
            this.checkWriteMode();
            ((NdJndiRepositoryItem)ndRepositoryItem).getRepDirContext().unbind(((NdJndiRepositoryEntry)((Object)ndRepositoryItem)).getRepName());
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotRemoveEntry", ndRepositoryItem.getName()), this, (Throwable)exception);
        }
    }

    public NdRepositoryEntryAttribute[] getRepositoryEntryAttributes(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = WjIekoG;
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        Vector<NdRepositoryEntryAttribute> vector2 = new Vector<NdRepositoryEntryAttribute>();
        try {
            if (this.WjIagGV().getRepositoryType().equals("attribute-based")) {
                Enumeration enumeration;
                Object object;
                String[] stringArray = new String[WjIqmxU.size()];
                int n = 0;
                Enumeration enumeration2 = WjIqmxU.keys();
                while (enumeration2.hasMoreElements()) {
                    stringArray[n] = (String)enumeration2.nextElement();
                    ++n;
                }
                NdJndiRepositoryDirectory ndJndiRepositoryDirectory = (NdJndiRepositoryDirectory)ndRepositoryEntry.getContainerDirectory();
                if (ndJndiRepositoryDirectory == null) {
                    return new NdRepositoryEntryAttribute[0];
                }
                Attributes attributes = ((DirContext)ndJndiRepositoryDirectory.getRepEntry()).getAttributes(((NdJndiRepositoryEntry)ndRepositoryEntry).getRepName(), stringArray);
                if (attributes == null) {
                    throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotFindAttributes", ndRepositoryEntry.getName()), this);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    object = attributes.get(stringArray[i]);
                    if (object == null) continue;
                    enumeration = (String)object.get();
                    vector.addElement(new NdRepositoryEntryAttribute(stringArray[i], (String)((Object)enumeration)));
                }
                Attributes attributes2 = this.WjIakmX((NdJndiRepositoryEntry)ndRepositoryEntry);
                object = attributes2.getIDs();
                while (object.hasMoreElements()) {
                    enumeration = (String)object.nextElement();
                    NdRepositoryEntryAttribute ndRepositoryEntryAttribute = new NdRepositoryEntryAttribute((String)((Object)enumeration), (String)attributes2.get((String)((Object)enumeration)).get());
                    vector2.addElement(ndRepositoryEntryAttribute);
                }
                ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[vector.size() + vector2.size()];
                enumeration = vector.elements();
                n = 0;
                while (enumeration.hasMoreElements()) {
                    ndRepositoryEntryAttributeArray[n] = (NdRepositoryEntryAttribute)enumeration.nextElement();
                    ++n;
                }
                if (vector2.size() > 0) {
                    enumeration = vector2.elements();
                    n = vector.size();
                    while (enumeration.hasMoreElements()) {
                        ndRepositoryEntryAttributeArray[n] = (NdRepositoryEntryAttribute)enumeration.nextElement();
                        ++n;
                    }
                }
            } else if (this.WjIagGV().getRepositoryType().equals("referenceable-based")) {
                throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqH("NotImplementedYet"), this);
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotFindAttributes", ndRepositoryEntry.getName()), this, (Throwable)exception);
        }
        return ndRepositoryEntryAttributeArray;
    }

    public void setRepositoryEntryAttributes(NdRepositoryEntry ndRepositoryEntry, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        this.checkWriteMode();
        boolean bl = ndRepositoryEntry instanceof NdRepositoryDirectory;
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray2 = this.WjIqmxX(ndRepositoryEntryAttributeArray, bl);
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray3 = this.WjIqmxW(ndRepositoryEntryAttributeArray, bl);
        try {
            if (this.WjIagGV().getRepositoryType().equals("attribute-based")) {
                Object[] objectArray;
                Attributes attributes = null;
                NdJndiRepositoryDirectory ndJndiRepositoryDirectory = (NdJndiRepositoryDirectory)ndRepositoryEntry.getContainerDirectory();
                if (ndJndiRepositoryDirectory == null) {
                    throw new NdRepositoryException(NdStrings.WjHzGqH("CannotSetAttributesOnRepositoryRoot"));
                }
                if (ndRepositoryEntryAttributeArray3 != null && ndRepositoryEntryAttributeArray3.length > 0) {
                    int n;
                    objectArray = new String[ndRepositoryEntryAttributeArray3.length];
                    for (n = 0; n < ndRepositoryEntryAttributeArray3.length; ++n) {
                        objectArray[n] = ndRepositoryEntryAttributeArray3[n].getAttbId();
                    }
                    attributes = ((DirContext)ndJndiRepositoryDirectory.getRepEntry()).getAttributes(((NdJndiRepositoryEntry)ndRepositoryEntry).getRepName(), (String[])objectArray);
                    if (attributes == null) {
                        attributes = new BasicAttributes(true);
                    }
                    for (n = 0; n < ndRepositoryEntryAttributeArray3.length; ++n) {
                        attributes.remove(ndRepositoryEntryAttributeArray3[n].getAttbId());
                        if (ndRepositoryEntryAttributeArray3[n].getAttbValue() == null) continue;
                        attributes.put(ndRepositoryEntryAttributeArray3[n].getAttbId(), ndRepositoryEntryAttributeArray3[n].getAttbValue());
                    }
                }
                objectArray = null;
                if (ndRepositoryEntryAttributeArray2 != null && ndRepositoryEntryAttributeArray2.length > 0) {
                    Serializable serializable;
                    Attributes attributes2 = this.WjIakmX((NdJndiRepositoryEntry)ndRepositoryEntry);
                    if (attributes2 == null) {
                        attributes2 = new BasicAttributes();
                    }
                    for (int i = 0; i < ndRepositoryEntryAttributeArray2.length; ++i) {
                        serializable = ndRepositoryEntryAttributeArray2[i];
                        attributes2.remove(((NdRepositoryEntryAttribute)serializable).getAttbId());
                        if (((NdRepositoryEntryAttribute)serializable).getAttbValue() == null) continue;
                        attributes2.put(((NdRepositoryEntryAttribute)serializable).getAttbId(), ((NdRepositoryEntryAttribute)serializable).getAttbValue());
                    }
                    NamingEnumeration<String> namingEnumeration = attributes2.getIDs();
                    serializable = new Vector();
                    while (namingEnumeration.hasMoreElements()) {
                        String string = (String)namingEnumeration.nextElement();
                        NdRepositoryEntryAttribute ndRepositoryEntryAttribute = new NdRepositoryEntryAttribute(string, (String)attributes2.get(string).get());
                        ((Vector)serializable).addElement(ndRepositoryEntryAttribute);
                    }
                    if (((Vector)serializable).size() > 0) {
                        objectArray = new NdRepositoryEntryAttribute[((Vector)serializable).size()];
                        ((Vector)serializable).copyInto(objectArray);
                    }
                }
                if (attributes == null) {
                    attributes = new BasicAttributes(true);
                }
                if (objectArray != null && objectArray.length > 0) {
                    String string = this.WjIakmW((NdRepositoryEntryAttribute[])objectArray);
                    attributes.put(WjIakmS, string);
                }
                ((DirContext)ndJndiRepositoryDirectory.getRepEntry()).modifyAttributes(((NdJndiRepositoryEntry)ndRepositoryEntry).getRepName(), 2, attributes);
            } else if (this.WjIagGV().getRepositoryType().equals("referenceable-based")) {
                throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqH("NotImplementedYet"), this);
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotSetAttributes", ndRepositoryEntry.getName()), this, (Throwable)exception);
        }
    }

    public NdRepositoryEntry lookupRepositoryEntry(String string) throws NdRepositoryException {
        NdJndiRepositoryEntry ndJndiRepositoryEntry = null;
        try {
            String string2;
            NdLocation ndLocation = this.WjIagGV().getRepositoryEntryLocationManager().translatePhysicalLocation(string);
            NdJndiRepositoryDirectory ndJndiRepositoryDirectory = this;
            if (ndLocation.isAbsolute() && !(this instanceof NdJndiRepository)) {
                ndJndiRepositoryDirectory = this.WjIagGV();
            }
            if ((string2 = this.WjIagGV().getRepositoryEntryLocationManager().translateLocation(ndLocation)).indexOf(",") > 0) {
                Object object;
                Vector<Object> vector = new Vector<Object>();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    vector.addElement(object);
                }
                object = new Vector();
                for (int i = vector.size() - 1; i >= 0; --i) {
                    ((Vector)object).addElement(vector.elementAt(i));
                }
                Object[] objectArray = new String[((Vector)object).size()];
                ((Vector)object).copyInto(objectArray);
                for (int i = 0; i < objectArray.length - 1 && (ndJndiRepositoryEntry = this.WjIakmV(ndJndiRepositoryDirectory, (String)objectArray[i])) != null; ++i) {
                    if (!(ndJndiRepositoryEntry instanceof NdJndiRepositoryDirectory)) {
                        throw new NdRepositoryException(NdStrings.WjHzGqJ("CouldNotFindDirectory", objectArray[i]));
                    }
                    ndJndiRepositoryDirectory = (NdJndiRepositoryDirectory)ndJndiRepositoryEntry;
                }
                if (ndJndiRepositoryDirectory != null) {
                    ndJndiRepositoryEntry = this.WjIakmV(ndJndiRepositoryDirectory, (String)objectArray[objectArray.length - 1]);
                }
            } else {
                ndJndiRepositoryEntry = this.WjIakmV(ndJndiRepositoryDirectory, string2);
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotFindEntry", string), this, (Throwable)exception);
        }
        return ndJndiRepositoryEntry;
    }

    static {
        WjIekoG = new NdRepositoryEntryAttribute[0];
        WjIqmxU = new Hashtable();
        WjIqmxU.put(WjIakmK, WjIakmK);
        WjIqmxU.put("innovatorShortDesc", "innovatorShortDesc");
        WjIqmxU.put("innovatorItemType", "innovatorItemType");
        WjIqmxU.put("innovatorTemplateRef", "innovatorTemplateRef");
        WjIqmxU.put("innovatorItemDeletedFlag", "innovatorItemDeletedFlag");
        WjIqmxU.put("innovatorItemCreationId", "innovatorItemCreationId");
        WjIqmxU.put(WjIakmN, WjIakmN);
        WjIqmxV = new Hashtable();
        WjIqmxV.put(WjIakmK, WjIakmK);
        WjIqmxV.put("innovatorShortDesc", "innovatorShortDesc");
    }
}

