/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.jndi;

import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.jndi.NdJndiEntryRepositoryException;
import com.blazesoft.repository.jndi.NdJndiRepository;
import com.blazesoft.repository.jndi.NdJndiRepositoryDirectory;
import com.blazesoft.repository.jndi.NdJndiRepositoryEntryData;
import com.blazesoft.repository.jndi.NdJndiRepositoryItemData;
import com.blazesoft.repository.jndi.NdStrings;
import com.blazesoft.repository.naming.NdLocation;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

public class NdJndiRepositoryEntry
implements NdRepositoryEntry {
    public static final String REPOSITORY_CLASS = "Repository";
    public static final String DIRECTORY_CLASS = "Directory";
    public static final String ITEM_CLASS = "Item";
    public static final int ENTRY_CLASS_REPOSITORY = 0;
    public static final int ENTRY_CLASS_DIRECTORY = 1;
    public static final int ENTRY_CLASS_ITEM = 2;
    public static final int ENTRY_CLASS_NONE = -1;
    public static final String DIRECTORY_ENTRY_TAG = "_ND_";
    private NdJndiRepositoryDirectory WjIagvK;
    private Context WjIagwL;
    private Object WjIagxM;
    private NdLocation WjIagyN;
    private static final String WjIagzO = "innovatorName";
    private static final String[] WjIagAP = new String[]{"innovatorName"};
    private static final String WjIagBQ = "innovatorClass";
    private static final String[] WjIagCR = new String[]{"innovatorClass"};
    private static final String WjIagDS = "aci";
    private static final String[] WjIagET = new String[]{"aci"};

    NdJndiRepositoryEntry(NdJndiRepositoryDirectory ndJndiRepositoryDirectory, NdLocation ndLocation, Object object) {
        this.WjIagvK = ndJndiRepositoryDirectory;
        this.WjIagwL = ndJndiRepositoryDirectory != null ? (Context)ndJndiRepositoryDirectory.getRepEntry() : null;
        this.WjIagyN = ndLocation;
        this.WjIagxM = object;
    }

    String WjIagFU() {
        String[] stringArray;
        String string = "";
        if (this.WjIagyN != null && (stringArray = this.WjIagyN.getComponents()).length > 0) {
            string = stringArray[stringArray.length - 1];
        }
        return string;
    }

    protected Context getRepDirContext() {
        return this.WjIagwL;
    }

    NdJndiRepository WjIagGV() {
        return this.WjIagvK.WjIagGV();
    }

    protected void setRepEntry(Object object) {
        this.WjIagxM = object;
    }

    protected void checkWriteMode() throws NdRepositoryException {
        int n = this.WjIagGV().getRepositoryMode();
        if (n != 1) {
            throw new NdRepositoryException(NdStrings.WjHzGqJ("WriteModeError", String.valueOf(n)));
        }
    }

    public String getRepName() throws NdRepositoryException {
        if (this.WjIagyN == null) {
            return "";
        }
        return this.WjIagGV().getRepositoryEntryLocationManager().translateLocation(this.WjIagyN);
    }

    public String tryGetRepName() {
        String string;
        try {
            string = this.getRepName();
        }
        catch (NdRepositoryException ndRepositoryException) {
            string = "";
        }
        return string;
    }

    public Object getRepEntry() {
        return this.WjIagxM;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkAccess() throws NdRepositoryException {
        try {
            if (!this.WjIagGV().getRepositoryType().equals("attribute-based")) return;
            Attributes attributes = ((DirContext)this.getRepDirContext()).getAttributes(this.getRepName(), WjIagET);
            if (attributes == null) {
                return;
            }
            Attribute attribute = attributes.get(WjIagDS);
            if (attribute == null) {
                return;
            }
            Object object = attribute.get();
            if (object == null) return;
        }
        catch (NamingException namingException) {
            throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotCheckAccess", this.getName()), this, (Throwable)namingException);
        }
    }

    public String getName() throws NdRepositoryException {
        String string;
        block8: {
            string = "";
            try {
                if (this.WjIagGV().getRepositoryType().equals("attribute-based")) {
                    Attributes attributes = ((DirContext)this.getRepDirContext()).getAttributes(this.getRepName(), WjIagAP);
                    if (attributes == null) {
                        throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotFindNameAttribute", this), this);
                    }
                    string = (String)attributes.get(WjIagzO).get();
                    break block8;
                }
                if (!this.WjIagGV().getRepositoryType().equals("referenceable-based")) break block8;
                if (this.getRepEntry() instanceof NdJndiRepositoryEntryData) {
                    string = ((NdJndiRepositoryEntryData)this.getRepEntry()).getEntryName();
                    break block8;
                }
                if (!(this.getRepEntry() instanceof Context)) break block8;
                try {
                    Object object = ((Context)this.getRepEntry()).lookup(DIRECTORY_ENTRY_TAG);
                    if (object instanceof NdJndiRepositoryEntryData) {
                        string = ((NdJndiRepositoryEntryData)object).getEntryName();
                    }
                }
                catch (Exception exception) {
                    throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotConvertNameAttribute", this), "<UNKNOWN>", (Throwable)exception);
                }
            }
            catch (Exception exception) {
                throw new NdRepositoryException(NdStrings.WjHzGqH("CouldNotGetEntryName"), exception);
            }
        }
        return string;
    }

    public NdRepositoryDirectory getContainerDirectory() {
        return this.WjIagvK;
    }

    public int getEntryClass(Context context, String string, Object object) throws NdRepositoryException {
        int n = -1;
        try {
            if (this.WjIagGV().getRepositoryType().equals("attribute-based")) {
                Attributes attributes = ((DirContext)context).getAttributes(string, WjIagCR);
                if (attributes == null) {
                    throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotFindClassAttribute", string), this);
                }
                String string2 = (String)attributes.get(WjIagBQ).get();
                if (string2 != null) {
                    if (string2.equals(ITEM_CLASS)) {
                        n = 2;
                    } else if (string2.equals(DIRECTORY_CLASS)) {
                        n = 1;
                    } else if (string2.equals(REPOSITORY_CLASS)) {
                        n = 0;
                    }
                }
            } else if (this.WjIagGV().getRepositoryType().equals("referenceable-based")) {
                Object object2 = context.lookup(string);
                if (object2 instanceof Context) {
                    String string3;
                    n = -1;
                    Object object3 = ((Context)object2).lookup(DIRECTORY_ENTRY_TAG);
                    if (object3 instanceof NdJndiRepositoryEntryData && (string3 = ((NdJndiRepositoryEntryData)object3).getEntryClass()) != null) {
                        if (string3.equals(ITEM_CLASS)) {
                            n = 2;
                        } else if (string3.equals(DIRECTORY_CLASS)) {
                            n = 1;
                        } else if (string3.equals(REPOSITORY_CLASS)) {
                            n = 0;
                        }
                    }
                } else if (object2 instanceof NdJndiRepositoryItemData) {
                    n = 2;
                }
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new NdRepositoryException(exception);
        }
        return n;
    }

    public Object getPhysicalDescription() {
        return this.WjIagwL;
    }
}

